/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "resources.h"
#include "types.h"

// The Legend of Kyrandia
#include "resources/lok_amiga.h"
#include "resources/lok_amiga_english.h"
#include "resources/lok_amiga_french.h"
#include "resources/lok_amiga_german.h"
#include "resources/lok_amiga_italian.h"

#include "resources/lok_dos_demo.h"
#include "resources/lok_dos_demo_english.h"

#include "resources/lok_dos.h"
#include "resources/lok_dos_english.h"
#include "resources/lok_dos_french.h"
#include "resources/lok_dos_german.h"
#include "resources/lok_dos_italian.h"
#include "resources/lok_dos_oldfloppy.h"
#include "resources/lok_dos_oldfloppy_czech.h"
#include "resources/lok_dos_oldfloppy_russian.h"
#include "resources/lok_dos_spanish.h"
#include "resources/lok_dos_korean.h"
#include "resources/lok_dos_chinese_trad.h"

#include "resources/lok_dos_cd.h"
#include "resources/lok_dos_cd_english.h"
#include "resources/lok_dos_cd_french.h"
#include "resources/lok_dos_cd_german.h"
#include "resources/lok_dos_cd_italian.h"
#include "resources/lok_dos_cd_spanish.h"
#include "resources/lok_dos_cd_russian.h"
#include "resources/lok_dos_cd_hebrew.h"
#include "resources/lok_dos_cd_czech.h"
#include "resources/lok_dos_cddemo.h"
#include "resources/lok_dos_cddemo_english.h"

#include "resources/lok_mac.h"
#include "resources/lok_mac_english.h"

#include "resources/lok_mac_cd.h"
#include "resources/lok_mac_cd_english.h"
#include "resources/lok_mac_cd_french.h"
#include "resources/lok_mac_cd_german.h"

#include "resources/lok_fmtowns.h"
#include "resources/lok_fmtowns_english.h"
#include "resources/lok_fmtowns_japanese.h"

#include "resources/lok_pc98.h"
#include "resources/lok_pc98_japanese.h"

// The Hand of Fate
#include "resources/hof_dos_demo.h"

#include "resources/hof_dos.h"
#include "resources/hof_dos_english.h"
#include "resources/hof_dos_french.h"
#include "resources/hof_dos_german.h"
#include "resources/hof_dos_italian.h"
#include "resources/hof_dos_russian.h"
#include "resources/hof_dos_spanish.h"
#include "resources/hof_dos_chinese_trad.h"
#include "resources/hof_dos_polish.h"

#include "resources/hof_dos_cddemo.h"
#include "resources/hof_dos_cddemo_english.h"
#include "resources/hof_dos_cddemo_french.h"
#include "resources/hof_dos_cddemo_german.h"

#include "resources/hof_dos_cd.h"
#include "resources/hof_dos_cd_english.h"
#include "resources/hof_dos_cd_french.h"
#include "resources/hof_dos_cd_german.h"
#include "resources/hof_dos_cd_italian.h"
#include "resources/hof_dos_cd_russian.h"
#include "resources/hof_dos_cd_spanish.h"
#include "resources/hof_dos_cd_hebrew.h"
#include "resources/hof_dos_cd_czech.h"

#include "resources/hof_fmtowns.h"
#include "resources/hof_fmtowns_english.h"
#include "resources/hof_fmtowns_japanese.h"

#include "resources/hof_pc98.h"
#include "resources/hof_pc98_english.h"
#include "resources/hof_pc98_japanese.h"

// Malcolm's Revenge
#include "resources/mr_dos_cd.h"
#include "resources/mr_dos_cd_english.h"
#include "resources/mr_dos_cd_french.h"
#include "resources/mr_dos_cd_german.h"
#include "resources/mr_dos_cd_italian.h"
#include "resources/mr_dos_cd_spanish.h"
#include "resources/mr_dos_cd_russian.h"
#include "resources/mr_dos_cd_hebrew.h"
#include "resources/mr_dos_cd_czech.h"
#include "resources/mr_dos_cd_chinese_simplified.h"
#include "resources/mr_dos_cd_chinese_trad.h"

// Eye of the Beholder
#include "resources/eob1_dos.h"
#include "resources/eob1_dos_english.h"
#include "resources/eob1_dos_german.h"
#include "resources/eob1_dos_italian.h"
#include "resources/eob1_dos_spanish.h"
#include "resources/eob1_amiga.h"
#include "resources/eob1_amiga_english.h"
#include "resources/eob1_amiga_german.h"
#include "resources/eob1_pc98.h"
#include "resources/eob1_pc98_japanese.h"
#include "resources/eob1_segacd.h"
#include "resources/eob1_segacd_english.h"
#include "resources/eob1_segacd_japanese.h"

// Eye of the Beholder: The Legend of Darkmoon
#include "resources/eob2_dos.h"
#include "resources/eob2_dos_chinese.h"
#include "resources/eob2_dos_english.h"
#include "resources/eob2_dos_german.h"
#include "resources/eob2_dos_spanish.h"
#include "resources/eob2_amiga.h"
#include "resources/eob2_amiga_english.h"
#include "resources/eob2_amiga_german.h"
#include "resources/eob2_pc98.h"
#include "resources/eob2_pc98_japanese.h"
#include "resources/eob2_fmtowns.h"
#include "resources/eob2_fmtowns_japanese.h"

// Lands of Lore
#include "resources/lol_dos_demo.h"
#include "resources/lol_dos_demo_english.h"
#include "resources/lol_dos_cddemo.h"

#include "resources/lol_dos.h"
#include "resources/lol_dos_english.h"
#include "resources/lol_dos_chinese.h"
#include "resources/lol_dos_french.h"
#include "resources/lol_dos_german.h"
#include "resources/lol_dos_russian.h"
#include "resources/lol_dos_spanish.h"

#include "resources/lol_dos_cd.h"
#include "resources/lol_dos_cd_english.h"
#include "resources/lol_dos_cd_french.h"
#include "resources/lol_dos_cd_german.h"
#include "resources/lol_dos_cd_italian.h"
#include "resources/lol_dos_cd_russian.h"
#include "resources/lol_dos_cd_spanish.h"

#include "resources/lol_pc98.h"
#include "resources/lol_pc98_japanese.h"

#include "resources/lol_fmtowns.h"
#include "resources/lol_fmtowns_japanese.h"

static const ResourceProvider resourceProviders[] = {
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1WestwoodLogoSeqDOSDemoProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1KyrandiaLogoSeqDOSDemoProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1IntroCPSStringsDOSDemoProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1IntroCOLStringsDOSDemoProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1IntroWSAStringsDOSDemoProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kDemoVersion, EN_ANY, &k1IntroStringsDOSDemoEnglishProvider },
	{ k1Demo1Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo1SeqDOSDemoProvider },
	{ k1Demo2Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo2SeqDOSDemoProvider },
	{ k1Demo3Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo3SeqDOSDemoProvider },
	{ k1Demo4Seq, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1Demo4SeqDOSDemoProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kDemoVersion, UNK_LANG, &k1AudioTracksIntroDOSDemoProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1KallakWritingSeqDOSCDDemoProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1MalcolmTreeSeqDOSCDDemoProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1WestwoodLogoSeqDOSCDDemoProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1KyrandiaLogoSeqDOSCDDemoProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1KallakMalcolmSeqDOSCDDemoProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1ForestSeqDOSCDDemoProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1IntroCPSStringsDOSCDDemoProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1IntroCOLStringsDOSCDDemoProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1IntroWSAStringsDOSCDDemoProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k1IntroStringsDOSCDDemoEnglishProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k1AudioTracksIntroDOSCDDemoProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1KallakWritingSeqAmigaProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqAmigaProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqAmigaProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqAmigaProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqAmigaProvider },
	{ k1ForestSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1ForestSeqAmigaProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1IntroCPSStringsAmigaProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1IntroWSAStringsAmigaProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1IntroCOLStringsAmigaProvider },
	{ k1IntroStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1IntroStringsAmigaEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1RoomListAmigaProvider },
	{ k1RoomFilenames, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1RoomFilenamesAmigaProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesAmigaProvider },
	{ k1DefaultShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1DefaultShapesAmigaProvider },
	{ k1ItemNames, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1ItemNamesAmigaEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1TakenStringsAmigaEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1PlacedStringsAmigaEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1DroppedStringsAmigaEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1NoDropStringsAmigaEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqAmigaProvider },
	{ k1PutDownString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1PutDownStringAmigaEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1WaitAmuletStringAmigaEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1BlackJewelStringAmigaEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1HealingTipStringAmigaEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1PoisonGoneStringAmigaEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Healing1ShapesAmigaProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Healing2ShapesAmigaProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1ThePoisonStringsAmigaEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1FluteStringsAmigaEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesAmigaProvider },
	{ k1FluteShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1FluteShapesAmigaProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Winter1ShapesAmigaProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Winter2ShapesAmigaProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1Winter3ShapesAmigaProvider },
	{ k1DrinkShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1DrinkShapesAmigaProvider },
	{ k1WispShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1WispShapesAmigaProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1MagicAnimShapesAmigaProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1BranStoneShapesAmigaProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1WispJewelStringsAmigaEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1MagicJewelStringsAmigaEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1FlaskFullStringAmigaEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1FullFlaskStringAmigaEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1OutroReunionSeqAmigaProvider },
	{ k1OutroHomeString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1OutroHomeStringAmigaEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1VeryCleverStringAmigaEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1GUIStringsAmigaEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1NewGameStringAmigaEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1ConfigStringsAmigaEnglishProvider },
	{ k1CreditsStrings, kKyra1, kPlatformAmiga, kNoSpecial, EN_ANY, &k1CreditsStringsAmigaEnglishProvider },
	{ k1AmigaIntroSFXTable, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1AmigaIntroSFXTableAmigaProvider },
	{ k1AmigaGameSFXTable, kKyra1, kPlatformAmiga, kNoSpecial, UNK_LANG, &k1AmigaGameSFXTableAmigaProvider },
	{ k1IntroStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1IntroStringsAmigaGermanProvider },
	{ k1ItemNames, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1ItemNamesAmigaGermanProvider },
	{ k1TakenStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1TakenStringsAmigaGermanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1PlacedStringsAmigaGermanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1DroppedStringsAmigaGermanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1NoDropStringsAmigaGermanProvider },
	{ k1PutDownString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1PutDownStringAmigaGermanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1WaitAmuletStringAmigaGermanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1BlackJewelStringAmigaGermanProvider },
	{ k1HealingTipString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1HealingTipStringAmigaGermanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1PoisonGoneStringAmigaGermanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1ThePoisonStringsAmigaGermanProvider },
	{ k1FluteStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1FluteStringsAmigaGermanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1WispJewelStringsAmigaGermanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1MagicJewelStringsAmigaGermanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1FlaskFullStringAmigaGermanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1FullFlaskStringAmigaGermanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1OutroHomeStringAmigaGermanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1VeryCleverStringAmigaGermanProvider },
	{ k1GUIStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1GUIStringsAmigaGermanProvider },
	{ k1NewGameString, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1NewGameStringAmigaGermanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1ConfigStringsAmigaGermanProvider },
	{ k1CreditsStrings, kKyra1, kPlatformAmiga, kNoSpecial, DE_DEU, &k1CreditsStringsAmigaGermanProvider },
	{ k1IntroStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1IntroStringsAmigaFrenchProvider },
	{ k1ItemNames, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1ItemNamesAmigaFrenchProvider },
	{ k1TakenStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1TakenStringsAmigaFrenchProvider },
	{ k1PlacedStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1PlacedStringsAmigaFrenchProvider },
	{ k1DroppedStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1DroppedStringsAmigaFrenchProvider },
	{ k1NoDropStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1NoDropStringsAmigaFrenchProvider },
	{ k1PutDownString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1PutDownStringAmigaFrenchProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1WaitAmuletStringAmigaFrenchProvider },
	{ k1BlackJewelString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1BlackJewelStringAmigaFrenchProvider },
	{ k1HealingTipString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1HealingTipStringAmigaFrenchProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1PoisonGoneStringAmigaFrenchProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1ThePoisonStringsAmigaFrenchProvider },
	{ k1FluteStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1FluteStringsAmigaFrenchProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1WispJewelStringsAmigaFrenchProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1MagicJewelStringsAmigaFrenchProvider },
	{ k1FlaskFullString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1FlaskFullStringAmigaFrenchProvider },
	{ k1FullFlaskString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1FullFlaskStringAmigaFrenchProvider },
	{ k1OutroHomeString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1OutroHomeStringAmigaFrenchProvider },
	{ k1VeryCleverString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1VeryCleverStringAmigaFrenchProvider },
	{ k1GUIStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1GUIStringsAmigaFrenchProvider },
	{ k1NewGameString, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1NewGameStringAmigaFrenchProvider },
	{ k1ConfigStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1ConfigStringsAmigaFrenchProvider },
	{ k1CreditsStrings, kKyra1, kPlatformAmiga, kNoSpecial, FR_FRA, &k1CreditsStringsAmigaFrenchProvider },
	{ k1IntroStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1IntroStringsAmigaItalianProvider },
	{ k1ItemNames, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1ItemNamesAmigaItalianProvider },
	{ k1TakenStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1TakenStringsAmigaItalianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1PlacedStringsAmigaItalianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1DroppedStringsAmigaItalianProvider },
	{ k1NoDropStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1NoDropStringsAmigaItalianProvider },
	{ k1PutDownString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1PutDownStringAmigaItalianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1WaitAmuletStringAmigaItalianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1BlackJewelStringAmigaItalianProvider },
	{ k1HealingTipString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1HealingTipStringAmigaItalianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1PoisonGoneStringAmigaItalianProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1ThePoisonStringsAmigaItalianProvider },
	{ k1FluteStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1FluteStringsAmigaItalianProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1WispJewelStringsAmigaItalianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1MagicJewelStringsAmigaItalianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1FlaskFullStringAmigaItalianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1FullFlaskStringAmigaItalianProvider },
	{ k1OutroHomeString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1OutroHomeStringAmigaItalianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1VeryCleverStringAmigaItalianProvider },
	{ k1GUIStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1GUIStringsAmigaItalianProvider },
	{ k1NewGameString, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1NewGameStringAmigaItalianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1ConfigStringsAmigaItalianProvider },
	{ k1CreditsStrings, kKyra1, kPlatformAmiga, kNoSpecial, IT_ITA, &k1CreditsStringsAmigaItalianProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1KallakWritingSeqDOSProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqDOSProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqDOSProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqDOSProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqDOSProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1ForestSeqDOSProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1IntroCPSStringsDOSProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1IntroCOLStringsDOSProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1IntroWSAStringsDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1IntroStringsDOSEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1RoomListDOSProvider },
	{ k1RoomFilenames, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1RoomFilenamesDOSProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesDOSProvider },
	{ k1DefaultShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1DefaultShapesDOSProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1ItemNamesDOSEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1TakenStringsDOSEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1PlacedStringsDOSEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1DroppedStringsDOSEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1NoDropStringsDOSEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqDOSProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette1DOSProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette2DOSProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette3DOSProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette4DOSProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette5DOSProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette6DOSProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette7DOSProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette8DOSProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette9DOSProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette10DOSProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette11DOSProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette12DOSProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette13DOSProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette14DOSProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette15DOSProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette16DOSProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette17DOSProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette18DOSProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette19DOSProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette20DOSProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette21DOSProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette22DOSProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette23DOSProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette24DOSProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette25DOSProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette26DOSProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette27DOSProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette28DOSProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette29DOSProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette30DOSProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette31DOSProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette32DOSProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1SpecialPalette33DOSProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1PutDownStringDOSEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1WaitAmuletStringDOSEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1BlackJewelStringDOSEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1HealingTipStringDOSEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1PoisonGoneStringDOSEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Healing1ShapesDOSProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Healing2ShapesDOSProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1ThePoisonStringsDOSEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1FluteStringsDOSEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesDOSProvider },
	{ k1FluteShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1FluteShapesDOSProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Winter1ShapesDOSProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Winter2ShapesDOSProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1Winter3ShapesDOSProvider },
	{ k1DrinkShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1DrinkShapesDOSProvider },
	{ k1WispShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1WispShapesDOSProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1MagicAnimShapesDOSProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1BranStoneShapesDOSProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1WispJewelStringsDOSEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1MagicJewelStringsDOSEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1FlaskFullStringDOSEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1FullFlaskStringDOSEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1OutroReunionSeqDOSProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1OutroHomeStringDOSEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1VeryCleverStringDOSEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1GUIStringsDOSEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1NewGameStringDOSEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1ConfigStringsDOSEnglishProvider },
	{ k1TwoByteFontLookupTable, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1TwoByteFontLookupTableDOSProvider },
	{ k1CreditsStrings, kKyra1, kPlatformDOS, kNoSpecial, EN_ANY, &k1k1CreditsStringsDummyDOSProvider },
	{ k1AudioTracks, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1AudioTracksDOSProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, &k1AudioTracksIntroDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1IntroStringsDOSGermanProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1ItemNamesDOSGermanProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1TakenStringsDOSGermanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1PlacedStringsDOSGermanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1DroppedStringsDOSGermanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1NoDropStringsDOSGermanProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1PutDownStringDOSGermanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1WaitAmuletStringDOSGermanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1BlackJewelStringDOSGermanProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1HealingTipStringDOSGermanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1PoisonGoneStringDOSGermanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1ThePoisonStringsDOSGermanProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1FluteStringsDOSGermanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1WispJewelStringsDOSGermanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1MagicJewelStringsDOSGermanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1FlaskFullStringDOSGermanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1FullFlaskStringDOSGermanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1OutroHomeStringDOSGermanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1VeryCleverStringDOSGermanProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1GUIStringsDOSGermanProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1NewGameStringDOSGermanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1ConfigStringsDOSGermanProvider },
	{ k1TwoByteFontLookupTable, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1TwoByteFontLookupTableDOSProvider },
	{ k1CreditsStrings, kKyra1, kPlatformDOS, kNoSpecial, DE_DEU, &k1k1CreditsStringsDummyDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1IntroStringsDOSFrenchProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1ItemNamesDOSFrenchProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1TakenStringsDOSFrenchProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1PlacedStringsDOSFrenchProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1DroppedStringsDOSFrenchProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1NoDropStringsDOSFrenchProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1PutDownStringDOSFrenchProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1WaitAmuletStringDOSFrenchProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1BlackJewelStringDOSFrenchProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1HealingTipStringDOSFrenchProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1PoisonGoneStringDOSFrenchProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1ThePoisonStringsDOSFrenchProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1FluteStringsDOSFrenchProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1WispJewelStringsDOSFrenchProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1MagicJewelStringsDOSFrenchProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1FlaskFullStringDOSFrenchProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1FullFlaskStringDOSFrenchProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1OutroHomeStringDOSFrenchProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1VeryCleverStringDOSFrenchProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1GUIStringsDOSFrenchProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1NewGameStringDOSFrenchProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1ConfigStringsDOSFrenchProvider },
	{ k1TwoByteFontLookupTable, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1TwoByteFontLookupTableDOSProvider },
	{ k1CreditsStrings, kKyra1, kPlatformDOS, kNoSpecial, FR_FRA, &k1k1CreditsStringsDummyDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1IntroStringsDOSItalianProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1ItemNamesDOSItalianProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1TakenStringsDOSItalianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1PlacedStringsDOSItalianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1DroppedStringsDOSItalianProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1NoDropStringsDOSItalianProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1PutDownStringDOSItalianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1WaitAmuletStringDOSItalianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1BlackJewelStringDOSItalianProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1HealingTipStringDOSItalianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1PoisonGoneStringDOSItalianProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1ThePoisonStringsDOSItalianProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1FluteStringsDOSItalianProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1WispJewelStringsDOSItalianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1MagicJewelStringsDOSItalianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1FlaskFullStringDOSItalianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1FullFlaskStringDOSItalianProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1OutroHomeStringDOSItalianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1VeryCleverStringDOSItalianProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1GUIStringsDOSItalianProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1NewGameStringDOSItalianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1ConfigStringsDOSItalianProvider },
	{ k1TwoByteFontLookupTable, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1TwoByteFontLookupTableDOSProvider },
	{ k1CreditsStrings, kKyra1, kPlatformDOS, kNoSpecial, IT_ITA, &k1k1CreditsStringsDummyDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1IntroStringsDOSSpanishProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1ItemNamesDOSSpanishProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1TakenStringsDOSSpanishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1PlacedStringsDOSSpanishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1DroppedStringsDOSSpanishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1NoDropStringsDOSSpanishProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1PutDownStringDOSSpanishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1WaitAmuletStringDOSSpanishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1BlackJewelStringDOSSpanishProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1HealingTipStringDOSSpanishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1PoisonGoneStringDOSSpanishProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1ThePoisonStringsDOSSpanishProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1FluteStringsDOSSpanishProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1WispJewelStringsDOSSpanishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1MagicJewelStringsDOSSpanishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1FlaskFullStringDOSSpanishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1FullFlaskStringDOSSpanishProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1OutroHomeStringDOSSpanishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1VeryCleverStringDOSSpanishProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1GUIStringsDOSSpanishProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1NewGameStringDOSSpanishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1ConfigStringsDOSSpanishProvider },
	{ k1TwoByteFontLookupTable, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1TwoByteFontLookupTableDOSProvider },
	{ k1CreditsStrings, kKyra1, kPlatformDOS, kNoSpecial, ES_ESP, &k1k1CreditsStringsDummyDOSProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1IntroStringsDOSKoreanProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1ItemNamesDOSKoreanProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1TakenStringsDOSKoreanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1PlacedStringsDOSKoreanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1DroppedStringsDOSKoreanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1NoDropStringsDOSKoreanProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1PutDownStringDOSKoreanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1WaitAmuletStringDOSKoreanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1BlackJewelStringDOSKoreanProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1HealingTipStringDOSKoreanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1PoisonGoneStringDOSKoreanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1ThePoisonStringsDOSKoreanProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1FluteStringsDOSKoreanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1WispJewelStringsDOSKoreanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1MagicJewelStringsDOSKoreanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1FlaskFullStringDOSKoreanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1FullFlaskStringDOSKoreanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1OutroHomeStringDOSKoreanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1VeryCleverStringDOSKoreanProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1GUIStringsDOSKoreanProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1NewGameStringDOSKoreanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1ConfigStringsDOSKoreanProvider },
	{ k1TwoByteFontLookupTable, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1TwoByteFontLookupTableDOSKoreanProvider },
	{ k1CreditsStrings, kKyra1, kPlatformDOS, kNoSpecial, KO_KOR, &k1CreditsStringsDOSKoreanProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1IntroStringsDOSChineseTradProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1ItemNamesDOSChineseTradProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1TakenStringsDOSChineseTradProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1PlacedStringsDOSChineseTradProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1DroppedStringsDOSChineseTradProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1NoDropStringsDOSChineseTradProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1PutDownStringDOSChineseTradProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1WaitAmuletStringDOSChineseTradProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1BlackJewelStringDOSChineseTradProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1HealingTipStringDOSChineseTradProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1PoisonGoneStringDOSChineseTradProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1ThePoisonStringsDOSChineseTradProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1FluteStringsDOSChineseTradProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1WispJewelStringsDOSChineseTradProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1MagicJewelStringsDOSChineseTradProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1FlaskFullStringDOSChineseTradProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1FullFlaskStringDOSChineseTradProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1OutroHomeStringDOSChineseTradProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1VeryCleverStringDOSChineseTradProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1GUIStringsDOSChineseTradProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1NewGameStringDOSChineseTradProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1ConfigStringsDOSChineseTradProvider },
	{ k1TwoByteFontLookupTable, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1TwoByteFontLookupTableDOSChineseTradProvider },
	{ k1CreditsStrings, kKyra1, kPlatformDOS, kNoSpecial, ZH_TWN, &k1CreditsStringsDOSChineseTradProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1KallakWritingSeqDOSOldFloppyProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1MalcolmTreeSeqDOSOldFloppyProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1WestwoodLogoSeqDOSOldFloppyProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1KyrandiaLogoSeqDOSOldFloppyProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1KallakMalcolmSeqDOSOldFloppyProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1ForestSeqDOSOldFloppyProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1IntroCPSStringsDOSOldFloppyProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1IntroCOLStringsDOSOldFloppyProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1IntroWSAStringsDOSOldFloppyProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1IntroStringsDOSOldFloppyRussianProvider },
	{ k1RoomList, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1RoomListDOSOldFloppyProvider },
	{ k1RoomFilenames, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1RoomFilenamesDOSOldFloppyProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1CharacterImageFilenamesDOSOldFloppyProvider },
	{ k1DefaultShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1DefaultShapesDOSOldFloppyProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1ItemNamesDOSOldFloppyRussianProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1TakenStringsDOSOldFloppyRussianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1PlacedStringsDOSOldFloppyRussianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1DroppedStringsDOSOldFloppyRussianProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1AmuleteAnimSeqDOSOldFloppyProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette1DOSOldFloppyProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette2DOSOldFloppyProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette3DOSOldFloppyProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette4DOSOldFloppyProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette5DOSOldFloppyProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette6DOSOldFloppyProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette7DOSOldFloppyProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette8DOSOldFloppyProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette9DOSOldFloppyProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette10DOSOldFloppyProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette11DOSOldFloppyProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette12DOSOldFloppyProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette13DOSOldFloppyProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette14DOSOldFloppyProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette15DOSOldFloppyProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette16DOSOldFloppyProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette17DOSOldFloppyProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette18DOSOldFloppyProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette19DOSOldFloppyProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette20DOSOldFloppyProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette21DOSOldFloppyProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette22DOSOldFloppyProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette23DOSOldFloppyProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette24DOSOldFloppyProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette25DOSOldFloppyProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette26DOSOldFloppyProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette27DOSOldFloppyProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette28DOSOldFloppyProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette29DOSOldFloppyProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette30DOSOldFloppyProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette31DOSOldFloppyProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette32DOSOldFloppyProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1SpecialPalette33DOSOldFloppyProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1PutDownStringDOSOldFloppyRussianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1WaitAmuletStringDOSOldFloppyRussianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1BlackJewelStringDOSOldFloppyRussianProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1HealingTipStringDOSOldFloppyRussianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1PoisonGoneStringDOSOldFloppyRussianProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Healing1ShapesDOSOldFloppyProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Healing2ShapesDOSOldFloppyProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1ThePoisonStringsDOSOldFloppyRussianProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1FluteStringsDOSOldFloppyRussianProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1PoisonDeathShapesDOSOldFloppyProvider },
	{ k1FluteShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1FluteShapesDOSOldFloppyProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Winter1ShapesDOSOldFloppyProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Winter2ShapesDOSOldFloppyProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1Winter3ShapesDOSOldFloppyProvider },
	{ k1DrinkShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1DrinkShapesDOSOldFloppyProvider },
	{ k1WispShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1WispShapesDOSOldFloppyProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1MagicAnimShapesDOSOldFloppyProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1BranStoneShapesDOSOldFloppyProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1WispJewelStringsDOSOldFloppyRussianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1MagicJewelStringsDOSOldFloppyRussianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1FlaskFullStringDOSOldFloppyRussianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1FullFlaskStringDOSOldFloppyRussianProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1OutroReunionSeqDOSOldFloppyProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1OutroHomeStringDOSOldFloppyRussianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1VeryCleverStringDOSOldFloppyRussianProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1GUIStringsDOSOldFloppyRussianProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1NewGameStringDOSOldFloppyRussianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kOldFloppy, RU_RUS, &k1ConfigStringsDOSOldFloppyRussianProvider },
	{ k1AudioTracks, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1AudioTracksDOSOldFloppyProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kOldFloppy, UNK_LANG, &k1AudioTracksIntroDOSOldFloppyProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1IntroStringsDOSOldFloppyCzechProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1ItemNamesDOSOldFloppyCzechProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1TakenStringsDOSOldFloppyCzechProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1PlacedStringsDOSOldFloppyCzechProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1DroppedStringsDOSOldFloppyCzechProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1PutDownStringDOSOldFloppyCzechProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1WaitAmuletStringDOSOldFloppyCzechProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1BlackJewelStringDOSOldFloppyCzechProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1HealingTipStringDOSOldFloppyCzechProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1PoisonGoneStringDOSOldFloppyCzechProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1ThePoisonStringsDOSOldFloppyCzechProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1FluteStringsDOSOldFloppyCzechProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1WispJewelStringsDOSOldFloppyCzechProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1MagicJewelStringsDOSOldFloppyCzechProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1FlaskFullStringDOSOldFloppyCzechProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1FullFlaskStringDOSOldFloppyCzechProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1OutroHomeStringDOSOldFloppyCzechProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1VeryCleverStringDOSOldFloppyCzechProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1GUIStringsDOSOldFloppyCzechProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1NewGameStringDOSOldFloppyCzechProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kOldFloppy, CS_CZE, &k1ConfigStringsDOSOldFloppyCzechProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1KallakWritingSeqDOSCDProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1MalcolmTreeSeqDOSCDProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1WestwoodLogoSeqDOSCDProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1KyrandiaLogoSeqDOSCDProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1KallakMalcolmSeqDOSCDProvider },
	{ k1ForestSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1ForestSeqDOSCDProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1IntroCPSStringsDOSCDProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1IntroCOLStringsDOSCDProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1IntroWSAStringsDOSCDProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1IntroStringsDOSCDEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1RoomListDOSCDProvider },
	{ k1RoomFilenames, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1RoomFilenamesDOSCDProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1CharacterImageFilenamesDOSCDProvider },
	{ k1DefaultShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1DefaultShapesDOSCDProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1ItemNamesDOSCDEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1TakenStringsDOSCDEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1PlacedStringsDOSCDEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1DroppedStringsDOSCDEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1NoDropStringsDOSCDEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1AmuleteAnimSeqDOSCDProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette1DOSCDProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette2DOSCDProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette3DOSCDProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette4DOSCDProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette5DOSCDProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette6DOSCDProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette7DOSCDProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette8DOSCDProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette9DOSCDProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette10DOSCDProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette11DOSCDProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette12DOSCDProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette13DOSCDProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette14DOSCDProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette15DOSCDProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette16DOSCDProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette17DOSCDProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette18DOSCDProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette19DOSCDProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette20DOSCDProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette21DOSCDProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette22DOSCDProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette23DOSCDProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette24DOSCDProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette25DOSCDProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette26DOSCDProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette27DOSCDProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette28DOSCDProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette29DOSCDProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette30DOSCDProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette31DOSCDProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette32DOSCDProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1SpecialPalette33DOSCDProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1PutDownStringDOSCDEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1WaitAmuletStringDOSCDEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1BlackJewelStringDOSCDEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1HealingTipStringDOSCDEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1PoisonGoneStringDOSCDEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Healing1ShapesDOSCDProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Healing2ShapesDOSCDProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1ThePoisonStringsDOSCDEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1FluteStringsDOSCDEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1PoisonDeathShapesDOSCDProvider },
	{ k1FluteShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1FluteShapesDOSCDProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Winter1ShapesDOSCDProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Winter2ShapesDOSCDProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1Winter3ShapesDOSCDProvider },
	{ k1DrinkShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1DrinkShapesDOSCDProvider },
	{ k1WispShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1WispShapesDOSCDProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1MagicAnimShapesDOSCDProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1BranStoneShapesDOSCDProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1WispJewelStringsDOSCDEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1MagicJewelStringsDOSCDEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1FlaskFullStringDOSCDEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1FullFlaskStringDOSCDEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1OutroReunionSeqDOSCDProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1OutroHomeStringDOSCDEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1VeryCleverStringDOSCDEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1GUIStringsDOSCDEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1NewGameStringDOSCDEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, EN_ANY, &k1ConfigStringsDOSCDEnglishProvider },
	{ k1AudioTracks, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1AudioTracksDOSCDProvider },
	{ k1AudioTracksIntro, kKyra1, kPlatformDOS, kTalkieVersion, UNK_LANG, &k1AudioTracksIntroDOSCDProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1IntroStringsDOSCDGermanProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1ItemNamesDOSCDGermanProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1TakenStringsDOSCDGermanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1PlacedStringsDOSCDGermanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1DroppedStringsDOSCDGermanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1NoDropStringsDOSCDGermanProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1PutDownStringDOSCDGermanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1WaitAmuletStringDOSCDGermanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1BlackJewelStringDOSCDGermanProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1HealingTipStringDOSCDGermanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1PoisonGoneStringDOSCDGermanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1ThePoisonStringsDOSCDGermanProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1FluteStringsDOSCDGermanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1WispJewelStringsDOSCDGermanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1MagicJewelStringsDOSCDGermanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1FlaskFullStringDOSCDGermanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1FullFlaskStringDOSCDGermanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1OutroHomeStringDOSCDGermanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1VeryCleverStringDOSCDGermanProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1GUIStringsDOSCDGermanProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1NewGameStringDOSCDGermanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, DE_DEU, &k1ConfigStringsDOSCDGermanProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1IntroStringsDOSCDFrenchProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1ItemNamesDOSCDFrenchProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1TakenStringsDOSCDFrenchProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1PlacedStringsDOSCDFrenchProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1DroppedStringsDOSCDFrenchProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1NoDropStringsDOSCDFrenchProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1PutDownStringDOSCDFrenchProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1WaitAmuletStringDOSCDFrenchProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1BlackJewelStringDOSCDFrenchProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1HealingTipStringDOSCDFrenchProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1PoisonGoneStringDOSCDFrenchProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1ThePoisonStringsDOSCDFrenchProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1FluteStringsDOSCDFrenchProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1WispJewelStringsDOSCDFrenchProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1MagicJewelStringsDOSCDFrenchProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1FlaskFullStringDOSCDFrenchProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1FullFlaskStringDOSCDFrenchProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1OutroHomeStringDOSCDFrenchProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1VeryCleverStringDOSCDFrenchProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1GUIStringsDOSCDFrenchProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1NewGameStringDOSCDFrenchProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, FR_FRA, &k1ConfigStringsDOSCDFrenchProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1IntroStringsDOSCDItalianProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1ItemNamesDOSCDItalianProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1TakenStringsDOSCDItalianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1PlacedStringsDOSCDItalianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1DroppedStringsDOSCDItalianProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1NoDropStringsDOSCDItalianProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1PutDownStringDOSCDItalianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1WaitAmuletStringDOSCDItalianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1BlackJewelStringDOSCDItalianProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1HealingTipStringDOSCDItalianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1PoisonGoneStringDOSCDItalianProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1ThePoisonStringsDOSCDItalianProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1FluteStringsDOSCDItalianProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1WispJewelStringsDOSCDItalianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1MagicJewelStringsDOSCDItalianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1FlaskFullStringDOSCDItalianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1FullFlaskStringDOSCDItalianProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1OutroHomeStringDOSCDItalianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1VeryCleverStringDOSCDItalianProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1GUIStringsDOSCDItalianProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1NewGameStringDOSCDItalianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, IT_ITA, &k1ConfigStringsDOSCDItalianProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1IntroStringsDOSCDSpanishProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1ItemNamesDOSCDSpanishProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1TakenStringsDOSCDSpanishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1PlacedStringsDOSCDSpanishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1DroppedStringsDOSCDSpanishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1NoDropStringsDOSCDSpanishProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1PutDownStringDOSCDSpanishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1WaitAmuletStringDOSCDSpanishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1BlackJewelStringDOSCDSpanishProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1HealingTipStringDOSCDSpanishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1PoisonGoneStringDOSCDSpanishProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1ThePoisonStringsDOSCDSpanishProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1FluteStringsDOSCDSpanishProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1WispJewelStringsDOSCDSpanishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1MagicJewelStringsDOSCDSpanishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1FlaskFullStringDOSCDSpanishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1FullFlaskStringDOSCDSpanishProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1OutroHomeStringDOSCDSpanishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1VeryCleverStringDOSCDSpanishProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1GUIStringsDOSCDSpanishProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1NewGameStringDOSCDSpanishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, ES_ESP, &k1ConfigStringsDOSCDSpanishProvider },

	/*{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1IntroStringsDOSCDRussianProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1ItemNamesDOSCDRussianProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1TakenStringsDOSCDRussianProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1PlacedStringsDOSCDRussianProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1DroppedStringsDOSCDRussianProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1NoDropStringsDOSCDRussianProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1PutDownStringDOSCDRussianProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1WaitAmuletStringDOSCDRussianProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1BlackJewelStringDOSCDRussianProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1HealingTipStringDOSCDRussianProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1PoisonGoneStringDOSCDRussianProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1ThePoisonStringsDOSCDRussianProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1FluteStringsDOSCDRussianProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1WispJewelStringsDOSCDRussianProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1MagicJewelStringsDOSCDRussianProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1FlaskFullStringDOSCDRussianProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1FullFlaskStringDOSCDRussianProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1OutroHomeStringDOSCDRussianProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1VeryCleverStringDOSCDRussianProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1GUIStringsDOSCDRussianProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1NewGameStringDOSCDRussianProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, RU_RUS, &k1ConfigStringsDOSCDRussianProvider },*/

	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1IntroStringsDOSCDHebrewProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1ItemNamesDOSCDHebrewProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1TakenStringsDOSCDHebrewProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1PlacedStringsDOSCDHebrewProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1DroppedStringsDOSCDHebrewProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1NoDropStringsDOSCDHebrewProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1PutDownStringDOSCDHebrewProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1WaitAmuletStringDOSCDHebrewProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1BlackJewelStringDOSCDHebrewProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1HealingTipStringDOSCDHebrewProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1PoisonGoneStringDOSCDHebrewProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1ThePoisonStringsDOSCDHebrewProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1FluteStringsDOSCDHebrewProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1WispJewelStringsDOSCDHebrewProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1MagicJewelStringsDOSCDHebrewProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1FlaskFullStringDOSCDHebrewProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1FullFlaskStringDOSCDHebrewProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1OutroHomeStringDOSCDHebrewProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1VeryCleverStringDOSCDHebrewProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1GUIStringsDOSCDHebrewProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1NewGameStringDOSCDHebrewProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, HE_ISR, &k1ConfigStringsDOSCDHebrewProvider },
	{ k1IntroStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1IntroStringsDOSCDCzechProvider },
	{ k1ItemNames, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1ItemNamesDOSCDCzechProvider },
	{ k1TakenStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1TakenStringsDOSCDCzechProvider },
	{ k1PlacedStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1PlacedStringsDOSCDCzechProvider },
	{ k1DroppedStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1DroppedStringsDOSCDCzechProvider },
	{ k1NoDropStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1NoDropStringsDOSCDCzechProvider },
	{ k1PutDownString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1PutDownStringDOSCDCzechProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1WaitAmuletStringDOSCDCzechProvider },
	{ k1BlackJewelString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1BlackJewelStringDOSCDCzechProvider },
	{ k1HealingTipString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1HealingTipStringDOSCDCzechProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1PoisonGoneStringDOSCDCzechProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1ThePoisonStringsDOSCDCzechProvider },
	{ k1FluteStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1FluteStringsDOSCDCzechProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1WispJewelStringsDOSCDCzechProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1MagicJewelStringsDOSCDCzechProvider },
	{ k1FlaskFullString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1FlaskFullStringDOSCDCzechProvider },
	{ k1FullFlaskString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1FullFlaskStringDOSCDCzechProvider },
	{ k1OutroHomeString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1OutroHomeStringDOSCDCzechProvider },
	{ k1VeryCleverString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1VeryCleverStringDOSCDCzechProvider },
	{ k1GUIStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1GUIStringsDOSCDCzechProvider },
	{ k1NewGameString, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1NewGameStringDOSCDCzechProvider },
	{ k1ConfigStrings, kKyra1, kPlatformDOS, kTalkieVersion, CS_CZE, &k1ConfigStringsDOSCDCzechProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1KallakWritingSeqFMTownsProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqFMTownsProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqFMTownsProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqFMTownsProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqFMTownsProvider },
	{ k1ForestSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1ForestSeqFMTownsProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1IntroCPSStringsFMTownsProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1IntroCOLStringsFMTownsProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1IntroWSAStringsFMTownsProvider },
	{ k1IntroStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1IntroStringsFMTownsEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1RoomListFMTownsProvider },
	{ k1RoomFilenames, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1RoomFilenamesFMTownsProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesFMTownsProvider },
	{ k1DefaultShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1DefaultShapesFMTownsProvider },
	{ k1ItemNames, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1ItemNamesFMTownsEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1TakenStringsFMTownsEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1PlacedStringsFMTownsEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1DroppedStringsFMTownsEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1NoDropStringsFMTownsEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqFMTownsProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette1FMTownsProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette2FMTownsProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette3FMTownsProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette4FMTownsProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette5FMTownsProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette6FMTownsProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette7FMTownsProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette8FMTownsProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette9FMTownsProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette10FMTownsProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette11FMTownsProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette12FMTownsProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette13FMTownsProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette14FMTownsProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette15FMTownsProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette16FMTownsProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette17FMTownsProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette18FMTownsProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette19FMTownsProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette20FMTownsProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette21FMTownsProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette22FMTownsProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette23FMTownsProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette24FMTownsProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette25FMTownsProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette26FMTownsProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette27FMTownsProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette28FMTownsProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette29FMTownsProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette30FMTownsProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette31FMTownsProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette32FMTownsProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1SpecialPalette33FMTownsProvider },
	{ k1PutDownString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1PutDownStringFMTownsEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1WaitAmuletStringFMTownsEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1BlackJewelStringFMTownsEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1HealingTipStringFMTownsEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1PoisonGoneStringFMTownsEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Healing1ShapesFMTownsProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Healing2ShapesFMTownsProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1ThePoisonStringsFMTownsEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1FluteStringsFMTownsEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesFMTownsProvider },
	{ k1FluteShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1FluteShapesFMTownsProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Winter1ShapesFMTownsProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Winter2ShapesFMTownsProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1Winter3ShapesFMTownsProvider },
	{ k1DrinkShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1DrinkShapesFMTownsProvider },
	{ k1WispShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1WispShapesFMTownsProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1MagicAnimShapesFMTownsProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1BranStoneShapesFMTownsProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1WispJewelStringsFMTownsEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1MagicJewelStringsFMTownsEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1FlaskFullStringFMTownsEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1FullFlaskStringFMTownsEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1OutroReunionSeqFMTownsProvider },
	{ k1OutroHomeString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1OutroHomeStringFMTownsEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1VeryCleverStringFMTownsEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1GUIStringsFMTownsEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1NewGameStringFMTownsEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1ConfigStringsFMTownsEnglishProvider },
	{ k1TownsMusicFadeTable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsMusicFadeTableFMTownsProvider },
	{ k1TownsSFXwdTable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsSFXwdTableFMTownsProvider },
	{ k1TownsSFXbtTable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsSFXbtTableFMTownsProvider },
	{ k1TownsCDATable, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1TownsCDATableFMTownsProvider },
	{ k1AudioTracks, kKyra1, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k1AudioTracksFMTownsProvider },
	{ k1CreditsStrings, kKyra1, kPlatformFMTowns, kNoSpecial, EN_ANY, &k1CreditsStringsFMTownsEnglishProvider },
	{ k1IntroStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1IntroStringsFMTownsJapaneseProvider },
	{ k1ItemNames, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1ItemNamesFMTownsJapaneseProvider },
	{ k1TakenStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1TakenStringsFMTownsJapaneseProvider },
	{ k1PlacedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1PlacedStringsFMTownsJapaneseProvider },
	{ k1DroppedStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1DroppedStringsFMTownsJapaneseProvider },
	{ k1NoDropStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1NoDropStringsFMTownsJapaneseProvider },
	{ k1PutDownString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1PutDownStringFMTownsJapaneseProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1WaitAmuletStringFMTownsJapaneseProvider },
	{ k1BlackJewelString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1BlackJewelStringFMTownsJapaneseProvider },
	{ k1HealingTipString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1HealingTipStringFMTownsJapaneseProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1PoisonGoneStringFMTownsJapaneseProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1ThePoisonStringsFMTownsJapaneseProvider },
	{ k1FluteStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1FluteStringsFMTownsJapaneseProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1WispJewelStringsFMTownsJapaneseProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1MagicJewelStringsFMTownsJapaneseProvider },
	{ k1FlaskFullString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1FlaskFullStringFMTownsJapaneseProvider },
	{ k1FullFlaskString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1FullFlaskStringFMTownsJapaneseProvider },
	{ k1OutroHomeString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1OutroHomeStringFMTownsJapaneseProvider },
	{ k1VeryCleverString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1VeryCleverStringFMTownsJapaneseProvider },
	{ k1GUIStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1GUIStringsFMTownsJapaneseProvider },
	{ k1NewGameString, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1NewGameStringFMTownsJapaneseProvider },
	{ k1ConfigStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1ConfigStringsFMTownsJapaneseProvider },
	{ k1CreditsStrings, kKyra1, kPlatformFMTowns, kNoSpecial, JA_JPN, &k1CreditsStringsFMTownsJapaneseProvider },
	{ k1KallakWritingSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1KallakWritingSeqPC98Provider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqPC98Provider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqPC98Provider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqPC98Provider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqPC98Provider },
	{ k1ForestSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1ForestSeqPC98Provider },
	{ k1IntroCPSStrings, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1IntroCPSStringsPC98Provider },
	{ k1IntroCOLStrings, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1IntroCOLStringsPC98Provider },
	{ k1IntroWSAStrings, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1IntroWSAStringsPC98Provider },
	{ k1IntroStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1IntroStringsPC98JapaneseProvider },
	{ k1RoomList, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1RoomListPC98Provider },
	{ k1RoomFilenames, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1RoomFilenamesPC98Provider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesPC98Provider },
	{ k1DefaultShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1DefaultShapesPC98Provider },
	{ k1ItemNames, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1ItemNamesPC98JapaneseProvider },
	{ k1TakenStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1TakenStringsPC98JapaneseProvider },
	{ k1PlacedStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PlacedStringsPC98JapaneseProvider },
	{ k1DroppedStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1DroppedStringsPC98JapaneseProvider },
	{ k1NoDropStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1NoDropStringsPC98JapaneseProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqPC98Provider },
	{ k1SpecialPalette1, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette1PC98Provider },
	{ k1SpecialPalette2, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette2PC98Provider },
	{ k1SpecialPalette3, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette3PC98Provider },
	{ k1SpecialPalette4, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette4PC98Provider },
	{ k1SpecialPalette5, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette5PC98Provider },
	{ k1SpecialPalette6, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette6PC98Provider },
	{ k1SpecialPalette7, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette7PC98Provider },
	{ k1SpecialPalette8, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette8PC98Provider },
	{ k1SpecialPalette9, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette9PC98Provider },
	{ k1SpecialPalette10, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette10PC98Provider },
	{ k1SpecialPalette11, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette11PC98Provider },
	{ k1SpecialPalette12, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette12PC98Provider },
	{ k1SpecialPalette13, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette13PC98Provider },
	{ k1SpecialPalette14, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette14PC98Provider },
	{ k1SpecialPalette15, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette15PC98Provider },
	{ k1SpecialPalette16, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette16PC98Provider },
	{ k1SpecialPalette17, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette17PC98Provider },
	{ k1SpecialPalette18, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette18PC98Provider },
	{ k1SpecialPalette19, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette19PC98Provider },
	{ k1SpecialPalette20, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette20PC98Provider },
	{ k1SpecialPalette21, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette21PC98Provider },
	{ k1SpecialPalette22, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette22PC98Provider },
	{ k1SpecialPalette23, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette23PC98Provider },
	{ k1SpecialPalette24, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette24PC98Provider },
	{ k1SpecialPalette25, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette25PC98Provider },
	{ k1SpecialPalette26, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette26PC98Provider },
	{ k1SpecialPalette27, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette27PC98Provider },
	{ k1SpecialPalette28, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette28PC98Provider },
	{ k1SpecialPalette29, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette29PC98Provider },
	{ k1SpecialPalette30, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette30PC98Provider },
	{ k1SpecialPalette31, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette31PC98Provider },
	{ k1SpecialPalette32, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette32PC98Provider },
	{ k1SpecialPalette33, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1SpecialPalette33PC98Provider },
	{ k1PutDownString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PutDownStringPC98JapaneseProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1WaitAmuletStringPC98JapaneseProvider },
	{ k1BlackJewelString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1BlackJewelStringPC98JapaneseProvider },
	{ k1HealingTipString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1HealingTipStringPC98JapaneseProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PoisonGoneStringPC98JapaneseProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Healing1ShapesPC98Provider },
	{ k1Healing2Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Healing2ShapesPC98Provider },
	{ k1ThePoisonStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1ThePoisonStringsPC98JapaneseProvider },
	{ k1FluteStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1FluteStringsPC98JapaneseProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesPC98Provider },
	{ k1FluteShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1FluteShapesPC98Provider },
	{ k1Winter1Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Winter1ShapesPC98Provider },
	{ k1Winter2Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Winter2ShapesPC98Provider },
	{ k1Winter3Shapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1Winter3ShapesPC98Provider },
	{ k1DrinkShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1DrinkShapesPC98Provider },
	{ k1WispShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1WispShapesPC98Provider },
	{ k1MagicAnimShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1MagicAnimShapesPC98Provider },
	{ k1BranStoneShapes, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1BranStoneShapesPC98Provider },
	{ k1WispJewelStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1WispJewelStringsPC98JapaneseProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1MagicJewelStringsPC98JapaneseProvider },
	{ k1FlaskFullString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1FlaskFullStringPC98JapaneseProvider },
	{ k1FullFlaskString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1FullFlaskStringPC98JapaneseProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1OutroReunionSeqPC98Provider },
	{ k1OutroHomeString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1OutroHomeStringPC98JapaneseProvider },
	{ k1VeryCleverString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1VeryCleverStringPC98JapaneseProvider },
	{ k1GUIStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1GUIStringsPC98JapaneseProvider },
	{ k1NewGameString, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1NewGameStringPC98JapaneseProvider },
	{ k1ConfigStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1ConfigStringsPC98JapaneseProvider },
	{ k1PC98StoryStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1PC98StoryStringsPC98JapaneseProvider },
	{ k1PC98IntroSfx, kKyra1, kPlatformPC98, kNoSpecial, UNK_LANG, &k1PC98IntroSfxPC98Provider },
	{ k1CreditsStrings, kKyra1, kPlatformPC98, kNoSpecial, JA_JPN, &k1CreditsStringsPC98JapaneseProvider },

	{ k1KallakWritingSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1KallakWritingSeqMacProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1MalcolmTreeSeqMacProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1WestwoodLogoSeqMacProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1KyrandiaLogoSeqMacProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1KallakMalcolmSeqMacProvider },
	{ k1ForestSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1ForestSeqMacProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1IntroCPSStringsMacProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1IntroCOLStringsMacProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1IntroWSAStringsMacProvider },
	{ k1IntroStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1IntroStringsMacEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1RoomListMacProvider },
	{ k1RoomFilenames, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1RoomFilenamesMacProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1CharacterImageFilenamesMacProvider },
	{ k1DefaultShapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1DefaultShapesMacProvider },
	{ k1ItemNames, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1ItemNamesMacEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1TakenStringsMacEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1PlacedStringsMacEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1DroppedStringsMacEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1NoDropStringsMacEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1AmuleteAnimSeqMacProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette1MacProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette2MacProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette3MacProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette4MacProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette5MacProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette6MacProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette7MacProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette8MacProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette9MacProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette10MacProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette11MacProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette12MacProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette13MacProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette14MacProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette15MacProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette16MacProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette17MacProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette18MacProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette19MacProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette20MacProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette21MacProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette22MacProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette23MacProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette24MacProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette25MacProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette26MacProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette27MacProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette28MacProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette29MacProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette30MacProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette31MacProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette32MacProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1SpecialPalette33MacProvider },
	{ k1PutDownString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1PutDownStringMacEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1WaitAmuletStringMacEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1BlackJewelStringMacEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1HealingTipStringMacEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1PoisonGoneStringMacEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1Healing1ShapesMacProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1Healing2ShapesMacProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1ThePoisonStringsMacEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1FluteStringsMacEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1PoisonDeathShapesMacProvider },
	{ k1FluteShapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1FluteShapesMacProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1Winter1ShapesMacProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1Winter2ShapesMacProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1Winter3ShapesMacProvider },
	{ k1DrinkShapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1DrinkShapesMacProvider },
	{ k1WispShapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1WispShapesMacProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1MagicAnimShapesMacProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1BranStoneShapesMacProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1WispJewelStringsMacEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1MagicJewelStringsMacEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1FlaskFullStringMacEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1FullFlaskStringMacEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformMacintosh, kNoSpecial, UNK_LANG, &k1OutroReunionSeqMacProvider },
	{ k1OutroHomeString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1OutroHomeStringMacEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1VeryCleverStringMacEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1GUIStringsMacEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1NewGameStringMacEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1ConfigStringsMacEnglishProvider },
	{ k1ConfigStrings2, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1ConfigStrings2MacEnglishProvider },
	{ k1CreditsStrings, kKyra1, kPlatformMacintosh, kNoSpecial, EN_ANY, &k1CreditsStringsMacEnglishProvider },

	{ k1KallakWritingSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1KallakWritingSeqMacCDProvider },
	{ k1MalcolmTreeSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1MalcolmTreeSeqMacCDProvider },
	{ k1WestwoodLogoSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1WestwoodLogoSeqMacCDProvider },
	{ k1KyrandiaLogoSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1KyrandiaLogoSeqMacCDProvider },
	{ k1KallakMalcolmSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1KallakMalcolmSeqMacCDProvider },
	{ k1ForestSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1ForestSeqMacCDProvider },
	{ k1IntroCPSStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1IntroCPSStringsMacCDProvider },
	{ k1IntroCOLStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1IntroCOLStringsMacCDProvider },
	{ k1IntroWSAStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1IntroWSAStringsMacCDProvider },
	{ k1IntroStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1IntroStringsMacCDEnglishProvider },
	{ k1RoomList, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1RoomListMacCDProvider },
	{ k1RoomFilenames, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1RoomFilenamesMacCDProvider },
	{ k1CharacterImageFilenames, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1CharacterImageFilenamesMacCDProvider },
	{ k1DefaultShapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1DefaultShapesMacCDProvider },
	{ k1ItemNames, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1ItemNamesMacCDEnglishProvider },
	{ k1TakenStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1TakenStringsMacCDEnglishProvider },
	{ k1PlacedStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1PlacedStringsMacCDEnglishProvider },
	{ k1DroppedStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1DroppedStringsMacCDEnglishProvider },
	{ k1NoDropStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1NoDropStringsMacCDEnglishProvider },
	{ k1AmuleteAnimSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1AmuleteAnimSeqMacCDProvider },
	{ k1SpecialPalette1, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette1MacCDProvider },
	{ k1SpecialPalette2, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette2MacCDProvider },
	{ k1SpecialPalette3, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette3MacCDProvider },
	{ k1SpecialPalette4, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette4MacCDProvider },
	{ k1SpecialPalette5, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette5MacCDProvider },
	{ k1SpecialPalette6, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette6MacCDProvider },
	{ k1SpecialPalette7, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette7MacCDProvider },
	{ k1SpecialPalette8, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette8MacCDProvider },
	{ k1SpecialPalette9, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette9MacCDProvider },
	{ k1SpecialPalette10, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette10MacCDProvider },
	{ k1SpecialPalette11, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette11MacCDProvider },
	{ k1SpecialPalette12, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette12MacCDProvider },
	{ k1SpecialPalette13, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette13MacCDProvider },
	{ k1SpecialPalette14, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette14MacCDProvider },
	{ k1SpecialPalette15, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette15MacCDProvider },
	{ k1SpecialPalette16, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette16MacCDProvider },
	{ k1SpecialPalette17, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette17MacCDProvider },
	{ k1SpecialPalette18, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette18MacCDProvider },
	{ k1SpecialPalette19, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette19MacCDProvider },
	{ k1SpecialPalette20, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette20MacCDProvider },
	{ k1SpecialPalette21, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette21MacCDProvider },
	{ k1SpecialPalette22, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette22MacCDProvider },
	{ k1SpecialPalette23, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette23MacCDProvider },
	{ k1SpecialPalette24, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette24MacCDProvider },
	{ k1SpecialPalette25, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette25MacCDProvider },
	{ k1SpecialPalette26, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette26MacCDProvider },
	{ k1SpecialPalette27, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette27MacCDProvider },
	{ k1SpecialPalette28, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette28MacCDProvider },
	{ k1SpecialPalette29, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette29MacCDProvider },
	{ k1SpecialPalette30, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette30MacCDProvider },
	{ k1SpecialPalette31, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette31MacCDProvider },
	{ k1SpecialPalette32, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette32MacCDProvider },
	{ k1SpecialPalette33, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1SpecialPalette33MacCDProvider },
	{ k1PutDownString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1PutDownStringMacCDEnglishProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1WaitAmuletStringMacCDEnglishProvider },
	{ k1BlackJewelString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1BlackJewelStringMacCDEnglishProvider },
	{ k1HealingTipString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1HealingTipStringMacCDEnglishProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1PoisonGoneStringMacCDEnglishProvider },
	{ k1Healing1Shapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1Healing1ShapesMacCDProvider },
	{ k1Healing2Shapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1Healing2ShapesMacCDProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1ThePoisonStringsMacCDEnglishProvider },
	{ k1FluteStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1FluteStringsMacCDEnglishProvider },
	{ k1PoisonDeathShapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1PoisonDeathShapesMacCDProvider },
	{ k1FluteShapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1FluteShapesMacCDProvider },
	{ k1Winter1Shapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1Winter1ShapesMacCDProvider },
	{ k1Winter2Shapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1Winter2ShapesMacCDProvider },
	{ k1Winter3Shapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1Winter3ShapesMacCDProvider },
	{ k1DrinkShapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1DrinkShapesMacCDProvider },
	{ k1WispShapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1WispShapesMacCDProvider },
	{ k1MagicAnimShapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1MagicAnimShapesMacCDProvider },
	{ k1BranStoneShapes, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1BranStoneShapesMacCDProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1WispJewelStringsMacCDEnglishProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1MagicJewelStringsMacCDEnglishProvider },
	{ k1FlaskFullString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1FlaskFullStringMacCDEnglishProvider },
	{ k1FullFlaskString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1FullFlaskStringMacCDEnglishProvider },
	{ k1OutroReunionSeq, kKyra1, kPlatformMacintosh, kTalkieVersion, UNK_LANG, &k1OutroReunionSeqMacCDProvider },
	{ k1OutroHomeString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1OutroHomeStringMacCDEnglishProvider },
	{ k1VeryCleverString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1VeryCleverStringMacCDEnglishProvider },
	{ k1GUIStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1GUIStringsMacCDEnglishProvider },
	{ k1NewGameString, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1NewGameStringMacCDEnglishProvider },
	{ k1ConfigStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1ConfigStringsMacCDEnglishProvider },
	{ k1ConfigStrings2, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1ConfigStrings2MacCDEnglishProvider },
	{ k1CreditsStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, EN_ANY, &k1CreditsStringsMacCDEnglishProvider },
	{ k1IntroStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1IntroStringsMacCDGermanProvider },
	{ k1ItemNames, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1ItemNamesMacCDGermanProvider },
	{ k1TakenStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1TakenStringsMacCDGermanProvider },
	{ k1PlacedStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1PlacedStringsMacCDGermanProvider },
	{ k1DroppedStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1DroppedStringsMacCDGermanProvider },
	{ k1NoDropStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1NoDropStringsMacCDGermanProvider },
	{ k1PutDownString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1PutDownStringMacCDGermanProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1WaitAmuletStringMacCDGermanProvider },
	{ k1BlackJewelString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1BlackJewelStringMacCDGermanProvider },
	{ k1HealingTipString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1HealingTipStringMacCDGermanProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1PoisonGoneStringMacCDGermanProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1ThePoisonStringsMacCDGermanProvider },
	{ k1FluteStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1FluteStringsMacCDGermanProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1WispJewelStringsMacCDGermanProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1MagicJewelStringsMacCDGermanProvider },
	{ k1FlaskFullString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1FlaskFullStringMacCDGermanProvider },
	{ k1FullFlaskString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1FullFlaskStringMacCDGermanProvider },
	{ k1OutroHomeString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1OutroHomeStringMacCDGermanProvider },
	{ k1VeryCleverString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1VeryCleverStringMacCDGermanProvider },
	{ k1GUIStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1GUIStringsMacCDGermanProvider },
	{ k1NewGameString, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1NewGameStringMacCDGermanProvider },
	{ k1ConfigStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1ConfigStringsMacCDGermanProvider },
	{ k1ConfigStrings2, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1ConfigStrings2MacCDGermanProvider },
	{ k1CreditsStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, DE_DEU, &k1CreditsStringsMacCDGermanProvider },
	{ k1IntroStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1IntroStringsMacCDFrenchProvider },
	{ k1ItemNames, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1ItemNamesMacCDFrenchProvider },
	{ k1TakenStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1TakenStringsMacCDFrenchProvider },
	{ k1PlacedStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1PlacedStringsMacCDFrenchProvider },
	{ k1DroppedStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1DroppedStringsMacCDFrenchProvider },
	{ k1NoDropStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1NoDropStringsMacCDFrenchProvider },
	{ k1PutDownString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1PutDownStringMacCDFrenchProvider },
	{ k1WaitAmuletString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1WaitAmuletStringMacCDFrenchProvider },
	{ k1BlackJewelString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1BlackJewelStringMacCDFrenchProvider },
	{ k1HealingTipString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1HealingTipStringMacCDFrenchProvider },
	{ k1PoisonGoneString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1PoisonGoneStringMacCDFrenchProvider },
	{ k1ThePoisonStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1ThePoisonStringsMacCDFrenchProvider },
	{ k1FluteStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1FluteStringsMacCDFrenchProvider },
	{ k1WispJewelStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1WispJewelStringsMacCDFrenchProvider },
	{ k1MagicJewelStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1MagicJewelStringsMacCDFrenchProvider },
	{ k1FlaskFullString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1FlaskFullStringMacCDFrenchProvider },
	{ k1FullFlaskString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1FullFlaskStringMacCDFrenchProvider },
	{ k1OutroHomeString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1OutroHomeStringMacCDFrenchProvider },
	{ k1VeryCleverString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1VeryCleverStringMacCDFrenchProvider },
	{ k1GUIStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1GUIStringsMacCDFrenchProvider },
	{ k1NewGameString, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1NewGameStringMacCDFrenchProvider },
	{ k1ConfigStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1ConfigStringsMacCDFrenchProvider },
	{ k1ConfigStrings2, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1ConfigStrings2MacCDFrenchProvider },
	{ k1CreditsStrings, kKyra1, kPlatformMacintosh, kTalkieVersion, FR_FRA, &k1CreditsStringsMacCDFrenchProvider },

	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplayPakFilesDOSDemoProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplaySeqDataDOSDemoProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplaySfxFilesDOSDemoProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplayIntroTracksDOSDemoProvider },
	{ k2SeqplayShapeAnimData, kKyra2, kPlatformDOS, kDemoVersion, UNK_LANG, &k2SeqplayShapeAnimDataDOSDemoProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayPakFilesDOSCDDemoProvider },
	{ k2SeqplayCredits, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayCreditsDOSCDDemoProvider },
	{ k2SeqplayCreditsSpecial, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayCreditsSpecialDOSCDDemoProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k2SeqplayStringsDOSCDDemoEnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplaySfxFilesDOSCDDemoProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k2SeqplayTlkFilesDOSCDDemoEnglishProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplaySeqDataDOSCDDemoProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayIntroTracksDOSCDDemoProvider },
	{ k2SeqplayFinaleTracks, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2SeqplayFinaleTracksDOSCDDemoProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameSfxFilesDOSCDDemoProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameSfxIndexDOSCDDemoProvider },
	{ k2IngameTracks, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameTracksDOSCDDemoProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameTalkObjIndexDOSCDDemoProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &k2IngameShapeAnimDataDOSCDDemoProvider },
	{ k2IngameTlkDemoStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &k2IngameTlkDemoStringsDOSCDDemoEnglishProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, FR_FRA, &k2SeqplayStringsDOSCDDemoFrenchProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, FR_FRA, &k2SeqplayTlkFilesDOSCDDemoFrenchProvider },
	{ k2IngameTlkDemoStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, FR_FRA, &k2IngameTlkDemoStringsDOSCDDemoFrenchProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, DE_DEU, &k2SeqplayStringsDOSCDDemoGermanProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieDemoVersion, DE_DEU, &k2SeqplayTlkFilesDOSCDDemoGermanProvider },
	{ k2IngameTlkDemoStrings, kKyra2, kPlatformDOS, kTalkieDemoVersion, DE_DEU, &k2IngameTlkDemoStringsDOSCDDemoGermanProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplayPakFilesDOSProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, EN_ANY, &k2SeqplayStringsDOSEnglishProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, PL_POL, &k2SeqplayStringsDOSPolishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplaySfxFilesDOSProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplayIntroTracksDOSProvider },
	{ k2SeqplayFinaleTracks, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplayFinaleTracksDOSProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2SeqplaySeqDataDOSProvider },
	{ k2IngamePakFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngamePakFilesDOSProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameSfxFilesDOSProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameSfxIndexDOSProvider },
	{ k2IngameTracks, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameTracksDOSProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameTalkObjIndexDOSProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformDOS, kNoSpecial, UNK_LANG, &k2IngameShapeAnimDataDOSProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, FR_FRA, &k2SeqplayStringsDOSFrenchProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, DE_DEU, &k2SeqplayStringsDOSGermanProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, IT_ITA, &k2SeqplayStringsDOSItalianProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, RU_RUS, &k2SeqplayStringsDOSRussianProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, ES_ESP, &k2SeqplayStringsDOSSpanishProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kNoSpecial, ZH_TWN, &k2SeqplayStringsDOSChineseTradProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayPakFilesDOSCDProvider },
	{ k2SeqplayCredits, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayCreditsDOSCDProvider },
	{ k2SeqplayCreditsSpecial, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayCreditsSpecialDOSCDProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, EN_ANY, &k2SeqplayStringsDOSCDEnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplaySfxFilesDOSCDProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, EN_ANY, &k2SeqplayTlkFilesDOSCDEnglishProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplaySeqDataDOSCDProvider },
	{ k2SeqplayIntroTracks, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayIntroTracksDOSCDProvider },
	{ k2SeqplayFinaleTracks, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2SeqplayFinaleTracksDOSCDProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameSfxFilesDOSCDProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameSfxIndexDOSCDProvider },
	{ k2IngameTracks, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameTracksDOSCDProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameTalkObjIndexDOSCDProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformDOS, kTalkieVersion, UNK_LANG, &k2IngameShapeAnimDataDOSCDProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, FR_FRA, &k2SeqplayStringsDOSCDFrenchProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, FR_FRA, &k2SeqplayTlkFilesDOSCDFrenchProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, DE_DEU, &k2SeqplayStringsDOSCDGermanProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, DE_DEU, &k2SeqplayTlkFilesDOSCDGermanProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, IT_ITA, &k2SeqplayStringsDOSCDItalianProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, IT_ITA, &k2SeqplayTlkFilesDOSCDItalianProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, HE_ISR, &k2SeqplayStringsDOSCDHebrewProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, HE_ISR, &k2SeqplayTlkFilesDOSCDHebrewProvider },
	/*{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, RU_RUS, &k2SeqplayStringsDOSCDRussianProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, RU_RUS, &k2SeqplayTlkFilesDOSCDRussianProvider },*/
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, ES_ESP, &k2SeqplayStringsDOSCDSpanishProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, ES_ESP, &k2SeqplayTlkFilesDOSCDSpanishProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformDOS, kTalkieVersion, CS_CZE, &k2SeqplayStringsDOSCDCzechProvider },
	{ k2SeqplayTlkFiles, kKyra2, kPlatformDOS, kTalkieVersion, CS_CZE, &k2SeqplayTlkFilesDOSCDCzechProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplayPakFilesFMTownsProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformFMTowns, kNoSpecial, EN_ANY, &k2SeqplayStringsFMTownsEnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplaySfxFilesFMTownsProvider },
	{ k2SeqplaySeqData, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplaySeqDataFMTownsProvider },
	{ k2SeqplayIntroCDA, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplayIntroCDAFMTownsProvider },
	{ k2SeqplayFinaleCDA, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2SeqplayFinaleCDAFMTownsProvider },
	{ k2IngamePakFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngamePakFilesFMTownsProvider },
	{ k2IngameSfxFiles, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameSfxFilesFMTownsProvider },
	{ k2IngameSfxIndex, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameSfxIndexFMTownsProvider },
	{ k2IngameCDA, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameCDAFMTownsProvider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameTalkObjIndexFMTownsProvider },
	{ k2IngameTimJpStrings, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameTimJpStringsFMTownsProvider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &k2IngameShapeAnimDataFMTownsProvider },
	{ k2SeqplayStrings, kKyra2, kPlatformFMTowns, kNoSpecial, JA_JPN, &k2SeqplayStringsFMTownsJapaneseProvider },
	{ k2SeqplayPakFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2SeqplayPakFilesPC98Provider },
	{ k2SeqplayStrings, kKyra2, kPlatformPC98, kNoSpecial, EN_ANY, &k2SeqplayStringsPC98EnglishProvider },
	{ k2SeqplaySfxFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2SeqplaySfxFilesPC98Provider },
	{ k2SeqplaySeqData, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2SeqplaySeqDataPC98Provider },
	{ k2IngamePakFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngamePakFilesPC98Provider },
	{ k2IngameSfxFiles, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameSfxFilesPC98Provider },
	{ k2IngameSfxIndex, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameSfxIndexPC98Provider },
	{ k2IngameTalkObjIndex, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameTalkObjIndexPC98Provider },
	{ k2IngameTimJpStrings, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameTimJpStringsPC98Provider },
	{ k2IngameShapeAnimData, kKyra2, kPlatformPC98, kNoSpecial, UNK_LANG, &k2IngameShapeAnimDataPC98Provider },
	{ k2SeqplayStrings, kKyra2, kPlatformPC98, kNoSpecial, JA_JPN, &k2SeqplayStringsPC98JapaneseProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, EN_ANY, &k2FontDataDOSDummyProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, FR_FRA, &k2FontDataDOSDummyProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, DE_DEU, &k2FontDataDOSDummyProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, IT_ITA, &k2FontDataDOSDummyProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, ES_ESP, &k2FontDataDOSDummyProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, RU_RUS, &k2FontDataDOSDummyProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, PL_POL, &k2FontDataDOSDummyProvider },
	{ k2FontData, kKyra2, kPlatformDOS, kNoSpecial, ZH_TWN, &k2FontDataDOSChineseTradProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, EN_ANY, &k3MainMenuStringsDOSCDEnglishProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, FR_FRA, &k3MainMenuStringsDOSCDFrenchProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, DE_DEU, &k3MainMenuStringsDOSCDGermanProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, IT_ITA, &k3MainMenuStringsDOSCDItalianProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, ES_ESP, &k3MainMenuStringsDOSCDSpanishProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, RU_RUS, &k3MainMenuStringsDOSCDRussianProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, HE_ISR, &k3MainMenuStringsDOSCDHebrewProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, CS_CZE, &k3MainMenuStringsDOSCDCzechProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, ZH_CHN, &k3MainMenuStringsDOSCDChineseSmplProvider },
	{ k3MainMenuStrings, kKyra3, kPlatformDOS, kTalkieVersion, ZH_TWN, &k3MainMenuStringsDOSCDChineseTradProvider },
	{ k3MusicFiles, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3MusicFilesDOSCDProvider },
	{ k3ScoreTable, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ScoreTableDOSCDProvider },
	{ k3SfxFiles, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3SfxFilesDOSCDProvider },
	{ k3SfxMap, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3SfxMapDOSCDProvider },
	{ k3ItemAnimData, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ItemAnimDataDOSCDProvider },
	{ k3ItemMagicTable, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ItemMagicTableDOSCDProvider },
	{ k3ItemStringMap, kKyra3, kPlatformDOS, kTalkieVersion, UNK_LANG, &k3ItemStringMapDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, EN_ANY, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, FR_FRA, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, DE_DEU, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, IT_ITA, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, ES_ESP, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, RU_RUS, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, HE_ISR, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, CS_CZE, &k3DummyDataDOSCDProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, ZH_CHN, &k3FontDataDOSCDChineseSmplProvider },
	{ k2FontData, kKyra3, kPlatformDOS, kTalkieVersion, ZH_TWN, &k3FontDataDOSCDChineseTradProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, EN_ANY, &k3VqaSubtitlesIntroDOSCDEnglishProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, FR_FRA, &k3VqaSubtitlesIntroDOSCDFrenchProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, DE_DEU, &k3VqaSubtitlesIntroDOSCDGermanProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, IT_ITA, &k3VqaSubtitlesIntroDOSCDItalianProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, ES_ESP, &k3VqaSubtitlesIntroDOSCDSpanishProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, RU_RUS, &k3VqaSubtitlesIntroDOSCDRussianProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, HE_ISR, &k3VqaSubtitlesIntroDOSCDHebrewProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, CS_CZE, &k3VqaSubtitlesIntroDOSCDCzechProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, ZH_CHN, &k3VqaSubtitlesIntroDOSCDChineseSmplProvider },
	{ k3VqaSubtitlesIntro, kKyra3, kPlatformDOS, kTalkieVersion, ZH_TWN, &k3VqaSubtitlesIntroDOSCDChineseTradProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, EN_ANY, &k3VqaSubtitlesBoatDOSCDEnglishProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, FR_FRA, &k3VqaSubtitlesBoatDOSCDFrenchProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, DE_DEU, &k3VqaSubtitlesBoatDOSCDGermanProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, IT_ITA, &k3VqaSubtitlesBoatDOSCDItalianProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, ES_ESP, &k3VqaSubtitlesBoatDOSCDSpanishProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, RU_RUS, &k3VqaSubtitlesBoatDOSCDRussianProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, HE_ISR, &k3VqaSubtitlesBoatDOSCDHebrewProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, CS_CZE, &k3VqaSubtitlesBoatDOSCDCzechProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, ZH_CHN, &k3VqaSubtitlesBoatDOSCDChineseSmplProvider },
	{ k3VqaSubtitlesBoat, kKyra3, kPlatformDOS, kTalkieVersion, ZH_TWN, &k3VqaSubtitlesBoatDOSCDChineseTradProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1NpcPresetsNamesDOSEnglishProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenStrings1DOSEnglishProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenStrings2DOSEnglishProvider },
	{ kEoBBaseChargenStartLevels, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenStartLevelsDOSProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenStatStringsDOSEnglishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenRaceSexStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenClassStringsDOSEnglishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenAlignmentStringsDOSEnglishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ChargenEnterGameStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassMinStats, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenClassMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMaxStatsDOSProvider },
	{ kEoBBaseSaveThrowTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable1DOSProvider },
	{ kEoBBaseSaveThrowTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable2DOSProvider },
	{ kEoBBaseSaveThrowTable3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable3DOSProvider },
	{ kEoBBaseSaveThrowTable4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable4DOSProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrwLvlIndexDOSProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModDivDOSProvider },
	{ kEoBBaseSaveThrwModExt, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModExtDOSProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MainMenuStringsDOSEnglishProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1BonusStringsDOSEnglishProvider },
	{ kEoB1IntroFilesOpening, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOpeningDOSProvider },
	{ kEoB1IntroFilesTower, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTowerDOSProvider },
	{ kEoB1IntroFilesOrb, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOrbDOSProvider },
	{ kEoB1IntroFilesWdEntry, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdEntryDOSProvider },
	{ kEoB1IntroFilesKing, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesKingDOSProvider },
	{ kEoB1IntroFilesHands, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesHandsDOSProvider },
	{ kEoB1IntroFilesWdExit, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdExitDOSProvider },
	{ kEoB1IntroFilesTunnel, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTunnelDOSProvider },
	{ kEoB1IntroOpeningFrmDelay, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroOpeningFrmDelayDOSProvider },
	{ kEoB1IntroWdEncodeX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeXDOSProvider },
	{ kEoB1IntroWdEncodeY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeYDOSProvider },
	{ kEoB1IntroWdEncodeWH, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeWHDOSProvider },
	{ kEoB1IntroWdDsX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsXDOSProvider },
	{ kEoB1IntroWdDsY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsYDOSProvider },
	{ kEoB1IntroTvlX1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX1DOSProvider },
	{ kEoB1IntroTvlY1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY1DOSProvider },
	{ kEoB1IntroTvlX2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX2DOSProvider },
	{ kEoB1IntroTvlY2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY2DOSProvider },
	{ kEoB1IntroTvlW, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlWDOSProvider },
	{ kEoB1IntroTvlH, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1IntroTvlHDOSProvider },
	{ kEoB1DoorShapeDefs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DoorShapeDefsDOSProvider },
	{ kEoB1DoorSwitchShapeDefs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchShapeDefsDOSProvider },
	{ kEoB1DoorSwitchCoords, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchCoordsDOSProvider },
	{ kEoB1MonsterProperties, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterPropertiesDOSProvider },
	{ kEoB1EnemyMageSpellList, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSpellListDOSProvider },
	{ kEoB1EnemyMageSfx, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSfxDOSProvider },
	{ kEoB1BeholderSpellList, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1BeholderSpellListDOSProvider },
	{ kEoB1BeholderSfx, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1BeholderSfxDOSProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1TurnUndeadStringDOSEnglishProvider },
	{ kEoB1CgaMappingDefault, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingDefaultDOSProvider },
	{ kEoB1CgaMappingAlt, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingAltDOSProvider },
	{ kEoB1CgaMappingInv, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingInvDOSProvider },
	{ kEoB1CgaMappingItemsL, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingItemsLDOSProvider },
	{ kEoB1CgaMappingItemsS, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingItemsSDOSProvider },
	{ kEoB1CgaMappingThrown, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingThrownDOSProvider },
	{ kEoB1CgaMappingIcons, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingIconsDOSProvider },
	{ kEoB1CgaMappingDeco, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingDecoDOSProvider },
	{ kEoB1CgaLevelMappingIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaLevelMappingIndexDOSProvider },
	{ kEoB1CgaMappingLevel0, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel0DOSProvider },
	{ kEoB1CgaMappingLevel1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel1DOSProvider },
	{ kEoB1CgaMappingLevel2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel2DOSProvider },
	{ kEoB1CgaMappingLevel3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel3DOSProvider },
	{ kEoB1CgaMappingLevel4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1CgaMappingLevel4DOSProvider },
	{ kEoB1NpcShpData, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcShpDataDOSProvider },
	{ kEoB1NpcSubShpIndex1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex1DOSProvider },
	{ kEoB1NpcSubShpIndex2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex2DOSProvider },
	{ kEoB1NpcSubShpY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpYDOSProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc0StringsDOSEnglishProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc11StringsDOSEnglishProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc12StringsDOSEnglishProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc21StringsDOSEnglishProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc22StringsDOSEnglishProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc31StringsDOSEnglishProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc32StringsDOSEnglishProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc4StringsDOSEnglishProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc5StringsDOSEnglishProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc6StringsDOSEnglishProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1Npc7StringsDOSEnglishProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PryDoorStringsDOSEnglishProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1WarningStringsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsRingsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsPotionsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsWandsDOSEnglishProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1RipItemStringsDOSEnglishProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CursedStringDOSEnglishProvider },
	{ kEoBBaseEnchantedString, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EnchantedStringDOSProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicObjectStringsDOSEnglishProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicObjectString5DOSEnglishProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PatternSuffixDOSEnglishProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PatternGrFix1DOSEnglishProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PatternGrFix2DOSEnglishProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ValidateArmorStringDOSEnglishProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ValidateNoDropStringDOSEnglishProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PotionStringsDOSEnglishProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1WandStringsDOSEnglishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ItemMisuseStringsDOSEnglishProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1TakenStringsDOSEnglishProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1PotionEffectStringsDOSEnglishProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1YesNoStringsDOSEnglishProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MoreStringsDOSEnglishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1NpcMaxStringsDOSEnglishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1NpcJoinStringsDOSEnglishProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CancelStringsDOSEnglishProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsMainDOSEnglishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsSaveLoadDOSEnglishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsOnOffDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsSpellsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsRestDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsDropDOSEnglishProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsExitDOSEnglishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsStarveDOSEnglishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsScribeDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsDrop2DOSEnglishProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsHeadDOSEnglishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsPoisonDOSEnglishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsMgcDOSEnglishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsPrefsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest2DOSEnglishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest4DOSEnglishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuStringsDefeatDOSEnglishProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MenuYesNoStringsDOSEnglishProvider },
	{ kEoBBaseSpellLevelsMage, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsMageDOSProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsClericDOSProvider },
	{ kEoBBaseNumSpellsCleric, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsClericDOSProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsWisAdjDOSProvider },
	{ kEoBBaseNumSpellsPal, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsPalDOSProvider },
	{ kEoBBaseNumSpellsMage, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NumSpellsMageDOSProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsHpDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsWp1DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsWrDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsSt1DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsInDOSEnglishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings7DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings81DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings9DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings131DOSEnglishProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1LevelGainStringsDOSEnglishProvider },
	{ kEoBBaseExperienceTable0, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable0DOSProvider },
	{ kEoBBaseExperienceTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable1DOSProvider },
	{ kEoBBaseExperienceTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable2DOSProvider },
	{ kEoBBaseExperienceTable3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable3DOSProvider },
	{ kEoBBaseExperienceTable4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable4DOSProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1BookNumbersDOSEnglishProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MageSpellsListDOSEnglishProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ClericSpellsListDOSEnglishProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1SpellNamesDOSEnglishProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings1DOSEnglishProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings2DOSEnglishProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings3DOSEnglishProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings4DOSEnglishProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings6DOSEnglishProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings7DOSEnglishProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings8DOSEnglishProvider },
	//{ kEoBBaseMagicStrings9, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MagicStrings9DOSEnglishProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTblIndexDOSProvider },
	{ kEoBBaseExpObjectShpStart, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectShpStartDOSProvider },
	{ kEoBBaseExpObjectTbl1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl1DOSProvider },
	{ kEoBBaseExpObjectTbl2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl2DOSProvider },
	{ kEoBBaseExpObjectTbl3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl3DOSProvider },
	{ kEoBBaseExpObjectY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ExpObjectYDOSProvider },
	{ kEoBBaseSparkDefSteps, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefStepsDOSProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefSubStepsDOSProvider },
	{ kEoBBaseSparkDefShift, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefShiftDOSProvider },
	{ kEoBBaseSparkDefAdd, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefAddDOSProvider },
	{ kEoBBaseSparkDefX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefXDOSProvider },
	{ kEoBBaseSparkDefY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkDefYDOSProvider },
	{ kEoBBaseSparkOfFlags1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags1DOSProvider },
	{ kEoBBaseSparkOfFlags2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags2DOSProvider },
	{ kEoBBaseSparkOfShift, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfShiftDOSProvider },
	{ kEoBBaseSparkOfX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfXDOSProvider },
	{ kEoBBaseSparkOfY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SparkOfYDOSProvider },
	{ kEoBBaseSpellProperties, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SpellPropertiesDOSProvider },
	{ kEoBBaseMagicFlightProps, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MagicFlightPropsDOSProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1TurnUndeadEffectDOSProvider },
	{ kEoBBaseBurningHandsDest, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1BurningHandsDestDOSProvider },
	{ kEoBBaseConeOfColdDest1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest1DOSProvider },
	{ kEoBBaseConeOfColdDest2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest2DOSProvider },
	{ kEoBBaseConeOfColdDest3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest3DOSProvider },
	{ kEoBBaseConeOfColdDest4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest4DOSProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdGfxTblDOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorShapeIndexDOSProvider },
	{ kEoBBaseWllFlagPreset, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1WllFlagPresetDOSProvider },
	{ kEoBBaseDscShapeCoords, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscShapeCoordsDOSProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleOffsDOSProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult1DOSProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult2DOSProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult3DOSProvider },
	{ kEoBBaseDscDoorScaleMult4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult4DOSProvider },
	{ kEoBBaseDscDoorScaleMult5, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult5DOSProvider },
	{ kEoBBaseDscDoorScaleMult6, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult6DOSProvider },
	{ kEoBBaseDscDoorXE, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorXEDOSProvider },
	{ kEoBBaseDscDoorY1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY1DOSProvider },
	{ kEoBBaseDscDoorY3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY3DOSProvider },
	{ kEoBBaseDscDoorY4, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY4DOSProvider },
	{ kEoBBaseDscDoorY5, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY5DOSProvider },
	{ kEoBBaseDscDoorY6, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY6DOSProvider },
	{ kEoBBaseDscDoorY7, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorY7DOSProvider },
	{ kEoBBaseDscDoorCoordsExt, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorCoordsExtDOSProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY2DOSProvider },
	{ kRpgCommonDscDoorFrameIndex1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex1DOSProvider },
	{ kRpgCommonDscDoorFrameIndex2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex2DOSProvider },
	{ kEoBBaseDscItemPosIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemPosIndexDOSProvider },
	{ kEoBBaseDscItemShpX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemShpXDOSProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemScaleIndexDOSProvider },
	{ kEoBBaseDscItemTileIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemTileIndexDOSProvider },
	{ kEoBBaseDscItemShapeMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscItemShapeMapDOSProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscTelptrShpCoordsDOSProvider },
	{ kEoBBasePortalSeqData, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1PortalSeqDataDOSProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ManDefDOSEnglishProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ManWordDOSEnglishProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1ManPromptDOSEnglishProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl1DOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl2DOSProvider },
	{ kEoBBaseInvSlotX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1InvSlotXDOSProvider },
	{ kEoBBaseInvSlotY, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1InvSlotYDOSProvider },
	{ kEoBBaseSlotValidationFlags, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SlotValidationFlagsDOSProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ProjectileWeaponTypesDOSProvider },
	{ kEoBBaseWandTypes, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1WandTypesDOSProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DrawObjPosIndexDOSProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FlightObjFlipIndexDOSProvider },
	{ kEoBBaseFlightObjShpMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FlightObjShpMapDOSProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FlightObjSclIndexDOSProvider },
	{ kRpgCommonDscShapeIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscShapeIndexDOSProvider },
	{ kRpgCommonDscX, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscXDOSProvider },
	{ kRpgCommonDscTileIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscTileIndexDOSProvider },
	{ kRpgCommonDscDimData1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscDimMapDOSProvider },
	{ kRpgCommonDscBlockIndex, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1DscBlockIndexDOSProvider },
	{ kEoBBaseClassModifierFlags, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1ClassModifierFlagsDOSProvider },
	{ kEoBBaseMonsterStepTable01, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable01DOSProvider },
	{ kEoBBaseMonsterStepTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable2DOSProvider },
	{ kEoBBaseMonsterStepTable3, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable3DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable21, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable21DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable2DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable2DOSProvider },
	{ kEoBBaseMonsterProximityTable, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterProximityTableDOSProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1FindBlockMonstersTableDOSProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1MonsterDirChangeTableDOSProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB1MonsterDistAttStringsDOSEnglishProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefsDOSProvider },
	{ kEoBBaseNpcPresets, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1NpcPresetsDOSProvider },
	{ kEoBBaseSoundFilesIntro, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SoundFilesIntroDOSProvider },
	{ kEoBBaseSoundFilesIngame, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SoundFilesIngameDOSProvider },
	{ kEoBBaseSoundFilesFinale, kEoB1, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB1SoundFilesFinaleDOSProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1NpcPresetsNamesDOSGermanProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenStrings1DOSGermanProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenStrings2DOSGermanProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenStatStringsDOSGermanProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenRaceSexStringsDOSGermanProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenClassStringsDOSGermanProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenAlignmentStringsDOSGermanProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ChargenEnterGameStringsDOSGermanProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MainMenuStringsDOSGermanProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1BonusStringsDOSGermanProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1TurnUndeadStringDOSGermanProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc0StringsDOSGermanProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc11StringsDOSGermanProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc12StringsDOSGermanProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc21StringsDOSGermanProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc22StringsDOSGermanProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc31StringsDOSGermanProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc32StringsDOSGermanProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc4StringsDOSGermanProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc5StringsDOSGermanProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc6StringsDOSGermanProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1Npc7StringsDOSGermanProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PryDoorStringsDOSGermanProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1WarningStringsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsRingsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsPotionsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsWandsDOSGermanProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1RipItemStringsDOSGermanProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CursedStringDOSGermanProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicObjectStringsDOSGermanProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicObjectString5DOSGermanProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PatternSuffixDOSGermanProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PatternGrFix1DOSGermanProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PatternGrFix2DOSGermanProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ValidateArmorStringDOSGermanProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ValidateNoDropStringDOSGermanProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PotionStringsDOSGermanProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1WandStringsDOSGermanProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ItemMisuseStringsDOSGermanProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1TakenStringsDOSGermanProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1PotionEffectStringsDOSGermanProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1YesNoStringsDOSGermanProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MoreStringsDOSGermanProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1NpcMaxStringsDOSGermanProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1NpcJoinStringsDOSGermanProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CancelStringsDOSGermanProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsMainDOSGermanProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsSaveLoadDOSGermanProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsOnOffDOSGermanProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsSpellsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsRestDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsDropDOSGermanProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsExitDOSGermanProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsStarveDOSGermanProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsScribeDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsDrop2DOSGermanProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsHeadDOSGermanProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsPoisonDOSGermanProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsMgcDOSGermanProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsPrefsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsRest2DOSGermanProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsRest4DOSGermanProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuStringsDefeatDOSGermanProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MenuYesNoStringsDOSGermanProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsHpDOSGermanProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsWp1DOSGermanProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsWrDOSGermanProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsSt1DOSGermanProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsInDOSGermanProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings7DOSGermanProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings81DOSGermanProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings9DOSGermanProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings131DOSGermanProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1LevelGainStringsDOSGermanProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1BookNumbersDOSGermanProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MageSpellsListDOSGermanProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ClericSpellsListDOSGermanProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1SpellNamesDOSGermanProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings1DOSGermanProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings2DOSGermanProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings3DOSGermanProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings4DOSGermanProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings6DOSGermanProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings7DOSGermanProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings8DOSGermanProvider },
	//{ kEoBBaseMagicStrings9, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MagicStrings9DOSGermanProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ManDefDOSGermanProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ManWordDOSGermanProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1ManPromptDOSGermanProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB1MonsterDistAttStringsDOSGermanProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1NpcPresetsNamesDOSItalianProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenStrings1DOSItalianProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenStrings2DOSItalianProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenStatStringsDOSItalianProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenRaceSexStringsDOSItalianProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenClassStringsDOSItalianProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenAlignmentStringsDOSItalianProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ChargenEnterGameStringsDOSItalianProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MainMenuStringsDOSItalianProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1BonusStringsDOSItalianProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1TurnUndeadStringDOSItalianProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc0StringsDOSItalianProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc11StringsDOSItalianProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc12StringsDOSItalianProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc21StringsDOSItalianProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc22StringsDOSItalianProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc31StringsDOSItalianProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc32StringsDOSItalianProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc4StringsDOSItalianProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc5StringsDOSItalianProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc6StringsDOSItalianProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1Npc7StringsDOSItalianProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PryDoorStringsDOSItalianProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1WarningStringsDOSItalianProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemSuffixStringsRingsDOSItalianProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemSuffixStringsPotionsDOSItalianProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemSuffixStringsWandsDOSItalianProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1RipItemStringsDOSItalianProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CursedStringDOSItalianProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicObjectStringsDOSItalianProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicObjectString5DOSItalianProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PatternSuffixDOSItalianProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PatternGrFix1DOSItalianProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PatternGrFix2DOSItalianProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ValidateArmorStringDOSItalianProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ValidateNoDropStringDOSItalianProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PotionStringsDOSItalianProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1WandStringsDOSItalianProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ItemMisuseStringsDOSItalianProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1TakenStringsDOSItalianProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1PotionEffectStringsDOSItalianProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1YesNoStringsDOSItalianProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MoreStringsDOSItalianProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1NpcMaxStringsDOSItalianProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1NpcJoinStringsDOSItalianProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CancelStringsDOSItalianProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsMainDOSItalianProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsSaveLoadDOSItalianProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsOnOffDOSItalianProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsSpellsDOSItalianProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsRestDOSItalianProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsDropDOSItalianProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsExitDOSItalianProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsStarveDOSItalianProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsScribeDOSItalianProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsDrop2DOSItalianProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsHeadDOSItalianProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsPoisonDOSItalianProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsMgcDOSItalianProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsPrefsDOSItalianProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsRest2DOSItalianProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsRest4DOSItalianProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuStringsDefeatDOSItalianProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MenuYesNoStringsDOSItalianProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsHpDOSItalianProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsWp1DOSItalianProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsWrDOSItalianProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsSt1DOSItalianProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharGuiStringsInDOSItalianProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings7DOSItalianProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings81DOSItalianProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings9DOSItalianProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1CharStatusStrings131DOSItalianProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1LevelGainStringsDOSItalianProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1BookNumbersDOSItalianProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MageSpellsListDOSItalianProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ClericSpellsListDOSItalianProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1SpellNamesDOSItalianProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings1DOSItalianProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings2DOSItalianProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings3DOSItalianProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings4DOSItalianProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings6DOSItalianProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings7DOSItalianProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings8DOSItalianProvider },
	//{ kEoBBaseMagicStrings9, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MagicStrings9DOSItalianProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ManDefDOSItalianProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ManWordDOSItalianProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1ManPromptDOSItalianProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformDOS, kNoSpecial, IT_ITA, &kEoB1MonsterDistAttStringsDOSItalianProvider },
	{ kEoBBaseChargenStartLevels, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ChargenStartLevelsDOSProvider },
	{ kEoBBaseChargenClassMinStats, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ChargenClassMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ChargenRaceMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ChargenRaceMaxStatsDOSProvider },
	{ kEoBBaseSaveThrowTable1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SaveThrowTable1DOSProvider },
	{ kEoBBaseSaveThrowTable2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SaveThrowTable2DOSProvider },
	{ kEoBBaseSaveThrowTable3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SaveThrowTable3DOSProvider },
	{ kEoBBaseSaveThrowTable4, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SaveThrowTable4DOSProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SaveThrwLvlIndexDOSProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SaveThrwModDivDOSProvider },
	{ kEoBBaseSaveThrwModExt, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SaveThrwModExtDOSProvider },
	{ kEoB1IntroFilesOpening, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesOpeningDOSProvider },
	{ kEoB1IntroFilesTower, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesTowerDOSProvider },
	{ kEoB1IntroFilesOrb, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesOrbDOSProvider },
	{ kEoB1IntroFilesWdEntry, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesWdEntryDOSProvider },
	{ kEoB1IntroFilesKing, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesKingDOSProvider },
	{ kEoB1IntroFilesHands, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesHandsDOSProvider },
	{ kEoB1IntroFilesWdExit, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesWdExitDOSProvider },
	{ kEoB1IntroFilesTunnel, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroFilesTunnelDOSProvider },
	{ kEoB1IntroOpeningFrmDelay, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroOpeningFrmDelayDOSProvider },
	{ kEoB1IntroWdEncodeX, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroWdEncodeXDOSProvider },
	{ kEoB1IntroWdEncodeY, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroWdEncodeYDOSProvider },
	{ kEoB1IntroWdEncodeWH, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroWdEncodeWHDOSProvider },
	{ kEoB1IntroWdDsX, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroWdDsXDOSProvider },
	{ kEoB1IntroWdDsY, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroWdDsYDOSProvider },
	{ kEoB1IntroTvlX1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroTvlX1DOSProvider },
	{ kEoB1IntroTvlY1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroTvlY1DOSProvider },
	{ kEoB1IntroTvlX2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroTvlX2DOSProvider },
	{ kEoB1IntroTvlY2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroTvlY2DOSProvider },
	{ kEoB1IntroTvlW, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroTvlWDOSProvider },
	{ kEoB1IntroTvlH, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1IntroTvlHDOSProvider },
	{ kEoB1IntroStringsTower, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1IntroStringsTowerDOSSpanishProvider },
	{ kEoB1IntroStringsOrb, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1IntroStringsOrbDOSSpanishProvider },
	{ kEoB1IntroStringsWdEntry, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1IntroStringsWdEntryDOSSpanishProvider },
	{ kEoB1IntroStringsKing, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1IntroStringsKingDOSSpanishProvider },
	{ kEoB1IntroStringsHands, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1IntroStringsHandsDOSSpanishProvider },
	{ kEoB1IntroStringsWdExit, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1IntroStringsWdExitDOSSpanishProvider },
	{ kEoB1IntroStringsTunnel, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1IntroStringsTunnelDOSSpanishProvider },
	{ kEoB1DoorShapeDefs, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DoorShapeDefsDOSProvider },
	{ kEoB1DoorSwitchShapeDefs, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DoorSwitchShapeDefsDOSProvider },
	{ kEoB1DoorSwitchCoords, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DoorSwitchCoordsDOSProvider },
	{ kEoB1MonsterProperties, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterPropertiesDOSProvider },
	{ kEoB1EnemyMageSpellList, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1EnemyMageSpellListDOSProvider },
	{ kEoB1EnemyMageSfx, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1EnemyMageSfxDOSProvider },
	{ kEoB1BeholderSpellList, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1BeholderSpellListDOSProvider },
	{ kEoB1BeholderSfx, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1BeholderSfxDOSProvider },
	{ kEoB1CgaMappingDefault, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingDefaultDOSProvider },
	{ kEoB1CgaMappingAlt, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingAltDOSProvider },
	{ kEoB1CgaMappingInv, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingInvDOSProvider },
	{ kEoB1CgaMappingItemsL, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingItemsLDOSProvider },
	{ kEoB1CgaMappingItemsS, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingItemsSDOSProvider },
	{ kEoB1CgaMappingThrown, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingThrownDOSProvider },
	{ kEoB1CgaMappingIcons, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingIconsDOSProvider },
	{ kEoB1CgaMappingDeco, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingDecoDOSProvider },
	{ kEoB1CgaLevelMappingIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaLevelMappingIndexDOSProvider },
	{ kEoB1CgaMappingLevel0, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingLevel0DOSProvider },
	{ kEoB1CgaMappingLevel1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingLevel1DOSProvider },
	{ kEoB1CgaMappingLevel2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingLevel2DOSProvider },
	{ kEoB1CgaMappingLevel3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingLevel3DOSProvider },
	{ kEoB1CgaMappingLevel4, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1CgaMappingLevel4DOSProvider },
	{ kEoB1NpcShpData, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NpcShpDataDOSProvider },
	{ kEoB1NpcSubShpIndex1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NpcSubShpIndex1DOSProvider },
	{ kEoB1NpcSubShpIndex2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NpcSubShpIndex2DOSProvider },
	{ kEoB1NpcSubShpY, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NpcSubShpYDOSProvider },
	{ kEoBBaseSpellLevelsMage, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SpellLevelsMageDOSProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SpellLevelsClericDOSProvider },
	{ kEoBBaseNumSpellsCleric, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NumSpellsClericDOSProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NumSpellsWisAdjDOSProvider },
	{ kEoBBaseNumSpellsPal, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NumSpellsPalDOSProvider },
	{ kEoBBaseNumSpellsMage, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NumSpellsMageDOSProvider },
	{ kEoBBaseExperienceTable0, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExperienceTable0DOSProvider },
	{ kEoBBaseExperienceTable1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExperienceTable1DOSProvider },
	{ kEoBBaseExperienceTable2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExperienceTable2DOSProvider },
	{ kEoBBaseExperienceTable3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExperienceTable3DOSProvider },
	{ kEoBBaseExperienceTable4, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExperienceTable4DOSProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExpObjectTblIndexDOSProvider },
	{ kEoBBaseExpObjectShpStart, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExpObjectShpStartDOSProvider },
	{ kEoBBaseExpObjectTbl1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExpObjectTbl1DOSProvider },
	{ kEoBBaseExpObjectTbl2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExpObjectTbl2DOSProvider },
	{ kEoBBaseExpObjectTbl3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExpObjectTbl3DOSProvider },
	{ kEoBBaseExpObjectY, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ExpObjectYDOSProvider },
	{ kEoBBaseSparkDefSteps, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkDefStepsDOSProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkDefSubStepsDOSProvider },
	{ kEoBBaseSparkDefShift, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkDefShiftDOSProvider },
	{ kEoBBaseSparkDefAdd, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkDefAddDOSProvider },
	{ kEoBBaseSparkDefX, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkDefXDOSProvider },
	{ kEoBBaseSparkDefY, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkDefYDOSProvider },
	{ kEoBBaseSparkOfFlags1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkOfFlags1DOSProvider },
	{ kEoBBaseSparkOfFlags2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkOfFlags2DOSProvider },
	{ kEoBBaseSparkOfShift, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkOfShiftDOSProvider },
	{ kEoBBaseSparkOfX, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkOfXDOSProvider },
	{ kEoBBaseSparkOfY, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SparkOfYDOSProvider },
	{ kEoBBaseSpellProperties, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SpellPropertiesDOSProvider },
	{ kEoBBaseMagicFlightProps, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MagicFlightPropsDOSProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1TurnUndeadEffectDOSProvider },
	{ kEoBBaseBurningHandsDest, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1BurningHandsDestDOSProvider },
	{ kEoBBaseConeOfColdDest1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ConeOfColdDest1DOSProvider },
	{ kEoBBaseConeOfColdDest2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ConeOfColdDest2DOSProvider },
	{ kEoBBaseConeOfColdDest3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ConeOfColdDest3DOSProvider },
	{ kEoBBaseConeOfColdDest4, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ConeOfColdDest4DOSProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ConeOfColdGfxTblDOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorShapeIndexDOSProvider },
	{ kEoBBaseWllFlagPreset, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1WllFlagPresetDOSProvider },
	{ kEoBBaseDscShapeCoords, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscShapeCoordsDOSProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorScaleOffsDOSProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorScaleMult1DOSProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorScaleMult2DOSProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorScaleMult3DOSProvider },
	{ kEoBBaseDscDoorScaleMult4, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorScaleMult4DOSProvider },
	{ kEoBBaseDscDoorScaleMult5, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorScaleMult5DOSProvider },
	{ kEoBBaseDscDoorScaleMult6, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorScaleMult6DOSProvider },
	{ kEoBBaseDscDoorXE, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorXEDOSProvider },
	{ kEoBBaseDscDoorY1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorY1DOSProvider },
	{ kEoBBaseDscDoorY3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorY3DOSProvider },
	{ kEoBBaseDscDoorY4, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorY4DOSProvider },
	{ kEoBBaseDscDoorY5, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorY5DOSProvider },
	{ kEoBBaseDscDoorY6, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorY6DOSProvider },
	{ kEoBBaseDscDoorY7, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorY7DOSProvider },
	{ kEoBBaseDscDoorCoordsExt, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorCoordsExtDOSProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorFrameY2DOSProvider },
	{ kRpgCommonDscDoorFrameIndex1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorFrameIndex1DOSProvider },
	{ kRpgCommonDscDoorFrameIndex2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDoorFrameIndex2DOSProvider },
	{ kEoBBaseDscItemPosIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscItemPosIndexDOSProvider },
	{ kEoBBaseDscItemShpX, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscItemShpXDOSProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscItemScaleIndexDOSProvider },
	{ kEoBBaseDscItemTileIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscItemTileIndexDOSProvider },
	{ kEoBBaseDscItemShapeMap, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscItemShapeMapDOSProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscTelptrShpCoordsDOSProvider },
	{ kEoBBasePortalSeqData, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1PortalSeqDataDOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl1DOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl2DOSProvider },
	{ kEoBBaseInvSlotX, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1InvSlotXDOSProvider },
	{ kEoBBaseInvSlotY, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1InvSlotYDOSProvider },
	{ kEoBBaseSlotValidationFlags, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SlotValidationFlagsDOSProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ProjectileWeaponTypesDOSProvider },
	{ kEoBBaseWandTypes, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1WandTypesDOSProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DrawObjPosIndexDOSProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1FlightObjFlipIndexDOSProvider },
	{ kEoBBaseFlightObjShpMap, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1FlightObjShpMapDOSProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1FlightObjSclIndexDOSProvider },
	{ kRpgCommonDscShapeIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscShapeIndexDOSProvider },
	{ kRpgCommonDscX, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscXDOSProvider },
	{ kRpgCommonDscTileIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscTileIndexDOSProvider },
	{ kRpgCommonDscDimData1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscDimMapDOSProvider },
	{ kRpgCommonDscBlockIndex, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1DscBlockIndexDOSProvider },
	{ kEoBBaseClassModifierFlags, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1ClassModifierFlagsDOSProvider },
	{ kEoBBaseMonsterStepTable01, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterStepTable01DOSProvider },
	{ kEoBBaseMonsterStepTable2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterStepTable2DOSProvider },
	{ kEoBBaseMonsterStepTable3, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterStepTable3DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterCloseAttPosTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable21, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterCloseAttPosTable21DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterCloseAttChkTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterCloseAttChkTable2DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterCloseAttDstTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterCloseAttDstTable2DOSProvider },
	{ kEoBBaseMonsterProximityTable, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterProximityTableDOSProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1FindBlockMonstersTableDOSProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1MonsterDirChangeTableDOSProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1EncodeMonsterDefsDOSProvider },
	{ kEoBBaseNpcPresets, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1NpcPresetsDOSProvider },
	{ kEoBBaseSoundFilesIntro, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SoundFilesIntroDOSProvider },
	{ kEoBBaseSoundFilesIngame, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SoundFilesIngameDOSProvider },
	{ kEoBBaseSoundFilesFinale, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1SoundFilesFinaleDOSProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1NpcPresetsNamesDOSSpanishProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ChargenStrings1DOSSpanishProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ChargenStrings2DOSSpanishProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ChargenStatStringsDOSSpanishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ChargenRaceSexStringsDOSSpanishProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ChargenClassStringsDOSSpanishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ChargenAlignmentStringsDOSSpanishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ChargenEnterGameStringsDOSSpanishProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MainMenuStringsDOSSpanishProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1BonusStringsDOSSpanishProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1TurnUndeadStringDOSSpanishProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc0StringsDOSSpanishProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc11StringsDOSSpanishProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc12StringsDOSSpanishProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc21StringsDOSSpanishProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc22StringsDOSSpanishProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc31StringsDOSSpanishProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc32StringsDOSSpanishProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc4StringsDOSSpanishProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc5StringsDOSSpanishProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc6StringsDOSSpanishProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1Npc7StringsDOSSpanishProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1PryDoorStringsDOSSpanishProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1WarningStringsDOSSpanishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ItemSuffixStringsRingsDOSSpanishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ItemSuffixStringsPotionsDOSSpanishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ItemSuffixStringsWandsDOSSpanishProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1RipItemStringsDOSSpanishProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CursedStringDOSSpanishProvider },
	{ kEoBBaseEnchantedString, kEoB1, kPlatformDOS, kOldFloppy, UNK_LANG, &kEoB1EnchantedStringDOSProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicObjectStringsDOSSpanishProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicObjectString5DOSSpanishProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1PatternSuffixDOSSpanishProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1PatternGrFix1DOSSpanishProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1PatternGrFix2DOSSpanishProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ValidateArmorStringDOSSpanishProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ValidateNoDropStringDOSSpanishProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1PotionStringsDOSSpanishProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1WandStringsDOSSpanishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ItemMisuseStringsDOSSpanishProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1TakenStringsDOSSpanishProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1PotionEffectStringsDOSSpanishProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1YesNoStringsDOSSpanishProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MoreStringsDOSSpanishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1NpcMaxStringsDOSSpanishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1NpcJoinStringsDOSSpanishProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CancelStringsDOSSpanishProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsMainDOSSpanishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsSaveLoadDOSSpanishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsOnOffDOSSpanishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsSpellsDOSSpanishProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsRestDOSSpanishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsDropDOSSpanishProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsExitDOSSpanishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsStarveDOSSpanishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsScribeDOSSpanishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsDrop2DOSSpanishProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsHeadDOSSpanishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsPoisonDOSSpanishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsMgcDOSSpanishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsPrefsDOSSpanishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsRest2DOSSpanishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsRest4DOSSpanishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuStringsDefeatDOSSpanishProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MenuYesNoStringsDOSSpanishProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharGuiStringsHpDOSSpanishProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharGuiStringsWp1DOSSpanishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharGuiStringsWrDOSSpanishProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharGuiStringsSt1DOSSpanishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharGuiStringsInDOSSpanishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharStatusStrings7DOSSpanishProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharStatusStrings81DOSSpanishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharStatusStrings9DOSSpanishProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1CharStatusStrings131DOSSpanishProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1LevelGainStringsDOSSpanishProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1BookNumbersDOSSpanishProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MageSpellsListDOSSpanishProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ClericSpellsListDOSSpanishProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1SpellNamesDOSSpanishProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings1DOSSpanishProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings2DOSSpanishProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings3DOSSpanishProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings4DOSSpanishProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings6DOSSpanishProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings7DOSSpanishProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings8DOSSpanishProvider },
	//{ kEoBBaseMagicStrings9, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MagicStrings9DOSSpanishProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ManDefDOSSpanishProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ManWordDOSSpanishProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1ManPromptDOSSpanishProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformDOS, kOldFloppy, ES_ESP, &kEoB1MonsterDistAttStringsDOSSpanishProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1NpcPresetsNamesAmigaEnglishProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ChargenStrings1AmigaEnglishProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ChargenStrings2AmigaEnglishProvider },
	{ kEoBBaseChargenStartLevels, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ChargenStartLevelsAmigaProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ChargenStatStringsAmigaEnglishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ChargenRaceSexStringsAmigaEnglishProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ChargenClassStringsAmigaEnglishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ChargenAlignmentStringsAmigaEnglishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ChargenEnterGameStringsAmigaEnglishProvider },
	{ kEoBBaseChargenClassMinStats, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ChargenClassMinStatsAmigaProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMinStatsAmigaProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMaxStatsAmigaProvider },
	{ kEoBBaseSaveThrowTable1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable1AmigaProvider },
	{ kEoBBaseSaveThrowTable2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable2AmigaProvider },
	{ kEoBBaseSaveThrowTable3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable3AmigaProvider },
	{ kEoBBaseSaveThrowTable4, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable4AmigaProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SaveThrwLvlIndexAmigaProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModDivAmigaProvider },
	{ kEoBBaseSaveThrwModExt, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModExtAmigaProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MainMenuStringsAmigaEnglishProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1BonusStringsAmigaEnglishProvider },
	{ kEoB1IntroFilesOpening, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOpeningAmigaProvider },
	{ kEoB1IntroFilesTower, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTowerAmigaProvider },
	{ kEoB1IntroFilesOrb, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOrbAmigaProvider },
	{ kEoB1IntroFilesWdEntry, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdEntryAmigaProvider },
	{ kEoB1IntroFilesKing, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesKingAmigaProvider },
	{ kEoB1IntroFilesHands, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesHandsAmigaProvider },
	{ kEoB1IntroFilesWdExit, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdExitAmigaProvider },
	{ kEoB1IntroFilesTunnel, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTunnelAmigaProvider },
	{ kEoB1IntroOpeningFrmDelay, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroOpeningFrmDelayAmigaProvider },
	{ kEoB1IntroWdEncodeX, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeXAmigaProvider },
	{ kEoB1IntroWdEncodeY, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeYAmigaProvider },
	{ kEoB1IntroWdEncodeWH, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeWHAmigaProvider },
	{ kEoB1IntroWdDsX, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsXAmigaProvider },
	{ kEoB1IntroWdDsY, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsYAmigaProvider },
	{ kEoB1IntroTvlX1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX1AmigaProvider },
	{ kEoB1IntroTvlY1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY1AmigaProvider },
	{ kEoB1IntroTvlX2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX2AmigaProvider },
	{ kEoB1IntroTvlY2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY2AmigaProvider },
	{ kEoB1IntroTvlW, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroTvlWAmigaProvider },
	{ kEoB1IntroTvlH, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroTvlHAmigaProvider },
	{ kEoB1IntroOrbFadePal, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1IntroOrbFadePalAmigaProvider },
	{ kEoB1FinaleCouncilAnim1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1CouncilAnimData1AmigaProvider },
	{ kEoB1FinaleCouncilAnim2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1CouncilAnimData2AmigaProvider },
	{ kEoB1FinaleCouncilAnim3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1CouncilAnimData3AmigaProvider },
	{ kEoB1FinaleCouncilAnim4, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1CouncilAnimData4AmigaProvider },
	{ kEoB1FinaleEyesAnim, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1EyesAnimDataAmigaProvider },
	{ kEoB1FinaleHandsAnim, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1HandsAnimDataAmigaProvider },
	{ kEoB1FinaleTextDuration, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1TextFrameDurationAmigaProvider },
	{ kEoB1DoorShapeDefs, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DoorShapeDefsAmigaProvider },
	{ kEoB1DoorSwitchShapeDefs, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchShapeDefsAmigaProvider },
	{ kEoB1DoorSwitchCoords, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchCoordsAmigaProvider },
	{ kEoB1MonsterProperties, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterPropertiesAmigaProvider },
	{ kEoB1EnemyMageSpellList, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSpellListAmigaProvider },
	{ kEoB1EnemyMageSfx, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSfxAmigaProvider },
	{ kEoB1BeholderSpellList, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1BeholderSpellListAmigaProvider },
	{ kEoB1BeholderSfx, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1BeholderSfxAmigaProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1TurnUndeadStringAmigaEnglishProvider },
	{ kEoB1NpcShpData, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NpcShpDataAmigaProvider },
	{ kEoB1NpcSubShpIndex1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex1AmigaProvider },
	{ kEoB1NpcSubShpIndex2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex2AmigaProvider },
	{ kEoB1NpcSubShpY, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpYAmigaProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc0StringsAmigaEnglishProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc11StringsAmigaEnglishProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc12StringsAmigaEnglishProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc21StringsAmigaEnglishProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc22StringsAmigaEnglishProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc31StringsAmigaEnglishProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc32StringsAmigaEnglishProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc4StringsAmigaEnglishProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc5StringsAmigaEnglishProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc6StringsAmigaEnglishProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1Npc7StringsAmigaEnglishProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1PryDoorStringsAmigaEnglishProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1WarningStringsAmigaEnglishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsRingsAmigaEnglishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsPotionsAmigaEnglishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsWandsAmigaEnglishProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1RipItemStringsAmigaEnglishProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CursedStringAmigaEnglishProvider },
	{ kEoBBaseEnchantedString, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1EnchantedStringAmigaProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicObjectStringsAmigaEnglishProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicObjectString5AmigaEnglishProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1PatternSuffixAmigaEnglishProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1PatternGrFix1AmigaEnglishProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1PatternGrFix2AmigaEnglishProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ValidateArmorStringAmigaEnglishProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ValidateNoDropStringAmigaEnglishProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1PotionStringsAmigaEnglishProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1WandStringsAmigaEnglishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ItemMisuseStringsAmigaEnglishProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1TakenStringsAmigaEnglishProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1PotionEffectStringsAmigaEnglishProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1YesNoStringsAmigaEnglishProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MoreStringsAmigaEnglishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1NpcMaxStringsAmigaEnglishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1NpcJoinStringsAmigaEnglishProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CancelStringsAmigaEnglishProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsMainAmigaEnglishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsSaveLoadAmigaEnglishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsOnOffAmigaEnglishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsSpellsAmigaEnglishProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsRestAmigaEnglishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsDropAmigaEnglishProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsExitAmigaEnglishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsStarveAmigaEnglishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsScribeAmigaEnglishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsDrop2AmigaEnglishProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsHeadAmigaEnglishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsPoisonAmigaEnglishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsMgcAmigaEnglishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsPrefsAmigaEnglishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest2AmigaEnglishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest4AmigaEnglishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuStringsDefeatAmigaEnglishProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MenuYesNoStringsAmigaEnglishProvider },
	{ kEoBBaseSpellLevelsMage, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsMageAmigaProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsClericAmigaProvider },
	{ kEoBBaseNumSpellsCleric, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NumSpellsClericAmigaProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NumSpellsWisAdjAmigaProvider },
	{ kEoBBaseNumSpellsPal, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NumSpellsPalAmigaProvider },
	{ kEoBBaseNumSpellsMage, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NumSpellsMageAmigaProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsHpAmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsWp1AmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsWrAmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsSt1AmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsInAmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings7AmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings81AmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings9AmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings131AmigaEnglishProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1LevelGainStringsAmigaEnglishProvider },
	{ kEoBBaseExperienceTable0, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable0AmigaProvider },
	{ kEoBBaseExperienceTable1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable1AmigaProvider },
	{ kEoBBaseExperienceTable2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable2AmigaProvider },
	{ kEoBBaseExperienceTable3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable3AmigaProvider },
	{ kEoBBaseExperienceTable4, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable4AmigaProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1BookNumbersAmigaEnglishProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MageSpellsListAmigaEnglishProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ClericSpellsListAmigaEnglishProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1SpellNamesAmigaEnglishProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings1AmigaEnglishProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings2AmigaEnglishProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings3AmigaEnglishProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings4AmigaEnglishProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings6AmigaEnglishProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings7AmigaEnglishProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings8AmigaEnglishProvider },
	{ kEoBBaseMagicStrings9, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MagicStrings9AmigaEnglishProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTblIndexAmigaProvider },
	{ kEoBBaseExpObjectShpStart, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExpObjectShpStartAmigaProvider },
	{ kEoBBaseExpObjectTbl1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl1AmigaProvider },
	{ kEoBBaseExpObjectTbl2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl2AmigaProvider },
	{ kEoBBaseExpObjectTbl3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl3AmigaProvider },
	{ kEoBBaseExpObjectY, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ExpObjectYAmigaProvider },
	{ kEoBBaseSparkDefSteps, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkDefStepsAmigaProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkDefSubStepsAmigaProvider },
	{ kEoBBaseSparkDefShift, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkDefShiftAmigaProvider },
	{ kEoBBaseSparkDefAdd, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkDefAddAmigaProvider },
	{ kEoBBaseSparkDefX, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkDefXAmigaProvider },
	{ kEoBBaseSparkDefY, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkDefYAmigaProvider },
	{ kEoBBaseSparkOfFlags1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags1AmigaProvider },
	{ kEoBBaseSparkOfFlags2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags2AmigaProvider },
	{ kEoBBaseSparkOfShift, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkOfShiftAmigaProvider },
	{ kEoBBaseSparkOfX, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkOfXAmigaProvider },
	{ kEoBBaseSparkOfY, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SparkOfYAmigaProvider },
	{ kEoBBaseSpellProperties, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SpellPropertiesAmigaProvider },
	{ kEoBBaseMagicFlightProps, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MagicFlightPropsAmigaProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1TurnUndeadEffectAmigaProvider },
	{ kEoBBaseBurningHandsDest, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1BurningHandsDestAmigaProvider },
	{ kEoBBaseConeOfColdDest1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest1AmigaProvider },
	{ kEoBBaseConeOfColdDest2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest2AmigaProvider },
	{ kEoBBaseConeOfColdDest3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest3AmigaProvider },
	{ kEoBBaseConeOfColdDest4, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest4AmigaProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdGfxTblAmigaProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorShapeIndexAmigaProvider },
	{ kEoBBaseWllFlagPreset, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1WllFlagPresetAmigaProvider },
	{ kEoBBaseDscShapeCoords, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscShapeCoordsAmigaProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleOffsAmigaProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult1AmigaProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult2AmigaProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult3AmigaProvider },
	{ kEoBBaseDscDoorScaleMult4, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult4AmigaProvider },
	{ kEoBBaseDscDoorScaleMult5, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult5AmigaProvider },
	{ kEoBBaseDscDoorScaleMult6, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult6AmigaProvider },
	{ kEoBBaseDscDoorXE, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorXEAmigaProvider },
	{ kEoBBaseDscDoorY1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorY1AmigaProvider },
	{ kEoBBaseDscDoorY3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorY3AmigaProvider },
	{ kEoBBaseDscDoorY4, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorY4AmigaProvider },
	{ kEoBBaseDscDoorY5, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorY5AmigaProvider },
	{ kEoBBaseDscDoorY6, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorY6AmigaProvider },
	{ kEoBBaseDscDoorY7, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorY7AmigaProvider },
	{ kEoBBaseDscDoorCoordsExt, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorCoordsExtAmigaProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY1AmigaProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY2AmigaProvider },
	{ kRpgCommonDscDoorFrameIndex1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex1AmigaProvider },
	{ kRpgCommonDscDoorFrameIndex2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex2AmigaProvider },
	{ kEoBBaseDscItemPosIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscItemPosIndexAmigaProvider },
	{ kEoBBaseDscItemShpX, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscItemShpXAmigaProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscItemScaleIndexAmigaProvider },
	{ kEoBBaseDscItemTileIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscItemTileIndexAmigaProvider },
	{ kEoBBaseDscItemShapeMap, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscItemShapeMapAmigaProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscTelptrShpCoordsAmigaProvider },
	{ kEoBBasePortalSeqData, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1PortalSeqDataAmigaProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ManDefAmigaEnglishProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ManWordAmigaEnglishProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1ManPromptAmigaEnglishProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl1AmigaProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl2AmigaProvider },
	{ kEoBBaseInvSlotX, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1InvSlotXAmigaProvider },
	{ kEoBBaseInvSlotY, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1InvSlotYAmigaProvider },
	{ kEoBBaseSlotValidationFlags, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SlotValidationFlagsAmigaProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ProjectileWeaponTypesAmigaProvider },
	{ kEoBBaseWandTypes, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1WandTypesAmigaProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DrawObjPosIndexAmigaProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1FlightObjFlipIndexAmigaProvider },
	{ kEoBBaseFlightObjShpMap, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1FlightObjShpMapAmigaProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1FlightObjSclIndexAmigaProvider },
	{ kRpgCommonDscShapeIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscShapeIndexAmigaProvider },
	{ kRpgCommonDscX, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscXAmigaProvider },
	{ kRpgCommonDscTileIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscTileIndexAmigaProvider },
	{ kRpgCommonDscDimData1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDimData1AmigaProvider },
	{ kRpgCommonDscDimData2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDimData2AmigaProvider },
	{ kRpgCommonDscBlockMap, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscBlockMapAmigaProvider },
	{ kRpgCommonDscDimMap, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscDimMapAmigaProvider },
	{ kRpgCommonDscBlockIndex, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1DscBlockIndexAmigaProvider },
	{ kEoBBaseClassModifierFlags, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1ClassModifierFlagsAmigaProvider },
	{ kEoBBaseMonsterStepTable01, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable01AmigaProvider },
	{ kEoBBaseMonsterStepTable2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable2AmigaProvider },
	{ kEoBBaseMonsterStepTable3, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable3AmigaProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable1AmigaProvider },
	{ kEoBBaseMonsterCloseAttPosTable21, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable21AmigaProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable1AmigaProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable2AmigaProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable1AmigaProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable2AmigaProvider },
	{ kEoBBaseMonsterProximityTable, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterProximityTableAmigaProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1FindBlockMonstersTableAmigaProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1MonsterDirChangeTableAmigaProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB1MonsterDistAttStringsAmigaEnglishProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefsAmigaProvider },
	{ kEoBBaseNpcPresets, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1NpcPresetsAmigaProvider },
	{ kEoBBaseSoundMap, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SoundMapAmigaProvider },
	{ kEoBBaseLevelSoundFiles1, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1LevelSoundFiles1AmigaProvider },
	{ kEoBBaseLevelSoundFiles2, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1LevelSoundFiles2AmigaProvider },
	{ kEoBBaseSoundFilesIntro, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SoundFilesIntroAmigaProvider },
	{ kEoBBaseSoundFilesIngame, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SoundFilesIngameAmigaProvider },
	{ kEoBBaseSoundFilesFinale, kEoB1, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB1SoundFilesFinaleAmigaProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1NpcPresetsNamesAmigaGermanProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ChargenStrings1AmigaGermanProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ChargenStrings2AmigaGermanProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ChargenStatStringsAmigaGermanProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ChargenRaceSexStringsAmigaGermanProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ChargenClassStringsAmigaGermanProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ChargenAlignmentStringsAmigaGermanProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ChargenEnterGameStringsAmigaGermanProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MainMenuStringsAmigaGermanProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1BonusStringsAmigaGermanProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1TurnUndeadStringAmigaGermanProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc0StringsAmigaGermanProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc11StringsAmigaGermanProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc12StringsAmigaGermanProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc21StringsAmigaGermanProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc22StringsAmigaGermanProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc31StringsAmigaGermanProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc32StringsAmigaGermanProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc4StringsAmigaGermanProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc5StringsAmigaGermanProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc6StringsAmigaGermanProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1Npc7StringsAmigaGermanProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1PryDoorStringsAmigaGermanProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1WarningStringsAmigaGermanProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsRingsAmigaGermanProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsPotionsAmigaGermanProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ItemSuffixStringsWandsAmigaGermanProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1RipItemStringsAmigaGermanProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CursedStringAmigaGermanProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicObjectStringsAmigaGermanProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicObjectString5AmigaGermanProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1PatternSuffixAmigaGermanProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1PatternGrFix1AmigaGermanProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1PatternGrFix2AmigaGermanProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ValidateArmorStringAmigaGermanProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ValidateNoDropStringAmigaGermanProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1PotionStringsAmigaGermanProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1WandStringsAmigaGermanProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ItemMisuseStringsAmigaGermanProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1TakenStringsAmigaGermanProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1PotionEffectStringsAmigaGermanProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1YesNoStringsAmigaGermanProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MoreStringsAmigaGermanProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1NpcMaxStringsAmigaGermanProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1NpcJoinStringsAmigaGermanProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CancelStringsAmigaGermanProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsMainAmigaGermanProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsSaveLoadAmigaGermanProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsOnOffAmigaGermanProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsSpellsAmigaGermanProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsRestAmigaGermanProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsDropAmigaGermanProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsExitAmigaGermanProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsStarveAmigaGermanProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsScribeAmigaGermanProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsDrop2AmigaGermanProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsHeadAmigaGermanProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsPoisonAmigaGermanProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsMgcAmigaGermanProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsPrefsAmigaGermanProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsRest2AmigaGermanProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsRest4AmigaGermanProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuStringsDefeatAmigaGermanProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MenuYesNoStringsAmigaGermanProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsHpAmigaGermanProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsWp1AmigaGermanProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsWrAmigaGermanProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsSt1AmigaGermanProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharGuiStringsInAmigaGermanProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings7AmigaGermanProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings81AmigaGermanProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings9AmigaGermanProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1CharStatusStrings131AmigaGermanProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1LevelGainStringsAmigaGermanProvider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1BookNumbersAmigaGermanProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MageSpellsListAmigaGermanProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ClericSpellsListAmigaGermanProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1SpellNamesAmigaGermanProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings1AmigaGermanProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings2AmigaGermanProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings3AmigaGermanProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings4AmigaGermanProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings6AmigaGermanProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings7AmigaGermanProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings8AmigaGermanProvider },
	{ kEoBBaseMagicStrings9, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MagicStrings9AmigaGermanProvider },
	{ kEoBBaseManDef, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ManDefAmigaGermanProvider },
	{ kEoBBaseManWord, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ManWordAmigaGermanProvider },
	{ kEoBBaseManPrompt, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1ManPromptAmigaGermanProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB1MonsterDistAttStringsAmigaGermanProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1NpcPresetsNamesPC98JapaneseProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ChargenStrings1PC98JapaneseProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ChargenStrings2PC98JapaneseProvider },
	{ kEoBBaseChargenStartLevels, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ChargenStartLevelsPC98Provider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ChargenStatStringsPC98JapaneseProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ChargenRaceSexStringsPC98JapaneseProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ChargenClassStringsPC98JapaneseProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ChargenAlignmentStringsPC98JapaneseProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ChargenEnterGameStringsPC98JapaneseProvider },
	{ kEoBBaseChargenClassMinStats, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ChargenClassMinStatsPC98Provider },
	{ kEoBBaseChargenRaceMinStats, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMinStatsPC98Provider },
	{ kEoBBaseChargenRaceMaxStats, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMaxStatsPC98Provider },
	{ kEoBBaseSaveThrowTable1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable1PC98Provider },
	{ kEoBBaseSaveThrowTable2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable2PC98Provider },
	{ kEoBBaseSaveThrowTable3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable3PC98Provider },
	{ kEoBBaseSaveThrowTable4, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable4PC98Provider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SaveThrwLvlIndexPC98Provider },
	{ kEoBBaseSaveThrwModDiv, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModDivPC98Provider },
	{ kEoBBaseSaveThrwModExt, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModExtPC98Provider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MainMenuStringsPC98JapaneseProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1BonusStringsPC98JapaneseProvider },
	{ kEoB1IntroFilesOpening, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOpeningPC98Provider },
	{ kEoB1IntroFilesTower, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTowerPC98Provider },
	{ kEoB1IntroFilesOrb, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesOrbPC98Provider },
	{ kEoB1IntroFilesWdEntry, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdEntryPC98Provider },
	{ kEoB1IntroFilesKing, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesKingPC98Provider },
	{ kEoB1IntroFilesHands, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesHandsPC98Provider },
	{ kEoB1IntroFilesWdExit, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesWdExitPC98Provider },
	{ kEoB1IntroFilesTunnel, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroFilesTunnelPC98Provider },
	{ kEoB1IntroOpeningFrmDelay, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroOpeningFrmDelayPC98Provider },
	{ kEoB1IntroWdEncodeX, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeXPC98Provider },
	{ kEoB1IntroWdEncodeY, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeYPC98Provider },
	{ kEoB1IntroWdEncodeWH, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroWdEncodeWHPC98Provider },
	{ kEoB1IntroWdDsX, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsXPC98Provider },
	{ kEoB1IntroWdDsY, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsYPC98Provider },
	{ kEoB1IntroTvlX1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX1PC98Provider },
	{ kEoB1IntroTvlY1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY1PC98Provider },
	{ kEoB1IntroTvlX2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroTvlX2PC98Provider },
	{ kEoB1IntroTvlY2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroTvlY2PC98Provider },
	{ kEoB1IntroTvlW, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroTvlWPC98Provider },
	{ kEoB1IntroTvlH, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1IntroTvlHPC98Provider },
	{ kEoB1IntroStringsTower, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1IntroStringsTowerPC98JapaneseProvider },
	{ kEoB1IntroStringsOrb, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1IntroStringsOrbPC98JapaneseProvider },
	{ kEoB1IntroStringsWdEntry, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1IntroStringsWdEntryPC98JapaneseProvider },
	{ kEoB1IntroStringsKing, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1IntroStringsKingPC98JapaneseProvider },
	{ kEoB1IntroStringsHands, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1IntroStringsHandsPC98JapaneseProvider },
	{ kEoB1IntroStringsWdExit, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1IntroStringsWdExitPC98JapaneseProvider },
	{ kEoB1IntroStringsTunnel, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1IntroStringsTunnelPC98JapaneseProvider },
	{ kEoB1FinaleStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1FinaleStringsPC98JapaneseProvider },
	{ kEoB1FinaleEyesAnim, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FinaleEyesAnimPC98Provider },
	{ kEoB1FinaleHandsAnim, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FinaleHandsAnimPC98Provider },
	{ kEoB1FinaleHandsAnim2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FinaleHandsAnim2PC98Provider },
	{ kEoB1FinaleHandsAnim3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FinaleHandsAnim3PC98Provider },
	{ kEoB1CreditsStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CreditsStringsPC98JapaneseProvider },
	{ kEoB1CreditsCharWdth, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1CreditsCharWdthPC98Provider },
	{ kEoB1DoorShapeDefs, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DoorShapeDefsPC98Provider },
	{ kEoB1DoorSwitchShapeDefs, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchShapeDefsPC98Provider },
	{ kEoB1DoorSwitchCoords, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchCoordsPC98Provider },
	{ kEoB1MonsterProperties, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterPropertiesPC98Provider },
	{ kEoB1EnemyMageSpellList, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSpellListPC98Provider },
	{ kEoB1EnemyMageSfx, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSfxPC98Provider },
	{ kEoB1BeholderSpellList, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1BeholderSpellListPC98Provider },
	{ kEoB1BeholderSfx, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1BeholderSfxPC98Provider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1TurnUndeadStringPC98JapaneseProvider },
	{ kEoB1NpcShpData, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NpcShpDataPC98Provider },
	{ kEoB1NpcSubShpIndex1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex1PC98Provider },
	{ kEoB1NpcSubShpIndex2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpIndex2PC98Provider },
	{ kEoB1NpcSubShpY, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NpcSubShpYPC98Provider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc0StringsPC98JapaneseProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc11StringsPC98JapaneseProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc12StringsPC98JapaneseProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc21StringsPC98JapaneseProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc22StringsPC98JapaneseProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc31StringsPC98JapaneseProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc32StringsPC98JapaneseProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc4StringsPC98JapaneseProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc5StringsPC98JapaneseProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc6StringsPC98JapaneseProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1Npc7StringsPC98JapaneseProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1PryDoorStringsPC98JapaneseProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1WarningStringsPC98JapaneseProvider },
	{ kEoB1ItemNames, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ItemNamesPC98JapaneseProvider },
	{ kEoB1Ascii2SjisTable1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1Ascii2SjisTable1PC98Provider },
	{ kEoB1Ascii2SjisTable2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1Ascii2SjisTable2PC98Provider },
	{ kEoB1FontLookupTable, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FontLookupTablePC98Provider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ItemSuffixStringsRingsPC98JapaneseProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ItemSuffixStringsPotionsPC98JapaneseProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ItemSuffixStringsWandsPC98JapaneseProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1RipItemStringsPC98JapaneseProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CursedStringPC98JapaneseProvider },
	{ kEoBBaseEnchantedString, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1EnchantedStringPC98Provider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicObjectStringsPC98JapaneseProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicObjectString5PC98JapaneseProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1PatternSuffixPC98JapaneseProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1PatternGrFix1PC98JapaneseProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1PatternGrFix2PC98JapaneseProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ValidateArmorStringPC98JapaneseProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ValidateNoDropStringPC98JapaneseProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1PotionStringsPC98JapaneseProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1WandStringsPC98JapaneseProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ItemMisuseStringsPC98JapaneseProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1TakenStringsPC98JapaneseProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1PotionEffectStringsPC98JapaneseProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1YesNoStringsPC98JapaneseProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MoreStringsPC98JapaneseProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1NpcMaxStringsPC98JapaneseProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1NpcJoinStringsPC98JapaneseProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CancelStringsPC98JapaneseProvider },
	{ kEoBBaseMenuStringsMain, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsMainPC98JapaneseProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsSaveLoadPC98JapaneseProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsOnOffPC98JapaneseProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsSpellsPC98JapaneseProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsRestPC98JapaneseProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsDropPC98JapaneseProvider },
	{ kEoBBaseMenuStringsExit, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsExitPC98JapaneseProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsStarvePC98JapaneseProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsScribePC98JapaneseProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsDrop2PC98JapaneseProvider },
	{ kEoBBaseMenuStringsHead, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsHeadPC98JapaneseProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsPoisonPC98JapaneseProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsMgcPC98JapaneseProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsPrefsPC98JapaneseProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsRest2PC98JapaneseProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsRest4PC98JapaneseProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuStringsDefeatPC98JapaneseProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MenuYesNoStringsPC98JapaneseProvider },
	{ kEoBBaseSpellLevelsMage, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsMagePC98Provider },
	{ kEoBBaseSpellLevelsCleric, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsClericPC98Provider },
	{ kEoBBaseNumSpellsCleric, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NumSpellsClericPC98Provider },
	{ kEoBBaseNumSpellsWisAdj, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NumSpellsWisAdjPC98Provider },
	{ kEoBBaseNumSpellsPal, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NumSpellsPalPC98Provider },
	{ kEoBBaseNumSpellsMage, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NumSpellsMagePC98Provider },
	{ kEoBBaseCharGuiStringsHp, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharGuiStringsHpPC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsWp1, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharGuiStringsWp1PC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharGuiStringsWrPC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsSt1, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharGuiStringsSt1PC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharGuiStringsInPC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings7PC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings81PC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings9PC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings131PC98JapaneseProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1LevelGainStringsPC98JapaneseProvider },
	{ kEoBBaseExperienceTable0, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable0PC98Provider },
	{ kEoBBaseExperienceTable1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable1PC98Provider },
	{ kEoBBaseExperienceTable2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable2PC98Provider },
	{ kEoBBaseExperienceTable3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable3PC98Provider },
	{ kEoBBaseExperienceTable4, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable4PC98Provider },
	{ kEoBBaseBookNumbers, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1BookNumbersPC98JapaneseProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MageSpellsListPC98JapaneseProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1ClericSpellsListPC98JapaneseProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1SpellNamesPC98JapaneseProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings1PC98JapaneseProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings2PC98JapaneseProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings3PC98JapaneseProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings4PC98JapaneseProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings6PC98JapaneseProvider },
	{ kEoBBaseMagicStrings7, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings7PC98JapaneseProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings8PC98JapaneseProvider },
		//{ kEoBBaseMagicStrings9, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MagicStrings9PC98JapaneseProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTblIndexPC98Provider },
	{ kEoBBaseExpObjectShpStart, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExpObjectShpStartPC98Provider },
	{ kEoBBaseExpObjectTbl1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl1PC98Provider },
	{ kEoBBaseExpObjectTbl2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl2PC98Provider },
	{ kEoBBaseExpObjectTbl3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl3PC98Provider },
	{ kEoBBaseExpObjectY, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ExpObjectYPC98Provider },
	{ kEoBBaseSparkDefSteps, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkDefStepsPC98Provider },
	{ kEoBBaseSparkDefSubSteps, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkDefSubStepsPC98Provider },
	{ kEoBBaseSparkDefShift, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkDefShiftPC98Provider },
	{ kEoBBaseSparkDefAdd, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkDefAddPC98Provider },
	{ kEoBBaseSparkDefX, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkDefXPC98Provider },
	{ kEoBBaseSparkDefY, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkDefYPC98Provider },
	{ kEoBBaseSparkOfFlags1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags1PC98Provider },
	{ kEoBBaseSparkOfFlags2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags2PC98Provider },
	{ kEoBBaseSparkOfShift, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkOfShiftPC98Provider },
	{ kEoBBaseSparkOfX, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkOfXPC98Provider },
	{ kEoBBaseSparkOfY, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SparkOfYPC98Provider },
	{ kEoBBaseSpellProperties, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SpellPropertiesPC98Provider },
	{ kEoBBaseMagicFlightProps, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MagicFlightPropsPC98Provider },
	{ kEoBBaseTurnUndeadEffect, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1TurnUndeadEffectPC98Provider },
	{ kEoBBaseBurningHandsDest, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1BurningHandsDestPC98Provider },
	{ kEoBBaseConeOfColdDest1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest1PC98Provider },
	{ kEoBBaseConeOfColdDest2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest2PC98Provider },
	{ kEoBBaseConeOfColdDest3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest3PC98Provider },
	{ kEoBBaseConeOfColdDest4, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest4PC98Provider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdGfxTblPC98Provider },
	{ kRpgCommonDscDoorShapeIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorShapeIndexPC98Provider },
	{ kEoBBaseWllFlagPreset, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1WllFlagPresetPC98Provider },
	{ kEoBBaseDscShapeCoords, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscShapeCoordsPC98Provider },
	{ kRpgCommonDscDoorScaleOffs, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleOffsPC98Provider },
	{ kEoBBaseDscDoorScaleMult1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult1PC98Provider },
	{ kEoBBaseDscDoorScaleMult2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult2PC98Provider },
	{ kEoBBaseDscDoorScaleMult3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult3PC98Provider },
	{ kEoBBaseDscDoorScaleMult4, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult4PC98Provider },
	{ kEoBBaseDscDoorScaleMult5, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult5PC98Provider },
	{ kEoBBaseDscDoorScaleMult6, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult6PC98Provider },
	{ kEoBBaseDscDoorXE, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorXEPC98Provider },
	{ kEoBBaseDscDoorY1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorY1PC98Provider },
	{ kEoBBaseDscDoorY3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorY3PC98Provider },
	{ kEoBBaseDscDoorY4, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorY4PC98Provider },
	{ kEoBBaseDscDoorY5, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorY5PC98Provider },
	{ kEoBBaseDscDoorY6, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorY6PC98Provider },
	{ kEoBBaseDscDoorY7, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorY7PC98Provider },
	{ kEoBBaseDscDoorCoordsExt, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorCoordsExtPC98Provider },
	{ kRpgCommonDscDoorFrameY1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY1PC98Provider },
	{ kRpgCommonDscDoorFrameY2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY2PC98Provider },
	{ kRpgCommonDscDoorFrameIndex1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex1PC98Provider },
	{ kRpgCommonDscDoorFrameIndex2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex2PC98Provider },
	{ kEoBBaseDscItemPosIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscItemPosIndexPC98Provider },
	{ kEoBBaseDscItemShpX, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscItemShpXPC98Provider },
	{ kEoBBaseDscItemScaleIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscItemScaleIndexPC98Provider },
	{ kEoBBaseDscItemTileIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscItemTileIndexPC98Provider },
	{ kEoBBaseDscItemShapeMap, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscItemShapeMapPC98Provider },
	{ kEoBBaseDscTelptrShpCoords, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscTelptrShpCoordsPC98Provider },
	{ kEoBBasePortalSeqData, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1PortalSeqDataPC98Provider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl1PC98Provider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl2PC98Provider },
	{ kEoBBaseInvSlotX, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1InvSlotXPC98Provider },
	{ kEoBBaseInvSlotY, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1InvSlotYPC98Provider },
	{ kEoBBaseSlotValidationFlags, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SlotValidationFlagsPC98Provider },
	{ kEoBBaseProjectileWeaponTypes, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ProjectileWeaponTypesPC98Provider },
	{ kEoBBaseWandTypes, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1WandTypesPC98Provider },
	{ kEoBBaseDrawObjPosIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DrawObjPosIndexPC98Provider },
	{ kEoBBaseFlightObjFlipIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FlightObjFlipIndexPC98Provider },
	{ kEoBBaseFlightObjShpMap, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FlightObjShpMapPC98Provider },
	{ kEoBBaseFlightObjSclIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FlightObjSclIndexPC98Provider },
	{ kRpgCommonDscShapeIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscShapeIndexPC98Provider },
	{ kRpgCommonDscX, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscXPC98Provider },
	{ kRpgCommonDscTileIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscTileIndexPC98Provider },
	{ kRpgCommonDscDimData1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDimData1PC98Provider },
	{ kRpgCommonDscDimData2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDimData2PC98Provider },
	{ kRpgCommonDscBlockMap, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscBlockMapPC98Provider },
	{ kRpgCommonDscDimMap, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscDimMapPC98Provider },
	{ kRpgCommonDscBlockIndex, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1DscBlockIndexPC98Provider },
	{ kEoBBaseClassModifierFlags, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1ClassModifierFlagsPC98Provider },
	{ kEoBBaseMonsterStepTable01, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable01PC98Provider },
	{ kEoBBaseMonsterStepTable2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable2PC98Provider },
	{ kEoBBaseMonsterStepTable3, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable3PC98Provider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable1PC98Provider },
	{ kEoBBaseMonsterCloseAttPosTable21, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable21PC98Provider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable1PC98Provider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable2PC98Provider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable1PC98Provider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable2PC98Provider },
	{ kEoBBaseMonsterProximityTable, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterProximityTablePC98Provider },
	{ kEoBBaseFindBlockMonstersTable, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1FindBlockMonstersTablePC98Provider },
	{ kEoBBaseMonsterDirChangeTable, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1MonsterDirChangeTablePC98Provider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB1MonsterDistAttStringsPC98JapaneseProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefsPC98Provider },
	{ kEoBBaseNpcPresets, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1NpcPresetsPC98Provider },
	{ kEoB1Palettes16c, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1Palettes16cPC98Provider },
	{ kEoB1PalCycleData, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1PalCycleDataPC98Provider },
	{ kEoB1PalCycleStyle1, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1PalCycleStyle1PC98Provider },
	{ kEoB1PalCycleStyle2, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1PalCycleStyle2PC98Provider },
	{ kEoBBaseSoundFilesIntro, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SoundFilesIntroPC98Provider },
	{ kEoBBaseSoundFilesIngame, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SoundFilesIngamePC98Provider },
	{ kEoBBaseSoundFilesFinale, kEoB1, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB1SoundFilesFinalePC98Provider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1NpcPresetsNamesSegaCDEnglishProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ChargenStrings1SegaCDEnglishProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ChargenStrings2SegaCDEnglishProvider },
	{ kEoBBaseChargenStartLevels, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ChargenStartLevelsSegaCDProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ChargenStatStringsSegaCDEnglishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ChargenRaceSexStringsSegaCDEnglishProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ChargenClassStringsSegaCDEnglishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ChargenAlignmentStringsSegaCDEnglishProvider },
	{ kEoBBaseChargenClassMinStats, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ChargenClassMinStatsSegaCDProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMinStatsSegaCDProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ChargenRaceMaxStatsSegaCDProvider },
	{ kEoBBaseSaveThrowTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable1SegaCDProvider },
	{ kEoBBaseSaveThrowTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable2SegaCDProvider },
	{ kEoBBaseSaveThrowTable3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable3SegaCDProvider },
	{ kEoBBaseSaveThrowTable4, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SaveThrowTable4SegaCDProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SaveThrwLvlIndexSegaCDProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModDivSegaCDProvider },
	{ kEoBBaseSaveThrwModExt, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SaveThrwModExtSegaCDProvider },
	{ kEoB1DefaultPartyStats, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DefaultPartyStatsSegaCDProvider },
	{ kEoB1DefaultPartyNames, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1DefaultPartyNamesSegaCDEnglishProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MainMenuStringsSegaCDEnglishProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1BonusStringsSegaCDEnglishProvider },
	{ kEoB1CreditsStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CreditsStrings2SegaCDEnglishProvider },
	{ kEoB1CreditsTileGrid, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1CreditsTileGridSegaCDProvider },
	{ kEoB1IntroWdDsX, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsXSegaCDProvider },
	{ kEoB1IntroWdDsY, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1IntroWdDsYSegaCDProvider },
	{ kEoB1DoorShapeDefs, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DoorShapeDefsSegaCDProvider },
	{ kEoB1DoorSwitchShapeDefs, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchShapeDefsSegaCDProvider },
	{ kEoB1DoorSwitchCoords, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DoorSwitchCoordsSegaCDProvider },
	{ kEoB1MonsterProperties, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterPropertiesSegaCDProvider },
	{ kEoB1EnemyMageSpellList, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSpellListSegaCDProvider },
	{ kEoB1EnemyMageSfx, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EnemyMageSfxSegaCDProvider },
	{ kEoB1BeholderSpellList, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1BeholderSpellListSegaCDProvider },
	{ kEoB1BeholderSfx, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1BeholderSfxSegaCDProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1TurnUndeadStringSegaCDEnglishProvider },
	{ kEoB1PalettesSega, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PalettesSegaCDProvider },
	{ kEoB1PatternTable0, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternTable0SegaCDProvider },
	{ kEoB1PatternTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternTable1SegaCDProvider },
	{ kEoB1PatternTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternTable2SegaCDProvider },
	{ kEoB1PatternTable3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternTable3SegaCDProvider },
	{ kEoB1PatternTable4, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternTable4SegaCDProvider },
	{ kEoB1PatternTable5, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternTable5SegaCDProvider },
	{ kEoB1PatternAddTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternAddTable1SegaCDProvider },
	{ kEoB1PatternAddTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PatternAddTable2SegaCDProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc0StringsSegaCDEnglishProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc11StringsSegaCDEnglishProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc12StringsSegaCDEnglishProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc21StringsSegaCDEnglishProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc22StringsSegaCDEnglishProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc31StringsSegaCDEnglishProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc32StringsSegaCDEnglishProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc4StringsSegaCDEnglishProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc5StringsSegaCDEnglishProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc6StringsSegaCDEnglishProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1Npc7StringsSegaCDEnglishProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1PryDoorStringsSegaCDEnglishProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1WarningStringsSegaCDEnglishProvider },
	{ kEoB1ParchmentStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ParchmentStringsSegaCDEnglishProvider },
	{ kEoB1ItemNames, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ItemNamesSegaCDEnglishProvider },
	{ kEoB1SpeechAnimData, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SpeechAnimDataSegaCDProvider },
	{ kEoB1WdAnimSprites, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1WdAnimSpritesSegaCDProvider },
	{ kEoB1SequenceTrackMap, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SequenceTrackMapSegaCDProvider },
	{ kEoB1MapStrings1, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MapStrings1SegaCDEnglishProvider },
	{ kEoB1MapStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MapStrings2SegaCDEnglishProvider },
	{ kEoB1MapStrings3, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MapStrings3SegaCDEnglishProvider },
	{ kEoB1MapLevelData, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MapLevelDataSegaCDProvider },
	{ kEoB1Ascii2SjisTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1Ascii2SjisTable1SegaCDProvider },
	{ kEoB1Ascii2SjisTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1Ascii2SjisTable2SegaCDProvider },
	{ kEoB1CharWidthTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1CharWidthTable1SegaCDProvider },
	{ kEoB1CharWidthTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1CharWidthTable2SegaCDProvider },
	{ kEoB1CharWidthTable3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1CharWidthTable3SegaCDProvider },
	{ kEoB1CharTilesTable, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CharTilesTableSegaCDEnglishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsRingsSegaCDEnglishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsPotionsSegaCDEnglishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ItemSuffixStringsWandsSegaCDEnglishProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1RipItemStringsSegaCDEnglishProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CursedStringSegaCDEnglishProvider },
	{ kEoBBaseEnchantedString, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EnchantedStringSegaCDProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicObjectStringsSegaCDEnglishProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicObjectString5SegaCDEnglishProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1PatternSuffixSegaCDEnglishProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1PatternGrFix1SegaCDEnglishProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1PatternGrFix2SegaCDEnglishProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ValidateArmorStringSegaCDEnglishProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ValidateNoDropStringSegaCDEnglishProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1PotionStringsSegaCDEnglishProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1WandStringsSegaCDEnglishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ItemMisuseStringsSegaCDEnglishProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1TakenStringsSegaCDEnglishProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1PotionEffectStringsSegaCDEnglishProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1YesNoStringsSegaCDEnglishProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MoreStringsSegaCDEnglishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1NpcMaxStringsSegaCDEnglishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1NpcJoinStringsSegaCDEnglishProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CancelStringsSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsSaveLoadSegaCDEnglishProvider },
	//{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsOnOffSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsSpellsSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsRestSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsDropSegaCDEnglishProvider },
	//{ kEoBBaseMenuStringsExit, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsExitSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsStarveSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsScribeSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsDrop2SegaCDEnglishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsPoisonSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsMgcSegaCDEnglishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest2SegaCDEnglishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsRest4SegaCDEnglishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuStringsDefeatSegaCDEnglishProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MenuYesNoStringsSegaCDEnglishProvider },
	{ kEoBBaseSpellLevelsMage, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsMageSegaCDProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SpellLevelsClericSegaCDProvider },
	{ kEoBBaseNumSpellsCleric, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1NumSpellsClericSegaCDProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1NumSpellsWisAdjSegaCDProvider },
	{ kEoBBaseNumSpellsPal, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1NumSpellsPalSegaCDProvider },
	{ kEoBBaseNumSpellsMage, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1NumSpellsMageSegaCDProvider },
	//{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CharGuiStringsInSegaCDEnglishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings7SegaCDEnglishProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings81SegaCDEnglishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings9SegaCDEnglishProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1CharStatusStrings131SegaCDEnglishProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1LevelGainStringsSegaCDEnglishProvider },
	{ kEoBBaseExperienceTable0, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable0SegaCDProvider },
	{ kEoBBaseExperienceTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable1SegaCDProvider },
	{ kEoBBaseExperienceTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable2SegaCDProvider },
	{ kEoBBaseExperienceTable3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable3SegaCDProvider },
	{ kEoBBaseExperienceTable4, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExperienceTable4SegaCDProvider },
	//{ kEoBBaseBookNumbers, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1BookNumbersSegaCDEnglishProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MageSpellsListSegaCDEnglishProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ClericSpellsListSegaCDEnglishProvider },
	{ kEoBBaseMageSpellsList2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MageSpellsList2SegaCDEnglishProvider },
	{ kEoBBaseClericSpellsList2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1ClericSpellsList2SegaCDEnglishProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1SpellNamesSegaCDEnglishProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings1SegaCDEnglishProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings2SegaCDEnglishProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings3SegaCDEnglishProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings4SegaCDEnglishProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings6SegaCDEnglishProvider },
	//{ kEoBBaseMagicStrings7, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings7SegaCDEnglishProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings8SegaCDEnglishProvider },
	//{ kEoBBaseMagicStrings9, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MagicStrings9SegaCDEnglishProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTblIndexSegaCDProvider },
	{ kEoBBaseExpObjectShpStart, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExpObjectShpStartSegaCDProvider },
	{ kEoBBaseExpObjectTbl1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl1SegaCDProvider },
	{ kEoBBaseExpObjectTbl2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl2SegaCDProvider },
	{ kEoBBaseExpObjectTbl3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExpObjectTbl3SegaCDProvider },
	{ kEoBBaseExpObjectY, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ExpObjectYSegaCDProvider },
	{ kEoBBaseSparkDefSteps, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkDefStepsSegaCDProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkDefSubStepsSegaCDProvider },
	{ kEoBBaseSparkDefShift, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkDefShiftSegaCDProvider },
	{ kEoBBaseSparkDefAdd, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkDefAddSegaCDProvider },
	{ kEoBBaseSparkDefX, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkDefXSegaCDProvider },
	{ kEoBBaseSparkDefY, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkDefYSegaCDProvider },
	{ kEoBBaseSparkOfFlags1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags1SegaCDProvider },
	{ kEoBBaseSparkOfFlags2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkOfFlags2SegaCDProvider },
	{ kEoBBaseSparkOfShift, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkOfShiftSegaCDProvider },
	{ kEoBBaseSparkOfX, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkOfXSegaCDProvider },
	{ kEoBBaseSparkOfY, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SparkOfYSegaCDProvider },
	{ kEoBBaseSpellProperties, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SpellPropertiesSegaCDProvider },
	{ kEoBBaseMagicFlightProps, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MagicFlightPropsSegaCDProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1TurnUndeadEffectSegaCDProvider },
	{ kEoBBaseBurningHandsDest, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1BurningHandsDestSegaCDProvider },
	{ kEoBBaseConeOfColdDest1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest1SegaCDProvider },
	{ kEoBBaseConeOfColdDest2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest2SegaCDProvider },
	{ kEoBBaseConeOfColdDest3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest3SegaCDProvider },
	{ kEoBBaseConeOfColdDest4, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdDest4SegaCDProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ConeOfColdGfxTblSegaCDProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorShapeIndexSegaCDProvider },
	{ kEoBBaseWllFlagPreset, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1WllFlagPresetSegaCDProvider },
	{ kEoBBaseDscShapeCoords, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscShapeCoordsSegaCDProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleOffsSegaCDProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult1SegaCDProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult2SegaCDProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult3SegaCDProvider },
	{ kEoBBaseDscDoorScaleMult4, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult4SegaCDProvider },
	{ kEoBBaseDscDoorScaleMult5, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult5SegaCDProvider },
	{ kEoBBaseDscDoorScaleMult6, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorScaleMult6SegaCDProvider },
	{ kEoBBaseDscDoorXE, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorXESegaCDProvider },
	{ kEoBBaseDscDoorY1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorY1SegaCDProvider },
	{ kEoBBaseDscDoorY3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorY3SegaCDProvider },
	{ kEoBBaseDscDoorY4, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorY4SegaCDProvider },
	{ kEoBBaseDscDoorY5, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorY5SegaCDProvider },
	{ kEoBBaseDscDoorY6, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorY6SegaCDProvider },
	{ kEoBBaseDscDoorY7, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorY7SegaCDProvider },
	{ kEoBBaseDscDoorCoordsExt, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorCoordsExtSegaCDProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY1SegaCDProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameY2SegaCDProvider },
	{ kRpgCommonDscDoorFrameIndex1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex1SegaCDProvider },
	{ kRpgCommonDscDoorFrameIndex2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDoorFrameIndex2SegaCDProvider },
	{ kEoBBaseDscItemPosIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscItemPosIndexSegaCDProvider },
	{ kEoBBaseDscItemShpX, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscItemShpXSegaCDProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscItemScaleIndexSegaCDProvider },
	{ kEoBBaseDscItemTileIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscItemTileIndexSegaCDProvider },
	{ kEoBBaseDscItemShapeMap, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscItemShapeMapSegaCDProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscTelptrShpCoordsSegaCDProvider },
	{ kEoBBasePortalSeqData, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1PortalSeqDataSegaCDProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl1SegaCDProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscMonsterFrmOffsTbl2SegaCDProvider },
	{ kEoBBaseInvSlotX, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1InvSlotXSegaCDProvider },
	{ kEoBBaseInvSlotY, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1InvSlotYSegaCDProvider },
	{ kEoBBaseSlotValidationFlags, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1SlotValidationFlagsSegaCDProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ProjectileWeaponTypesSegaCDProvider },
	{ kEoBBaseWandTypes, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1WandTypesSegaCDProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DrawObjPosIndexSegaCDProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1FlightObjFlipIndexSegaCDProvider },
	{ kEoBBaseFlightObjShpMap, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1FlightObjShpMapSegaCDProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1FlightObjSclIndexSegaCDProvider },
	{ kRpgCommonDscShapeIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscShapeIndexSegaCDProvider },
	{ kRpgCommonDscX, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscXSegaCDProvider },
	{ kRpgCommonDscTileIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscTileIndexSegaCDProvider },
	{ kRpgCommonDscDimData1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDimData1SegaCDProvider },
	{ kRpgCommonDscDimData2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDimData2SegaCDProvider },
	{ kRpgCommonDscBlockMap, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscBlockMapSegaCDProvider },
	{ kRpgCommonDscDimMap, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscDimMapSegaCDProvider },
	{ kRpgCommonDscBlockIndex, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1DscBlockIndexSegaCDProvider },
	{ kEoBBaseClassModifierFlags, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1ClassModifierFlagsSegaCDProvider },
	{ kEoBBaseMonsterStepTable01, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable01SegaCDProvider },
	{ kEoBBaseMonsterStepTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable2SegaCDProvider },
	{ kEoBBaseMonsterStepTable3, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterStepTable3SegaCDProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable1SegaCDProvider },
	{ kEoBBaseMonsterCloseAttPosTable21, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttPosTable21SegaCDProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable1SegaCDProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttChkTable2SegaCDProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable1SegaCDProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterCloseAttDstTable2SegaCDProvider },
	{ kEoBBaseMonsterProximityTable, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterProximityTableSegaCDProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1FindBlockMonstersTableSegaCDProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterDirChangeTableSegaCDProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1MonsterDistAttStringsSegaCDEnglishProvider },
	{ kEoBBaseEncodeMonsterDefs00, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs00SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs01, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs01SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs02, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs02SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs03, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs03SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs04, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs04SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs05, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs05SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs06, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs06SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs07, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs07SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs08, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs08SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs09, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs09SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs10, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs10SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs11, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs11SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs12, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs12SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs13, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs13SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs14, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs14SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs15, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs15SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs16, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs16SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs17, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs17SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs18, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs18SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs19, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs19SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs20, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs20SegaCDProvider },
	{ kEoBBaseEncodeMonsterDefs21, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1EncodeMonsterDefs21SegaCDProvider },
	{ kEoB1MonsterAnimFrames00, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames00SegaCDProvider },
	{ kEoB1MonsterAnimFrames01, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames01SegaCDProvider },
	{ kEoB1MonsterAnimFrames02, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames02SegaCDProvider },
	{ kEoB1MonsterAnimFrames03, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames03SegaCDProvider },
	{ kEoB1MonsterAnimFrames04, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames04SegaCDProvider },
	{ kEoB1MonsterAnimFrames05, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames05SegaCDProvider },
	{ kEoB1MonsterAnimFrames06, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames06SegaCDProvider },
	{ kEoB1MonsterAnimFrames07, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames07SegaCDProvider },
	{ kEoB1MonsterAnimFrames08, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames08SegaCDProvider },
	{ kEoB1MonsterAnimFrames09, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames09SegaCDProvider },
	{ kEoB1MonsterAnimFrames10, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames10SegaCDProvider },
	{ kEoB1MonsterAnimFrames11, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames11SegaCDProvider },
	{ kEoB1MonsterAnimFrames12, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames12SegaCDProvider },
	{ kEoB1MonsterAnimFrames13, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames13SegaCDProvider },
	{ kEoB1MonsterAnimFrames14, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames14SegaCDProvider },
	{ kEoB1MonsterAnimFrames15, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames15SegaCDProvider },
	{ kEoB1MonsterAnimFrames16, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames16SegaCDProvider },
	{ kEoB1MonsterAnimFrames17, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames17SegaCDProvider },
	{ kEoB1MonsterAnimFrames18, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames18SegaCDProvider },
	{ kEoB1MonsterAnimFrames19, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames19SegaCDProvider },
	{ kEoB1MonsterAnimFrames20, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames20SegaCDProvider },
	{ kEoB1MonsterAnimFrames21, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames21SegaCDProvider },
	{ kEoB1MonsterAnimFrames22, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames22SegaCDProvider },
	{ kEoB1MonsterAnimFrames23, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames23SegaCDProvider },
	{ kEoB1MonsterAnimFrames24, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames24SegaCDProvider },
	{ kEoB1MonsterAnimFrames25, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames25SegaCDProvider },
	{ kEoB1MonsterAnimFrames26, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames26SegaCDProvider },
	{ kEoB1MonsterAnimFrames27, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames27SegaCDProvider },
	{ kEoB1MonsterAnimFrames28, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames28SegaCDProvider },
	{ kEoB1MonsterAnimFrames29, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames29SegaCDProvider },
	{ kEoB1MonsterAnimFrames30, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames30SegaCDProvider },
	{ kEoB1MonsterAnimFrames31, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames31SegaCDProvider },
	{ kEoB1MonsterAnimFrames32, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames32SegaCDProvider },
	{ kEoB1MonsterAnimFrames33, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames33SegaCDProvider },
	{ kEoB1MonsterAnimFrames34, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames34SegaCDProvider },
	{ kEoB1MonsterAnimFrames35, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames35SegaCDProvider },
	{ kEoB1MonsterAnimFrames36, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames36SegaCDProvider },
	{ kEoB1MonsterAnimFrames37, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames37SegaCDProvider },
	{ kEoB1MonsterAnimFrames38, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames38SegaCDProvider },
	{ kEoB1MonsterAnimFrames39, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames39SegaCDProvider },
	{ kEoB1MonsterAnimFrames40, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames40SegaCDProvider },
	{ kEoB1MonsterAnimFrames41, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames41SegaCDProvider },
	{ kEoB1MonsterAnimFrames42, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames42SegaCDProvider },
	{ kEoB1MonsterAnimFrames43, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames43SegaCDProvider },
	{ kEoB1MonsterAnimFrames44, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames44SegaCDProvider },
	{ kEoB1MonsterAnimFrames45, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames45SegaCDProvider },
	{ kEoB1MonsterAnimFrames46, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames46SegaCDProvider },
	{ kEoB1MonsterAnimFrames47, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames47SegaCDProvider },
	{ kEoB1MonsterAnimFrames48, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames48SegaCDProvider },
	{ kEoB1MonsterAnimFrames49, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames49SegaCDProvider },
	{ kEoB1MonsterAnimFrames50, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames50SegaCDProvider },
	{ kEoB1MonsterAnimFrames51, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames51SegaCDProvider },
	{ kEoB1MonsterAnimFrames52, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames52SegaCDProvider },
	{ kEoB1MonsterAnimFrames53, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames53SegaCDProvider },
	{ kEoB1MonsterAnimFrames54, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames54SegaCDProvider },
	{ kEoB1MonsterAnimFrames55, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames55SegaCDProvider },
	{ kEoB1MonsterAnimFrames56, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames56SegaCDProvider },
	{ kEoB1MonsterAnimFrames57, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames57SegaCDProvider },
	{ kEoB1MonsterAnimFrames58, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames58SegaCDProvider },
	{ kEoB1MonsterAnimFrames59, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames59SegaCDProvider },
	{ kEoB1MonsterAnimFrames60, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames60SegaCDProvider },
	{ kEoB1MonsterAnimFrames61, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames61SegaCDProvider },
	{ kEoB1MonsterAnimFrames62, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames62SegaCDProvider },
	{ kEoB1MonsterAnimFrames63, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames63SegaCDProvider },
	{ kEoB1MonsterAnimFrames64, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames64SegaCDProvider },
	{ kEoB1MonsterAnimFrames65, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames65SegaCDProvider },
	{ kEoB1MonsterAnimFrames66, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames66SegaCDProvider },
	{ kEoB1MonsterAnimFrames67, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames67SegaCDProvider },
	{ kEoB1MonsterAnimFrames68, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames68SegaCDProvider },
	{ kEoB1MonsterAnimFrames69, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames69SegaCDProvider },
	{ kEoB1MonsterAnimFrames70, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames70SegaCDProvider },
	{ kEoB1MonsterAnimFrames71, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames71SegaCDProvider },
	{ kEoB1MonsterAnimFrames72, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames72SegaCDProvider },
	{ kEoB1MonsterAnimFrames73, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames73SegaCDProvider },
	{ kEoB1MonsterAnimFrames74, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames74SegaCDProvider },
	{ kEoB1MonsterAnimFrames75, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames75SegaCDProvider },
	{ kEoB1MonsterAnimFrames76, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames76SegaCDProvider },
	{ kEoB1MonsterAnimFrames77, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames77SegaCDProvider },
	{ kEoB1MonsterAnimFrames78, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames78SegaCDProvider },
	{ kEoB1MonsterAnimFrames79, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames79SegaCDProvider },
	{ kEoB1MonsterAnimFrames80, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames80SegaCDProvider },
	{ kEoB1MonsterAnimFrames81, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames81SegaCDProvider },
	{ kEoB1MonsterAnimFrames82, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames82SegaCDProvider },
	{ kEoB1MonsterAnimFrames83, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames83SegaCDProvider },
	{ kEoB1MonsterAnimFrames84, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames84SegaCDProvider },
	{ kEoB1MonsterAnimFrames85, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames85SegaCDProvider },
	{ kEoB1MonsterAnimFrames86, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames86SegaCDProvider },
	{ kEoB1MonsterAnimFrames87, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames87SegaCDProvider },
	{ kEoB1MonsterAnimFrames88, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames88SegaCDProvider },
	{ kEoB1MonsterAnimFrames89, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames89SegaCDProvider },
	{ kEoB1MonsterAnimFrames90, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames90SegaCDProvider },
	{ kEoB1MonsterAnimFrames91, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames91SegaCDProvider },
	{ kEoB1MonsterAnimFrames92, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames92SegaCDProvider },
	{ kEoB1MonsterAnimFrames93, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames93SegaCDProvider },
	{ kEoB1MonsterAnimFrames94, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames94SegaCDProvider },
	{ kEoB1MonsterAnimFrames95, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames95SegaCDProvider },
	{ kEoB1MonsterAnimFrames96, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames96SegaCDProvider },
	{ kEoB1MonsterAnimFrames97, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames97SegaCDProvider },
	{ kEoB1MonsterAnimFrames98, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames98SegaCDProvider },
	{ kEoB1MonsterAnimFrames99, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames99SegaCDProvider },
	{ kEoB1MonsterAnimFrames100, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames100SegaCDProvider },
	{ kEoB1MonsterAnimFrames101, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames101SegaCDProvider },
	{ kEoB1MonsterAnimFrames102, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames102SegaCDProvider },
	{ kEoB1MonsterAnimFrames103, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames103SegaCDProvider },
	{ kEoB1MonsterAnimFrames104, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames104SegaCDProvider },
	{ kEoB1MonsterAnimFrames105, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames105SegaCDProvider },
	{ kEoB1MonsterAnimFrames106, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames106SegaCDProvider },
	{ kEoB1MonsterAnimFrames107, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames107SegaCDProvider },
	{ kEoB1MonsterAnimFrames108, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames108SegaCDProvider },
	{ kEoB1MonsterAnimFrames109, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1MonsterAnimFrames109SegaCDProvider },
	{ kEoBBaseNpcPresets, kEoB1, kPlatformSegaCD, kNoSpecial, UNK_LANG, &kEoB1NpcPresetsSegaCDProvider },
	{ kEoBBaseTextInputCharacterLines, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1TextInputCharacterLinesSegaCDEnglishProvider },
	{ kEoBBaseTextInputSelectStrings, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1TextInputSelectStringsSegaCDEnglishProvider },
	{ kEoBBaseSaveNamePatterns, kEoB1, kPlatformSegaCD, kNoSpecial, EN_ANY, &kEoB1SaveNamePatternsSegaCDEnglishProvider },
	{ kEoBBaseNpcPresetsNames, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1NpcPresetsNamesSegaCDJapaneseProvider },
	{ kEoBBaseChargenStrings1, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ChargenStrings1SegaCDJapaneseProvider },
	{ kEoBBaseChargenStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ChargenStrings2SegaCDJapaneseProvider },
	{ kEoBBaseChargenStatStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ChargenStatStringsSegaCDJapaneseProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ChargenRaceSexStringsSegaCDJapaneseProvider },
	{ kEoBBaseChargenClassStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ChargenClassStringsSegaCDJapaneseProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ChargenAlignmentStringsSegaCDJapaneseProvider },
	{ kEoB1DefaultPartyNames, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1DefaultPartyNamesSegaCDJapaneseProvider },
	{ kEoB1MainMenuStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MainMenuStringsSegaCDJapaneseProvider },
	{ kEoB1BonusStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1BonusStringsSegaCDJapaneseProvider },
	{ kEoB1CreditsStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CreditsStrings2SegaCDJapaneseProvider },
	{ kEoB1TurnUndeadString, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1TurnUndeadStringSegaCDJapaneseProvider },
	{ kEoB1Npc0Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc0StringsSegaCDJapaneseProvider },
	{ kEoB1Npc11Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc11StringsSegaCDJapaneseProvider },
	{ kEoB1Npc12Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc12StringsSegaCDJapaneseProvider },
	{ kEoB1Npc21Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc21StringsSegaCDJapaneseProvider },
	{ kEoB1Npc22Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc22StringsSegaCDJapaneseProvider },
	{ kEoB1Npc31Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc31StringsSegaCDJapaneseProvider },
	{ kEoB1Npc32Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc32StringsSegaCDJapaneseProvider },
	{ kEoB1Npc4Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc4StringsSegaCDJapaneseProvider },
	{ kEoB1Npc5Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc5StringsSegaCDJapaneseProvider },
	{ kEoB1Npc6Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc6StringsSegaCDJapaneseProvider },
	{ kEoB1Npc7Strings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1Npc7StringsSegaCDJapaneseProvider },
	{ kEoBBasePryDoorStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1PryDoorStringsSegaCDJapaneseProvider },
	{ kEoBBaseWarningStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1WarningStringsSegaCDJapaneseProvider },
	{ kEoB1ParchmentStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ParchmentStringsSegaCDJapaneseProvider },
	{ kEoB1ItemNames, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ItemNamesSegaCDJapaneseProvider },
	{ kEoB1MapStrings1, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MapStrings1SegaCDJapaneseProvider },
	{ kEoB1MapStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MapStrings2SegaCDJapaneseProvider },
	{ kEoB1MapStrings3, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MapStrings3SegaCDJapaneseProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ItemSuffixStringsRingsSegaCDJapaneseProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ItemSuffixStringsPotionsSegaCDJapaneseProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ItemSuffixStringsWandsSegaCDJapaneseProvider },
	{ kEoBBaseRipItemStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1RipItemStringsSegaCDJapaneseProvider },
	{ kEoBBaseCursedString, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CursedStringSegaCDJapaneseProvider },
	{ kEoBBaseMagicObjectStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicObjectStringsSegaCDJapaneseProvider },
	{ kEoBBaseMagicObjectString5, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicObjectString5SegaCDJapaneseProvider },
	{ kEoBBasePatternSuffix, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1PatternSuffixSegaCDJapaneseProvider },
	{ kEoBBasePatternGrFix1, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1PatternGrFix1SegaCDJapaneseProvider },
	{ kEoBBasePatternGrFix2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1PatternGrFix2SegaCDJapaneseProvider },
	{ kEoBBaseValidateArmorString, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ValidateArmorStringSegaCDJapaneseProvider },
	{ kEoBBaseValidateNoDropString, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ValidateNoDropStringSegaCDJapaneseProvider },
	{ kEoBBasePotionStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1PotionStringsSegaCDJapaneseProvider },
	{ kEoBBaseWandStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1WandStringsSegaCDJapaneseProvider },
	{ kEoBBaseItemMisuseStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ItemMisuseStringsSegaCDJapaneseProvider },
	{ kEoBBaseTakenStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1TakenStringsSegaCDJapaneseProvider },
	{ kEoBBasePotionEffectStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1PotionEffectStringsSegaCDJapaneseProvider },
	{ kEoBBaseYesNoStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1YesNoStringsSegaCDJapaneseProvider },
	{ kRpgCommonMoreStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MoreStringsSegaCDJapaneseProvider },
	{ kEoBBaseNpcMaxStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1NpcMaxStringsSegaCDJapaneseProvider },
	{ kEoBBaseNpcJoinStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1NpcJoinStringsSegaCDJapaneseProvider },
	{ kEoBBaseCancelStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CancelStringsSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsSaveLoadSegaCDJapaneseProvider },
	//{ kEoBBaseMenuStringsOnOff, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsOnOffSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsSpells, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsSpellsSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsRest, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsRestSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsDrop, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsDropSegaCDJapaneseProvider },
	//{ kEoBBaseMenuStringsExit, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsExitSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsStarve, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsStarveSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsScribe, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsScribeSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsDrop2SegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsPoison, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsPoisonSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsMgc, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsMgcSegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsRest2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsRest2SegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsRest4, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsRest4SegaCDJapaneseProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuStringsDefeatSegaCDJapaneseProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MenuYesNoStringsSegaCDJapaneseProvider },
	//{ kEoBBaseCharGuiStringsIn, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CharGuiStringsInSegaCDJapaneseProvider },
	{ kEoBBaseCharStatusStrings7, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings7SegaCDJapaneseProvider },
	{ kEoBBaseCharStatusStrings81, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings81SegaCDJapaneseProvider },
	{ kEoBBaseCharStatusStrings9, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings9SegaCDJapaneseProvider },
	{ kEoBBaseCharStatusStrings131, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CharStatusStrings131SegaCDJapaneseProvider },
	{ kEoBBaseLevelGainStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1LevelGainStringsSegaCDJapaneseProvider },
	//{ kEoBBaseBookNumbers, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1BookNumbersSegaCDJapaneseProvider },
	{ kEoBBaseMageSpellsList, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MageSpellsListSegaCDJapaneseProvider },
	{ kEoBBaseClericSpellsList, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ClericSpellsListSegaCDJapaneseProvider },
	{ kEoBBaseMageSpellsList2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MageSpellsList2SegaCDJapaneseProvider },
	{ kEoBBaseClericSpellsList2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1ClericSpellsList2SegaCDJapaneseProvider },
	{ kEoBBaseSpellNames, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1SpellNamesSegaCDJapaneseProvider },
	{ kEoBBaseMagicStrings1, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings1SegaCDJapaneseProvider },
	{ kEoBBaseMagicStrings2, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings2SegaCDJapaneseProvider },
	{ kEoBBaseMagicStrings3, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings3SegaCDJapaneseProvider },
	{ kEoBBaseMagicStrings4, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings4SegaCDJapaneseProvider },
	{ kEoBBaseMagicStrings6, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings6SegaCDJapaneseProvider },
	//{ kEoBBaseMagicStrings7, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings7SegaCDJapaneseProvider },
	{ kEoBBaseMagicStrings8, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings8SegaCDJapaneseProvider },
	//{ kEoBBaseMagicStrings9, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MagicStrings9SegaCDJapaneseProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1MonsterDistAttStringsSegaCDJapaneseProvider },
	{ kEoBBaseTextInputCharacterLines, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1TextInputCharacterLinesSegaCDJapaneseProvider },
	{ kEoBBaseTextInputSelectStrings, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1TextInputSelectStringsSegaCDJapaneseProvider },
	{ kEoBBaseSaveNamePatterns, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1SaveNamePatternsSegaCDJapaneseProvider },
	{ kEoB1CharTilesTable, kEoB1, kPlatformSegaCD, kNoSpecial, JA_JPN, &kEoB1CharTilesTableSegaCDJapaneseProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2NpcPresetsNamesDOSEnglishProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenStrings1DOSEnglishProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenStrings2DOSEnglishProvider },
	{ kEoBBaseChargenStartLevels, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenStartLevelsDOSProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenStatStringsDOSEnglishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenRaceSexStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenClassStringsDOSEnglishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenAlignmentStringsDOSEnglishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ChargenEnterGameStringsDOSEnglishProvider },
	{ kEoBBaseChargenClassMinStats, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenClassMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMaxStatsDOSProvider },
	{ kEoBBaseSaveThrowTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable1DOSProvider },
	{ kEoBBaseSaveThrowTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable2DOSProvider },
	{ kEoBBaseSaveThrowTable3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable3DOSProvider },
	{ kEoBBaseSaveThrowTable4, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable4DOSProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrwLvlIndexDOSProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModDivDOSProvider },
	{ kEoBBaseSaveThrwModExt, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModExtDOSProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PryDoorStringsDOSEnglishProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2WarningStringsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsRingsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsPotionsDOSEnglishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsWandsDOSEnglishProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2RipItemStringsDOSEnglishProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CursedStringDOSEnglishProvider },
	{ kEoBBaseEnchantedString, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2EnchantedStringDOSProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicObjectStringsDOSEnglishProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicObjectString5DOSEnglishProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PatternSuffixDOSEnglishProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PatternGrFix1DOSEnglishProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PatternGrFix2DOSEnglishProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ValidateArmorStringDOSEnglishProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ValidateCursedStringDOSEnglishProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ValidateNoDropStringDOSEnglishProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PotionStringsDOSEnglishProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2WandStringsDOSEnglishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ItemMisuseStringsDOSEnglishProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TakenStringsDOSEnglishProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2PotionEffectStringsDOSEnglishProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2YesNoStringsDOSEnglishProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MoreStringsDOSEnglishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2NpcMaxStringsDOSEnglishProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2OkStringsDOSEnglishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2NpcJoinStringsDOSEnglishProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CancelStringsDOSEnglishProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2AbortStringsDOSEnglishProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsMainDOSEnglishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsSaveLoadDOSEnglishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsOnOffDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsSpellsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRestDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsDropDOSEnglishProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsExitDOSEnglishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsStarveDOSEnglishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsScribeDOSEnglishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsDrop2DOSEnglishProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsHeadDOSEnglishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsPoisonDOSEnglishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsMgcDOSEnglishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsPrefsDOSEnglishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest2DOSEnglishProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest3DOSEnglishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest4DOSEnglishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsDefeatDOSEnglishProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsTransferDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuStringsSpecDOSEnglishProvider },
	{ kEoBBaseMenuStringsSpellNo, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MenuStringsSpellNoDOSProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MenuYesNoStringsDOSEnglishProvider },
	{ kEoBBaseSpellLevelsMage, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsMageDOSProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsClericDOSProvider },
	{ kEoBBaseNumSpellsCleric, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsClericDOSProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsWisAdjDOSProvider },
	{ kEoBBaseNumSpellsPal, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsPalDOSProvider },
	{ kEoBBaseNumSpellsMage, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NumSpellsMageDOSProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsHpDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsWp2DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsWrDOSEnglishProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsSt2DOSEnglishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsInDOSEnglishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings7DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings82DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings9DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings12DOSEnglishProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings132DOSEnglishProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2LevelGainStringsDOSEnglishProvider },
	{ kEoBBaseExperienceTable0, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable0DOSProvider },
	{ kEoBBaseExperienceTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable1DOSProvider },
	{ kEoBBaseExperienceTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable2DOSProvider },
	{ kEoBBaseExperienceTable3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable3DOSProvider },
	{ kEoBBaseExperienceTable4, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable4DOSProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2BookNumbersDOSEnglishProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MageSpellsListDOSEnglishProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ClericSpellsListDOSEnglishProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2SpellNamesDOSEnglishProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings1DOSEnglishProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings2DOSEnglishProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings3DOSEnglishProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings4DOSEnglishProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings6DOSEnglishProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings7DOSEnglishProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MagicStrings8DOSEnglishProvider },
	{ kEoBBaseExpObjectTlMode, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTlModeDOSProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTblIndexDOSProvider },
	{ kEoBBaseExpObjectShpStart, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectShpStartDOSProvider },
	{ kEoBBaseExpObjectTbl1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl1DOSProvider },
	{ kEoBBaseExpObjectTbl2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl2DOSProvider },
	{ kEoBBaseExpObjectTbl3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl3DOSProvider },
	{ kEoBBaseExpObjectY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ExpObjectYDOSProvider },
	{ kEoBBaseSparkDefSteps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefStepsDOSProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefSubStepsDOSProvider },
	{ kEoBBaseSparkDefShift, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefShiftDOSProvider },
	{ kEoBBaseSparkDefAdd, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefAddDOSProvider },
	{ kEoBBaseSparkDefX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefXDOSProvider },
	{ kEoBBaseSparkDefY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkDefYDOSProvider },
	{ kEoBBaseSparkOfFlags1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags1DOSProvider },
	{ kEoBBaseSparkOfFlags2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags2DOSProvider },
	{ kEoBBaseSparkOfShift, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfShiftDOSProvider },
	{ kEoBBaseSparkOfX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfXDOSProvider },
	{ kEoBBaseSparkOfY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SparkOfYDOSProvider },
	{ kEoBBaseSpellProperties, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SpellPropertiesDOSProvider },
	{ kEoBBaseMagicFlightProps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MagicFlightPropsDOSProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TurnUndeadEffectDOSProvider },
	{ kEoBBaseBurningHandsDest, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2BurningHandsDestDOSProvider },
	{ kEoBBaseConeOfColdDest1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest1DOSProvider },
	{ kEoBBaseConeOfColdDest2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest2DOSProvider },
	{ kEoBBaseConeOfColdDest3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest3DOSProvider },
	{ kEoBBaseConeOfColdDest4, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest4DOSProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdGfxTblDOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorShapeIndexDOSProvider },
	{ kEoBBaseWllFlagPreset, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WllFlagPresetDOSProvider },
	{ kEoBBaseDscShapeCoords, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscShapeCoordsDOSProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleOffsDOSProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult1DOSProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult2DOSProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult3DOSProvider },
	{ kEoBBaseDscDoorType5Offs, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorType5OffsDOSProvider },
	{ kEoBBaseDscDoorY1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorY1DOSProvider },
	{ kRpgCommonDscDoorY2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorY2DOSProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY2DOSProvider },
	{ kEoBBaseDscItemPosIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemPosIndexDOSProvider },
	{ kEoBBaseDscItemShpX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemShpXDOSProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemScaleIndexDOSProvider },
	{ kEoBBaseDscItemTileIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemTileIndexDOSProvider },
	{ kEoBBaseDscItemShapeMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscItemShapeMapDOSProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscTelptrShpCoordsDOSProvider },
	{ kEoBBasePortalSeqData, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2PortalSeqDataDOSProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ManDefDOSEnglishProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ManWordDOSEnglishProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2ManPromptDOSEnglishProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl1DOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl2DOSProvider },
	{ kEoBBaseInvSlotX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2InvSlotXDOSProvider },
	{ kEoBBaseInvSlotY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2InvSlotYDOSProvider },
	{ kEoBBaseSlotValidationFlags, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SlotValidationFlagsDOSProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ProjectileWeaponTypesDOSProvider },
	{ kEoBBaseWandTypes, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WandTypesDOSProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DrawObjPosIndexDOSProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FlightObjFlipIndexDOSProvider },
	{ kEoBBaseFlightObjShpMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FlightObjShpMapDOSProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FlightObjSclIndexDOSProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MainMenuStringsDOSEnglishProvider },
	{ kEoB2TransferPortraitFrames, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferPortraitFramesDOSProvider },
	{ kEoB2TransferConvertTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferConvertTableDOSProvider },
	{ kEoB2TransferItemTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferItemTableDOSProvider },
	{ kEoB2TransferExpTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2TransferExpTableDOSProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TransferStrings1DOSEnglishProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TransferStrings2DOSEnglishProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2TransferLabelsDOSEnglishProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2IntroStringsDOSEnglishProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2IntroCPSFilesDOSEnglishProvider },
	{ kEoB2IntroAnimData00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData00DOSProvider },
	{ kEoB2IntroAnimData01, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData01DOSProvider },
	{ kEoB2IntroAnimData02, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData02DOSProvider },
	{ kEoB2IntroAnimData03, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData03DOSProvider },
	{ kEoB2IntroAnimData04, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData04DOSProvider },
	{ kEoB2IntroAnimData05, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData05DOSProvider },
	{ kEoB2IntroAnimData06, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData06DOSProvider },
	{ kEoB2IntroAnimData07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData07DOSProvider },
	{ kEoB2IntroAnimData08, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData08DOSProvider },
	{ kEoB2IntroAnimData09, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData09DOSProvider },
	{ kEoB2IntroAnimData10, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData10DOSProvider },
	{ kEoB2IntroAnimData11, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData11DOSProvider },
	{ kEoB2IntroAnimData12, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData12DOSProvider },
	{ kEoB2IntroAnimData13, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData13DOSProvider },
	{ kEoB2IntroAnimData14, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData14DOSProvider },
	{ kEoB2IntroAnimData15, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData15DOSProvider },
	{ kEoB2IntroAnimData16, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData16DOSProvider },
	{ kEoB2IntroAnimData17, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData17DOSProvider },
	{ kEoB2IntroAnimData18, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData18DOSProvider },
	{ kEoB2IntroAnimData19, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData19DOSProvider },
	{ kEoB2IntroAnimData20, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData20DOSProvider },
	{ kEoB2IntroAnimData21, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData21DOSProvider },
	{ kEoB2IntroAnimData22, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData22DOSProvider },
	{ kEoB2IntroAnimData23, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData23DOSProvider },
	{ kEoB2IntroAnimData24, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData24DOSProvider },
	{ kEoB2IntroAnimData25, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData25DOSProvider },
	{ kEoB2IntroAnimData26, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData26DOSProvider },
	{ kEoB2IntroAnimData27, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData27DOSProvider },
	{ kEoB2IntroAnimData28, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData28DOSProvider },
	{ kEoB2IntroAnimData29, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData29DOSProvider },
	{ kEoB2IntroAnimData30, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData30DOSProvider },
	{ kEoB2IntroAnimData31, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData31DOSProvider },
	{ kEoB2IntroAnimData32, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData32DOSProvider },
	{ kEoB2IntroAnimData33, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData33DOSProvider },
	{ kEoB2IntroAnimData34, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData34DOSProvider },
	{ kEoB2IntroAnimData35, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData35DOSProvider },
	{ kEoB2IntroAnimData36, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData36DOSProvider },
	{ kEoB2IntroAnimData37, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData37DOSProvider },
	{ kEoB2IntroAnimData38, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData38DOSProvider },
	{ kEoB2IntroAnimData39, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData39DOSProvider },
	{ kEoB2IntroAnimData40, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData40DOSProvider },
	{ kEoB2IntroAnimData41, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData41DOSProvider },
	{ kEoB2IntroAnimData42, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData42DOSProvider },
	{ kEoB2IntroAnimData43, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData43DOSProvider },
	{ kEoB2IntroShapes00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes00DOSProvider },
	{ kEoB2IntroShapes01, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes01DOSProvider },
	{ kEoB2IntroShapes04, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes04DOSProvider },
	{ kEoB2IntroShapes07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2IntroShapes07DOSProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2FinaleStringsDOSEnglishProvider },
	{ kEoB2CreditsData, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2CreditsDataDOSEnglishProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2FinaleCPSFilesDOSEnglishProvider },
	{ kEoB2FinaleAnimData00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData00DOSProvider },
	{ kEoB2FinaleAnimData01, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData01DOSProvider },
	{ kEoB2FinaleAnimData02, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData02DOSProvider },
	{ kEoB2FinaleAnimData03, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData03DOSProvider },
	{ kEoB2FinaleAnimData04, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData04DOSProvider },
	{ kEoB2FinaleAnimData05, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData05DOSProvider },
	{ kEoB2FinaleAnimData06, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData06DOSProvider },
	{ kEoB2FinaleAnimData07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData07DOSProvider },
	{ kEoB2FinaleAnimData08, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData08DOSProvider },
	{ kEoB2FinaleAnimData09, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData09DOSProvider },
	{ kEoB2FinaleAnimData10, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData10DOSProvider },
	{ kEoB2FinaleAnimData11, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData11DOSProvider },
	{ kEoB2FinaleAnimData12, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData12DOSProvider },
	{ kEoB2FinaleAnimData13, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData13DOSProvider },
	{ kEoB2FinaleAnimData14, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData14DOSProvider },
	{ kEoB2FinaleAnimData15, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData15DOSProvider },
	{ kEoB2FinaleAnimData16, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData16DOSProvider },
	{ kEoB2FinaleAnimData17, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData17DOSProvider },
	{ kEoB2FinaleAnimData18, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData18DOSProvider },
	{ kEoB2FinaleAnimData19, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData19DOSProvider },
	{ kEoB2FinaleAnimData20, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData20DOSProvider },
	{ kEoB2FinaleShapes00, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes00DOSProvider },
	{ kEoB2FinaleShapes03, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes03DOSProvider },
	{ kEoB2FinaleShapes07, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes07DOSProvider },
	{ kEoB2FinaleShapes09, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes09DOSProvider },
	{ kEoB2FinaleShapes10, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes10DOSProvider },
	{ kEoB2NpcShapeData, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NpcShapeDataDOSProvider },
	{ kEoBBaseClassModifierFlags, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2ClassModifierFlagsDOSProvider },
	{ kEoBBaseMonsterStepTable02, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable02DOSProvider },
	{ kEoBBaseMonsterStepTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable1DOSProvider },
	{ kEoBBaseMonsterStepTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable2DOSProvider },
	{ kEoBBaseMonsterStepTable3, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable3DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable22, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable22DOSProvider },
	{ kEoBBaseMonsterCloseAttUnkTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttUnkTableDOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable2DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable2DOSProvider },
	{ kEoBBaseMonsterProximityTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterProximityTableDOSProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2FindBlockMonstersTableDOSProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2MonsterDirChangeTableDOSProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MonsterDistAttStringsDOSEnglishProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2EncodeMonsterDefsDOSProvider },
	{ kEoBBaseNpcPresets, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2NpcPresetsDOSProvider },
	{ kEoBBaseSoundFilesIntro, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SoundFilesIntroDOSProvider },
	{ kEoBBaseSoundFilesFinale, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2SoundFilesFinaleDOSProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2Npc1StringsDOSEnglishProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2Npc2StringsDOSEnglishProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2MonsterDustStringsDOSEnglishProvider },
	{ kEoB2DreamSteps, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DreamStepsDOSProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2KheldranStringsDOSEnglishProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformDOS, kNoSpecial, EN_ANY, &kEoB2HornStringsDOSEnglishProvider },
	{ kEoB2HornSounds, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2HornSoundsDOSProvider },
	{ kEoB2WallOfForceDsX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsXDOSProvider },
	{ kEoB2WallOfForceDsY, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsYDOSProvider },
	{ kEoB2WallOfForceNumW, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumWDOSProvider },
	{ kEoB2WallOfForceNumH, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumHDOSProvider },
	{ kEoB2WallOfForceShpId, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShpIdDOSProvider },
	{ kRpgCommonDscShapeIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscShapeIndexDOSProvider },
	{ kRpgCommonDscX, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscXDOSProvider },
	{ kRpgCommonDscTileIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscTileIndexDOSProvider },
	{ kRpgCommonDscDimData1, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscDimMapDOSProvider },
	{ kRpgCommonDscBlockIndex, kEoB2, kPlatformDOS, kNoSpecial, UNK_LANG, &kEoB2DscBlockIndexDOSProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2NpcPresetsNamesDOSChineseProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ChargenStrings1DOSChineseProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ChargenStrings2DOSChineseProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ChargenStatStringsDOSChineseProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ChargenRaceSexStringsDOSChineseProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ChargenClassStringsDOSChineseProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ChargenAlignmentStringsDOSChineseProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ChargenEnterGameStringsDOSChineseProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2PryDoorStringsDOSChineseProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2WarningStringsDOSChineseProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ItemSuffixStringsRingsDOSChineseProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ItemSuffixStringsPotionsDOSChineseProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ItemSuffixStringsWandsDOSChineseProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2RipItemStringsDOSChineseProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CursedStringDOSChineseProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicObjectStringsDOSChineseProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicObjectString5DOSChineseProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2PatternSuffixDOSChineseProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2PatternGrFix1DOSChineseProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2PatternGrFix2DOSChineseProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ValidateArmorStringDOSChineseProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ValidateCursedStringDOSChineseProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ValidateNoDropStringDOSChineseProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2PotionStringsDOSChineseProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2WandStringsDOSChineseProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ItemMisuseStringsDOSChineseProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2TakenStringsDOSChineseProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2PotionEffectStringsDOSChineseProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2YesNoStringsDOSChineseProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MoreStringsDOSChineseProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2NpcMaxStringsDOSChineseProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2OkStringsDOSChineseProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2NpcJoinStringsDOSChineseProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CancelStringsDOSChineseProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2AbortStringsDOSChineseProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsMainDOSChineseProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsSaveLoadDOSChineseProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsOnOffDOSChineseProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsSpellsDOSChineseProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsRestDOSChineseProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsDropDOSChineseProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsExitDOSChineseProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsStarveDOSChineseProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsScribeDOSChineseProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsDrop2DOSChineseProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsHeadDOSChineseProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsPoisonDOSChineseProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsMgcDOSChineseProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsPrefsDOSChineseProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsRest2DOSChineseProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsRest3DOSChineseProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsRest4DOSChineseProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsDefeatDOSChineseProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsTransferDOSChineseProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuStringsSpecDOSChineseProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MenuYesNoStringsDOSChineseProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharGuiStringsHpDOSChineseProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharGuiStringsWp2DOSChineseProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharGuiStringsWrDOSChineseProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharGuiStringsSt2DOSChineseProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharGuiStringsInDOSChineseProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharStatusStrings7DOSChineseProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharStatusStrings82DOSChineseProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharStatusStrings9DOSChineseProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharStatusStrings12DOSChineseProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CharStatusStrings132DOSChineseProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2LevelGainStringsDOSChineseProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2BookNumbersDOSChineseProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MageSpellsListDOSChineseProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ClericSpellsListDOSChineseProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2SpellNamesDOSChineseProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicStrings1DOSChineseProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicStrings2DOSChineseProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicStrings3DOSChineseProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicStrings4DOSChineseProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicStrings6DOSChineseProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicStrings7DOSChineseProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MagicStrings8DOSChineseProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ManDefDOSChineseProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ManWordDOSChineseProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2ManPromptDOSChineseProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MainMenuStringsDOSChineseProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2TransferStrings1DOSChineseProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2TransferStrings2DOSChineseProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2TransferLabelsDOSChineseProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2IntroStringsDOSChineseProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2IntroCPSFilesDOSChineseProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2FinaleStringsDOSChineseProvider },
	{ kEoB2CreditsData, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2CreditsDataDOSEnglishProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2FinaleCPSFilesDOSChineseProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MonsterDistAttStringsDOSChineseProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2Npc1StringsDOSChineseProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2Npc2StringsDOSChineseProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2MonsterDustStringsDOSChineseProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2KheldranStringsDOSChineseProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2HornStringsDOSChineseProvider },
	{ kEoB2IntroAnimData40, kEoB2, kPlatformDOS, kTalkieVersion, ZH_TWN, &kEoB2IntroAnimData40DOSChineseProvider },
	{ kEoBBaseChargenStartLevels, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ChargenStartLevelsDOSProvider },
	{ kEoBBaseChargenClassMinStats, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ChargenClassMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ChargenRaceMinStatsDOSProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ChargenRaceMaxStatsDOSProvider },
	{ kEoBBaseSaveThrowTable1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SaveThrowTable1DOSProvider },
	{ kEoBBaseSaveThrowTable2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SaveThrowTable2DOSProvider },
	{ kEoBBaseSaveThrowTable3, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SaveThrowTable3DOSProvider },
	{ kEoBBaseSaveThrowTable4, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SaveThrowTable4DOSProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SaveThrwLvlIndexDOSProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SaveThrwModDivDOSProvider },
	{ kEoBBaseSaveThrwModExt, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SaveThrwModExtDOSProvider },
	{ kEoBBaseEnchantedString, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2EnchantedStringDOSChineseProvider },
	{ kEoBBaseMenuStringsSpellNo, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MenuStringsSpellNoDOSProvider },
	{ kEoBBaseSpellLevelsMage, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SpellLevelsMageDOSProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SpellLevelsClericDOSProvider },
	{ kEoBBaseNumSpellsCleric, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2NumSpellsClericDOSProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2NumSpellsWisAdjDOSProvider },
	{ kEoBBaseNumSpellsPal, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2NumSpellsPalDOSProvider },
	{ kEoBBaseNumSpellsMage, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2NumSpellsMageDOSProvider },
	{ kEoBBaseExperienceTable0, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExperienceTable0DOSProvider },
	{ kEoBBaseExperienceTable1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExperienceTable1DOSProvider },
	{ kEoBBaseExperienceTable2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExperienceTable2DOSProvider },
	{ kEoBBaseExperienceTable3, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExperienceTable3DOSProvider },
	{ kEoBBaseExperienceTable4, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExperienceTable4DOSProvider },
	{ kEoBBaseExpObjectTlMode, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExpObjectTlModeDOSProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExpObjectTblIndexDOSProvider },
	{ kEoBBaseExpObjectShpStart, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExpObjectShpStartDOSProvider },
	{ kEoBBaseExpObjectTbl1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExpObjectTbl1DOSProvider },
	{ kEoBBaseExpObjectTbl2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExpObjectTbl2DOSProvider },
	{ kEoBBaseExpObjectTbl3, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExpObjectTbl3DOSProvider },
	{ kEoBBaseExpObjectY, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ExpObjectYDOSProvider },
	{ kEoBBaseSparkDefSteps, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkDefStepsDOSProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkDefSubStepsDOSProvider },
	{ kEoBBaseSparkDefShift, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkDefShiftDOSProvider },
	{ kEoBBaseSparkDefAdd, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkDefAddDOSProvider },
	{ kEoBBaseSparkDefX, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkDefXDOSProvider },
	{ kEoBBaseSparkDefY, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkDefYDOSProvider },
	{ kEoBBaseSparkOfFlags1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkOfFlags1DOSProvider },
	{ kEoBBaseSparkOfFlags2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkOfFlags2DOSProvider },
	{ kEoBBaseSparkOfShift, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkOfShiftDOSProvider },
	{ kEoBBaseSparkOfX, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkOfXDOSProvider },
	{ kEoBBaseSparkOfY, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SparkOfYDOSProvider },
	{ kEoBBaseSpellProperties, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SpellPropertiesDOSProvider },
	{ kEoBBaseMagicFlightProps, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MagicFlightPropsDOSProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2TurnUndeadEffectDOSProvider },
	{ kEoBBaseBurningHandsDest, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2BurningHandsDestDOSProvider },
	{ kEoBBaseConeOfColdDest1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ConeOfColdDest1DOSProvider },
	{ kEoBBaseConeOfColdDest2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ConeOfColdDest2DOSProvider },
	{ kEoBBaseConeOfColdDest3, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ConeOfColdDest3DOSProvider },
	{ kEoBBaseConeOfColdDest4, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ConeOfColdDest4DOSProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ConeOfColdGfxTblDOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorShapeIndexDOSProvider },
	{ kEoBBaseWllFlagPreset, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2WllFlagPresetDOSProvider },
	{ kEoBBaseDscShapeCoords, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscShapeCoordsDOSProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorScaleOffsDOSProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorScaleMult1DOSProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorScaleMult2DOSProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorScaleMult3DOSProvider },
	{ kEoBBaseDscDoorType5Offs, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorType5OffsDOSProvider },
	{ kEoBBaseDscDoorY1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorY1DOSProvider },
	{ kRpgCommonDscDoorY2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorY2DOSProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDoorFrameY2DOSProvider },
	{ kEoBBaseDscItemPosIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscItemPosIndexDOSProvider },
	{ kEoBBaseDscItemShpX, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscItemShpXDOSProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscItemScaleIndexDOSProvider },
	{ kEoBBaseDscItemTileIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscItemTileIndexDOSProvider },
	{ kEoBBaseDscItemShapeMap, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscItemShapeMapDOSProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscTelptrShpCoordsDOSProvider },
	{ kEoBBasePortalSeqData, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2PortalSeqDataDOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl1DOSProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl2DOSProvider },
	{ kEoBBaseInvSlotX, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2InvSlotXDOSProvider },
	{ kEoBBaseInvSlotY, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2InvSlotYDOSProvider },
	{ kEoBBaseSlotValidationFlags, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SlotValidationFlagsDOSProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ProjectileWeaponTypesDOSProvider },
	{ kEoBBaseWandTypes, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2WandTypesDOSProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DrawObjPosIndexDOSProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FlightObjFlipIndexDOSProvider },
	{ kEoBBaseFlightObjShpMap, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FlightObjShpMapDOSProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FlightObjSclIndexDOSProvider },
	{ kEoB2TransferPortraitFrames, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2TransferPortraitFramesDOSChineseProvider },
	{ kEoB2TransferConvertTable, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2TransferConvertTableDOSProvider },
	{ kEoB2TransferItemTable, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2TransferItemTableDOSProvider },
	{ kEoB2TransferExpTable, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2TransferExpTableDOSProvider },
	{ kEoB2IntroAnimData00, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData00DOSProvider },
	{ kEoB2IntroAnimData01, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData01DOSProvider },
	{ kEoB2IntroAnimData02, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData02DOSProvider },
	{ kEoB2IntroAnimData03, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData03DOSProvider },
	{ kEoB2IntroAnimData04, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData04DOSProvider },
	{ kEoB2IntroAnimData05, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData05DOSProvider },
	{ kEoB2IntroAnimData06, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData06DOSProvider },
	{ kEoB2IntroAnimData07, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData07DOSProvider },
	{ kEoB2IntroAnimData08, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData08DOSProvider },
	{ kEoB2IntroAnimData09, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData09DOSProvider },
	{ kEoB2IntroAnimData10, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData10DOSProvider },
	{ kEoB2IntroAnimData11, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData11DOSProvider },
	{ kEoB2IntroAnimData12, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData12DOSProvider },
	{ kEoB2IntroAnimData13, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData13DOSProvider },
	{ kEoB2IntroAnimData14, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData14DOSProvider },
	{ kEoB2IntroAnimData15, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData15DOSProvider },
	{ kEoB2IntroAnimData16, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData16DOSProvider },
	{ kEoB2IntroAnimData17, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData17DOSProvider },
	{ kEoB2IntroAnimData18, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData18DOSProvider },
	{ kEoB2IntroAnimData19, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData19DOSProvider },
	{ kEoB2IntroAnimData20, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData20DOSProvider },
	{ kEoB2IntroAnimData21, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData21DOSProvider },
	{ kEoB2IntroAnimData22, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData22DOSProvider },
	{ kEoB2IntroAnimData23, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData23DOSProvider },
	{ kEoB2IntroAnimData24, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData24DOSProvider },
	{ kEoB2IntroAnimData25, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData25DOSProvider },
	{ kEoB2IntroAnimData26, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData26DOSProvider },
	{ kEoB2IntroAnimData27, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData27DOSProvider },
	{ kEoB2IntroAnimData28, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData28DOSProvider },
	{ kEoB2IntroAnimData29, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData29DOSProvider },
	{ kEoB2IntroAnimData30, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData30DOSProvider },
	{ kEoB2IntroAnimData31, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData31DOSProvider },
	{ kEoB2IntroAnimData32, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData32DOSProvider },
	{ kEoB2IntroAnimData33, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData33DOSProvider },
	{ kEoB2IntroAnimData34, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData34DOSProvider },
	{ kEoB2IntroAnimData35, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData35DOSProvider },
	{ kEoB2IntroAnimData36, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData36DOSProvider },
	{ kEoB2IntroAnimData37, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData37DOSProvider },
	{ kEoB2IntroAnimData38, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData38DOSProvider },
	{ kEoB2IntroAnimData39, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData39DOSProvider },
	{ kEoB2IntroAnimData41, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData41DOSProvider },
	{ kEoB2IntroAnimData42, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData42DOSProvider },
	{ kEoB2IntroAnimData43, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroAnimData43DOSProvider },
	{ kEoB2IntroShapes00, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroShapes00DOSProvider },
	{ kEoB2IntroShapes01, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroShapes01DOSProvider },
	{ kEoB2IntroShapes04, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroShapes04DOSProvider },
	{ kEoB2IntroShapes07, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2IntroShapes07DOSProvider },
	{ kEoB2FinaleAnimData00, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData00DOSProvider },
	{ kEoB2FinaleAnimData01, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData01DOSProvider },
	{ kEoB2FinaleAnimData02, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData02DOSProvider },
	{ kEoB2FinaleAnimData03, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData03DOSProvider },
	{ kEoB2FinaleAnimData04, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData04DOSProvider },
	{ kEoB2FinaleAnimData05, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData05DOSProvider },
	{ kEoB2FinaleAnimData06, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData06DOSProvider },
	{ kEoB2FinaleAnimData07, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData07DOSProvider },
	{ kEoB2FinaleAnimData08, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData08DOSProvider },
	{ kEoB2FinaleAnimData09, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData09DOSProvider },
	{ kEoB2FinaleAnimData10, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData10DOSProvider },
	{ kEoB2FinaleAnimData11, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData11DOSProvider },
	{ kEoB2FinaleAnimData12, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData12DOSProvider },
	{ kEoB2FinaleAnimData13, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData13DOSProvider },
	{ kEoB2FinaleAnimData14, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData14DOSProvider },
	{ kEoB2FinaleAnimData15, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData15DOSProvider },
	{ kEoB2FinaleAnimData16, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData16DOSProvider },
	{ kEoB2FinaleAnimData17, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData17DOSProvider },
	{ kEoB2FinaleAnimData18, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData18DOSProvider },
	{ kEoB2FinaleAnimData19, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData19DOSProvider },
	{ kEoB2FinaleAnimData20, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleAnimData20DOSProvider },
	{ kEoB2FinaleShapes00, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleShapes00DOSProvider },
	{ kEoB2FinaleShapes03, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleShapes03DOSProvider },
	{ kEoB2FinaleShapes07, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleShapes07DOSProvider },
	{ kEoB2FinaleShapes09, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleShapes09DOSProvider },
	{ kEoB2FinaleShapes10, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FinaleShapes10DOSProvider },
	{ kEoB2NpcShapeData, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2NpcShapeDataDOSProvider },
	{ kEoBBaseClassModifierFlags, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2ClassModifierFlagsDOSProvider },
	{ kEoBBaseMonsterStepTable02, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterStepTable02DOSProvider },
	{ kEoBBaseMonsterStepTable1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterStepTable1DOSProvider },
	{ kEoBBaseMonsterStepTable2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterStepTable2DOSProvider },
	{ kEoBBaseMonsterStepTable3, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterStepTable3DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterCloseAttPosTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttPosTable22, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterCloseAttPosTable22DOSProvider },
	{ kEoBBaseMonsterCloseAttUnkTable, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterCloseAttUnkTableDOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterCloseAttChkTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterCloseAttChkTable2DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterCloseAttDstTable1DOSProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterCloseAttDstTable2DOSProvider },
	{ kEoBBaseMonsterProximityTable, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterProximityTableDOSProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2FindBlockMonstersTableDOSProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2MonsterDirChangeTableDOSProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2EncodeMonsterDefsDOSProvider },
	{ kEoBBaseNpcPresets, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2NpcPresetsDOSProvider },
	{ kEoBBaseSoundFilesIntro, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SoundFilesIntroDOSProvider },
	{ kEoBBaseSoundFilesFinale, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2SoundFilesFinaleDOSProvider },
	{ kEoB2DreamSteps, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DreamStepsDOSProvider },
	{ kEoB2HornSounds, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2HornSoundsDOSProvider },
	{ kEoB2WallOfForceDsX, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2WallOfForceDsXDOSProvider },
	{ kEoB2WallOfForceDsY, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2WallOfForceDsYDOSProvider },
	{ kEoB2WallOfForceNumW, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2WallOfForceNumWDOSProvider },
	{ kEoB2WallOfForceNumH, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2WallOfForceNumHDOSProvider },
	{ kEoB2WallOfForceShpId, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2WallOfForceShpIdDOSProvider },
	{ kRpgCommonDscShapeIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscShapeIndexDOSProvider },
	{ kRpgCommonDscX, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscXDOSProvider },
	{ kRpgCommonDscTileIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscTileIndexDOSProvider },
	{ kRpgCommonDscDimData1, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscDimMapDOSProvider },
	{ kRpgCommonDscBlockIndex, kEoB2, kPlatformDOS, kTalkieVersion, UNK_LANG, &kEoB2DscBlockIndexDOSProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2NpcPresetsNamesDOSGermanProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenStrings1DOSGermanProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenStrings2DOSGermanProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenStatStringsDOSGermanProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenRaceSexStringsDOSGermanProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenClassStringsDOSGermanProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenAlignmentStringsDOSGermanProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ChargenEnterGameStringsDOSGermanProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PryDoorStringsDOSGermanProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2WarningStringsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsRingsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsPotionsDOSGermanProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsWandsDOSGermanProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2RipItemStringsDOSGermanProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CursedStringDOSGermanProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicObjectStringsDOSGermanProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicObjectString5DOSGermanProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PatternSuffixDOSGermanProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PatternGrFix1DOSGermanProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PatternGrFix2DOSGermanProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ValidateArmorStringDOSGermanProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ValidateCursedStringDOSGermanProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ValidateNoDropStringDOSGermanProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PotionStringsDOSGermanProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2WandStringsDOSGermanProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ItemMisuseStringsDOSGermanProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TakenStringsDOSGermanProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2PotionEffectStringsDOSGermanProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2YesNoStringsDOSGermanProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MoreStringsDOSGermanProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2NpcMaxStringsDOSGermanProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2OkStringsDOSGermanProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2NpcJoinStringsDOSGermanProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CancelStringsDOSGermanProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2AbortStringsDOSGermanProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsMainDOSGermanProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsSaveLoadDOSGermanProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsOnOffDOSGermanProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsSpellsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRestDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsDropDOSGermanProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsExitDOSGermanProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsStarveDOSGermanProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsScribeDOSGermanProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsDrop2DOSGermanProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsHeadDOSGermanProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsPoisonDOSGermanProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsMgcDOSGermanProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsPrefsDOSGermanProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest2DOSGermanProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest3DOSGermanProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest4DOSGermanProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsDefeatDOSGermanProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsTransferDOSGermanProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuStringsSpecDOSGermanProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MenuYesNoStringsDOSGermanProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsHpDOSGermanProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsWp2DOSGermanProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsWrDOSGermanProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsSt2DOSGermanProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsInDOSGermanProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings7DOSGermanProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings82DOSGermanProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings9DOSGermanProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings12DOSGermanProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings132DOSGermanProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2LevelGainStringsDOSGermanProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2BookNumbersDOSGermanProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MageSpellsListDOSGermanProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ClericSpellsListDOSGermanProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2SpellNamesDOSGermanProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings1DOSGermanProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings2DOSGermanProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings3DOSGermanProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings4DOSGermanProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings6DOSGermanProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings7DOSGermanProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MagicStrings8DOSGermanProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ManDefDOSGermanProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ManWordDOSGermanProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2ManPromptDOSGermanProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MainMenuStringsDOSGermanProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TransferStrings1DOSGermanProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TransferStrings2DOSGermanProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2TransferLabelsDOSGermanProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2IntroStringsDOSGermanProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2IntroCPSFilesDOSGermanProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2FinaleStringsDOSGermanProvider },
	{ kEoB2CreditsData, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2CreditsDataDOSGermanProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2FinaleCPSFilesDOSGermanProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MonsterDistAttStringsDOSGermanProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2Npc1StringsDOSGermanProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2Npc2StringsDOSGermanProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2MonsterDustStringsDOSGermanProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2KheldranStringsDOSGermanProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformDOS, kNoSpecial, DE_DEU, &kEoB2HornStringsDOSGermanProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2NpcPresetsNamesDOSSpanishProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ChargenStrings1DOSSpanishProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ChargenStrings2DOSSpanishProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ChargenStatStringsDOSSpanishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ChargenRaceSexStringsDOSSpanishProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ChargenClassStringsDOSSpanishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ChargenAlignmentStringsDOSSpanishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ChargenEnterGameStringsDOSSpanishProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2PryDoorStringsDOSSpanishProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2WarningStringsDOSSpanishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ItemSuffixStringsRingsDOSSpanishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ItemSuffixStringsPotionsDOSSpanishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ItemSuffixStringsWandsDOSSpanishProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2RipItemStringsDOSSpanishProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CursedStringDOSSpanishProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicObjectStringsDOSSpanishProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicObjectString5DOSSpanishProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2PatternSuffixDOSSpanishProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2PatternGrFix1DOSSpanishProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2PatternGrFix2DOSSpanishProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ValidateArmorStringDOSSpanishProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ValidateCursedStringDOSSpanishProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ValidateNoDropStringDOSSpanishProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2PotionStringsDOSSpanishProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2WandStringsDOSSpanishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ItemMisuseStringsDOSSpanishProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2TakenStringsDOSSpanishProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2PotionEffectStringsDOSSpanishProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2YesNoStringsDOSSpanishProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MoreStringsDOSSpanishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2NpcMaxStringsDOSSpanishProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2OkStringsDOSSpanishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2NpcJoinStringsDOSSpanishProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CancelStringsDOSSpanishProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2AbortStringsDOSSpanishProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsMainDOSSpanishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsSaveLoadDOSSpanishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsOnOffDOSSpanishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsSpellsDOSSpanishProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsRestDOSSpanishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsDropDOSSpanishProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsExitDOSSpanishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsStarveDOSSpanishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsScribeDOSSpanishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsDrop2DOSSpanishProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsHeadDOSSpanishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsPoisonDOSSpanishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsMgcDOSSpanishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsPrefsDOSSpanishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsRest2DOSSpanishProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsRest3DOSSpanishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsRest4DOSSpanishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsDefeatDOSSpanishProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsTransferDOSSpanishProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuStringsSpecDOSSpanishProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MenuYesNoStringsDOSSpanishProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharGuiStringsHpDOSSpanishProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharGuiStringsWp2DOSSpanishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharGuiStringsWrDOSSpanishProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharGuiStringsSt2DOSSpanishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharGuiStringsInDOSSpanishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharStatusStrings7DOSSpanishProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharStatusStrings82DOSSpanishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharStatusStrings9DOSSpanishProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharStatusStrings12DOSSpanishProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CharStatusStrings132DOSSpanishProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2LevelGainStringsDOSSpanishProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2BookNumbersDOSSpanishProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MageSpellsListDOSSpanishProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ClericSpellsListDOSSpanishProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2SpellNamesDOSSpanishProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicStrings1DOSSpanishProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicStrings2DOSSpanishProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicStrings3DOSSpanishProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicStrings4DOSSpanishProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicStrings6DOSSpanishProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicStrings7DOSSpanishProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MagicStrings8DOSSpanishProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ManDefDOSSpanishProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ManWordDOSSpanishProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2ManPromptDOSSpanishProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MainMenuStringsDOSSpanishProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2TransferStrings1DOSSpanishProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2TransferStrings2DOSSpanishProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2TransferLabelsDOSSpanishProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2IntroStringsDOSSpanishProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2IntroCPSFilesDOSSpanishProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2FinaleStringsDOSSpanishProvider },
	{ kEoB2CreditsData, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2CreditsDataDOSSpanishProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2FinaleCPSFilesDOSSpanishProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MonsterDistAttStringsDOSSpanishProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2Npc1StringsDOSSpanishProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2Npc2StringsDOSSpanishProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2MonsterDustStringsDOSSpanishProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2KheldranStringsDOSSpanishProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformDOS, kNoSpecial, ES_ESP, &kEoB2HornStringsDOSSpanishProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2NpcPresetsNamesAmigaEnglishProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ChargenStrings1AmigaEnglishProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ChargenStrings2AmigaEnglishProvider },
	{ kEoBBaseChargenStartLevels, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ChargenStartLevelsAmigaProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ChargenStatStringsAmigaEnglishProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ChargenRaceSexStringsAmigaEnglishProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ChargenClassStringsAmigaEnglishProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ChargenAlignmentStringsAmigaEnglishProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ChargenEnterGameStringsAmigaEnglishProvider },
	{ kEoBBaseChargenClassMinStats, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ChargenClassMinStatsAmigaProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMinStatsAmigaProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMaxStatsAmigaProvider },
	{ kEoBBaseSaveThrowTable1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable1AmigaProvider },
	{ kEoBBaseSaveThrowTable2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable2AmigaProvider },
	{ kEoBBaseSaveThrowTable3, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable3AmigaProvider },
	{ kEoBBaseSaveThrowTable4, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable4AmigaProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SaveThrwLvlIndexAmigaProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModDivAmigaProvider },
	{ kEoBBaseSaveThrwModExt, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModExtAmigaProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2PryDoorStringsAmigaEnglishProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2WarningStringsAmigaEnglishProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsRingsAmigaEnglishProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsPotionsAmigaEnglishProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ItemSuffixStringsWandsAmigaEnglishProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2RipItemStringsAmigaEnglishProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CursedStringAmigaEnglishProvider },
	{ kEoBBaseEnchantedString, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2EnchantedStringAmigaProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicObjectStringsAmigaEnglishProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicObjectString5AmigaEnglishProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2PatternSuffixAmigaEnglishProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2PatternGrFix1AmigaEnglishProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2PatternGrFix2AmigaEnglishProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ValidateArmorStringAmigaEnglishProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ValidateCursedStringAmigaEnglishProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ValidateNoDropStringAmigaEnglishProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2PotionStringsAmigaEnglishProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2WandStringsAmigaEnglishProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ItemMisuseStringsAmigaEnglishProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2TakenStringsAmigaEnglishProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2PotionEffectStringsAmigaEnglishProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2YesNoStringsAmigaEnglishProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MoreStringsAmigaEnglishProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2NpcMaxStringsAmigaEnglishProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2OkStringsAmigaEnglishProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2NpcJoinStringsAmigaEnglishProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CancelStringsAmigaEnglishProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2AbortStringsAmigaEnglishProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsMainAmigaEnglishProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsSaveLoadAmigaEnglishProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsOnOffAmigaEnglishProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsSpellsAmigaEnglishProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsRestAmigaEnglishProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsDropAmigaEnglishProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsExitAmigaEnglishProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsStarveAmigaEnglishProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsScribeAmigaEnglishProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsDrop2AmigaEnglishProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsHeadAmigaEnglishProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsPoisonAmigaEnglishProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsMgcAmigaEnglishProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsPrefsAmigaEnglishProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest2AmigaEnglishProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest3AmigaEnglishProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsRest4AmigaEnglishProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsDefeatAmigaEnglishProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsTransferAmigaEnglishProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuStringsSpecAmigaEnglishProvider },
	{ kEoBBaseMenuStringsSpellNo, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MenuStringsSpellNoAmigaProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MenuYesNoStringsAmigaEnglishProvider },
	{ kEoBBaseSpellLevelsMage, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsMageAmigaProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsClericAmigaProvider },
	{ kEoBBaseNumSpellsCleric, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2NumSpellsClericAmigaProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2NumSpellsWisAdjAmigaProvider },
	{ kEoBBaseNumSpellsPal, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2NumSpellsPalAmigaProvider },
	{ kEoBBaseNumSpellsMage, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2NumSpellsMageAmigaProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsHpAmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsWp2AmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsWrAmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsSt2AmigaEnglishProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharGuiStringsInAmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings7AmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings82AmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings9AmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings12AmigaEnglishProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2CharStatusStrings132AmigaEnglishProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2LevelGainStringsAmigaEnglishProvider },
	{ kEoBBaseExperienceTable0, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable0AmigaProvider },
	{ kEoBBaseExperienceTable1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable1AmigaProvider },
	{ kEoBBaseExperienceTable2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable2AmigaProvider },
	{ kEoBBaseExperienceTable3, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable3AmigaProvider },
	{ kEoBBaseExperienceTable4, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable4AmigaProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2BookNumbersAmigaEnglishProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MageSpellsListAmigaEnglishProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ClericSpellsListAmigaEnglishProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2SpellNamesAmigaEnglishProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicStrings1AmigaEnglishProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicStrings2AmigaEnglishProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicStrings3AmigaEnglishProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicStrings4AmigaEnglishProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicStrings6AmigaEnglishProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicStrings7AmigaEnglishProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MagicStrings8AmigaEnglishProvider },
	{ kEoBBaseExpObjectTlMode, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTlModeAmigaProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTblIndexAmigaProvider },
	{ kEoBBaseExpObjectShpStart, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExpObjectShpStartAmigaProvider },
	{ kEoBBaseExpObjectTbl1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl1AmigaProvider },
	{ kEoBBaseExpObjectTbl2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl2AmigaProvider },
	{ kEoBBaseExpObjectTbl3, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl3AmigaProvider },
	{ kEoBBaseExpObjectY, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ExpObjectYAmigaProvider },
	{ kEoBBaseSparkDefSteps, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkDefStepsAmigaProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkDefSubStepsAmigaProvider },
	{ kEoBBaseSparkDefShift, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkDefShiftAmigaProvider },
	{ kEoBBaseSparkDefAdd, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkDefAddAmigaProvider },
	{ kEoBBaseSparkDefX, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkDefXAmigaProvider },
	{ kEoBBaseSparkDefY, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkDefYAmigaProvider },
	{ kEoBBaseSparkOfFlags1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags1AmigaProvider },
	{ kEoBBaseSparkOfFlags2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags2AmigaProvider },
	{ kEoBBaseSparkOfShift, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkOfShiftAmigaProvider },
	{ kEoBBaseSparkOfX, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkOfXAmigaProvider },
	{ kEoBBaseSparkOfY, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SparkOfYAmigaProvider },
	{ kEoBBaseSpellProperties, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SpellPropertiesAmigaProvider },
	{ kEoBBaseMagicFlightProps, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MagicFlightPropsAmigaProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2TurnUndeadEffectAmigaProvider },
	{ kEoBBaseBurningHandsDest, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2BurningHandsDestAmigaProvider },
	{ kEoBBaseConeOfColdDest1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest1AmigaProvider },
	{ kEoBBaseConeOfColdDest2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest2AmigaProvider },
	{ kEoBBaseConeOfColdDest3, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest3AmigaProvider },
	{ kEoBBaseConeOfColdDest4, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest4AmigaProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdGfxTblAmigaProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorShapeIndexAmigaProvider },
	{ kEoBBaseWllFlagPreset, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2WllFlagPresetAmigaProvider },
	{ kEoBBaseDscShapeCoords, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscShapeCoordsAmigaProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleOffsAmigaProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult1AmigaProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult2AmigaProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult3AmigaProvider },
	{ kEoBBaseDscDoorType5Offs, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorType5OffsAmigaProvider },
	{ kEoBBaseDscDoorY1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorY1AmigaProvider },
	{ kRpgCommonDscDoorY2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorY2AmigaProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY1AmigaProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY2AmigaProvider },
	{ kEoBBaseDscItemPosIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscItemPosIndexAmigaProvider },
	{ kEoBBaseDscItemShpX, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscItemShpXAmigaProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscItemScaleIndexAmigaProvider },
	{ kEoBBaseDscItemTileIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscItemTileIndexAmigaProvider },
	{ kEoBBaseDscItemShapeMap, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscItemShapeMapAmigaProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscTelptrShpCoordsAmigaProvider },
	{ kEoBBasePortalSeqData, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2PortalSeqDataAmigaProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ManDefAmigaEnglishProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ManWordAmigaEnglishProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2ManPromptAmigaEnglishProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl1AmigaProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl2AmigaProvider },
	{ kEoBBaseInvSlotX, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2InvSlotXAmigaProvider },
	{ kEoBBaseInvSlotY, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2InvSlotYAmigaProvider },
	{ kEoBBaseSlotValidationFlags, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SlotValidationFlagsAmigaProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ProjectileWeaponTypesAmigaProvider },
	{ kEoBBaseWandTypes, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2WandTypesAmigaProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DrawObjPosIndexAmigaProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FlightObjFlipIndexAmigaProvider },
	{ kEoBBaseFlightObjShpMap, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FlightObjShpMapAmigaProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FlightObjSclIndexAmigaProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MainMenuStringsAmigaEnglishProvider },
	{ kEoB2TransferPortraitFrames, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2TransferPortraitFramesAmigaProvider },
	{ kEoB2TransferConvertTable, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2TransferConvertTableAmigaProvider },
	{ kEoB2TransferItemTable, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2TransferItemTableAmigaProvider },
	{ kEoB2TransferExpTable, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2TransferExpTableAmigaProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2TransferStrings1AmigaEnglishProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2TransferStrings2AmigaEnglishProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2TransferLabelsAmigaEnglishProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2IntroStringsAmigaEnglishProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2IntroCPSFilesAmigaEnglishProvider },
	{ kEoB2IntroAnimData00, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData00AmigaProvider },
	{ kEoB2IntroAnimData01, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData01AmigaProvider },
	{ kEoB2IntroAnimData02, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData02AmigaProvider },
	{ kEoB2IntroAnimData03, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData03AmigaProvider },
	{ kEoB2IntroAnimData04, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData04AmigaProvider },
	{ kEoB2IntroAnimData05, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData05AmigaProvider },
	{ kEoB2IntroAnimData06, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData06AmigaProvider },
	{ kEoB2IntroAnimData07, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData07AmigaProvider },
	{ kEoB2IntroAnimData08, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData08AmigaProvider },
	{ kEoB2IntroAnimData09, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData09AmigaProvider },
	{ kEoB2IntroAnimData10, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData10AmigaProvider },
	{ kEoB2IntroAnimData11, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData11AmigaProvider },
	{ kEoB2IntroAnimData12, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData12AmigaProvider },
	{ kEoB2IntroAnimData13, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData13AmigaProvider },
	{ kEoB2IntroAnimData14, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData14AmigaProvider },
	{ kEoB2IntroAnimData15, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData15AmigaProvider },
	{ kEoB2IntroAnimData16, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData16AmigaProvider },
	{ kEoB2IntroAnimData17, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData17AmigaProvider },
	{ kEoB2IntroAnimData18, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData18AmigaProvider },
	{ kEoB2IntroAnimData19, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData19AmigaProvider },
	{ kEoB2IntroAnimData20, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData20AmigaProvider },
	{ kEoB2IntroAnimData21, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData21AmigaProvider },
	{ kEoB2IntroAnimData22, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData22AmigaProvider },
	{ kEoB2IntroAnimData23, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData23AmigaProvider },
	{ kEoB2IntroAnimData24, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData24AmigaProvider },
	{ kEoB2IntroAnimData25, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData25AmigaProvider },
	{ kEoB2IntroAnimData26, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData26AmigaProvider },
	{ kEoB2IntroAnimData27, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData27AmigaProvider },
	{ kEoB2IntroAnimData28, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData28AmigaProvider },
	{ kEoB2IntroAnimData29, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData29AmigaProvider },
	{ kEoB2IntroAnimData30, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData30AmigaProvider },
	{ kEoB2IntroAnimData31, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData31AmigaProvider },
	{ kEoB2IntroAnimData32, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData32AmigaProvider },
	{ kEoB2IntroAnimData33, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData33AmigaProvider },
	{ kEoB2IntroAnimData34, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData34AmigaProvider },
	{ kEoB2IntroAnimData35, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData35AmigaProvider },
	{ kEoB2IntroAnimData36, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData36AmigaProvider },
	{ kEoB2IntroAnimData37, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData37AmigaProvider },
	{ kEoB2IntroAnimData38, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData38AmigaProvider },
	{ kEoB2IntroAnimData39, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData39AmigaProvider },
	{ kEoB2IntroAnimData40, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData40AmigaProvider },
	{ kEoB2IntroShapes00, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroShapes00AmigaProvider },
	{ kEoB2IntroShapes01, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroShapes01AmigaProvider },
	{ kEoB2IntroShapes04, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroShapes04AmigaProvider },
	{ kEoB2IntroShapes07, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroShapes07AmigaProvider },
	{ kEoB2IntroShapes13, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroShapes13AmigaProvider },
	{ kEoB2IntroShapes14, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroShapes14AmigaProvider },
	{ kEoB2IntroShapes15, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2IntroShapes15AmigaProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2FinaleStringsAmigaEnglishProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2FinaleCPSFilesAmigaEnglishProvider },
	{ kEoB2FinaleAnimData00, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData00AmigaProvider },
	{ kEoB2FinaleAnimData01, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData01AmigaProvider },
	{ kEoB2FinaleAnimData02, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData02AmigaProvider },
	{ kEoB2FinaleAnimData03, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData03AmigaProvider },
	{ kEoB2FinaleAnimData04, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData04AmigaProvider },
	{ kEoB2FinaleAnimData05, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData05AmigaProvider },
	{ kEoB2FinaleAnimData06, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData06AmigaProvider },
	{ kEoB2FinaleAnimData07, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData07AmigaProvider },
	{ kEoB2FinaleAnimData08, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData08AmigaProvider },
	{ kEoB2FinaleAnimData09, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData09AmigaProvider },
	{ kEoB2FinaleAnimData10, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData10AmigaProvider },
	{ kEoB2FinaleAnimData11, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData11AmigaProvider },
	{ kEoB2FinaleAnimData12, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData12AmigaProvider },
	{ kEoB2FinaleAnimData13, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData13AmigaProvider },
	{ kEoB2FinaleAnimData14, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData14AmigaProvider },
	{ kEoB2FinaleAnimData15, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData15AmigaProvider },
	{ kEoB2FinaleAnimData16, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData16AmigaProvider },
	{ kEoB2FinaleAnimData17, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData17AmigaProvider },
	{ kEoB2FinaleAnimData18, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData18AmigaProvider },
	{ kEoB2FinaleAnimData19, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData19AmigaProvider },
	{ kEoB2FinaleAnimData20, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData20AmigaProvider },
	{ kEoB2FinaleShapes00, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes00AmigaProvider },
	{ kEoB2FinaleShapes03, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes03AmigaProvider },
	{ kEoB2FinaleShapes07, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes07AmigaProvider },
	{ kEoB2FinaleShapes09, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes09AmigaProvider },
	{ kEoB2FinaleShapes10, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes10AmigaProvider },
	{ kEoB2NpcShapeData, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2NpcShapeDataAmigaProvider },
	{ kEoBBaseClassModifierFlags, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2ClassModifierFlagsAmigaProvider },
	{ kEoBBaseMonsterStepTable02, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable02AmigaProvider },
	{ kEoBBaseMonsterStepTable1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable1AmigaProvider },
	{ kEoBBaseMonsterStepTable2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable2AmigaProvider },
	{ kEoBBaseMonsterStepTable3, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable3AmigaProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable1AmigaProvider },
	{ kEoBBaseMonsterCloseAttPosTable22, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable22AmigaProvider },
	{ kEoBBaseMonsterCloseAttUnkTable, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttUnkTableAmigaProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable1AmigaProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable2AmigaProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable1AmigaProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable2AmigaProvider },
	{ kEoBBaseMonsterProximityTable, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterProximityTableAmigaProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2FindBlockMonstersTableAmigaProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterDirChangeTableAmigaProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MonsterDistAttStringsAmigaEnglishProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2EncodeMonsterDefsAmigaProvider },
	{ kEoBBaseNpcPresets, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2NpcPresetsAmigaProvider },
	{ kEoBBaseSoundMap, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundMapAmigaProvider },
	{ kEoB2SoundMapExtra, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundMapExtraAmigaProvider },
	{ kEoB2SoundIndex1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundIndex1AmigaProvider },
	{ kEoB2SoundIndex2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundIndex2AmigaProvider },
	{ kEoB2SoundFilesIngame2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundFilesIngame2AmigaProvider },
	{ kEoB2MonsterSoundPatchData, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2MonsterSoundPatchDataAmigaProvider },
	{ kEoBBaseLevelSoundFiles1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2LevelSoundFiles1AmigaProvider },
	{ kEoBBaseLevelSoundFiles2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2LevelSoundFiles2AmigaProvider },
	{ kEoBBaseSoundFilesIntro, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundFilesIntroAmigaProvider },
	{ kEoBBaseSoundFilesIngame, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundFilesIngameAmigaProvider },
	{ kEoBBaseSoundFilesFinale, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2SoundFilesFinaleAmigaProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2Npc1StringsAmigaEnglishProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2Npc2StringsAmigaEnglishProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2MonsterDustStringsAmigaEnglishProvider },
	{ kEoB2DreamSteps, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DreamStepsAmigaProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2KheldranStringsAmigaEnglishProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformAmiga, kNoSpecial, EN_ANY, &kEoB2HornStringsAmigaEnglishProvider },
	{ kEoB2HornSounds, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2HornSoundsAmigaProvider },
	{ kEoB2WallOfForceDsX, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsXAmigaProvider },
	{ kEoB2WallOfForceDsY, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsYAmigaProvider },
	{ kEoB2WallOfForceNumW, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumWAmigaProvider },
	{ kEoB2WallOfForceNumH, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumHAmigaProvider },
	{ kEoB2WallOfForceShpId, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShpIdAmigaProvider },
	{ kRpgCommonDscShapeIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscShapeIndexAmigaProvider },
	{ kRpgCommonDscX, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscXAmigaProvider },
	{ kRpgCommonDscTileIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscTileIndexAmigaProvider },
	{ kRpgCommonDscDimData1, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDimData1AmigaProvider },
	{ kRpgCommonDscDimData2, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDimData2AmigaProvider },
	{ kRpgCommonDscBlockMap, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscBlockMapAmigaProvider },
	{ kRpgCommonDscDimMap, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscDimMapAmigaProvider },
	{ kRpgCommonDscBlockIndex, kEoB2, kPlatformAmiga, kNoSpecial, UNK_LANG, &kEoB2DscBlockIndexAmigaProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2NpcPresetsNamesAmigaGermanProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ChargenStrings1AmigaGermanProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ChargenStrings2AmigaGermanProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ChargenStatStringsAmigaGermanProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ChargenRaceSexStringsAmigaGermanProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ChargenClassStringsAmigaGermanProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ChargenAlignmentStringsAmigaGermanProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ChargenEnterGameStringsAmigaGermanProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2PryDoorStringsAmigaGermanProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2WarningStringsAmigaGermanProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsRingsAmigaGermanProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsPotionsAmigaGermanProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ItemSuffixStringsWandsAmigaGermanProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2RipItemStringsAmigaGermanProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CursedStringAmigaGermanProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicObjectStringsAmigaGermanProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicObjectString5AmigaGermanProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2PatternSuffixAmigaGermanProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2PatternGrFix1AmigaGermanProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2PatternGrFix2AmigaGermanProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ValidateArmorStringAmigaGermanProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ValidateCursedStringAmigaGermanProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ValidateNoDropStringAmigaGermanProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2PotionStringsAmigaGermanProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2WandStringsAmigaGermanProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ItemMisuseStringsAmigaGermanProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2TakenStringsAmigaGermanProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2PotionEffectStringsAmigaGermanProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2YesNoStringsAmigaGermanProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MoreStringsAmigaGermanProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2NpcMaxStringsAmigaGermanProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2OkStringsAmigaGermanProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2NpcJoinStringsAmigaGermanProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CancelStringsAmigaGermanProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2AbortStringsAmigaGermanProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsMainAmigaGermanProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsSaveLoadAmigaGermanProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsOnOffAmigaGermanProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsSpellsAmigaGermanProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsRestAmigaGermanProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsDropAmigaGermanProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsExitAmigaGermanProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsStarveAmigaGermanProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsScribeAmigaGermanProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsDrop2AmigaGermanProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsHeadAmigaGermanProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsPoisonAmigaGermanProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsMgcAmigaGermanProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsPrefsAmigaGermanProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest2AmigaGermanProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest3AmigaGermanProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsRest4AmigaGermanProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsDefeatAmigaGermanProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsTransferAmigaGermanProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuStringsSpecAmigaGermanProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MenuYesNoStringsAmigaGermanProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsHpAmigaGermanProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsWp2AmigaGermanProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsWrAmigaGermanProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsSt2AmigaGermanProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharGuiStringsInAmigaGermanProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings7AmigaGermanProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings82AmigaGermanProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings9AmigaGermanProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings12AmigaGermanProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2CharStatusStrings132AmigaGermanProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2LevelGainStringsAmigaGermanProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2BookNumbersAmigaGermanProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MageSpellsListAmigaGermanProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ClericSpellsListAmigaGermanProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2SpellNamesAmigaGermanProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicStrings1AmigaGermanProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicStrings2AmigaGermanProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicStrings3AmigaGermanProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicStrings4AmigaGermanProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicStrings6AmigaGermanProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicStrings7AmigaGermanProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MagicStrings8AmigaGermanProvider },
	{ kEoBBaseManDef, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ManDefAmigaGermanProvider },
	{ kEoBBaseManWord, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ManWordAmigaGermanProvider },
	{ kEoBBaseManPrompt, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2ManPromptAmigaGermanProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MainMenuStringsAmigaGermanProvider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2TransferStrings1AmigaGermanProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2TransferStrings2AmigaGermanProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2TransferLabelsAmigaGermanProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2IntroStringsAmigaGermanProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2IntroCPSFilesAmigaGermanProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2FinaleStringsAmigaGermanProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2FinaleCPSFilesAmigaGermanProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MonsterDistAttStringsAmigaGermanProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2Npc1StringsAmigaGermanProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2Npc2StringsAmigaGermanProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2MonsterDustStringsAmigaGermanProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2KheldranStringsAmigaGermanProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformAmiga, kNoSpecial, DE_DEU, &kEoB2HornStringsAmigaGermanProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2NpcPresetsNamesFMTownsJapaneseProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ChargenStrings1FMTownsJapaneseProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ChargenStrings2FMTownsJapaneseProvider },
	{ kEoBBaseChargenStartLevels, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ChargenStartLevelsFMTownsProvider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ChargenStatStringsFMTownsJapaneseProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ChargenRaceSexStringsFMTownsJapaneseProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ChargenClassStringsFMTownsJapaneseProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ChargenAlignmentStringsFMTownsJapaneseProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ChargenEnterGameStringsFMTownsJapaneseProvider },
	{ kEoBBaseChargenClassMinStats, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ChargenClassMinStatsFMTownsProvider },
	{ kEoBBaseChargenRaceMinStats, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMinStatsFMTownsProvider },
	{ kEoBBaseChargenRaceMaxStats, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMaxStatsFMTownsProvider },
	{ kEoBBaseSaveThrowTable1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable1FMTownsProvider },
	{ kEoBBaseSaveThrowTable2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable2FMTownsProvider },
	{ kEoBBaseSaveThrowTable3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable3FMTownsProvider },
	{ kEoBBaseSaveThrowTable4, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable4FMTownsProvider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SaveThrwLvlIndexFMTownsProvider },
	{ kEoBBaseSaveThrwModDiv, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModDivFMTownsProvider },
	{ kEoBBaseSaveThrwModExt, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModExtFMTownsProvider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2PryDoorStringsFMTownsJapaneseProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2WarningStringsFMTownsJapaneseProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ItemSuffixStringsRingsFMTownsJapaneseProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ItemSuffixStringsPotionsFMTownsJapaneseProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ItemSuffixStringsWandsFMTownsJapaneseProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2RipItemStringsFMTownsJapaneseProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CursedStringFMTownsJapaneseProvider },
	{ kEoBBaseEnchantedString, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2EnchantedStringFMTownsProvider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicObjectStringsFMTownsJapaneseProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicObjectString5FMTownsJapaneseProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2PatternSuffixFMTownsJapaneseProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2PatternGrFix1FMTownsJapaneseProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2PatternGrFix2FMTownsJapaneseProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ValidateArmorStringFMTownsJapaneseProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ValidateCursedStringFMTownsJapaneseProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ValidateNoDropStringFMTownsJapaneseProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2PotionStringsFMTownsJapaneseProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2WandStringsFMTownsJapaneseProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ItemMisuseStringsFMTownsJapaneseProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2TakenStringsFMTownsJapaneseProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2PotionEffectStringsFMTownsJapaneseProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2YesNoStringsFMTownsJapaneseProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MoreStringsFMTownsJapaneseProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2NpcMaxStringsFMTownsJapaneseProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2OkStringsFMTownsJapaneseProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2NpcJoinStringsFMTownsJapaneseProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CancelStringsFMTownsJapaneseProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2AbortStringsFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsMainFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsSaveLoadFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsOnOffFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsSpellsFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsRestFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsDropFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsExitFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsStarveFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsScribeFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsDrop2FMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsHeadFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsPoisonFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsMgcFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsPrefsFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsRest2FMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsRest3FMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsRest4FMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsDefeatFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsTransferFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuStringsSpecFMTownsJapaneseProvider },
	{ kEoBBaseMenuStringsSpellNo, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MenuStringsSpellNoFMTownsProvider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MenuYesNoStringsFMTownsJapaneseProvider },
	{ kEoBBaseSpellLevelsMage, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsMageFMTownsProvider },
	{ kEoBBaseSpellLevelsCleric, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsClericFMTownsProvider },
	{ kEoBBaseNumSpellsCleric, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2NumSpellsClericFMTownsProvider },
	{ kEoBBaseNumSpellsWisAdj, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2NumSpellsWisAdjFMTownsProvider },
	{ kEoBBaseNumSpellsPal, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2NumSpellsPalFMTownsProvider },
	{ kEoBBaseNumSpellsMage, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2NumSpellsMageFMTownsProvider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsHpFMTownsJapaneseProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsWp2FMTownsJapaneseProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsWrFMTownsJapaneseProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsSt2FMTownsJapaneseProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsInFMTownsJapaneseProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings7FMTownsJapaneseProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings82FMTownsJapaneseProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings9FMTownsJapaneseProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings12FMTownsJapaneseProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings132FMTownsJapaneseProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2LevelGainStringsFMTownsJapaneseProvider },
	{ kEoBBaseExperienceTable0, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable0FMTownsProvider },
	{ kEoBBaseExperienceTable1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable1FMTownsProvider },
	{ kEoBBaseExperienceTable2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable2FMTownsProvider },
	{ kEoBBaseExperienceTable3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable3FMTownsProvider },
	{ kEoBBaseExperienceTable4, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable4FMTownsProvider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2BookNumbersFMTownsJapaneseProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MageSpellsListFMTownsJapaneseProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2ClericSpellsListFMTownsJapaneseProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2SpellNamesFMTownsJapaneseProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicStrings1FMTownsJapaneseProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicStrings2FMTownsJapaneseProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicStrings3FMTownsJapaneseProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicStrings4FMTownsJapaneseProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicStrings6FMTownsJapaneseProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicStrings7FMTownsJapaneseProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MagicStrings8FMTownsJapaneseProvider },
	{ kEoBBaseExpObjectTlMode, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTlModeFMTownsProvider },
	{ kEoBBaseExpObjectTblIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTblIndexFMTownsProvider },
	{ kEoBBaseExpObjectShpStart, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExpObjectShpStartFMTownsProvider },
	{ kEoBBaseExpObjectTbl1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl1FMTownsProvider },
	{ kEoBBaseExpObjectTbl2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl2FMTownsProvider },
	{ kEoBBaseExpObjectTbl3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl3FMTownsProvider },
	{ kEoBBaseExpObjectY, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ExpObjectYFMTownsProvider },
	{ kEoBBaseSparkDefSteps, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkDefStepsFMTownsProvider },
	{ kEoBBaseSparkDefSubSteps, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkDefSubStepsFMTownsProvider },
	{ kEoBBaseSparkDefShift, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkDefShiftFMTownsProvider },
	{ kEoBBaseSparkDefAdd, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkDefAddFMTownsProvider },
	{ kEoBBaseSparkDefX, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkDefXFMTownsProvider },
	{ kEoBBaseSparkDefY, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkDefYFMTownsProvider },
	{ kEoBBaseSparkOfFlags1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags1FMTownsProvider },
	{ kEoBBaseSparkOfFlags2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags2FMTownsProvider },
	{ kEoBBaseSparkOfShift, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkOfShiftFMTownsProvider },
	{ kEoBBaseSparkOfX, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkOfXFMTownsProvider },
	{ kEoBBaseSparkOfY, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkOfYFMTownsProvider },
	{ kEoBBaseSpellProperties, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SpellPropertiesFMTownsProvider },
	{ kEoBBaseMagicFlightProps, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MagicFlightPropsFMTownsProvider },
	{ kEoBBaseTurnUndeadEffect, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2TurnUndeadEffectFMTownsProvider },
	{ kEoBBaseBurningHandsDest, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2BurningHandsDestFMTownsProvider },
	{ kEoBBaseConeOfColdDest1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest1FMTownsProvider },
	{ kEoBBaseConeOfColdDest2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest2FMTownsProvider },
	{ kEoBBaseConeOfColdDest3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest3FMTownsProvider },
	{ kEoBBaseConeOfColdDest4, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest4FMTownsProvider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdGfxTblFMTownsProvider },
	{ kRpgCommonDscDoorShapeIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorShapeIndexFMTownsProvider },
	{ kEoBBaseWllFlagPreset, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WllFlagPresetFMTownsProvider },
	{ kEoBBaseDscShapeCoords, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscShapeCoordsFMTownsProvider },
	{ kRpgCommonDscDoorScaleOffs, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleOffsFMTownsProvider },
	{ kEoBBaseDscDoorScaleMult1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult1FMTownsProvider },
	{ kEoBBaseDscDoorScaleMult2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult2FMTownsProvider },
	{ kEoBBaseDscDoorScaleMult3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult3FMTownsProvider },
	{ kEoBBaseDscDoorType5Offs, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorType5OffsFMTownsProvider },
	{ kEoBBaseDscDoorY1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorY1FMTownsProvider },
	{ kRpgCommonDscDoorY2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorY2FMTownsProvider },
	{ kRpgCommonDscDoorFrameY1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY1FMTownsProvider },
	{ kRpgCommonDscDoorFrameY2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY2FMTownsProvider },
	{ kEoBBaseDscItemPosIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscItemPosIndexFMTownsProvider },
	{ kEoBBaseDscItemShpX, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscItemShpXFMTownsProvider },
	{ kEoBBaseDscItemScaleIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscItemScaleIndexFMTownsProvider },
	{ kEoBBaseDscItemTileIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscItemTileIndexFMTownsProvider },
	{ kEoBBaseDscItemShapeMap, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscItemShapeMapFMTownsProvider },
	{ kEoBBaseDscTelptrShpCoords, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscTelptrShpCoordsFMTownsProvider },
	{ kEoBBasePortalSeqData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2PortalSeqDataFMTownsProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl1FMTownsProvider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl2FMTownsProvider },
	{ kEoBBaseInvSlotX, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2InvSlotXFMTownsProvider },
	{ kEoBBaseInvSlotY, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2InvSlotYFMTownsProvider },
	{ kEoBBaseSlotValidationFlags, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SlotValidationFlagsFMTownsProvider },
	{ kEoBBaseProjectileWeaponTypes, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ProjectileWeaponTypesFMTownsProvider },
	{ kEoBBaseWandTypes, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WandTypesFMTownsProvider },
	{ kEoBBaseDrawObjPosIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DrawObjPosIndexFMTownsProvider },
	{ kEoBBaseFlightObjFlipIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FlightObjFlipIndexFMTownsProvider },
	{ kEoBBaseFlightObjShpMap, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FlightObjShpMapFMTownsProvider },
	{ kEoBBaseFlightObjSclIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FlightObjSclIndexFMTownsProvider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MainMenuStringsFMTownsJapaneseProvider },
	{ kEoB2MainMenuUtilStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MainMenuUtilStringsFMTownsJapaneseProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroStringsFMTownsJapaneseProvider },
	{ kEoB2IntroCpsDataStreet1, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataStreet1FMTownsProvider },
	{ kEoB2IntroCpsDataStreet2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataStreet2FMTownsProvider },
	{ kEoB2IntroCpsDataDoorway1, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataDoorway1FMTownsProvider },
	{ kEoB2IntroCpsDataDoorway2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataDoorway2FMTownsProvider },
	{ kEoB2IntroCpsDataWestwood, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataWestwoodFMTownsProvider },
	{ kEoB2IntroCpsDataWinding, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataWindingFMTownsProvider },
	{ kEoB2IntroCpsDataKhelban2, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataKhelban2FMTownsProvider },
	{ kEoB2IntroCpsDataKhelban1, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataKhelban1FMTownsProvider },
	{ kEoB2IntroCpsDataKhelban3, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataKhelban3FMTownsProvider },
	{ kEoB2IntroCpsDataKhelban4, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataKhelban4FMTownsProvider },
	{ kEoB2IntroCpsDataCoin, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataCoinFMTownsProvider },
	{ kEoB2IntroCpsDataKhelban5, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataKhelban5FMTownsProvider },
	{ kEoB2IntroCpsDataKhelban6, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2IntroCpsDataKhelban6FMTownsProvider },
	{ kEoB2IntroAnimData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData00FMTownsProvider },
	{ kEoB2IntroAnimData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData01FMTownsProvider },
	{ kEoB2IntroAnimData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData02FMTownsProvider },
	{ kEoB2IntroAnimData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData03FMTownsProvider },
	{ kEoB2IntroAnimData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData04FMTownsProvider },
	{ kEoB2IntroAnimData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData05FMTownsProvider },
	{ kEoB2IntroAnimData06, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData06FMTownsProvider },
	{ kEoB2IntroAnimData07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData07FMTownsProvider },
	{ kEoB2IntroAnimData08, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData08FMTownsProvider },
	{ kEoB2IntroAnimData09, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData09FMTownsProvider },
	{ kEoB2IntroAnimData10, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData10FMTownsProvider },
	{ kEoB2IntroAnimData11, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData11FMTownsProvider },
	{ kEoB2IntroAnimData12, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData12FMTownsProvider },
	{ kEoB2IntroAnimData13, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData13FMTownsProvider },
	{ kEoB2IntroAnimData14, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData14FMTownsProvider },
	{ kEoB2IntroAnimData15, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData15FMTownsProvider },
	{ kEoB2IntroAnimData16, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData16FMTownsProvider },
	{ kEoB2IntroAnimData17, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData17FMTownsProvider },
	{ kEoB2IntroAnimData18, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData18FMTownsProvider },
	{ kEoB2IntroAnimData19, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData19FMTownsProvider },
	{ kEoB2IntroAnimData20, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData20FMTownsProvider },
	{ kEoB2IntroAnimData21, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData21FMTownsProvider },
	{ kEoB2IntroAnimData22, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData22FMTownsProvider },
	{ kEoB2IntroAnimData23, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData23FMTownsProvider },
	{ kEoB2IntroAnimData24, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData24FMTownsProvider },
	{ kEoB2IntroAnimData25, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData25FMTownsProvider },
	{ kEoB2IntroAnimData26, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData26FMTownsProvider },
	{ kEoB2IntroAnimData27, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData27FMTownsProvider },
	{ kEoB2IntroAnimData28, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData28FMTownsProvider },
	{ kEoB2IntroAnimData29, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData29FMTownsProvider },
	{ kEoB2IntroAnimData30, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData30FMTownsProvider },
	{ kEoB2IntroAnimData31, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData31FMTownsProvider },
	{ kEoB2IntroAnimData32, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData32FMTownsProvider },
	{ kEoB2IntroAnimData33, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData33FMTownsProvider },
	{ kEoB2IntroAnimData34, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData34FMTownsProvider },
	{ kEoB2IntroAnimData35, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData35FMTownsProvider },
	{ kEoB2IntroAnimData36, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData36FMTownsProvider },
	{ kEoB2IntroAnimData37, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData37FMTownsProvider },
	{ kEoB2IntroAnimData38, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData38FMTownsProvider },
	{ kEoB2IntroAnimData39, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData39FMTownsProvider },
	{ kEoB2IntroAnimData40, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData40FMTownsProvider },
	{ kEoB2IntroAnimData41, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData41FMTownsProvider },
	{ kEoB2IntroAnimData42, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData42FMTownsProvider },
	{ kEoB2IntroAnimData43, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData43FMTownsProvider },
	{ kEoB2IntroShapes00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroShapes00FMTownsProvider },
	{ kEoB2IntroShapes01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroShapes01FMTownsProvider },
	{ kEoB2IntroShapes04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroShapes04FMTownsProvider },
	{ kEoB2IntroShapes07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2IntroShapes07FMTownsProvider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2FinaleStringsFMTownsJapaneseProvider },
	{ kEoB2FinaleCpsDataDragon1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataDragon1FMTownsProvider },
	{ kEoB2FinaleCpsDataDragon2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataDragon2FMTownsProvider },
	{ kEoB2FinaleCpsDataHurry1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataHurry1FMTownsProvider },
	{ kEoB2FinaleCpsDataHurry2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataHurry2FMTownsProvider },
	{ kEoB2FinaleCpsDataDestroy0, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataDestroy0FMTownsProvider },
	{ kEoB2FinaleCpsDataDestroy1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataDestroy1FMTownsProvider },
	{ kEoB2FinaleCpsDataDestroy2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataDestroy2FMTownsProvider },
	{ kEoB2FinaleCpsDataMagic, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataMagicFMTownsProvider },
	{ kEoB2FinaleCpsDataDestroy3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataDestroy3FMTownsProvider },
	{ kEoB2FinaleCpsDataCredits2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataCredits2FMTownsProvider },
	{ kEoB2FinaleCpsDataCredits3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataCredits3FMTownsProvider },
	{ kEoB2FinaleCpsDataHeroes, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataHeroesFMTownsProvider },
	{ kEoB2FinaleCpsDataThanks, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleCpsDataThanksFMTownsProvider },
	{ kEoB2FinaleAnimData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData00FMTownsProvider },
	{ kEoB2FinaleAnimData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData01FMTownsProvider },
	{ kEoB2FinaleAnimData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData02FMTownsProvider },
	{ kEoB2FinaleAnimData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData03FMTownsProvider },
	{ kEoB2FinaleAnimData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData04FMTownsProvider },
	{ kEoB2FinaleAnimData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData05FMTownsProvider },
	{ kEoB2FinaleAnimData06, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData06FMTownsProvider },
	{ kEoB2FinaleAnimData07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData07FMTownsProvider },
	{ kEoB2FinaleAnimData08, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData08FMTownsProvider },
	{ kEoB2FinaleAnimData09, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData09FMTownsProvider },
	{ kEoB2FinaleAnimData10, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData10FMTownsProvider },
	{ kEoB2FinaleAnimData11, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData11FMTownsProvider },
	{ kEoB2FinaleAnimData12, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData12FMTownsProvider },
	{ kEoB2FinaleAnimData13, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData13FMTownsProvider },
	{ kEoB2FinaleAnimData14, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData14FMTownsProvider },
	{ kEoB2FinaleAnimData15, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData15FMTownsProvider },
	{ kEoB2FinaleAnimData16, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData16FMTownsProvider },
	{ kEoB2FinaleAnimData17, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData17FMTownsProvider },
	{ kEoB2FinaleAnimData18, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData18FMTownsProvider },
	{ kEoB2FinaleAnimData19, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData19FMTownsProvider },
	{ kEoB2FinaleAnimData20, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData20FMTownsProvider },
	{ kEoB2FinaleShapes00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes00FMTownsProvider },
	{ kEoB2FinaleShapes03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes03FMTownsProvider },
	{ kEoB2FinaleShapes07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes07FMTownsProvider },
	{ kEoB2FinaleShapes09, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes09FMTownsProvider },
	{ kEoB2FinaleShapes10, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes10FMTownsProvider },
	{ kEoB2NpcShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2NpcShapeDataFMTownsProvider },
	{ kEoBBaseClassModifierFlags, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ClassModifierFlagsFMTownsProvider },
	{ kEoBBaseMonsterStepTable02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable02FMTownsProvider },
	{ kEoBBaseMonsterStepTable1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable1FMTownsProvider },
	{ kEoBBaseMonsterStepTable2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable2FMTownsProvider },
	{ kEoBBaseMonsterStepTable3, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable3FMTownsProvider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable1FMTownsProvider },
	{ kEoBBaseMonsterCloseAttPosTable22, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable22FMTownsProvider },
	{ kEoBBaseMonsterCloseAttUnkTable, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttUnkTableFMTownsProvider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable1FMTownsProvider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable2FMTownsProvider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable1FMTownsProvider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable2FMTownsProvider },
	{ kEoBBaseMonsterProximityTable, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterProximityTableFMTownsProvider },
	{ kEoBBaseFindBlockMonstersTable, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FindBlockMonstersTableFMTownsProvider },
	{ kEoBBaseMonsterDirChangeTable, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2MonsterDirChangeTableFMTownsProvider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MonsterDistAttStringsFMTownsJapaneseProvider },
	{ kEoBBaseNpcPresets, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2NpcPresetsFMTownsProvider },
	{ kEoBBaseSoundFilesIntro, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SoundFilesIntroFMTownsProvider },
	{ kEoBBaseSoundFilesFinale, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SoundFilesFinaleFMTownsProvider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2Npc1StringsFMTownsJapaneseProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2Npc2StringsFMTownsJapaneseProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2MonsterDustStringsFMTownsJapaneseProvider },
	{ kEoB2DreamSteps, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DreamStepsFMTownsProvider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2KheldranStringsFMTownsJapaneseProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2HornStringsFMTownsJapaneseProvider },
	{ kEoB2HornSounds, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2HornSoundsFMTownsProvider },
	{ kEoB2WallOfForceDsX, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsXFMTownsProvider },
	{ kEoB2WallOfForceDsY, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsYFMTownsProvider },
	{ kEoB2WallOfForceNumW, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumWFMTownsProvider },
	{ kEoB2WallOfForceNumH, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumHFMTownsProvider },
	{ kEoB2WallOfForceShpId, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShpIdFMTownsProvider },
	{ kRpgCommonDscShapeIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscShapeIndexFMTownsProvider },
	{ kRpgCommonDscX, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscXFMTownsProvider },
	{ kRpgCommonDscTileIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscTileIndexFMTownsProvider },
	{ kRpgCommonDscDimData1, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDimData1FMTownsProvider },
	{ kRpgCommonDscDimData2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDimData2FMTownsProvider },
	{ kRpgCommonDscBlockMap, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscBlockMapFMTownsProvider },
	{ kRpgCommonDscDimMap, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscDimMapFMTownsProvider },
	{ kRpgCommonDscBlockIndex, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DscBlockIndexFMTownsProvider },
	{ k2SeqplayPakFiles, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplayPakFilesDOSDemoProvider },
	{ k2SeqplayStrings, kLoL, kPlatformDOS, kDemoVersion, EN_ANY, &kLoLSeqplayStringsDOSDemoEnglishProvider },
	{ k2SeqplaySeqData, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplaySeqDataDOSDemoProvider },
	{ k2SeqplaySfxFiles, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplaySfxFilesDOSDemoProvider },
	{ k2SeqplayIntroTracks, kLoL, kPlatformDOS, kDemoVersion, UNK_LANG, &kLoLSeqplayIntroTracksDOSDemoProvider },
	{ kEoB2ItemIconShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData00FMTownsProvider },
	{ kEoB2ItemIconShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData01FMTownsProvider },
	{ kEoB2ItemIconShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData02FMTownsProvider },
	{ kEoB2ItemIconShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData03FMTownsProvider },
	{ kEoB2ItemIconShapeData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData04FMTownsProvider },
	{ kEoB2ItemIconShapeData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData05FMTownsProvider },
	{ kEoB2ItemIconShapeData06, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData06FMTownsProvider },
	{ kEoB2ItemIconShapeData07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData07FMTownsProvider },
	{ kEoB2ItemIconShapeData08, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData08FMTownsProvider },
	{ kEoB2ItemIconShapeData09, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData09FMTownsProvider },
	{ kEoB2ItemIconShapeData10, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData10FMTownsProvider },
	{ kEoB2ItemIconShapeData11, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData11FMTownsProvider },
	{ kEoB2ItemIconShapeData12, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData12FMTownsProvider },
	{ kEoB2ItemIconShapeData13, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData13FMTownsProvider },
	{ kEoB2ItemIconShapeData14, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData14FMTownsProvider },
	{ kEoB2ItemIconShapeData15, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData15FMTownsProvider },
	{ kEoB2ItemIconShapeData16, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData16FMTownsProvider },
	{ kEoB2ItemIconShapeData17, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData17FMTownsProvider },
	{ kEoB2ItemIconShapeData18, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData18FMTownsProvider },
	{ kEoB2ItemIconShapeData19, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData19FMTownsProvider },
	{ kEoB2ItemIconShapeData20, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData20FMTownsProvider },
	{ kEoB2ItemIconShapeData21, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData21FMTownsProvider },
	{ kEoB2ItemIconShapeData22, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData22FMTownsProvider },
	{ kEoB2ItemIconShapeData23, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData23FMTownsProvider },
	{ kEoB2ItemIconShapeData24, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData24FMTownsProvider },
	{ kEoB2ItemIconShapeData25, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData25FMTownsProvider },
	{ kEoB2ItemIconShapeData26, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData26FMTownsProvider },
	{ kEoB2ItemIconShapeData27, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData27FMTownsProvider },
	{ kEoB2ItemIconShapeData28, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData28FMTownsProvider },
	{ kEoB2ItemIconShapeData29, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData29FMTownsProvider },
	{ kEoB2ItemIconShapeData30, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData30FMTownsProvider },
	{ kEoB2ItemIconShapeData31, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData31FMTownsProvider },
	{ kEoB2ItemIconShapeData32, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData32FMTownsProvider },
	{ kEoB2ItemIconShapeData33, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData33FMTownsProvider },
	{ kEoB2ItemIconShapeData34, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData34FMTownsProvider },
	{ kEoB2ItemIconShapeData35, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData35FMTownsProvider },
	{ kEoB2ItemIconShapeData36, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData36FMTownsProvider },
	{ kEoB2ItemIconShapeData37, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData37FMTownsProvider },
	{ kEoB2ItemIconShapeData38, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData38FMTownsProvider },
	{ kEoB2ItemIconShapeData39, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData39FMTownsProvider },
	{ kEoB2ItemIconShapeData40, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData40FMTownsProvider },
	{ kEoB2ItemIconShapeData41, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData41FMTownsProvider },
	{ kEoB2ItemIconShapeData42, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData42FMTownsProvider },
	{ kEoB2ItemIconShapeData43, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData43FMTownsProvider },
	{ kEoB2ItemIconShapeData44, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData44FMTownsProvider },
	{ kEoB2ItemIconShapeData45, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData45FMTownsProvider },
	{ kEoB2ItemIconShapeData46, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData46FMTownsProvider },
	{ kEoB2ItemIconShapeData47, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData47FMTownsProvider },
	{ kEoB2ItemIconShapeData48, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData48FMTownsProvider },
	{ kEoB2ItemIconShapeData49, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData49FMTownsProvider },
	{ kEoB2ItemIconShapeData50, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData50FMTownsProvider },
	{ kEoB2ItemIconShapeData51, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData51FMTownsProvider },
	{ kEoB2ItemIconShapeData52, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData52FMTownsProvider },
	{ kEoB2ItemIconShapeData53, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData53FMTownsProvider },
	{ kEoB2ItemIconShapeData54, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData54FMTownsProvider },
	{ kEoB2ItemIconShapeData55, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData55FMTownsProvider },
	{ kEoB2ItemIconShapeData56, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData56FMTownsProvider },
	{ kEoB2ItemIconShapeData57, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData57FMTownsProvider },
	{ kEoB2ItemIconShapeData58, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData58FMTownsProvider },
	{ kEoB2ItemIconShapeData59, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData59FMTownsProvider },
	{ kEoB2ItemIconShapeData60, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData60FMTownsProvider },
	{ kEoB2ItemIconShapeData61, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData61FMTownsProvider },
	{ kEoB2ItemIconShapeData62, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData62FMTownsProvider },
	{ kEoB2ItemIconShapeData63, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData63FMTownsProvider },
	{ kEoB2ItemIconShapeData64, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData64FMTownsProvider },
	{ kEoB2ItemIconShapeData65, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData65FMTownsProvider },
	{ kEoB2ItemIconShapeData66, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData66FMTownsProvider },
	{ kEoB2ItemIconShapeData67, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData67FMTownsProvider },
	{ kEoB2ItemIconShapeData68, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData68FMTownsProvider },
	{ kEoB2ItemIconShapeData69, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData69FMTownsProvider },
	{ kEoB2ItemIconShapeData70, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData70FMTownsProvider },
	{ kEoB2ItemIconShapeData71, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData71FMTownsProvider },
	{ kEoB2ItemIconShapeData72, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData72FMTownsProvider },
	{ kEoB2ItemIconShapeData73, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData73FMTownsProvider },
	{ kEoB2ItemIconShapeData74, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData74FMTownsProvider },
	{ kEoB2ItemIconShapeData75, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData75FMTownsProvider },
	{ kEoB2ItemIconShapeData76, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData76FMTownsProvider },
	{ kEoB2ItemIconShapeData77, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData77FMTownsProvider },
	{ kEoB2ItemIconShapeData78, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData78FMTownsProvider },
	{ kEoB2ItemIconShapeData79, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData79FMTownsProvider },
	{ kEoB2ItemIconShapeData80, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData80FMTownsProvider },
	{ kEoB2ItemIconShapeData81, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData81FMTownsProvider },
	{ kEoB2ItemIconShapeData82, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData82FMTownsProvider },
	{ kEoB2ItemIconShapeData83, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData83FMTownsProvider },
	{ kEoB2ItemIconShapeData84, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData84FMTownsProvider },
	{ kEoB2ItemIconShapeData85, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData85FMTownsProvider },
	{ kEoB2ItemIconShapeData86, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData86FMTownsProvider },
	{ kEoB2ItemIconShapeData87, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData87FMTownsProvider },
	{ kEoB2ItemIconShapeData88, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData88FMTownsProvider },
	{ kEoB2ItemIconShapeData89, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData89FMTownsProvider },
	{ kEoB2ItemIconShapeData90, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData90FMTownsProvider },
	{ kEoB2ItemIconShapeData91, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData91FMTownsProvider },
	{ kEoB2ItemIconShapeData92, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData92FMTownsProvider },
	{ kEoB2ItemIconShapeData93, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData93FMTownsProvider },
	{ kEoB2ItemIconShapeData94, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData94FMTownsProvider },
	{ kEoB2ItemIconShapeData95, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData95FMTownsProvider },
	{ kEoB2ItemIconShapeData96, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData96FMTownsProvider },
	{ kEoB2ItemIconShapeData97, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData97FMTownsProvider },
	{ kEoB2ItemIconShapeData98, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData98FMTownsProvider },
	{ kEoB2ItemIconShapeData99, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData99FMTownsProvider },
	{ kEoB2ItemIconShapeData100, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData100FMTownsProvider },
	{ kEoB2ItemIconShapeData101, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData101FMTownsProvider },
	{ kEoB2ItemIconShapeData102, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData102FMTownsProvider },
	{ kEoB2ItemIconShapeData103, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData103FMTownsProvider },
	{ kEoB2ItemIconShapeData104, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData104FMTownsProvider },
	{ kEoB2ItemIconShapeData105, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData105FMTownsProvider },
	{ kEoB2ItemIconShapeData106, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData106FMTownsProvider },
	{ kEoB2ItemIconShapeData107, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData107FMTownsProvider },
	{ kEoB2ItemIconShapeData108, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData108FMTownsProvider },
	{ kEoB2ItemIconShapeData109, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData109FMTownsProvider },
	{ kEoB2ItemIconShapeData110, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData110FMTownsProvider },
	{ kEoB2ItemIconShapeData111, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ItemIconShapeData111FMTownsProvider },
	{ kEoB2LargeItemsShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData00FMTownsProvider },
	{ kEoB2LargeItemsShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData01FMTownsProvider },
	{ kEoB2LargeItemsShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData02FMTownsProvider },
	{ kEoB2LargeItemsShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData03FMTownsProvider },
	{ kEoB2LargeItemsShapeData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData04FMTownsProvider },
	{ kEoB2LargeItemsShapeData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData05FMTownsProvider },
	{ kEoB2LargeItemsShapeData06, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData06FMTownsProvider },
	{ kEoB2LargeItemsShapeData07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData07FMTownsProvider },
	{ kEoB2LargeItemsShapeData08, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData08FMTownsProvider },
	{ kEoB2LargeItemsShapeData09, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData09FMTownsProvider },
	{ kEoB2LargeItemsShapeData10, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LargeItemsShapeData10FMTownsProvider },
	{ kEoB2SmallItemsShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData00FMTownsProvider },
	{ kEoB2SmallItemsShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData01FMTownsProvider },
	{ kEoB2SmallItemsShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData02FMTownsProvider },
	{ kEoB2SmallItemsShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData03FMTownsProvider },
	{ kEoB2SmallItemsShapeData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData04FMTownsProvider },
	{ kEoB2SmallItemsShapeData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData05FMTownsProvider },
	{ kEoB2SmallItemsShapeData06, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData06FMTownsProvider },
	{ kEoB2SmallItemsShapeData07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData07FMTownsProvider },
	{ kEoB2SmallItemsShapeData08, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData08FMTownsProvider },
	{ kEoB2SmallItemsShapeData09, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData09FMTownsProvider },
	{ kEoB2SmallItemsShapeData10, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData10FMTownsProvider },
	{ kEoB2SmallItemsShapeData11, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData11FMTownsProvider },
	{ kEoB2SmallItemsShapeData12, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData12FMTownsProvider },
	{ kEoB2SmallItemsShapeData13, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData13FMTownsProvider },
	{ kEoB2SmallItemsShapeData14, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData14FMTownsProvider },
	{ kEoB2SmallItemsShapeData15, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData15FMTownsProvider },
	{ kEoB2SmallItemsShapeData16, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData16FMTownsProvider },
	{ kEoB2SmallItemsShapeData17, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData17FMTownsProvider },
	{ kEoB2SmallItemsShapeData18, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData18FMTownsProvider },
	{ kEoB2SmallItemsShapeData19, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData19FMTownsProvider },
	{ kEoB2SmallItemsShapeData20, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData20FMTownsProvider },
	{ kEoB2SmallItemsShapeData21, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData21FMTownsProvider },
	{ kEoB2SmallItemsShapeData22, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData22FMTownsProvider },
	{ kEoB2SmallItemsShapeData23, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData23FMTownsProvider },
	{ kEoB2SmallItemsShapeData24, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData24FMTownsProvider },
	{ kEoB2SmallItemsShapeData25, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallItemsShapeData25FMTownsProvider },
	{ kEoB2ThrownShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData00FMTownsProvider },
	{ kEoB2ThrownShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData01FMTownsProvider },
	{ kEoB2ThrownShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData02FMTownsProvider },
	{ kEoB2ThrownShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData03FMTownsProvider },
	{ kEoB2ThrownShapeData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData04FMTownsProvider },
	{ kEoB2ThrownShapeData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData05FMTownsProvider },
	{ kEoB2ThrownShapeData06, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData06FMTownsProvider },
	{ kEoB2ThrownShapeData07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData07FMTownsProvider },
	{ kEoB2ThrownShapeData08, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2ThrownShapeData08FMTownsProvider },
	{ kEoB2SpellShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SpellShapeData00FMTownsProvider },
	{ kEoB2SpellShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SpellShapeData01FMTownsProvider },
	{ kEoB2SpellShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SpellShapeData02FMTownsProvider },
	{ kEoB2SpellShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SpellShapeData03FMTownsProvider },
	{ kEoB2TeleporterShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2TeleporterShapeData00FMTownsProvider },
	{ kEoB2TeleporterShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2TeleporterShapeData01FMTownsProvider },
	{ kEoB2TeleporterShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2TeleporterShapeData02FMTownsProvider },
	{ kEoB2TeleporterShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2TeleporterShapeData03FMTownsProvider },
	{ kEoB2TeleporterShapeData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2TeleporterShapeData04FMTownsProvider },
	{ kEoB2TeleporterShapeData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2TeleporterShapeData05FMTownsProvider },
	{ kEoB2LightningColumnShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2LightningColumnShapeDataFMTownsProvider },
	{ kEoB2DeadCharShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DeadCharShapeDataFMTownsProvider },
	{ kEoB2DisabledCharGridShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2DisabledCharGridShapeDataFMTownsProvider },
	{ kEoB2WeaponSlotGridShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WeaponSlotGridShapeDataFMTownsProvider },
	{ kEoB2SmallGridShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SmallGridShapeDataFMTownsProvider },
	{ kEoB2WideGridShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WideGridShapeDataFMTownsProvider },
	{ kEoB2RedSplatShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2RedSplatShapeDataFMTownsProvider },
	{ kEoB2GreenSplatShapeData, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2GreenSplatShapeDataFMTownsProvider },
	{ kEoB2FirebeamShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FirebeamShapeData00FMTownsProvider },
	{ kEoB2FirebeamShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FirebeamShapeData01FMTownsProvider },
	{ kEoB2FirebeamShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FirebeamShapeData02FMTownsProvider },
	{ kEoB2SparkShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkShapeData00FMTownsProvider },
	{ kEoB2SparkShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkShapeData01FMTownsProvider },
	{ kEoB2SparkShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2SparkShapeData02FMTownsProvider },
	{ kEoB2CompassShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData00FMTownsProvider },
	{ kEoB2CompassShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData01FMTownsProvider },
	{ kEoB2CompassShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData02FMTownsProvider },
	{ kEoB2CompassShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData03FMTownsProvider },
	{ kEoB2CompassShapeData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData04FMTownsProvider },
	{ kEoB2CompassShapeData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData05FMTownsProvider },
	{ kEoB2CompassShapeData06, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData06FMTownsProvider },
	{ kEoB2CompassShapeData07, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData07FMTownsProvider },
	{ kEoB2CompassShapeData08, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData08FMTownsProvider },
	{ kEoB2CompassShapeData09, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData09FMTownsProvider },
	{ kEoB2CompassShapeData10, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData10FMTownsProvider },
	{ kEoB2CompassShapeData11, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2CompassShapeData11FMTownsProvider },
	{ kEoB2WallOfForceShapeData00, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShapeData00FMTownsProvider },
	{ kEoB2WallOfForceShapeData01, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShapeData01FMTownsProvider },
	{ kEoB2WallOfForceShapeData02, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShapeData02FMTownsProvider },
	{ kEoB2WallOfForceShapeData03, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShapeData03FMTownsProvider },
	{ kEoB2WallOfForceShapeData04, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShapeData04FMTownsProvider },
	{ kEoB2WallOfForceShapeData05, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShapeData05FMTownsProvider },
	{ kEoB2UtilMenuStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2UtilMenuStringsFMTownsJapaneseProvider },
	{ kEoB2Config2431Strings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2Config2431StringsFMTownsJapaneseProvider },
	{ kEoBBaseTextInputCharacterLines, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2TextInputCharacterLinesFMTownsJapaneseProvider },
	{ kEoBBaseTextInputSelectStrings, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2TextInputSelectStringsFMTownsJapaneseProvider },
	{ kEoB2FontLookupTbl, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2FontLookupTblFMTownsProvider },
	{ kEoB2Ascii2SjisTables, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2Ascii2SjisTablesFMTownsProvider },
	{ kEoB2Ascii2SjisTables2, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2Ascii2SjisTables2FMTownsProvider },
	{ kEoBBaseSaveNamePatterns, kEoB2, kPlatformFMTowns, kNoSpecial, JA_JPN, &kEoB2SaveNamePatternsFMTownsJapaneseProvider },
	{ kEoB2PcmSoundEffectsIngame, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2PcmSoundEffectsIngameFMTownsProvider },
	{ kEoB2PcmSoundEffectsIntro, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2PcmSoundEffectsIntroFMTownsProvider },
	{ kEoB2PcmSoundEffectsFinale, kEoB2, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kEoB2PcmSoundEffectsFinaleFMTownsProvider },
	{ kEoBBaseNpcPresetsNames, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2NpcPresetsNamesPC98JapaneseProvider },
	{ kEoBBaseChargenStrings1, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ChargenStrings1PC98JapaneseProvider },
	{ kEoBBaseChargenStrings2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ChargenStrings2PC98JapaneseProvider },
	{ kEoBBaseChargenStartLevels, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ChargenStartLevelsPC98Provider },
	{ kEoBBaseChargenStatStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ChargenStatStringsPC98JapaneseProvider },
	{ kEoBBaseChargenRaceSexStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ChargenRaceSexStringsPC98JapaneseProvider },
	{ kEoBBaseChargenClassStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ChargenClassStringsPC98JapaneseProvider },
	{ kEoBBaseChargenAlignmentStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ChargenAlignmentStringsPC98JapaneseProvider },
	{ kEoBBaseChargenEnterGameStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ChargenEnterGameStringsPC98JapaneseProvider },
	{ kEoBBaseChargenClassMinStats, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ChargenClassMinStatsPC98Provider },
	{ kEoBBaseChargenRaceMinStats, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMinStatsPC98Provider },
	{ kEoBBaseChargenRaceMaxStats, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ChargenRaceMaxStatsPC98Provider },
	{ kEoBBaseSaveThrowTable1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable1PC98Provider },
	{ kEoBBaseSaveThrowTable2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable2PC98Provider },
	{ kEoBBaseSaveThrowTable3, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable3PC98Provider },
	{ kEoBBaseSaveThrowTable4, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SaveThrowTable4PC98Provider },
	{ kEoBBaseSaveThrwLvlIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SaveThrwLvlIndexPC98Provider },
	{ kEoBBaseSaveThrwModDiv, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModDivPC98Provider },
	{ kEoBBaseSaveThrwModExt, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SaveThrwModExtPC98Provider },
	{ kEoBBasePryDoorStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2PryDoorStringsPC98JapaneseProvider },
	{ kEoBBaseWarningStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2WarningStringsPC98JapaneseProvider },
	{ kEoBBaseItemSuffixStringsRings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ItemSuffixStringsRingsPC98JapaneseProvider },
	{ kEoBBaseItemSuffixStringsPotions, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ItemSuffixStringsPotionsPC98JapaneseProvider },
	{ kEoBBaseItemSuffixStringsWands, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ItemSuffixStringsWandsPC98JapaneseProvider },
	{ kEoBBaseRipItemStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2RipItemStringsPC98JapaneseProvider },
	{ kEoBBaseCursedString, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CursedStringPC98JapaneseProvider },
	{ kEoBBaseEnchantedString, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2EnchantedStringPC98Provider },
	{ kEoBBaseMagicObjectStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicObjectStringsPC98JapaneseProvider },
	{ kEoBBaseMagicObjectString5, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicObjectString5PC98JapaneseProvider },
	{ kEoBBasePatternSuffix, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2PatternSuffixPC98JapaneseProvider },
	{ kEoBBasePatternGrFix1, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2PatternGrFix1PC98JapaneseProvider },
	{ kEoBBasePatternGrFix2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2PatternGrFix2PC98JapaneseProvider },
	{ kEoBBaseValidateArmorString, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ValidateArmorStringPC98JapaneseProvider },
	{ kEoBBaseValidateCursedString, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ValidateCursedStringPC98JapaneseProvider },
	{ kEoBBaseValidateNoDropString, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ValidateNoDropStringPC98JapaneseProvider },
	{ kEoBBasePotionStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2PotionStringsPC98JapaneseProvider },
	{ kEoBBaseWandStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2WandStringsPC98JapaneseProvider },
	{ kEoBBaseItemMisuseStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ItemMisuseStringsPC98JapaneseProvider },
	{ kEoBBaseTakenStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2TakenStringsPC98JapaneseProvider },
	{ kEoBBasePotionEffectStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2PotionEffectStringsPC98JapaneseProvider },
	{ kEoBBaseYesNoStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2YesNoStringsPC98JapaneseProvider },
	{ kRpgCommonMoreStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MoreStringsPC98JapaneseProvider },
	{ kEoBBaseNpcMaxStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2NpcMaxStringsPC98JapaneseProvider },
	{ kEoBBaseOkStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2OkStringsPC98JapaneseProvider },
	{ kEoBBaseNpcJoinStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2NpcJoinStringsPC98JapaneseProvider },
	{ kEoBBaseCancelStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CancelStringsPC98JapaneseProvider },
	{ kEoBBaseAbortStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2AbortStringsPC98JapaneseProvider },
	{ kEoBBaseMenuStringsMain, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsMainPC98JapaneseProvider },
	{ kEoBBaseMenuStringsSaveLoad, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsSaveLoadPC98JapaneseProvider },
	{ kEoBBaseMenuStringsOnOff, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsOnOffPC98JapaneseProvider },
	{ kEoBBaseMenuStringsSpells, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsSpellsPC98JapaneseProvider },
	{ kEoBBaseMenuStringsRest, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsRestPC98JapaneseProvider },
	{ kEoBBaseMenuStringsDrop, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsDropPC98JapaneseProvider },
	{ kEoBBaseMenuStringsExit, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsExitPC98JapaneseProvider },
	{ kEoBBaseMenuStringsStarve, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsStarvePC98JapaneseProvider },
	{ kEoBBaseMenuStringsScribe, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsScribePC98JapaneseProvider },
	{ kEoBBaseMenuStringsDrop2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsDrop2PC98JapaneseProvider },
	{ kEoBBaseMenuStringsHead, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsHeadPC98JapaneseProvider },
	{ kEoBBaseMenuStringsPoison, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsPoisonPC98JapaneseProvider },
	{ kEoBBaseMenuStringsMgc, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsMgcPC98JapaneseProvider },
	{ kEoBBaseMenuStringsPrefs, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsPrefsPC98JapaneseProvider },
	{ kEoBBaseMenuStringsRest2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsRest2PC98JapaneseProvider },
	{ kEoBBaseMenuStringsRest3, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsRest3PC98JapaneseProvider },
	{ kEoBBaseMenuStringsRest4, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsRest4PC98JapaneseProvider },
	{ kEoBBaseMenuStringsDefeat, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsDefeatPC98JapaneseProvider },
	{ kEoBBaseMenuStringsTransfer, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsTransferPC98JapaneseProvider },
	{ kEoBBaseMenuStringsSpec, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuStringsSpecPC98JapaneseProvider },
	{ kEoBBaseMenuStringsSpellNo, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MenuStringsSpellNoPC98Provider },
	{ kEoBBaseMenuYesNoStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MenuYesNoStringsPC98JapaneseProvider },
	{ kEoBBaseSpellLevelsMage, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsMagePC98Provider },
	{ kEoBBaseSpellLevelsCleric, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SpellLevelsClericPC98Provider },
	{ kEoBBaseNumSpellsCleric, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2NumSpellsClericPC98Provider },
	{ kEoBBaseNumSpellsWisAdj, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2NumSpellsWisAdjPC98Provider },
	{ kEoBBaseNumSpellsPal, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2NumSpellsPalPC98Provider },
	{ kEoBBaseNumSpellsMage, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2NumSpellsMagePC98Provider },
	{ kEoBBaseCharGuiStringsHp, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsHpPC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsWp2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsWp2PC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsWr, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsWrPC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsSt2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsSt2PC98JapaneseProvider },
	{ kEoBBaseCharGuiStringsIn, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharGuiStringsInPC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings7, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings7PC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings82, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings82PC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings9, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings9PC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings12, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings12PC98JapaneseProvider },
	{ kEoBBaseCharStatusStrings132, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2CharStatusStrings132PC98JapaneseProvider },
	{ kEoBBaseLevelGainStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2LevelGainStringsPC98JapaneseProvider },
	{ kEoBBaseExperienceTable0, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable0PC98Provider },
	{ kEoBBaseExperienceTable1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable1PC98Provider },
	{ kEoBBaseExperienceTable2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable2PC98Provider },
	{ kEoBBaseExperienceTable3, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable3PC98Provider },
	{ kEoBBaseExperienceTable4, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExperienceTable4PC98Provider },
	{ kEoBBaseBookNumbers, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2BookNumbersPC98JapaneseProvider },
	{ kEoBBaseMageSpellsList, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MageSpellsListPC98JapaneseProvider },
	{ kEoBBaseClericSpellsList, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2ClericSpellsListPC98JapaneseProvider },
	{ kEoBBaseSpellNames, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2SpellNamesPC98JapaneseProvider },
	{ kEoBBaseMagicStrings1, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicStrings1PC98JapaneseProvider },
	{ kEoBBaseMagicStrings2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicStrings2PC98JapaneseProvider },
	{ kEoBBaseMagicStrings3, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicStrings3PC98JapaneseProvider },
	{ kEoBBaseMagicStrings4, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicStrings4PC98JapaneseProvider },
	{ kEoBBaseMagicStrings6, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicStrings6PC98JapaneseProvider },
	{ kEoBBaseMagicStrings7, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicStrings7PC98JapaneseProvider },
	{ kEoBBaseMagicStrings8, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MagicStrings8PC98JapaneseProvider },
	{ kEoBBaseExpObjectTlMode, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTlModePC98Provider },
	{ kEoBBaseExpObjectTblIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTblIndexPC98Provider },
	{ kEoBBaseExpObjectShpStart, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExpObjectShpStartPC98Provider },
	{ kEoBBaseExpObjectTbl1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl1PC98Provider },
	{ kEoBBaseExpObjectTbl2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl2PC98Provider },
	{ kEoBBaseExpObjectTbl3, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExpObjectTbl3PC98Provider },
	{ kEoBBaseExpObjectY, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ExpObjectYPC98Provider },
	{ kEoBBaseSparkDefSteps, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkDefStepsPC98Provider },
	{ kEoBBaseSparkDefSubSteps, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkDefSubStepsPC98Provider },
	{ kEoBBaseSparkDefShift, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkDefShiftPC98Provider },
	{ kEoBBaseSparkDefAdd, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkDefAddPC98Provider },
	{ kEoBBaseSparkDefX, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkDefXPC98Provider },
	{ kEoBBaseSparkDefY, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkDefYPC98Provider },
	{ kEoBBaseSparkOfFlags1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags1PC98Provider },
	{ kEoBBaseSparkOfFlags2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkOfFlags2PC98Provider },
	{ kEoBBaseSparkOfShift, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkOfShiftPC98Provider },
	{ kEoBBaseSparkOfX, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkOfXPC98Provider },
	{ kEoBBaseSparkOfY, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SparkOfYPC98Provider },
	{ kEoBBaseSpellProperties, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SpellPropertiesPC98Provider },
	{ kEoBBaseMagicFlightProps, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MagicFlightPropsPC98Provider },
	{ kEoBBaseTurnUndeadEffect, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2TurnUndeadEffectPC98Provider },
	{ kEoBBaseBurningHandsDest, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2BurningHandsDestPC98Provider },
	{ kEoBBaseConeOfColdDest1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest1PC98Provider },
	{ kEoBBaseConeOfColdDest2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest2PC98Provider },
	{ kEoBBaseConeOfColdDest3, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest3PC98Provider },
	{ kEoBBaseConeOfColdDest4, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdDest4PC98Provider },
	{ kEoBBaseConeOfColdGfxTbl, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ConeOfColdGfxTblPC98Provider },
	{ kRpgCommonDscDoorShapeIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorShapeIndexPC98Provider },
	{ kEoBBaseWllFlagPreset, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2WllFlagPresetPC98Provider },
	{ kEoBBaseDscShapeCoords, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscShapeCoordsPC98Provider },
	{ kRpgCommonDscDoorScaleOffs, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleOffsPC98Provider },
	{ kEoBBaseDscDoorScaleMult1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult1PC98Provider },
	{ kEoBBaseDscDoorScaleMult2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult2PC98Provider },
	{ kEoBBaseDscDoorScaleMult3, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorScaleMult3PC98Provider },
	{ kEoBBaseDscDoorType5Offs, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorType5OffsPC98Provider },
	{ kEoBBaseDscDoorY1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorY1PC98Provider },
	{ kRpgCommonDscDoorY2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorY2PC98Provider },
	{ kRpgCommonDscDoorFrameY1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY1PC98Provider },
	{ kRpgCommonDscDoorFrameY2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDoorFrameY2PC98Provider },
	{ kEoBBaseDscItemPosIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscItemPosIndexPC98Provider },
	{ kEoBBaseDscItemShpX, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscItemShpXPC98Provider },
	{ kEoBBaseDscItemScaleIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscItemScaleIndexPC98Provider },
	{ kEoBBaseDscItemTileIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscItemTileIndexPC98Provider },
	{ kEoBBaseDscItemShapeMap, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscItemShapeMapPC98Provider },
	{ kEoBBaseDscTelptrShpCoords, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscTelptrShpCoordsPC98Provider },
	{ kEoBBasePortalSeqData, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2PortalSeqDataPC98Provider },
	{ kEoBBaseDscMonsterFrmOffsTbl1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl1PC98Provider },
	{ kEoBBaseDscMonsterFrmOffsTbl2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscMonsterFrmOffsTbl2PC98Provider },
	{ kEoBBaseInvSlotX, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2InvSlotXPC98Provider },
	{ kEoBBaseInvSlotY, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2InvSlotYPC98Provider },
	{ kEoBBaseSlotValidationFlags, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SlotValidationFlagsPC98Provider },
	{ kEoBBaseProjectileWeaponTypes, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ProjectileWeaponTypesPC98Provider },
	{ kEoBBaseWandTypes, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2WandTypesPC98Provider },
	{ kEoBBaseDrawObjPosIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DrawObjPosIndexPC98Provider },
	{ kEoBBaseFlightObjFlipIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FlightObjFlipIndexPC98Provider },
	{ kEoBBaseFlightObjShpMap, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FlightObjShpMapPC98Provider },
	{ kEoBBaseFlightObjSclIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FlightObjSclIndexPC98Provider },
	{ kEoB2MainMenuStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MainMenuStringsPC98JapaneseProvider },
	{ kEoB2TransferPortraitFrames, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2TransferPortraitFramesPC98Provider },
	{ kEoB2TransferConvertTable, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2TransferConvertTablePC98Provider },
	{ kEoB2TransferItemTable, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2TransferItemTablePC98Provider },
	{ kEoB2TransferExpTable, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2TransferExpTablePC98Provider },
	{ kEoB2TransferStrings1, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2TransferStrings1PC98JapaneseProvider },
	{ kEoB2TransferStrings2, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2TransferStrings2PC98JapaneseProvider },
	{ kEoB2TransferLabels, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2TransferLabelsPC98JapaneseProvider },
	{ kEoB2IntroStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2IntroStringsPC98JapaneseProvider },
	{ kEoB2IntroCPSFiles, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2IntroCPSFilesPC98JapaneseProvider },
	{ kEoB2IntroAnimData00, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData00PC98Provider },
	{ kEoB2IntroAnimData01, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData01PC98Provider },
	{ kEoB2IntroAnimData02, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData02PC98Provider },
	{ kEoB2IntroAnimData03, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData03PC98Provider },
	{ kEoB2IntroAnimData04, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData04PC98Provider },
	{ kEoB2IntroAnimData05, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData05PC98Provider },
	{ kEoB2IntroAnimData06, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData06PC98Provider },
	{ kEoB2IntroAnimData07, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData07PC98Provider },
	{ kEoB2IntroAnimData08, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData08PC98Provider },
	{ kEoB2IntroAnimData09, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData09PC98Provider },
	{ kEoB2IntroAnimData10, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData10PC98Provider },
	{ kEoB2IntroAnimData11, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData11PC98Provider },
	{ kEoB2IntroAnimData12, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData12PC98Provider },
	{ kEoB2IntroAnimData13, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData13PC98Provider },
	{ kEoB2IntroAnimData14, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData14PC98Provider },
	{ kEoB2IntroAnimData15, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData15PC98Provider },
	{ kEoB2IntroAnimData16, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData16PC98Provider },
	{ kEoB2IntroAnimData17, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData17PC98Provider },
	{ kEoB2IntroAnimData18, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData18PC98Provider },
	{ kEoB2IntroAnimData19, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData19PC98Provider },
	{ kEoB2IntroAnimData20, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData20PC98Provider },
	{ kEoB2IntroAnimData21, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData21PC98Provider },
	{ kEoB2IntroAnimData22, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData22PC98Provider },
	{ kEoB2IntroAnimData23, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData23PC98Provider },
	{ kEoB2IntroAnimData24, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData24PC98Provider },
	{ kEoB2IntroAnimData25, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData25PC98Provider },
	{ kEoB2IntroAnimData26, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData26PC98Provider },
	{ kEoB2IntroAnimData27, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData27PC98Provider },
	{ kEoB2IntroAnimData28, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData28PC98Provider },
	{ kEoB2IntroAnimData29, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData29PC98Provider },
	{ kEoB2IntroAnimData30, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData30PC98Provider },
	{ kEoB2IntroAnimData31, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData31PC98Provider },
	{ kEoB2IntroAnimData32, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData32PC98Provider },
	{ kEoB2IntroAnimData33, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData33PC98Provider },
	{ kEoB2IntroAnimData34, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData34PC98Provider },
	{ kEoB2IntroAnimData35, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData35PC98Provider },
	{ kEoB2IntroAnimData36, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData36PC98Provider },
	{ kEoB2IntroAnimData37, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData37PC98Provider },
	{ kEoB2IntroAnimData38, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData38PC98Provider },
	{ kEoB2IntroAnimData39, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData39PC98Provider },
	{ kEoB2IntroAnimData40, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData40PC98Provider },
	{ kEoB2IntroAnimData41, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData41PC98Provider },
	{ kEoB2IntroAnimData42, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData42PC98Provider },
	{ kEoB2IntroAnimData43, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData43PC98Provider },
	{ kEoB2IntroAnimData44, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData44PC98Provider },
	{ kEoB2IntroAnimData45, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData45PC98Provider },
	{ kEoB2IntroAnimData46, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData46PC98Provider },
	{ kEoB2IntroAnimData47, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroAnimData47PC98Provider },
	{ kEoB2IntroShapes00, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroShapes00PC98Provider },
	{ kEoB2IntroShapes01, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroShapes01PC98Provider },
	{ kEoB2IntroShapes04, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroShapes04PC98Provider },
	{ kEoB2IntroShapes07, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroShapes07PC98Provider },
	{ kEoB2IntroShapes13, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2IntroShapes13PC98Provider },
	{ kEoB2FinaleStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2FinaleStringsPC98JapaneseProvider },
	{ kEoB2FinaleCPSFiles, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2FinaleCPSFilesPC98JapaneseProvider },
	{ kEoB2FinaleAnimData00, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData00PC98Provider },
	{ kEoB2FinaleAnimData01, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData01PC98Provider },
	{ kEoB2FinaleAnimData02, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData02PC98Provider },
	{ kEoB2FinaleAnimData03, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData03PC98Provider },
	{ kEoB2FinaleAnimData04, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData04PC98Provider },
	{ kEoB2FinaleAnimData05, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData05PC98Provider },
	{ kEoB2FinaleAnimData06, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData06PC98Provider },
	{ kEoB2FinaleAnimData07, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData07PC98Provider },
	{ kEoB2FinaleAnimData08, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData08PC98Provider },
	{ kEoB2FinaleAnimData09, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData09PC98Provider },
	{ kEoB2FinaleAnimData10, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData10PC98Provider },
	{ kEoB2FinaleAnimData11, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData11PC98Provider },
	{ kEoB2FinaleAnimData12, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData12PC98Provider },
	{ kEoB2FinaleAnimData13, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData13PC98Provider },
	{ kEoB2FinaleAnimData14, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData14PC98Provider },
	{ kEoB2FinaleAnimData15, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData15PC98Provider },
	{ kEoB2FinaleAnimData16, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData16PC98Provider },
	{ kEoB2FinaleAnimData17, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData17PC98Provider },
	{ kEoB2FinaleAnimData18, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData18PC98Provider },
	{ kEoB2FinaleAnimData19, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData19PC98Provider },
	{ kEoB2FinaleAnimData20, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleAnimData20PC98Provider },
	{ kEoB2FinaleShapes00, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes00PC98Provider },
	{ kEoB2FinaleShapes03, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes03PC98Provider },
	{ kEoB2FinaleShapes07, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes07PC98Provider },
	{ kEoB2FinaleShapes09, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes09PC98Provider },
	{ kEoB2FinaleShapes10, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FinaleShapes10PC98Provider },
	{ kEoB2NpcShapeData, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2NpcShapeDataPC98Provider },
	{ kEoBBaseClassModifierFlags, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2ClassModifierFlagsPC98Provider },
	{ kEoBBaseMonsterStepTable02, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable02PC98Provider },
	{ kEoBBaseMonsterStepTable1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable1PC98Provider },
	{ kEoBBaseMonsterStepTable2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable2PC98Provider },
	{ kEoBBaseMonsterStepTable3, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterStepTable3PC98Provider },
	{ kEoBBaseMonsterCloseAttPosTable1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable1PC98Provider },
	{ kEoBBaseMonsterCloseAttPosTable22, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttPosTable22PC98Provider },
	{ kEoBBaseMonsterCloseAttUnkTable, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttUnkTablePC98Provider },
	{ kEoBBaseMonsterCloseAttChkTable1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable1PC98Provider },
	{ kEoBBaseMonsterCloseAttChkTable2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttChkTable2PC98Provider },
	{ kEoBBaseMonsterCloseAttDstTable1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable1PC98Provider },
	{ kEoBBaseMonsterCloseAttDstTable2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterCloseAttDstTable2PC98Provider },
	{ kEoBBaseMonsterProximityTable, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterProximityTablePC98Provider },
	{ kEoBBaseFindBlockMonstersTable, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FindBlockMonstersTablePC98Provider },
	{ kEoBBaseMonsterDirChangeTable, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2MonsterDirChangeTablePC98Provider },
	{ kEoBBaseMonsterDistAttStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MonsterDistAttStringsPC98JapaneseProvider },
	{ kEoBBaseEncodeMonsterDefs, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2EncodeMonsterDefsPC98Provider },
	{ kEoBBaseNpcPresets, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2NpcPresetsPC98Provider },
	{ kEoBBaseSoundFilesIntro, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SoundFilesIntroPC98Provider },
	{ kEoBBaseSoundFilesFinale, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2SoundFilesFinalePC98Provider },
	{ kEoB2Npc1Strings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2Npc1StringsPC98JapaneseProvider },
	{ kEoB2Npc2Strings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2Npc2StringsPC98JapaneseProvider },
	{ kEoB2MonsterDustStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2MonsterDustStringsPC98JapaneseProvider },
	{ kEoB2DreamSteps, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DreamStepsPC98Provider },
	{ kEoB2KheldranStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2KheldranStringsPC98JapaneseProvider },
	{ kEoB2HornStrings, kEoB2, kPlatformPC98, kNoSpecial, JA_JPN, &kEoB2HornStringsPC98JapaneseProvider },
	{ kEoB2HornSounds, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2HornSoundsPC98Provider },
	{ kEoB2WallOfForceDsX, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsXPC98Provider },
	{ kEoB2WallOfForceDsY, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2WallOfForceDsYPC98Provider },
	{ kEoB2WallOfForceNumW, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumWPC98Provider },
	{ kEoB2WallOfForceNumH, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2WallOfForceNumHPC98Provider },
	{ kEoB2WallOfForceShpId, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2WallOfForceShpIdPC98Provider },
	{ kRpgCommonDscShapeIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscShapeIndexPC98Provider },
	{ kRpgCommonDscX, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscXPC98Provider },
	{ kRpgCommonDscTileIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscTileIndexPC98Provider },
	{ kRpgCommonDscDimData1, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDimData1PC98Provider },
	{ kRpgCommonDscDimData2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDimData2PC98Provider },
	{ kRpgCommonDscBlockMap, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscBlockMapPC98Provider },
	{ kRpgCommonDscDimMap, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscDimMapPC98Provider },
	{ kRpgCommonDscBlockIndex, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2DscBlockIndexPC98Provider },
	{ kEoB2Ascii2SjisTables, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2Ascii2SjisTablesPC98Provider },
	{ kEoB2Ascii2SjisTables2, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2Ascii2SjisTables2PC98Provider },
	{ kEoB2FontConvertTbl, kEoB2, kPlatformPC98, kNoSpecial, UNK_LANG, &kEoB2FontConvertTblPC98Provider },
	{ kLoLIngamePakFiles, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngamePakFilesDOSProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, EN_ANY, &kLoLCharacterDefsDOSEnglishProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameSfxFilesDOSProvider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameSfxIndexDOSProvider },
	{ kLoLMusicTrackMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMusicTrackMapDOSProvider },
	{ kLoLIngameGMSfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameGMSfxIndexDOSProvider },
	{ kLoLIngameMT32SfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngameMT32SfxIndexDOSProvider },
	{ kLoLIngamePcSpkSfxIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLIngamePcSpkSfxIndexDOSProvider },
	{ kLoLSpellProperties, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSpellPropertiesDOSProvider },
	{ kLoLGameShapeMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLGameShapeMapDOSProvider },
	{ kLoLSceneItemOffs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSceneItemOffsDOSProvider },
	{ kLoLCharInvIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharInvIndexDOSProvider },
	{ kLoLCharInvDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharInvDefsDOSProvider },
	{ kLoLCharDefsMan, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsManDOSProvider },
	{ kLoLCharDefsWoman, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsWomanDOSProvider },
	{ kLoLCharDefsKieran, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsKieranDOSProvider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCharDefsAkshelDOSProvider },
	{ kLoLExpRequirements, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLExpRequirementsDOSProvider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers1DOSProvider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers2DOSProvider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers3DOSProvider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterShiftOffsetsDOSProvider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterDirFlagsDOSProvider },
	{ kLoLMonsterScaleY, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterScaleYDOSProvider },
	{ kLoLMonsterScaleX, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterScaleXDOSProvider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMonsterScaleWHDOSProvider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLFlyingObjectShpDOSProvider },
	{ kLoLInventoryDesc, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLInventoryDescDOSProvider },
	{ kLoLLevelShpList, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLevelShpListDOSProvider },
	{ kLoLLevelDatList, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLevelDatListDOSProvider },
	{ kLoLCompassDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLCompassDefsDOSProvider },
	{ kLoLStashSetup, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLStashSetupDOSProvider },
	{ kLoLDscWalls, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscWallsDOSProvider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscShapeIndexDOSProvider },
	{ kLoLDscOvlMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscOvlMapDOSProvider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscScaleWidthDataDOSProvider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscScaleHeightDataDOSProvider },
	{ kRpgCommonDscX, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscXDOSProvider },
	{ kLoLBaseDscY, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLBaseDscYDOSProvider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscTileIndexDOSProvider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorShapeIndexDOSProvider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDimData1DOSProvider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDimData2DOSProvider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscBlockMapDOSProvider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDimMapDOSProvider },
	{ kLoLDscOvlIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscOvlIndexDOSProvider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscBlockIndexDOSProvider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorY2DOSProvider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY1DOSProvider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY2DOSProvider },
	{ kRpgCommonDscDoorScaleOffs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorScaleOffsDOSProvider },
	{ kLoLDscDoorScale, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorScaleDOSProvider },
	{ kLoLDscDoor4, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoor4DOSProvider },
	{ kLoLDscDoorX, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorXDOSProvider },
	{ kLoLDscDoorY, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLDscDoorYDOSProvider },
	{ kLoLScrollXTop, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollXTopDOSProvider },
	{ kLoLScrollYTop, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollYTopDOSProvider },
	{ kLoLScrollXBottom, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollXBottomDOSProvider },
	{ kLoLScrollYBottom, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLScrollYBottomDOSProvider },
	{ kLoLButtonDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonDefsDOSProvider },
	{ kLoLButtonList1, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList1DOSProvider },
	{ kLoLButtonList2, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList2DOSProvider },
	{ kLoLButtonList3, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList3DOSProvider },
	{ kLoLButtonList4, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList4DOSProvider },
	{ kLoLButtonList5, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList5DOSProvider },
	{ kLoLButtonList6, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList6DOSProvider },
	{ kLoLButtonList7, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList7DOSProvider },
	{ kLoLButtonList8, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLButtonList8DOSProvider },
	{ kLoLLegendData, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLegendDataDOSProvider },
	{ kLoLMapCursorOvl, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMapCursorOvlDOSProvider },
	{ kLoLMapStringId, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLMapStringIdDOSProvider },
	{ kLoLSpellbookAnim, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSpellbookAnimDOSProvider },
	{ kLoLSpellbookCoords, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLSpellbookCoordsDOSProvider },
	{ kLoLHealShapeFrames, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLHealShapeFramesDOSProvider },
	{ kLoLLightningDefs, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLLightningDefsDOSProvider },
	{ kLoLFireballCoords, kLoL, kPlatformDOS, kNoSpecial, UNK_LANG, &kLoLFireballCoordsDOSProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, RU_RUS, &kLoLCharacterDefsDOSRussianProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, DE_DEU, &kLoLCharacterDefsDOSGermanProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, FR_FRA, &kLoLCharacterDefsDOSFrenchProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, ES_ESP, &kLoLCharacterDefsDOSSpanishProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kNoSpecial, ZH_TWN, &kLoLCharacterDefsDOSChineseProvider },
	{ k2FontData, kLoL, kPlatformDOS, kNoSpecial, EN_ANY, &k2FontDataDOSDummyProvider },
	{ k2FontData, kLoL, kPlatformDOS, kNoSpecial, RU_RUS, &k2FontDataDOSDummyProvider },
	{ k2FontData, kLoL, kPlatformDOS, kNoSpecial, DE_DEU, &k2FontDataDOSDummyProvider },
	{ k2FontData, kLoL, kPlatformDOS, kNoSpecial, FR_FRA, &k2FontDataDOSDummyProvider },
	{ k2FontData, kLoL, kPlatformDOS, kNoSpecial, ES_ESP, &k2FontDataDOSDummyProvider },
	{ k2FontData, kLoL, kPlatformDOS, kNoSpecial, ZH_TWN, &kLoLASCIIFontDOSChineseProvider },
	{ kLoLIngamePakFiles, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLIngamePakFilesPC98Provider },
	{ kLoLCharacterDefs, kLoL, kPlatformPC98, kNoSpecial, JA_JPN, &kLoLCharacterDefsPC98JapaneseProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLIngameSfxFilesPC98Provider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLIngameSfxIndexPC98Provider },
	{ kLoLSpellProperties, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSpellPropertiesPC98Provider },
	{ kLoLGameShapeMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLGameShapeMapPC98Provider },
	{ kLoLSceneItemOffs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSceneItemOffsPC98Provider },
	{ kLoLCharInvIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharInvIndexPC98Provider },
	{ kLoLCharInvDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharInvDefsPC98Provider },
	{ kLoLCharDefsMan, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsManPC98Provider },
	{ kLoLCharDefsWoman, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsWomanPC98Provider },
	{ kLoLCharDefsKieran, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsKieranPC98Provider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCharDefsAkshelPC98Provider },
	{ kLoLExpRequirements, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLExpRequirementsPC98Provider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers1PC98Provider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers2PC98Provider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers3PC98Provider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterShiftOffsetsPC98Provider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterDirFlagsPC98Provider },
	{ kLoLMonsterScaleY, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterScaleYPC98Provider },
	{ kLoLMonsterScaleX, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterScaleXPC98Provider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMonsterScaleWHPC98Provider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLFlyingObjectShpPC98Provider },
	{ kLoLInventoryDesc, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLInventoryDescPC98Provider },
	{ kLoLLevelShpList, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLevelShpListPC98Provider },
	{ kLoLLevelDatList, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLevelDatListPC98Provider },
	{ kLoLCompassDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCompassDefsPC98Provider },
	{ kLoLStashSetup, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLStashSetupPC98Provider },
	{ kLoLDscWalls, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscWallsPC98Provider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscShapeIndexPC98Provider },
	{ kLoLDscOvlMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscOvlMapPC98Provider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscScaleWidthDataPC98Provider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscScaleHeightDataPC98Provider },
	{ kRpgCommonDscX, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscXPC98Provider },
	{ kLoLBaseDscY, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLBaseDscYPC98Provider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscTileIndexPC98Provider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorShapeIndexPC98Provider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDimData1PC98Provider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDimData2PC98Provider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscBlockMapPC98Provider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDimMapPC98Provider },
	{ kLoLDscOvlIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscOvlIndexPC98Provider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscBlockIndexPC98Provider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorY2PC98Provider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY1PC98Provider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY2PC98Provider },
	{ kRpgCommonDscDoorScaleOffs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorScaleOffsPC98Provider },
	{ kLoLDscDoorScale, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorScalePC98Provider },
	{ kLoLDscDoor4, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoor4PC98Provider },
	{ kLoLDscDoorX, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorXPC98Provider },
	{ kLoLDscDoorY, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLDscDoorYPC98Provider },
	{ kLoLScrollXTop, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollXTopPC98Provider },
	{ kLoLScrollYTop, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollYTopPC98Provider },
	{ kLoLScrollXBottom, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollXBottomPC98Provider },
	{ kLoLScrollYBottom, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLScrollYBottomPC98Provider },
	{ kLoLButtonDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonDefsPC98Provider },
	{ kLoLButtonList1, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList1PC98Provider },
	{ kLoLButtonList2, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList2PC98Provider },
	{ kLoLButtonList3, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList3PC98Provider },
	{ kLoLButtonList4, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList4PC98Provider },
	{ kLoLButtonList5, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList5PC98Provider },
	{ kLoLButtonList6, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList6PC98Provider },
	{ kLoLButtonList7, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList7PC98Provider },
	{ kLoLButtonList8, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLButtonList8PC98Provider },
	{ kLoLLegendData, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLegendDataPC98Provider },
	{ kLoLMapStringId, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLMapStringIdPC98Provider },
	{ kLoLSpellbookAnim, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSpellbookAnimPC98Provider },
	{ kLoLSpellbookCoords, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLSpellbookCoordsPC98Provider },
	{ kLoLHealShapeFrames, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLHealShapeFramesPC98Provider },
	{ kLoLLightningDefs, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLLightningDefsPC98Provider },
	{ kLoLFireballCoords, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLFireballCoordsPC98Provider },
	{ kLoLCredits, kLoL, kPlatformPC98, kNoSpecial, UNK_LANG, &kLoLCreditsPC98Provider },
	{ kLoLIngamePakFiles, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLIngamePakFilesFMTownsProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformFMTowns, kNoSpecial, JA_JPN, &kLoLCharacterDefsFMTownsJapaneseProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLIngameSfxFilesFMTownsProvider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLIngameSfxIndexFMTownsProvider },
	{ kLoLSpellProperties, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSpellPropertiesFMTownsProvider },
	{ kLoLGameShapeMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLGameShapeMapFMTownsProvider },
	{ kLoLSceneItemOffs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSceneItemOffsFMTownsProvider },
	{ kLoLCharInvIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharInvIndexFMTownsProvider },
	{ kLoLCharInvDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharInvDefsFMTownsProvider },
	{ kLoLCharDefsMan, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsManFMTownsProvider },
	{ kLoLCharDefsWoman, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsWomanFMTownsProvider },
	{ kLoLCharDefsKieran, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsKieranFMTownsProvider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCharDefsAkshelFMTownsProvider },
	{ kLoLExpRequirements, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLExpRequirementsFMTownsProvider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers1FMTownsProvider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers2FMTownsProvider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterModifiers3FMTownsProvider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterShiftOffsetsFMTownsProvider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterDirFlagsFMTownsProvider },
	{ kLoLMonsterScaleY, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterScaleYFMTownsProvider },
	{ kLoLMonsterScaleX, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterScaleXFMTownsProvider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMonsterScaleWHFMTownsProvider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLFlyingObjectShpFMTownsProvider },
	{ kLoLInventoryDesc, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLInventoryDescFMTownsProvider },
	{ kLoLLevelShpList, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLevelShpListFMTownsProvider },
	{ kLoLLevelDatList, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLevelDatListFMTownsProvider },
	{ kLoLCompassDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCompassDefsFMTownsProvider },
	{ kLoLStashSetup, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLStashSetupFMTownsProvider },
	{ kLoLDscWalls, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscWallsFMTownsProvider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscShapeIndexFMTownsProvider },
	{ kLoLDscOvlMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscOvlMapFMTownsProvider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscScaleWidthDataFMTownsProvider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscScaleHeightDataFMTownsProvider },
	{ kRpgCommonDscX, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscXFMTownsProvider },
	{ kLoLBaseDscY, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLBaseDscYFMTownsProvider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscTileIndexFMTownsProvider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorShapeIndexFMTownsProvider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDimData1FMTownsProvider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDimData2FMTownsProvider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscBlockMapFMTownsProvider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDimMapFMTownsProvider },
	{ kLoLDscOvlIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscOvlIndexFMTownsProvider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscBlockIndexFMTownsProvider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorY2FMTownsProvider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY1FMTownsProvider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorFrameY2FMTownsProvider },
	{ kRpgCommonDscDoorScaleOffs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorScaleOffsFMTownsProvider },
	{ kLoLDscDoorScale, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorScaleFMTownsProvider },
	{ kLoLDscDoor4, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoor4FMTownsProvider },
	{ kLoLDscDoorX, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorXFMTownsProvider },
	{ kLoLDscDoorY, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLDscDoorYFMTownsProvider },
	{ kLoLScrollXTop, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollXTopFMTownsProvider },
	{ kLoLScrollYTop, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollYTopFMTownsProvider },
	{ kLoLScrollXBottom, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollXBottomFMTownsProvider },
	{ kLoLScrollYBottom, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLScrollYBottomFMTownsProvider },
	{ kLoLButtonDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonDefsFMTownsProvider },
	{ kLoLButtonList1, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList1FMTownsProvider },
	{ kLoLButtonList2, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList2FMTownsProvider },
	{ kLoLButtonList3, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList3FMTownsProvider },
	{ kLoLButtonList4, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList4FMTownsProvider },
	{ kLoLButtonList5, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList5FMTownsProvider },
	{ kLoLButtonList6, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList6FMTownsProvider },
	{ kLoLButtonList7, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList7FMTownsProvider },
	{ kLoLButtonList8, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLButtonList8FMTownsProvider },
	{ kLoLLegendData, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLegendDataFMTownsProvider },
	{ kLoLMapStringId, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLMapStringIdFMTownsProvider },
	{ kLoLSpellbookAnim, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSpellbookAnimFMTownsProvider },
	{ kLoLSpellbookCoords, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLSpellbookCoordsFMTownsProvider },
	{ kLoLHealShapeFrames, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLHealShapeFramesFMTownsProvider },
	{ kLoLLightningDefs, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLLightningDefsFMTownsProvider },
	{ kLoLFireballCoords, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLFireballCoordsFMTownsProvider },
	{ kLoLCredits, kLoL, kPlatformFMTowns, kNoSpecial, UNK_LANG, &kLoLCreditsFMTownsProvider },
	{ kLoLHistory, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLHistoryDOSCDProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, EN_ANY, &kLoLCharacterDefsDOSCDEnglishProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameSfxFilesDOSCDProvider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameSfxIndexDOSCDProvider },
	{ kLoLMusicTrackMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMusicTrackMapDOSCDProvider },
	{ kLoLIngameGMSfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameGMSfxIndexDOSCDProvider },
	{ kLoLIngameMT32SfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngameMT32SfxIndexDOSCDProvider },
	{ kLoLIngamePcSpkSfxIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLIngamePcSpkSfxIndexDOSCDProvider },
	{ kLoLSpellProperties, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSpellPropertiesDOSCDProvider },
	{ kLoLGameShapeMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLGameShapeMapDOSCDProvider },
	{ kLoLSceneItemOffs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSceneItemOffsDOSCDProvider },
	{ kLoLCharInvIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharInvIndexDOSCDProvider },
	{ kLoLCharInvDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharInvDefsDOSCDProvider },
	{ kLoLCharDefsMan, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsManDOSCDProvider },
	{ kLoLCharDefsWoman, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsWomanDOSCDProvider },
	{ kLoLCharDefsKieran, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsKieranDOSCDProvider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCharDefsAkshelDOSCDProvider },
	{ kLoLExpRequirements, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLExpRequirementsDOSCDProvider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers1DOSCDProvider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers2DOSCDProvider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers3DOSCDProvider },
	{ kLoLMonsterModifiers4, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterModifiers4DOSCDProvider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterShiftOffsetsDOSCDProvider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterDirFlagsDOSCDProvider },
	{ kLoLMonsterScaleY, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterScaleYDOSCDProvider },
	{ kLoLMonsterScaleX, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterScaleXDOSCDProvider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMonsterScaleWHDOSCDProvider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLFlyingObjectShpDOSCDProvider },
	{ kLoLInventoryDesc, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLInventoryDescDOSCDProvider },
	{ kLoLLevelShpList, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLevelShpListDOSCDProvider },
	{ kLoLLevelDatList, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLevelDatListDOSCDProvider },
	{ kLoLCompassDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLCompassDefsDOSCDProvider },
	{ kLoLItemPrices, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLItemPricesDOSCDProvider },
	{ kLoLStashSetup, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLStashSetupDOSCDProvider },
	{ kLoLDscWalls, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscWallsDOSCDProvider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscShapeIndexDOSCDProvider },
	{ kLoLDscOvlMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscOvlMapDOSCDProvider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscScaleWidthDataDOSCDProvider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscScaleHeightDataDOSCDProvider },
	{ kRpgCommonDscX, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscXDOSCDProvider },
	{ kLoLBaseDscY, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLBaseDscYDOSCDProvider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscTileIndexDOSCDProvider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorShapeIndexDOSCDProvider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDimData1DOSCDProvider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDimData2DOSCDProvider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscBlockMapDOSCDProvider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDimMapDOSCDProvider },
	{ kLoLDscOvlIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscOvlIndexDOSCDProvider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscBlockIndexDOSCDProvider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorY2DOSCDProvider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorFrameY1DOSCDProvider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorFrameY2DOSCDProvider },
	{ kRpgCommonDscDoorScaleOffs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorScaleOffsDOSCDProvider },
	{ kLoLDscDoorScale, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorScaleDOSCDProvider },
	{ kLoLDscDoor4, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoor4DOSCDProvider },
	{ kLoLDscDoorX, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorXDOSCDProvider },
	{ kLoLDscDoorY, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLDscDoorYDOSCDProvider },
	{ kLoLScrollXTop, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollXTopDOSCDProvider },
	{ kLoLScrollYTop, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollYTopDOSCDProvider },
	{ kLoLScrollXBottom, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollXBottomDOSCDProvider },
	{ kLoLScrollYBottom, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLScrollYBottomDOSCDProvider },
	{ kLoLButtonDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonDefsDOSCDProvider },
	{ kLoLButtonList1, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList1DOSCDProvider },
	{ kLoLButtonList2, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList2DOSCDProvider },
	{ kLoLButtonList3, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList3DOSCDProvider },
	{ kLoLButtonList4, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList4DOSCDProvider },
	{ kLoLButtonList5, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList5DOSCDProvider },
	{ kLoLButtonList6, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList6DOSCDProvider },
	{ kLoLButtonList7, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList7DOSCDProvider },
	{ kLoLButtonList8, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLButtonList8DOSCDProvider },
	{ kLoLLegendData, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLegendDataDOSCDProvider },
	{ kLoLMapCursorOvl, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMapCursorOvlDOSCDProvider },
	{ kLoLMapStringId, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLMapStringIdDOSCDProvider },
	{ kLoLSpellbookAnim, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSpellbookAnimDOSCDProvider },
	{ kLoLSpellbookCoords, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLSpellbookCoordsDOSCDProvider },
	{ kLoLHealShapeFrames, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLHealShapeFramesDOSCDProvider },
	{ kLoLLightningDefs, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLLightningDefsDOSCDProvider },
	{ kLoLFireballCoords, kLoL, kPlatformDOS, kTalkieVersion, UNK_LANG, &kLoLFireballCoordsDOSCDProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, FR_FRA, &kLoLCharacterDefsDOSCDFrenchProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, DE_DEU, &kLoLCharacterDefsDOSCDGermanProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, IT_ITA, &kLoLCharacterDefsDOSCDItalianProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, RU_RUS, &kLoLCharacterDefsDOSCDRussianProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieVersion, ES_ESP, &kLoLCharacterDefsDOSCDSpanishProvider },
	{ kLoLIngameSfxFiles, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLIngameSfxFilesDOSCDDemoProvider },
	{ kLoLIngameSfxIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLIngameSfxIndexDOSCDDemoProvider },
	{ kLoLMusicTrackMap, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMusicTrackMapDOSCDDemoProvider },
	{ kLoLIngameGMSfxIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLIngameGMSfxIndexDOSCDDemoProvider },
	{ kLoLIngameMT32SfxIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLIngameMT32SfxIndexDOSCDDemoProvider },
	{ kLoLIngamePcSpkSfxIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLIngamePcSpkSfxIndexDOSCDDemoProvider },
	{ kLoLSpellProperties, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLSpellPropertiesDOSCDDemoProvider },
	{ kLoLGameShapeMap, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLGameShapeMapDOSCDDemoProvider },
	{ kLoLSceneItemOffs, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLSceneItemOffsDOSCDDemoProvider },
	{ kLoLCharInvIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLCharInvIndexDOSCDDemoProvider },
	{ kLoLCharInvDefs, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLCharInvDefsDOSCDDemoProvider },
	{ kLoLCharDefsMan, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLCharDefsManDOSCDDemoProvider },
	{ kLoLCharDefsAkshel, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLCharDefsAkshelDOSCDDemoProvider },
	{ kLoLExpRequirements, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLExpRequirementsDOSCDDemoProvider },
	{ kLoLMonsterModifiers1, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterModifiers1DOSCDDemoProvider },
	{ kLoLMonsterModifiers2, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterModifiers2DOSCDDemoProvider },
	{ kLoLMonsterModifiers3, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterModifiers3DOSCDDemoProvider },
	{ kLoLMonsterModifiers4, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterModifiers4DOSCDDemoProvider },
	{ kLoLMonsterShiftOffsets, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterShiftOffsetsDOSCDDemoProvider },
	{ kLoLMonsterDirFlags, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterDirFlagsDOSCDDemoProvider },
	{ kLoLMonsterScaleY, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterScaleYDOSCDDemoProvider },
	{ kLoLMonsterScaleX, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterScaleXDOSCDDemoProvider },
	{ kLoLMonsterScaleWH, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMonsterScaleWHDOSCDDemoProvider },
	{ kLoLFlyingObjectShp, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLFlyingObjectShpDOSCDDemoProvider },
	{ kLoLInventoryDesc, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLInventoryDescDOSCDDemoProvider },
	{ kLoLLevelShpList, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLLevelShpListDOSCDDemoProvider },
	{ kLoLLevelDatList, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLLevelDatListDOSCDDemoProvider },
	{ kLoLCompassDefs, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLCompassDefsDOSCDDemoProvider },
	{ kLoLItemPrices, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLItemPricesDOSCDDemoProvider },
	{ kLoLStashSetup, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLStashSetupDOSCDDemoProvider },
	{ kLoLDscWalls, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscWallsDOSCDDemoProvider },
	{ kRpgCommonDscShapeIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscShapeIndexDOSCDDemoProvider },
	{ kLoLDscOvlMap, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscOvlMapDOSCDDemoProvider },
	{ kLoLDscScaleWidthData, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscScaleWidthDataDOSCDDemoProvider },
	{ kLoLDscScaleHeightData, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscScaleHeightDataDOSCDDemoProvider },
	{ kRpgCommonDscX, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscXDOSCDDemoProvider },
	{ kLoLBaseDscY, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLBaseDscYDOSCDDemoProvider },
	{ kRpgCommonDscTileIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscTileIndexDOSCDDemoProvider },
	{ kRpgCommonDscDoorShapeIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorShapeIndexDOSCDDemoProvider },
	{ kRpgCommonDscDimData1, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDimData1DOSCDDemoProvider },
	{ kRpgCommonDscDimData2, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDimData2DOSCDDemoProvider },
	{ kRpgCommonDscBlockMap, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscBlockMapDOSCDDemoProvider },
	{ kRpgCommonDscDimMap, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDimMapDOSCDDemoProvider },
	{ kLoLDscOvlIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscOvlIndexDOSCDDemoProvider },
	{ kRpgCommonDscBlockIndex, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscBlockIndexDOSCDDemoProvider },
	{ kRpgCommonDscDoorY2, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorY2DOSCDDemoProvider },
	{ kRpgCommonDscDoorFrameY1, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorFrameY1DOSCDDemoProvider },
	{ kRpgCommonDscDoorFrameY2, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorFrameY2DOSCDDemoProvider },
	{ kRpgCommonDscDoorScaleOffs, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorScaleOffsDOSCDDemoProvider },
	{ kLoLDscDoorScale, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorScaleDOSCDDemoProvider },
	{ kLoLDscDoor4, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoor4DOSCDDemoProvider },
	{ kLoLDscDoorX, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorXDOSCDDemoProvider },
	{ kLoLDscDoorY, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLDscDoorYDOSCDDemoProvider },
	{ kLoLScrollXTop, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLScrollXTopDOSCDDemoProvider },
	{ kLoLScrollYTop, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLScrollYTopDOSCDDemoProvider },
	{ kLoLScrollXBottom, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLScrollXBottomDOSCDDemoProvider },
	{ kLoLScrollYBottom, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLScrollYBottomDOSCDDemoProvider },
	{ kLoLButtonDefs, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonDefsDOSCDDemoProvider },
	{ kLoLButtonList1, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList1DOSCDDemoProvider },
	{ kLoLButtonList2, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList2DOSCDDemoProvider },
	{ kLoLButtonList3, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList3DOSCDDemoProvider },
	{ kLoLButtonList4, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList4DOSCDDemoProvider },
	{ kLoLButtonList5, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList5DOSCDDemoProvider },
	{ kLoLButtonList6, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList6DOSCDDemoProvider },
	{ kLoLButtonList7, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList7DOSCDDemoProvider },
	{ kLoLButtonList8, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLButtonList8DOSCDDemoProvider },
	{ kLoLLegendData, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLLegendDataDOSCDDemoProvider },
	{ kLoLMapCursorOvl, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMapCursorOvlDOSCDDemoProvider },
	{ kLoLMapStringId, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLMapStringIdDOSCDDemoProvider },
	{ kLoLSpellbookAnim, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLSpellbookAnimDOSCDDemoProvider },
	{ kLoLSpellbookCoords, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLSpellbookCoordsDOSCDDemoProvider },
	{ kLoLHealShapeFrames, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLHealShapeFramesDOSCDDemoProvider },
	{ kLoLLightningDefs, kLoL, kPlatformDOS, kTalkieDemoVersion, UNK_LANG, &kLoLLightningDefsDOSCDDemoProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieDemoVersion, EN_ANY, &kLoLCharacterDefsDOSCDDemoProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieDemoVersion, FR_FRA, &kLoLCharacterDefsDOSCDDemoProvider },
	{ kLoLCharacterDefs, kLoL, kPlatformDOS, kTalkieDemoVersion, DE_DEU, &kLoLCharacterDefsDOSCDDemoProvider },
	{ kMaxResIDs, kKyra1, kPlatformDOS, kNoSpecial, UNK_LANG, nullptr }
};

const ResourceProvider *obtainResourceProviders() {
	return resourceProviders;
}
