% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-percent.R
\name{percent_format}
\alias{percent_format}
\alias{percent}
\title{Superseded interface to \code{label_percent()}}
\usage{
percent_format(
  accuracy = NULL,
  scale = 100,
  prefix = "",
  suffix = "\%",
  big.mark = NULL,
  decimal.mark = NULL,
  trim = TRUE,
  ...
)

percent(
  x,
  accuracy = NULL,
  scale = 100,
  prefix = "",
  suffix = "\%",
  big.mark = NULL,
  decimal.mark = NULL,
  trim = TRUE,
  ...
)
}
\arguments{
\item{accuracy}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}

\item{scale}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}

\item{prefix}{Additional text to display before the number. The suffix is
applied to absolute value before \code{style_positive} and \code{style_negative} are
processed so that \code{prefix = "$"} will yield (e.g.) \verb{-$1} and \verb{($1)}.}

\item{suffix}{Additional text to display after the number.}

\item{big.mark}{Character used between every 3 digits to separate thousands.
The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{decimal.mark}{The character to be used to indicate the numeric
decimal point.  The default (\code{NULL}) retrieves the setting from the
\link[=number_options]{number options}.}

\item{trim}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These functions are kept for backward compatibility; you should switch
to \code{\link[=label_percent]{label_percent()}} for new code.
}
\keyword{internal}
