% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_equals_linter.R
\name{class_equals_linter}
\alias{class_equals_linter}
\title{Block comparison of class with \code{==}}
\usage{
class_equals_linter()
}
\description{
Usage like \code{class(x) == "character"} is prone to error since class in R
is in general a vector. The correct version for S3 classes is \code{\link[=inherits]{inherits()}}:
\code{inherits(x, "character")}. Often, class \code{k} will have an \code{is.} equivalent,
for example \code{\link[=is.character]{is.character()}} or \code{\link[=is.data.frame]{is.data.frame()}}.
}
\details{
Similar reasoning applies for \code{class(x) \%in\% "character"}.
}
\examples{
# will produce lints
lint(
  text = 'is_lm <- class(x) == "lm"',
  linters = class_equals_linter()
)

lint(
  text = 'if ("lm" \%in\% class(x)) is_lm <- TRUE',
  linters = class_equals_linter()
)

# okay
lint(
  text = 'is_lm <- inherits(x, "lm")',
  linters = class_equals_linter()
)

lint(
  text = 'if (inherits(x, "lm")) is_lm <- TRUE',
  linters = class_equals_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=robustness_linters]{robustness}
}
