# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.costmanagement import CostManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-costmanagement
# USAGE
    python billing_account_query.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = CostManagementClient(
        credential=DefaultAzureCredential(),
    )

    response = client.query.usage(
        scope="providers/Microsoft.Billing/billingAccounts/70664866",
        parameters={
            "dataset": {
                "filter": {
                    "and": [
                        {
                            "or": [
                                {
                                    "dimensions": {
                                        "name": "ResourceLocation",
                                        "operator": "In",
                                        "values": ["East US", "West Europe"],
                                    }
                                },
                                {"tags": {"name": "Environment", "operator": "In", "values": ["UAT", "Prod"]}},
                            ]
                        },
                        {"dimensions": {"name": "ResourceGroup", "operator": "In", "values": ["API"]}},
                    ]
                },
                "granularity": "Daily",
            },
            "timeframe": "MonthToDate",
            "type": "Usage",
        },
    )
    print(response)


# x-ms-original-file: specification/cost-management/resource-manager/Microsoft.CostManagement/stable/2022-10-01/examples/BillingAccountQuery.json
if __name__ == "__main__":
    main()
