# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Literal, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AllowedAudiencesValidation(_serialization.Model):
    """The configuration settings of the Allowed Audiences validation flow.

    :ivar allowed_audiences: The configuration settings of the allowed list of audiences from which
     to validate the JWT token.
    :vartype allowed_audiences: list[str]
    """

    _attribute_map = {
        "allowed_audiences": {"key": "allowedAudiences", "type": "[str]"},
    }

    def __init__(self, *, allowed_audiences: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword allowed_audiences: The configuration settings of the allowed list of audiences from
         which to validate the JWT token.
        :paramtype allowed_audiences: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_audiences = allowed_audiences


class AllowedPrincipals(_serialization.Model):
    """The configuration settings of the Azure Active Directory allowed principals.

    :ivar groups: The list of the allowed groups.
    :vartype groups: list[str]
    :ivar identities: The list of the allowed identities.
    :vartype identities: list[str]
    """

    _attribute_map = {
        "groups": {"key": "groups", "type": "[str]"},
        "identities": {"key": "identities", "type": "[str]"},
    }

    def __init__(
        self, *, groups: Optional[List[str]] = None, identities: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword groups: The list of the allowed groups.
        :paramtype groups: list[str]
        :keyword identities: The list of the allowed identities.
        :paramtype identities: list[str]
        """
        super().__init__(**kwargs)
        self.groups = groups
        self.identities = identities


class AppInsightsConfiguration(_serialization.Model):
    """Configuration of Application Insights.

    :ivar connection_string: Application Insights connection string.
    :vartype connection_string: str
    """

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "str"},
    }

    def __init__(self, *, connection_string: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword connection_string: Application Insights connection string.
        :paramtype connection_string: str
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string


class Apple(_serialization.Model):
    """The configuration settings of the Apple provider.

    :ivar enabled: :code:`<code>false</code>` if the Apple provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Apple registration.
    :vartype registration: ~azure.mgmt.appcontainers.models.AppleRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.appcontainers.models.LoginScopes
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AppleRegistration"},
        "login": {"key": "login", "type": "LoginScopes"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AppleRegistration"] = None,
        login: Optional["_models.LoginScopes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Apple provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Apple registration.
        :paramtype registration: ~azure.mgmt.appcontainers.models.AppleRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.appcontainers.models.LoginScopes
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class AppleRegistration(_serialization.Model):
    """The configuration settings of the registration for the Apple provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
    }

    def __init__(
        self, *, client_id: Optional[str] = None, client_secret_setting_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class AppLogsConfiguration(_serialization.Model):
    """Configuration of application logs.

    :ivar destination: Logs destination, can be 'log-analytics', 'azure-monitor' or 'none'.
    :vartype destination: str
    :ivar log_analytics_configuration: Log Analytics configuration, must only be provided when
     destination is configured as 'log-analytics'.
    :vartype log_analytics_configuration:
     ~azure.mgmt.appcontainers.models.LogAnalyticsConfiguration
    """

    _attribute_map = {
        "destination": {"key": "destination", "type": "str"},
        "log_analytics_configuration": {"key": "logAnalyticsConfiguration", "type": "LogAnalyticsConfiguration"},
    }

    def __init__(
        self,
        *,
        destination: Optional[str] = None,
        log_analytics_configuration: Optional["_models.LogAnalyticsConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination: Logs destination, can be 'log-analytics', 'azure-monitor' or 'none'.
        :paramtype destination: str
        :keyword log_analytics_configuration: Log Analytics configuration, must only be provided when
         destination is configured as 'log-analytics'.
        :paramtype log_analytics_configuration:
         ~azure.mgmt.appcontainers.models.LogAnalyticsConfiguration
        """
        super().__init__(**kwargs)
        self.destination = destination
        self.log_analytics_configuration = log_analytics_configuration


class AppRegistration(_serialization.Model):
    """The configuration settings of the app registration for providers that have app ids and app
    secrets.

    :ivar app_id: The App ID of the app used for login.
    :vartype app_id: str
    :ivar app_secret_setting_name: The app setting name that contains the app secret.
    :vartype app_secret_setting_name: str
    """

    _attribute_map = {
        "app_id": {"key": "appId", "type": "str"},
        "app_secret_setting_name": {"key": "appSecretSettingName", "type": "str"},
    }

    def __init__(
        self, *, app_id: Optional[str] = None, app_secret_setting_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword app_id: The App ID of the app used for login.
        :paramtype app_id: str
        :keyword app_secret_setting_name: The app setting name that contains the app secret.
        :paramtype app_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.app_id = app_id
        self.app_secret_setting_name = app_secret_setting_name


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    """


class AppResiliency(ProxyResource):
    """Configuration to setup App Resiliency.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar timeout_policy: Policy to set request timeouts.
    :vartype timeout_policy: ~azure.mgmt.appcontainers.models.TimeoutPolicy
    :ivar http_retry_policy: Policy that defines http request retry conditions.
    :vartype http_retry_policy: ~azure.mgmt.appcontainers.models.HttpRetryPolicy
    :ivar tcp_retry_policy: Policy that defines tcp request retry conditions.
    :vartype tcp_retry_policy: ~azure.mgmt.appcontainers.models.TcpRetryPolicy
    :ivar circuit_breaker_policy: Policy that defines circuit breaker conditions.
    :vartype circuit_breaker_policy: ~azure.mgmt.appcontainers.models.CircuitBreakerPolicy
    :ivar http_connection_pool: Defines parameters for http connection pooling.
    :vartype http_connection_pool: ~azure.mgmt.appcontainers.models.HttpConnectionPool
    :ivar tcp_connection_pool: Defines parameters for tcp connection pooling.
    :vartype tcp_connection_pool: ~azure.mgmt.appcontainers.models.TcpConnectionPool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "timeout_policy": {"key": "properties.timeoutPolicy", "type": "TimeoutPolicy"},
        "http_retry_policy": {"key": "properties.httpRetryPolicy", "type": "HttpRetryPolicy"},
        "tcp_retry_policy": {"key": "properties.tcpRetryPolicy", "type": "TcpRetryPolicy"},
        "circuit_breaker_policy": {"key": "properties.circuitBreakerPolicy", "type": "CircuitBreakerPolicy"},
        "http_connection_pool": {"key": "properties.httpConnectionPool", "type": "HttpConnectionPool"},
        "tcp_connection_pool": {"key": "properties.tcpConnectionPool", "type": "TcpConnectionPool"},
    }

    def __init__(
        self,
        *,
        timeout_policy: Optional["_models.TimeoutPolicy"] = None,
        http_retry_policy: Optional["_models.HttpRetryPolicy"] = None,
        tcp_retry_policy: Optional["_models.TcpRetryPolicy"] = None,
        circuit_breaker_policy: Optional["_models.CircuitBreakerPolicy"] = None,
        http_connection_pool: Optional["_models.HttpConnectionPool"] = None,
        tcp_connection_pool: Optional["_models.TcpConnectionPool"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword timeout_policy: Policy to set request timeouts.
        :paramtype timeout_policy: ~azure.mgmt.appcontainers.models.TimeoutPolicy
        :keyword http_retry_policy: Policy that defines http request retry conditions.
        :paramtype http_retry_policy: ~azure.mgmt.appcontainers.models.HttpRetryPolicy
        :keyword tcp_retry_policy: Policy that defines tcp request retry conditions.
        :paramtype tcp_retry_policy: ~azure.mgmt.appcontainers.models.TcpRetryPolicy
        :keyword circuit_breaker_policy: Policy that defines circuit breaker conditions.
        :paramtype circuit_breaker_policy: ~azure.mgmt.appcontainers.models.CircuitBreakerPolicy
        :keyword http_connection_pool: Defines parameters for http connection pooling.
        :paramtype http_connection_pool: ~azure.mgmt.appcontainers.models.HttpConnectionPool
        :keyword tcp_connection_pool: Defines parameters for tcp connection pooling.
        :paramtype tcp_connection_pool: ~azure.mgmt.appcontainers.models.TcpConnectionPool
        """
        super().__init__(**kwargs)
        self.timeout_policy = timeout_policy
        self.http_retry_policy = http_retry_policy
        self.tcp_retry_policy = tcp_retry_policy
        self.circuit_breaker_policy = circuit_breaker_policy
        self.http_connection_pool = http_connection_pool
        self.tcp_connection_pool = tcp_connection_pool


class AppResiliencyCollection(_serialization.Model):
    """Collection of AppResiliency policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.AppResiliency]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppResiliency]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppResiliency"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.AppResiliency]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AuthConfig(ProxyResource):
    """Configuration settings for the Azure ContainerApp Service Authentication / Authorization
    feature.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar platform: The configuration settings of the platform of ContainerApp Service
     Authentication/Authorization.
    :vartype platform: ~azure.mgmt.appcontainers.models.AuthPlatform
    :ivar global_validation: The configuration settings that determines the validation flow of
     users using  Service Authentication/Authorization.
    :vartype global_validation: ~azure.mgmt.appcontainers.models.GlobalValidation
    :ivar identity_providers: The configuration settings of each of the identity providers used to
     configure ContainerApp Service Authentication/Authorization.
    :vartype identity_providers: ~azure.mgmt.appcontainers.models.IdentityProviders
    :ivar login: The configuration settings of the login flow of users using ContainerApp Service
     Authentication/Authorization.
    :vartype login: ~azure.mgmt.appcontainers.models.Login
    :ivar http_settings: The configuration settings of the HTTP requests for authentication and
     authorization requests made against ContainerApp Service Authentication/Authorization.
    :vartype http_settings: ~azure.mgmt.appcontainers.models.HttpSettings
    :ivar encryption_settings: The configuration settings of the secrets references of encryption
     key and signing key for ContainerApp Service Authentication/Authorization.
    :vartype encryption_settings: ~azure.mgmt.appcontainers.models.EncryptionSettings
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "platform": {"key": "properties.platform", "type": "AuthPlatform"},
        "global_validation": {"key": "properties.globalValidation", "type": "GlobalValidation"},
        "identity_providers": {"key": "properties.identityProviders", "type": "IdentityProviders"},
        "login": {"key": "properties.login", "type": "Login"},
        "http_settings": {"key": "properties.httpSettings", "type": "HttpSettings"},
        "encryption_settings": {"key": "properties.encryptionSettings", "type": "EncryptionSettings"},
    }

    def __init__(
        self,
        *,
        platform: Optional["_models.AuthPlatform"] = None,
        global_validation: Optional["_models.GlobalValidation"] = None,
        identity_providers: Optional["_models.IdentityProviders"] = None,
        login: Optional["_models.Login"] = None,
        http_settings: Optional["_models.HttpSettings"] = None,
        encryption_settings: Optional["_models.EncryptionSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform: The configuration settings of the platform of ContainerApp Service
         Authentication/Authorization.
        :paramtype platform: ~azure.mgmt.appcontainers.models.AuthPlatform
        :keyword global_validation: The configuration settings that determines the validation flow of
         users using  Service Authentication/Authorization.
        :paramtype global_validation: ~azure.mgmt.appcontainers.models.GlobalValidation
        :keyword identity_providers: The configuration settings of each of the identity providers used
         to configure ContainerApp Service Authentication/Authorization.
        :paramtype identity_providers: ~azure.mgmt.appcontainers.models.IdentityProviders
        :keyword login: The configuration settings of the login flow of users using ContainerApp
         Service Authentication/Authorization.
        :paramtype login: ~azure.mgmt.appcontainers.models.Login
        :keyword http_settings: The configuration settings of the HTTP requests for authentication and
         authorization requests made against ContainerApp Service Authentication/Authorization.
        :paramtype http_settings: ~azure.mgmt.appcontainers.models.HttpSettings
        :keyword encryption_settings: The configuration settings of the secrets references of
         encryption key and signing key for ContainerApp Service Authentication/Authorization.
        :paramtype encryption_settings: ~azure.mgmt.appcontainers.models.EncryptionSettings
        """
        super().__init__(**kwargs)
        self.platform = platform
        self.global_validation = global_validation
        self.identity_providers = identity_providers
        self.login = login
        self.http_settings = http_settings
        self.encryption_settings = encryption_settings


class AuthConfigCollection(_serialization.Model):
    """AuthConfig collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.AuthConfig]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AuthConfig]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AuthConfig"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.AuthConfig]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AuthPlatform(_serialization.Model):
    """The configuration settings of the platform of ContainerApp Service
    Authentication/Authorization.

    :ivar enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
     enabled for the current app; otherwise, :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar runtime_version: The RuntimeVersion of the Authentication / Authorization feature in use
     for the current app.
     The setting in this value can control the behavior of certain features in the Authentication /
     Authorization module.
    :vartype runtime_version: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, runtime_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: :code:`<code>true</code>` if the Authentication / Authorization feature is
         enabled for the current app; otherwise, :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword runtime_version: The RuntimeVersion of the Authentication / Authorization feature in
         use for the current app.
         The setting in this value can control the behavior of certain features in the Authentication /
         Authorization module.
        :paramtype runtime_version: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.runtime_version = runtime_version


class AvailableOperations(_serialization.Model):
    """Available operations of the service.

    :ivar value: Collection of available operation details.
    :vartype value: list[~azure.mgmt.appcontainers.models.OperationDetail]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDetail]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationDetail"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of available operation details.
        :paramtype value: list[~azure.mgmt.appcontainers.models.OperationDetail]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailableWorkloadProfile(ProxyResource):
    """A workload profile with specific hardware configure to run container apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar location: Region of the workload profile.
    :vartype location: str
    :ivar properties: Revision resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.AvailableWorkloadProfileProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "AvailableWorkloadProfileProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.AvailableWorkloadProfileProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Region of the workload profile.
        :paramtype location: str
        :keyword properties: Revision resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.AvailableWorkloadProfileProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.properties = properties


class AvailableWorkloadProfileProperties(_serialization.Model):
    """Revision resource specific properties.

    :ivar category: Used to categorize workload profiles.
    :vartype category: str
    :ivar applicability: indicates whether the profile is default for the location. Known values
     are: "LocationDefault" and "Custom".
    :vartype applicability: str or ~azure.mgmt.appcontainers.models.Applicability
    :ivar cores: Number of cores in CPU.
    :vartype cores: int
    :ivar memory_gi_b: Memory in GiB.
    :vartype memory_gi_b: int
    :ivar gpus: Number of GPUs.
    :vartype gpus: int
    :ivar display_name: The everyday name of the workload profile.
    :vartype display_name: str
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "applicability": {"key": "applicability", "type": "str"},
        "cores": {"key": "cores", "type": "int"},
        "memory_gi_b": {"key": "memoryGiB", "type": "int"},
        "gpus": {"key": "gpus", "type": "int"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        applicability: Optional[Union[str, "_models.Applicability"]] = None,
        cores: Optional[int] = None,
        memory_gi_b: Optional[int] = None,
        gpus: Optional[int] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Used to categorize workload profiles.
        :paramtype category: str
        :keyword applicability: indicates whether the profile is default for the location. Known values
         are: "LocationDefault" and "Custom".
        :paramtype applicability: str or ~azure.mgmt.appcontainers.models.Applicability
        :keyword cores: Number of cores in CPU.
        :paramtype cores: int
        :keyword memory_gi_b: Memory in GiB.
        :paramtype memory_gi_b: int
        :keyword gpus: Number of GPUs.
        :paramtype gpus: int
        :keyword display_name: The everyday name of the workload profile.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.category = category
        self.applicability = applicability
        self.cores = cores
        self.memory_gi_b = memory_gi_b
        self.gpus = gpus
        self.display_name = display_name


class AvailableWorkloadProfilesCollection(_serialization.Model):
    """Collection of available workload profiles in the location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of workload profiles. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.AvailableWorkloadProfile]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AvailableWorkloadProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AvailableWorkloadProfile"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of workload profiles. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.AvailableWorkloadProfile]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class AzureActiveDirectory(_serialization.Model):
    """The configuration settings of the Azure Active directory provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Active Directory app registration.
    :vartype registration: ~azure.mgmt.appcontainers.models.AzureActiveDirectoryRegistration
    :ivar login: The configuration settings of the Azure Active Directory login flow.
    :vartype login: ~azure.mgmt.appcontainers.models.AzureActiveDirectoryLogin
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~azure.mgmt.appcontainers.models.AzureActiveDirectoryValidation
    :ivar is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
     auto-provisioned using 1st party tooling.
     This is an internal flag primarily intended to support the Azure Management Portal. Users
     should not
     read or write to this property.
    :vartype is_auto_provisioned: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AzureActiveDirectoryRegistration"},
        "login": {"key": "login", "type": "AzureActiveDirectoryLogin"},
        "validation": {"key": "validation", "type": "AzureActiveDirectoryValidation"},
        "is_auto_provisioned": {"key": "isAutoProvisioned", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AzureActiveDirectoryRegistration"] = None,
        login: Optional["_models.AzureActiveDirectoryLogin"] = None,
        validation: Optional["_models.AzureActiveDirectoryValidation"] = None,
        is_auto_provisioned: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Active Directory provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Active Directory app
         registration.
        :paramtype registration: ~azure.mgmt.appcontainers.models.AzureActiveDirectoryRegistration
        :keyword login: The configuration settings of the Azure Active Directory login flow.
        :paramtype login: ~azure.mgmt.appcontainers.models.AzureActiveDirectoryLogin
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~azure.mgmt.appcontainers.models.AzureActiveDirectoryValidation
        :keyword is_auto_provisioned: Gets a value indicating whether the Azure AD configuration was
         auto-provisioned using 1st party tooling.
         This is an internal flag primarily intended to support the Azure Management Portal. Users
         should not
         read or write to this property.
        :paramtype is_auto_provisioned: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation
        self.is_auto_provisioned = is_auto_provisioned


class AzureActiveDirectoryLogin(_serialization.Model):
    """The configuration settings of the Azure Active Directory login flow.

    :ivar login_parameters: Login parameters to send to the OpenID Connect authorization endpoint
     when
     a user logs in. Each parameter must be in the form "key=value".
    :vartype login_parameters: list[str]
    :ivar disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
     should be omitted from the request; otherwise, :code:`<code>false</code>`.
    :vartype disable_www_authenticate: bool
    """

    _attribute_map = {
        "login_parameters": {"key": "loginParameters", "type": "[str]"},
        "disable_www_authenticate": {"key": "disableWWWAuthenticate", "type": "bool"},
    }

    def __init__(
        self,
        *,
        login_parameters: Optional[List[str]] = None,
        disable_www_authenticate: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword login_parameters: Login parameters to send to the OpenID Connect authorization
         endpoint when
         a user logs in. Each parameter must be in the form "key=value".
        :paramtype login_parameters: list[str]
        :keyword disable_www_authenticate: :code:`<code>true</code>` if the www-authenticate provider
         should be omitted from the request; otherwise, :code:`<code>false</code>`.
        :paramtype disable_www_authenticate: bool
        """
        super().__init__(**kwargs)
        self.login_parameters = login_parameters
        self.disable_www_authenticate = disable_www_authenticate


class AzureActiveDirectoryRegistration(_serialization.Model):
    """The configuration settings of the Azure Active Directory app registration.

    :ivar open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
     access tokens for this application.
     When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
     https://login.microsoftonline.com/v2.0/{tenant-guid}/.
     This URI is a case-sensitive identifier for the token issuer.
     More information on OpenID Connect Discovery:
     http://openid.net/specs/openid-connect-discovery-1_0.html.
    :vartype open_id_issuer: str
    :ivar client_id: The Client ID of this relying party application, known as the client_id.
     This setting is required for enabling OpenID Connection authentication with Azure Active
     Directory or
     other 3rd party OpenID Connect providers.
     More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret of the
     relying party application.
    :vartype client_secret_setting_name: str
    :ivar client_secret_certificate_thumbprint: An alternative to the client secret, that is the
     thumbprint of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret. It is also optional.
    :vartype client_secret_certificate_thumbprint: str
    :ivar client_secret_certificate_subject_alternative_name: An alternative to the client secret
     thumbprint, that is the subject alternative name of a certificate used for signing purposes.
     This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_subject_alternative_name: str
    :ivar client_secret_certificate_issuer: An alternative to the client secret thumbprint, that is
     the issuer of a certificate used for signing purposes. This property acts as
     a replacement for the Client Secret Certificate Thumbprint. It is also optional.
    :vartype client_secret_certificate_issuer: str
    """

    _attribute_map = {
        "open_id_issuer": {"key": "openIdIssuer", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
        "client_secret_certificate_thumbprint": {"key": "clientSecretCertificateThumbprint", "type": "str"},
        "client_secret_certificate_subject_alternative_name": {
            "key": "clientSecretCertificateSubjectAlternativeName",
            "type": "str",
        },
        "client_secret_certificate_issuer": {"key": "clientSecretCertificateIssuer", "type": "str"},
    }

    def __init__(
        self,
        *,
        open_id_issuer: Optional[str] = None,
        client_id: Optional[str] = None,
        client_secret_setting_name: Optional[str] = None,
        client_secret_certificate_thumbprint: Optional[str] = None,
        client_secret_certificate_subject_alternative_name: Optional[str] = None,
        client_secret_certificate_issuer: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword open_id_issuer: The OpenID Connect Issuer URI that represents the entity which issues
         access tokens for this application.
         When using Azure Active Directory, this value is the URI of the directory tenant, e.g.
         https://login.microsoftonline.com/v2.0/{tenant-guid}/.
         This URI is a case-sensitive identifier for the token issuer.
         More information on OpenID Connect Discovery:
         http://openid.net/specs/openid-connect-discovery-1_0.html.
        :paramtype open_id_issuer: str
        :keyword client_id: The Client ID of this relying party application, known as the client_id.
         This setting is required for enabling OpenID Connection authentication with Azure Active
         Directory or
         other 3rd party OpenID Connect providers.
         More information on OpenID Connect: http://openid.net/specs/openid-connect-core-1_0.html.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret of
         the relying party application.
        :paramtype client_secret_setting_name: str
        :keyword client_secret_certificate_thumbprint: An alternative to the client secret, that is the
         thumbprint of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret. It is also optional.
        :paramtype client_secret_certificate_thumbprint: str
        :keyword client_secret_certificate_subject_alternative_name: An alternative to the client
         secret thumbprint, that is the subject alternative name of a certificate used for signing
         purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_subject_alternative_name: str
        :keyword client_secret_certificate_issuer: An alternative to the client secret thumbprint, that
         is the issuer of a certificate used for signing purposes. This property acts as
         a replacement for the Client Secret Certificate Thumbprint. It is also optional.
        :paramtype client_secret_certificate_issuer: str
        """
        super().__init__(**kwargs)
        self.open_id_issuer = open_id_issuer
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name
        self.client_secret_certificate_thumbprint = client_secret_certificate_thumbprint
        self.client_secret_certificate_subject_alternative_name = client_secret_certificate_subject_alternative_name
        self.client_secret_certificate_issuer = client_secret_certificate_issuer


class AzureActiveDirectoryValidation(_serialization.Model):
    """The configuration settings of the Azure Active Directory token validation flow.

    :ivar jwt_claim_checks: The configuration settings of the checks that should be made while
     validating the JWT Claims.
    :vartype jwt_claim_checks: ~azure.mgmt.appcontainers.models.JwtClaimChecks
    :ivar allowed_audiences: The list of audiences that can make successful
     authentication/authorization requests.
    :vartype allowed_audiences: list[str]
    :ivar default_authorization_policy: The configuration settings of the default authorization
     policy.
    :vartype default_authorization_policy:
     ~azure.mgmt.appcontainers.models.DefaultAuthorizationPolicy
    """

    _attribute_map = {
        "jwt_claim_checks": {"key": "jwtClaimChecks", "type": "JwtClaimChecks"},
        "allowed_audiences": {"key": "allowedAudiences", "type": "[str]"},
        "default_authorization_policy": {"key": "defaultAuthorizationPolicy", "type": "DefaultAuthorizationPolicy"},
    }

    def __init__(
        self,
        *,
        jwt_claim_checks: Optional["_models.JwtClaimChecks"] = None,
        allowed_audiences: Optional[List[str]] = None,
        default_authorization_policy: Optional["_models.DefaultAuthorizationPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword jwt_claim_checks: The configuration settings of the checks that should be made while
         validating the JWT Claims.
        :paramtype jwt_claim_checks: ~azure.mgmt.appcontainers.models.JwtClaimChecks
        :keyword allowed_audiences: The list of audiences that can make successful
         authentication/authorization requests.
        :paramtype allowed_audiences: list[str]
        :keyword default_authorization_policy: The configuration settings of the default authorization
         policy.
        :paramtype default_authorization_policy:
         ~azure.mgmt.appcontainers.models.DefaultAuthorizationPolicy
        """
        super().__init__(**kwargs)
        self.jwt_claim_checks = jwt_claim_checks
        self.allowed_audiences = allowed_audiences
        self.default_authorization_policy = default_authorization_policy


class AzureCredentials(_serialization.Model):
    """Container App credentials.

    :ivar client_id: Client Id.
    :vartype client_id: str
    :ivar client_secret: Client Secret.
    :vartype client_secret: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    :ivar kind: Kind of auth github does for deploying the template.
    :vartype kind: str
    :ivar subscription_id: Subscription Id.
    :vartype subscription_id: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret": {"key": "clientSecret", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        kind: Optional[str] = None,
        subscription_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_id: Client Id.
        :paramtype client_id: str
        :keyword client_secret: Client Secret.
        :paramtype client_secret: str
        :keyword tenant_id: Tenant Id.
        :paramtype tenant_id: str
        :keyword kind: Kind of auth github does for deploying the template.
        :paramtype kind: str
        :keyword subscription_id: Subscription Id.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret = client_secret
        self.tenant_id = tenant_id
        self.kind = kind
        self.subscription_id = subscription_id


class AzureFileProperties(_serialization.Model):
    """Azure File Properties.

    :ivar account_name: Storage account name for azure file.
    :vartype account_name: str
    :ivar account_key: Storage account key for azure file.
    :vartype account_key: str
    :ivar account_key_vault_properties: Storage account key stored as an Azure Key Vault secret.
    :vartype account_key_vault_properties:
     ~azure.mgmt.appcontainers.models.SecretKeyVaultProperties
    :ivar access_mode: Access mode for storage. Known values are: "ReadOnly" and "ReadWrite".
    :vartype access_mode: str or ~azure.mgmt.appcontainers.models.AccessMode
    :ivar share_name: Azure file share name.
    :vartype share_name: str
    """

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "account_key": {"key": "accountKey", "type": "str"},
        "account_key_vault_properties": {"key": "accountKeyVaultProperties", "type": "SecretKeyVaultProperties"},
        "access_mode": {"key": "accessMode", "type": "str"},
        "share_name": {"key": "shareName", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        account_key: Optional[str] = None,
        account_key_vault_properties: Optional["_models.SecretKeyVaultProperties"] = None,
        access_mode: Optional[Union[str, "_models.AccessMode"]] = None,
        share_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword account_name: Storage account name for azure file.
        :paramtype account_name: str
        :keyword account_key: Storage account key for azure file.
        :paramtype account_key: str
        :keyword account_key_vault_properties: Storage account key stored as an Azure Key Vault secret.
        :paramtype account_key_vault_properties:
         ~azure.mgmt.appcontainers.models.SecretKeyVaultProperties
        :keyword access_mode: Access mode for storage. Known values are: "ReadOnly" and "ReadWrite".
        :paramtype access_mode: str or ~azure.mgmt.appcontainers.models.AccessMode
        :keyword share_name: Azure file share name.
        :paramtype share_name: str
        """
        super().__init__(**kwargs)
        self.account_name = account_name
        self.account_key = account_key
        self.account_key_vault_properties = account_key_vault_properties
        self.access_mode = access_mode
        self.share_name = share_name


class AzureStaticWebApps(_serialization.Model):
    """The configuration settings of the Azure Static Web Apps provider.

    :ivar enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not be
     enabled despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the Azure Static Web Apps registration.
    :vartype registration: ~azure.mgmt.appcontainers.models.AzureStaticWebAppsRegistration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AzureStaticWebAppsRegistration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AzureStaticWebAppsRegistration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Azure Static Web Apps provider should not
         be enabled despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the Azure Static Web Apps registration.
        :paramtype registration: ~azure.mgmt.appcontainers.models.AzureStaticWebAppsRegistration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration


class AzureStaticWebAppsRegistration(_serialization.Model):
    """The configuration settings of the registration for the Azure Static Web Apps provider.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id


class BaseContainer(_serialization.Model):
    """Container App base container definition.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar image_type: The type of the image. Set to CloudBuild to let the system manages the image,
     where user will not be able to update image through image field. Set to ContainerImage for user
     provided image. Known values are: "CloudBuild" and "ContainerImage".
    :vartype image_type: str or ~azure.mgmt.appcontainers.models.ImageType
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~azure.mgmt.appcontainers.models.ContainerResources
    :ivar volume_mounts: Container volume mounts.
    :vartype volume_mounts: list[~azure.mgmt.appcontainers.models.VolumeMount]
    """

    _attribute_map = {
        "image": {"key": "image", "type": "str"},
        "image_type": {"key": "imageType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
        "args": {"key": "args", "type": "[str]"},
        "env": {"key": "env", "type": "[EnvironmentVar]"},
        "resources": {"key": "resources", "type": "ContainerResources"},
        "volume_mounts": {"key": "volumeMounts", "type": "[VolumeMount]"},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        image_type: Optional[Union[str, "_models.ImageType"]] = None,
        name: Optional[str] = None,
        command: Optional[List[str]] = None,
        args: Optional[List[str]] = None,
        env: Optional[List["_models.EnvironmentVar"]] = None,
        resources: Optional["_models.ContainerResources"] = None,
        volume_mounts: Optional[List["_models.VolumeMount"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image: Container image tag.
        :paramtype image: str
        :keyword image_type: The type of the image. Set to CloudBuild to let the system manages the
         image, where user will not be able to update image through image field. Set to ContainerImage
         for user provided image. Known values are: "CloudBuild" and "ContainerImage".
        :paramtype image_type: str or ~azure.mgmt.appcontainers.models.ImageType
        :keyword name: Custom container name.
        :paramtype name: str
        :keyword command: Container start command.
        :paramtype command: list[str]
        :keyword args: Container start command arguments.
        :paramtype args: list[str]
        :keyword env: Container environment variables.
        :paramtype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
        :keyword resources: Container resource requirements.
        :paramtype resources: ~azure.mgmt.appcontainers.models.ContainerResources
        :keyword volume_mounts: Container volume mounts.
        :paramtype volume_mounts: list[~azure.mgmt.appcontainers.models.VolumeMount]
        """
        super().__init__(**kwargs)
        self.image = image
        self.image_type = image_type
        self.name = name
        self.command = command
        self.args = args
        self.env = env
        self.resources = resources
        self.volume_mounts = volume_mounts


class BillingMeter(_serialization.Model):
    """Billing meter.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar location: Region for the billing meter.
    :vartype location: str
    :ivar properties: Revision resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.BillingMeterProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "BillingMeterProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.BillingMeterProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Region for the billing meter.
        :paramtype location: str
        :keyword properties: Revision resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.BillingMeterProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.location = location
        self.properties = properties


class BillingMeterCollection(_serialization.Model):
    """Collection of billing meters.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of billing meters. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.BillingMeter]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BillingMeter]"},
    }

    def __init__(self, *, value: List["_models.BillingMeter"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of billing meters. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.BillingMeter]
        """
        super().__init__(**kwargs)
        self.value = value


class BillingMeterProperties(_serialization.Model):
    """Revision resource specific properties.

    :ivar category: Used to categorize billing meters.
    :vartype category: str
    :ivar meter_type: Billing meter type.
    :vartype meter_type: str
    :ivar display_name: The everyday name of the billing meter.
    :vartype display_name: str
    """

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "meter_type": {"key": "meterType", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
    }

    def __init__(
        self,
        *,
        category: Optional[str] = None,
        meter_type: Optional[str] = None,
        display_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword category: Used to categorize billing meters.
        :paramtype category: str
        :keyword meter_type: Billing meter type.
        :paramtype meter_type: str
        :keyword display_name: The everyday name of the billing meter.
        :paramtype display_name: str
        """
        super().__init__(**kwargs)
        self.category = category
        self.meter_type = meter_type
        self.display_name = display_name


class BlobStorageTokenStore(_serialization.Model):
    """The configuration settings of the storage of the tokens if blob storage is used.

    :ivar sas_url_setting_name: The name of the app secrets containing the SAS URL of the blob
     storage containing the tokens. Should not be used along with blobContainerUri.
    :vartype sas_url_setting_name: str
    :ivar blob_container_uri: The URI of the blob storage containing the tokens. Should not be used
     along with sasUrlSettingName.
    :vartype blob_container_uri: str
    :ivar client_id: The Client ID of a User-Assigned Managed Identity. Should not be used along
     with managedIdentityResourceId.
    :vartype client_id: str
    :ivar managed_identity_resource_id: The Resource ID of a User-Assigned Managed Identity. Should
     not be used along with clientId.
    :vartype managed_identity_resource_id: str
    """

    _attribute_map = {
        "sas_url_setting_name": {"key": "sasUrlSettingName", "type": "str"},
        "blob_container_uri": {"key": "blobContainerUri", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "managed_identity_resource_id": {"key": "managedIdentityResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        sas_url_setting_name: Optional[str] = None,
        blob_container_uri: Optional[str] = None,
        client_id: Optional[str] = None,
        managed_identity_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sas_url_setting_name: The name of the app secrets containing the SAS URL of the blob
         storage containing the tokens. Should not be used along with blobContainerUri.
        :paramtype sas_url_setting_name: str
        :keyword blob_container_uri: The URI of the blob storage containing the tokens. Should not be
         used along with sasUrlSettingName.
        :paramtype blob_container_uri: str
        :keyword client_id: The Client ID of a User-Assigned Managed Identity. Should not be used along
         with managedIdentityResourceId.
        :paramtype client_id: str
        :keyword managed_identity_resource_id: The Resource ID of a User-Assigned Managed Identity.
         Should not be used along with clientId.
        :paramtype managed_identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.sas_url_setting_name = sas_url_setting_name
        self.blob_container_uri = blob_container_uri
        self.client_id = client_id
        self.managed_identity_resource_id = managed_identity_resource_id


class BuildCollection(_serialization.Model):
    """The response of a BuildResource list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The BuildResource items on this page. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.BuildResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BuildResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.BuildResource"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The BuildResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.BuildResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BuildConfiguration(_serialization.Model):
    """Configuration of the build.

    :ivar base_os: Base OS used to build and run the app.
    :vartype base_os: str
    :ivar platform: Platform to be used to build and run the app.
    :vartype platform: str
    :ivar platform_version: Platform version to be used to build and run the app.
    :vartype platform_version: str
    :ivar environment_variables: List of environment variables to be passed to the build, secrets
     should not be used in environment variable.
    :vartype environment_variables: list[~azure.mgmt.appcontainers.models.EnvironmentVariable]
    :ivar pre_build_steps: List of steps to perform before the build.
    :vartype pre_build_steps: list[~azure.mgmt.appcontainers.models.PreBuildStep]
    """

    _attribute_map = {
        "base_os": {"key": "baseOs", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "platform_version": {"key": "platformVersion", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "[EnvironmentVariable]"},
        "pre_build_steps": {"key": "preBuildSteps", "type": "[PreBuildStep]"},
    }

    def __init__(
        self,
        *,
        base_os: Optional[str] = None,
        platform: Optional[str] = None,
        platform_version: Optional[str] = None,
        environment_variables: Optional[List["_models.EnvironmentVariable"]] = None,
        pre_build_steps: Optional[List["_models.PreBuildStep"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword base_os: Base OS used to build and run the app.
        :paramtype base_os: str
        :keyword platform: Platform to be used to build and run the app.
        :paramtype platform: str
        :keyword platform_version: Platform version to be used to build and run the app.
        :paramtype platform_version: str
        :keyword environment_variables: List of environment variables to be passed to the build,
         secrets should not be used in environment variable.
        :paramtype environment_variables: list[~azure.mgmt.appcontainers.models.EnvironmentVariable]
        :keyword pre_build_steps: List of steps to perform before the build.
        :paramtype pre_build_steps: list[~azure.mgmt.appcontainers.models.PreBuildStep]
        """
        super().__init__(**kwargs)
        self.base_os = base_os
        self.platform = platform
        self.platform_version = platform_version
        self.environment_variables = environment_variables
        self.pre_build_steps = pre_build_steps


class BuilderCollection(_serialization.Model):
    """The response of a BuilderResource list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The BuilderResource items on this page. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.BuilderResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BuilderResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.BuilderResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The BuilderResource items on this page. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.BuilderResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class BuilderResource(TrackedResource):
    """Information about the SourceToCloud builder resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar provisioning_state: Provisioning state of a builder resource. Known values are:
     "Succeeded", "Failed", "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.appcontainers.models.BuilderProvisioningState
    :ivar environment_id: Resource ID of the container apps environment that the builder is
     associated with.
    :vartype environment_id: str
    :ivar container_registries: List of mappings of container registries and the managed identity
     used to connect to it.
    :vartype container_registries: list[~azure.mgmt.appcontainers.models.ContainerRegistry]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
        "container_registries": {"key": "properties.containerRegistries", "type": "[ContainerRegistry]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        environment_id: Optional[str] = None,
        container_registries: Optional[List["_models.ContainerRegistry"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword environment_id: Resource ID of the container apps environment that the builder is
         associated with.
        :paramtype environment_id: str
        :keyword container_registries: List of mappings of container registries and the managed
         identity used to connect to it.
        :paramtype container_registries: list[~azure.mgmt.appcontainers.models.ContainerRegistry]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state: Optional[Union[str, "_models.BuilderProvisioningState"]] = None
        self.environment_id = environment_id
        self.container_registries = container_registries


class BuilderResourceUpdate(_serialization.Model):
    """The type used for update operations of the BuilderResource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar environment_id: Resource ID of the container apps environment that the builder is
     associated with.
    :vartype environment_id: str
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        environment_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword environment_id: Resource ID of the container apps environment that the builder is
         associated with.
        :paramtype environment_id: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.environment_id = environment_id


class BuildResource(ProxyResource):
    """Information pertaining to an individual build.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar provisioning_state: Build provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.appcontainers.models.BuildProvisioningState
    :ivar build_status: Status of the build once it has been provisioned. Known values are:
     "NotStarted", "InProgress", "Succeeded", "Canceled", and "Failed".
    :vartype build_status: str or ~azure.mgmt.appcontainers.models.BuildStatus
    :ivar destination_container_registry: Container registry that the final image will be uploaded
     to.
    :vartype destination_container_registry:
     ~azure.mgmt.appcontainers.models.ContainerRegistryWithCustomImage
    :ivar configuration: Configuration of the build.
    :vartype configuration: ~azure.mgmt.appcontainers.models.BuildConfiguration
    :ivar upload_endpoint: Endpoint to which the source code should be uploaded.
    :vartype upload_endpoint: str
    :ivar log_stream_endpoint: Endpoint from which the build logs can be streamed.
    :vartype log_stream_endpoint: str
    :ivar token_endpoint: Endpoint to use to retrieve an authentication token for log streaming and
     uploading source code.
    :vartype token_endpoint: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "build_status": {"readonly": True},
        "upload_endpoint": {"readonly": True},
        "log_stream_endpoint": {"readonly": True},
        "token_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "build_status": {"key": "properties.buildStatus", "type": "str"},
        "destination_container_registry": {
            "key": "properties.destinationContainerRegistry",
            "type": "ContainerRegistryWithCustomImage",
        },
        "configuration": {"key": "properties.configuration", "type": "BuildConfiguration"},
        "upload_endpoint": {"key": "properties.uploadEndpoint", "type": "str"},
        "log_stream_endpoint": {"key": "properties.logStreamEndpoint", "type": "str"},
        "token_endpoint": {"key": "properties.tokenEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        destination_container_registry: Optional["_models.ContainerRegistryWithCustomImage"] = None,
        configuration: Optional["_models.BuildConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination_container_registry: Container registry that the final image will be
         uploaded to.
        :paramtype destination_container_registry:
         ~azure.mgmt.appcontainers.models.ContainerRegistryWithCustomImage
        :keyword configuration: Configuration of the build.
        :paramtype configuration: ~azure.mgmt.appcontainers.models.BuildConfiguration
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.BuildProvisioningState"]] = None
        self.build_status: Optional[Union[str, "_models.BuildStatus"]] = None
        self.destination_container_registry = destination_container_registry
        self.configuration = configuration
        self.upload_endpoint: Optional[str] = None
        self.log_stream_endpoint: Optional[str] = None
        self.token_endpoint: Optional[str] = None


class BuildToken(_serialization.Model):
    """Build Auth Token.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar token: Authentication token.
    :vartype token: str
    :ivar expires: Token expiration date.
    :vartype expires: ~datetime.datetime
    """

    _validation = {
        "token": {"readonly": True},
        "expires": {"readonly": True},
    }

    _attribute_map = {
        "token": {"key": "token", "type": "str"},
        "expires": {"key": "expires", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.token: Optional[str] = None
        self.expires: Optional[datetime.datetime] = None


class Certificate(TrackedResource):
    """Certificate used for Custom Domain bindings of Container Apps in a Managed Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Certificate resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.CertificateProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "CertificateProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.CertificateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Certificate resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.CertificateProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class CertificateCollection(_serialization.Model):
    """Collection of Certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.Certificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Certificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Certificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.Certificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class CertificateKeyVaultProperties(_serialization.Model):
    """Properties for a certificate stored in a Key Vault.

    :ivar identity: Resource ID of a managed identity to authenticate with Azure Key Vault, or
     System to use a system-assigned identity.
    :vartype identity: str
    :ivar key_vault_url: URL pointing to the Azure Key Vault secret that holds the certificate.
    :vartype key_vault_url: str
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "str"},
        "key_vault_url": {"key": "keyVaultUrl", "type": "str"},
    }

    def __init__(self, *, identity: Optional[str] = None, key_vault_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword identity: Resource ID of a managed identity to authenticate with Azure Key Vault, or
         System to use a system-assigned identity.
        :paramtype identity: str
        :keyword key_vault_url: URL pointing to the Azure Key Vault secret that holds the certificate.
        :paramtype key_vault_url: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.key_vault_url = key_vault_url


class CertificatePatch(_serialization.Model):
    """A certificate to update.

    :ivar tags: Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class CertificateProperties(_serialization.Model):
    """Certificate resource specific properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the certificate. Known values are: "Succeeded",
     "Failed", "Canceled", "DeleteFailed", "Pending", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.CertificateProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar certificate_key_vault_properties: Properties for a certificate stored in a Key Vault.
    :vartype certificate_key_vault_properties:
     ~azure.mgmt.appcontainers.models.CertificateKeyVaultProperties
    :ivar password: Certificate password.
    :vartype password: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar subject_alternative_names: Subject alternative names the certificate applies to.
    :vartype subject_alternative_names: list[str]
    :ivar value: PFX or PEM blob.
    :vartype value: bytes
    :ivar issuer: Certificate issuer.
    :vartype issuer: str
    :ivar issue_date: Certificate issue Date.
    :vartype issue_date: ~datetime.datetime
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar valid: Is the certificate valid?.
    :vartype valid: bool
    :ivar public_key_hash: Public key hash.
    :vartype public_key_hash: str
    :ivar certificate_type: The type of the certificate. Allowed values are
     ``ServerSSLCertificate`` and ``ImagePullTrustedCA``. Known values are: "ServerSSLCertificate"
     and "ImagePullTrustedCA".
    :vartype certificate_type: str or ~azure.mgmt.appcontainers.models.CertificateType
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
        "subject_name": {"readonly": True},
        "subject_alternative_names": {"readonly": True},
        "issuer": {"readonly": True},
        "issue_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "valid": {"readonly": True},
        "public_key_hash": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_errors": {"key": "deploymentErrors", "type": "str"},
        "certificate_key_vault_properties": {
            "key": "certificateKeyVaultProperties",
            "type": "CertificateKeyVaultProperties",
        },
        "password": {"key": "password", "type": "str"},
        "subject_name": {"key": "subjectName", "type": "str"},
        "subject_alternative_names": {"key": "subjectAlternativeNames", "type": "[str]"},
        "value": {"key": "value", "type": "bytearray"},
        "issuer": {"key": "issuer", "type": "str"},
        "issue_date": {"key": "issueDate", "type": "iso-8601"},
        "expiration_date": {"key": "expirationDate", "type": "iso-8601"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "valid": {"key": "valid", "type": "bool"},
        "public_key_hash": {"key": "publicKeyHash", "type": "str"},
        "certificate_type": {"key": "certificateType", "type": "str"},
    }

    def __init__(
        self,
        *,
        certificate_key_vault_properties: Optional["_models.CertificateKeyVaultProperties"] = None,
        password: Optional[str] = None,
        value: Optional[bytes] = None,
        certificate_type: Optional[Union[str, "_models.CertificateType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword certificate_key_vault_properties: Properties for a certificate stored in a Key Vault.
        :paramtype certificate_key_vault_properties:
         ~azure.mgmt.appcontainers.models.CertificateKeyVaultProperties
        :keyword password: Certificate password.
        :paramtype password: str
        :keyword value: PFX or PEM blob.
        :paramtype value: bytes
        :keyword certificate_type: The type of the certificate. Allowed values are
         ``ServerSSLCertificate`` and ``ImagePullTrustedCA``. Known values are: "ServerSSLCertificate"
         and "ImagePullTrustedCA".
        :paramtype certificate_type: str or ~azure.mgmt.appcontainers.models.CertificateType
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.CertificateProvisioningState"]] = None
        self.deployment_errors: Optional[str] = None
        self.certificate_key_vault_properties = certificate_key_vault_properties
        self.password = password
        self.subject_name: Optional[str] = None
        self.subject_alternative_names: Optional[List[str]] = None
        self.value = value
        self.issuer: Optional[str] = None
        self.issue_date: Optional[datetime.datetime] = None
        self.expiration_date: Optional[datetime.datetime] = None
        self.thumbprint: Optional[str] = None
        self.valid: Optional[bool] = None
        self.public_key_hash: Optional[str] = None
        self.certificate_type = certificate_type


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """The check availability result.

    :ivar name_available: Indicates if the resource name is available.
    :vartype name_available: bool
    :ivar reason: The reason why the given name is not available. Known values are: "Invalid" and
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.appcontainers.models.CheckNameAvailabilityReason
    :ivar message: Detailed reason why the given name is available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates if the resource name is available.
        :paramtype name_available: bool
        :keyword reason: The reason why the given name is not available. Known values are: "Invalid"
         and "AlreadyExists".
        :paramtype reason: str or ~azure.mgmt.appcontainers.models.CheckNameAvailabilityReason
        :keyword message: Detailed reason why the given name is available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class CircuitBreakerPolicy(_serialization.Model):
    """Policy that defines circuit breaker conditions.

    :ivar consecutive_errors: Number of consecutive errors before the circuit breaker opens.
    :vartype consecutive_errors: int
    :ivar interval_in_seconds: The time interval, in seconds, between endpoint checks. This can
     result in opening the circuit breaker if the check fails as well as closing the circuit breaker
     if the check succeeds. Defaults to 10s.
    :vartype interval_in_seconds: int
    :ivar max_ejection_percent: Maximum percentage of hosts that will be ejected after failure
     threshold has been met.
    :vartype max_ejection_percent: int
    """

    _attribute_map = {
        "consecutive_errors": {"key": "consecutiveErrors", "type": "int"},
        "interval_in_seconds": {"key": "intervalInSeconds", "type": "int"},
        "max_ejection_percent": {"key": "maxEjectionPercent", "type": "int"},
    }

    def __init__(
        self,
        *,
        consecutive_errors: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        max_ejection_percent: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword consecutive_errors: Number of consecutive errors before the circuit breaker opens.
        :paramtype consecutive_errors: int
        :keyword interval_in_seconds: The time interval, in seconds, between endpoint checks. This can
         result in opening the circuit breaker if the check fails as well as closing the circuit breaker
         if the check succeeds. Defaults to 10s.
        :paramtype interval_in_seconds: int
        :keyword max_ejection_percent: Maximum percentage of hosts that will be ejected after failure
         threshold has been met.
        :paramtype max_ejection_percent: int
        """
        super().__init__(**kwargs)
        self.consecutive_errors = consecutive_errors
        self.interval_in_seconds = interval_in_seconds
        self.max_ejection_percent = max_ejection_percent


class ClientRegistration(_serialization.Model):
    """The configuration settings of the app registration for providers that have client ids and
    client secrets.

    :ivar client_id: The Client ID of the app used for login.
    :vartype client_id: str
    :ivar client_secret_setting_name: The app setting name that contains the client secret.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
    }

    def __init__(
        self, *, client_id: Optional[str] = None, client_secret_setting_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The Client ID of the app used for login.
        :paramtype client_id: str
        :keyword client_secret_setting_name: The app setting name that contains the client secret.
        :paramtype client_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_secret_setting_name = client_secret_setting_name


class Configuration(_serialization.Model):
    """Non versioned Container App configuration properties that define the mutable settings of a
    Container app.

    :ivar secrets: Collection of secrets used by a Container app.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.Secret]
    :ivar active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled for
     the Container app:


     .. raw:: html

        <list><item>Single: Only one revision can be active at a time. Traffic weights cannot be
     used. This is the default.</item><item>Multiple: Multiple revisions can be active, including
     optional traffic weights and labels.</item><item>Labels: Only revisions with labels are active.
     Traffic weights can be applied to labels.</item></list>. Known values are: "Multiple",
     "Single", and "Labels".
    :vartype active_revisions_mode: str or ~azure.mgmt.appcontainers.models.ActiveRevisionsMode
    :ivar target_label: Required in labels revisions mode. Label to apply to newly created
     revision.
    :vartype target_label: str
    :ivar ingress: Ingress configurations.
    :vartype ingress: ~azure.mgmt.appcontainers.models.Ingress
    :ivar registries: Collection of private container registry credentials for containers used by
     the Container app.
    :vartype registries: list[~azure.mgmt.appcontainers.models.RegistryCredentials]
    :ivar dapr: Dapr configuration for the Container App.
    :vartype dapr: ~azure.mgmt.appcontainers.models.Dapr
    :ivar runtime: App runtime configuration for the Container App.
    :vartype runtime: ~azure.mgmt.appcontainers.models.Runtime
    :ivar max_inactive_revisions: Optional. Max inactive revisions a Container App can have.
    :vartype max_inactive_revisions: int
    :ivar revision_transition_threshold: Optional. The percent of the total number of replicas that
     must be brought up before revision transition occurs. Defaults to 100 when none is given. Value
     must be greater than 0 and less than or equal to 100.
    :vartype revision_transition_threshold: int
    :ivar service: Container App to be a dev Container App Service.
    :vartype service: ~azure.mgmt.appcontainers.models.Service
    :ivar identity_settings: Optional settings for Managed Identities that are assigned to the
     Container App. If a Managed Identity is not specified here, default settings will be used.
    :vartype identity_settings: list[~azure.mgmt.appcontainers.models.IdentitySettings]
    """

    _validation = {
        "revision_transition_threshold": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[Secret]"},
        "active_revisions_mode": {"key": "activeRevisionsMode", "type": "str"},
        "target_label": {"key": "targetLabel", "type": "str"},
        "ingress": {"key": "ingress", "type": "Ingress"},
        "registries": {"key": "registries", "type": "[RegistryCredentials]"},
        "dapr": {"key": "dapr", "type": "Dapr"},
        "runtime": {"key": "runtime", "type": "Runtime"},
        "max_inactive_revisions": {"key": "maxInactiveRevisions", "type": "int"},
        "revision_transition_threshold": {"key": "revisionTransitionThreshold", "type": "int"},
        "service": {"key": "service", "type": "Service"},
        "identity_settings": {"key": "identitySettings", "type": "[IdentitySettings]"},
    }

    def __init__(
        self,
        *,
        secrets: Optional[List["_models.Secret"]] = None,
        active_revisions_mode: Union[str, "_models.ActiveRevisionsMode"] = "Single",
        target_label: Optional[str] = None,
        ingress: Optional["_models.Ingress"] = None,
        registries: Optional[List["_models.RegistryCredentials"]] = None,
        dapr: Optional["_models.Dapr"] = None,
        runtime: Optional["_models.Runtime"] = None,
        max_inactive_revisions: Optional[int] = None,
        revision_transition_threshold: Optional[int] = None,
        service: Optional["_models.Service"] = None,
        identity_settings: Optional[List["_models.IdentitySettings"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword secrets: Collection of secrets used by a Container app.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.Secret]
        :keyword active_revisions_mode: ActiveRevisionsMode controls how active revisions are handled
         for the Container app:


         .. raw:: html

            <list><item>Single: Only one revision can be active at a time. Traffic weights cannot be
         used. This is the default.</item><item>Multiple: Multiple revisions can be active, including
         optional traffic weights and labels.</item><item>Labels: Only revisions with labels are active.
         Traffic weights can be applied to labels.</item></list>. Known values are: "Multiple",
         "Single", and "Labels".
        :paramtype active_revisions_mode: str or ~azure.mgmt.appcontainers.models.ActiveRevisionsMode
        :keyword target_label: Required in labels revisions mode. Label to apply to newly created
         revision.
        :paramtype target_label: str
        :keyword ingress: Ingress configurations.
        :paramtype ingress: ~azure.mgmt.appcontainers.models.Ingress
        :keyword registries: Collection of private container registry credentials for containers used
         by the Container app.
        :paramtype registries: list[~azure.mgmt.appcontainers.models.RegistryCredentials]
        :keyword dapr: Dapr configuration for the Container App.
        :paramtype dapr: ~azure.mgmt.appcontainers.models.Dapr
        :keyword runtime: App runtime configuration for the Container App.
        :paramtype runtime: ~azure.mgmt.appcontainers.models.Runtime
        :keyword max_inactive_revisions: Optional. Max inactive revisions a Container App can have.
        :paramtype max_inactive_revisions: int
        :keyword revision_transition_threshold: Optional. The percent of the total number of replicas
         that must be brought up before revision transition occurs. Defaults to 100 when none is given.
         Value must be greater than 0 and less than or equal to 100.
        :paramtype revision_transition_threshold: int
        :keyword service: Container App to be a dev Container App Service.
        :paramtype service: ~azure.mgmt.appcontainers.models.Service
        :keyword identity_settings: Optional settings for Managed Identities that are assigned to the
         Container App. If a Managed Identity is not specified here, default settings will be used.
        :paramtype identity_settings: list[~azure.mgmt.appcontainers.models.IdentitySettings]
        """
        super().__init__(**kwargs)
        self.secrets = secrets
        self.active_revisions_mode = active_revisions_mode
        self.target_label = target_label
        self.ingress = ingress
        self.registries = registries
        self.dapr = dapr
        self.runtime = runtime
        self.max_inactive_revisions = max_inactive_revisions
        self.revision_transition_threshold = revision_transition_threshold
        self.service = service
        self.identity_settings = identity_settings


class ConnectedEnvironment(TrackedResource):
    """An environment for Kubernetes cluster specialized for web workloads by Azure App Service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The complex type of the extended location.
    :vartype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
    :ivar provisioning_state: Provisioning state of the Kubernetes Environment. Known values are:
     "Succeeded", "Failed", "Canceled", "Waiting", "InitializationInProgress",
     "InfrastructureSetupInProgress", "InfrastructureSetupComplete", and "ScheduledForDelete".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.ConnectedEnvironmentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :ivar static_ip: Static IP of the connectedEnvironment.
    :vartype static_ip: str
    :ivar dapr_ai_connection_string: Application Insights connection string used by Dapr to export
     Service to Service communication telemetry.
    :vartype dapr_ai_connection_string: str
    :ivar custom_domain_configuration: Custom domain configuration for the environment.
    :vartype custom_domain_configuration:
     ~azure.mgmt.appcontainers.models.CustomDomainConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
        "default_domain": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_errors": {"key": "properties.deploymentErrors", "type": "str"},
        "default_domain": {"key": "properties.defaultDomain", "type": "str"},
        "static_ip": {"key": "properties.staticIp", "type": "str"},
        "dapr_ai_connection_string": {"key": "properties.daprAIConnectionString", "type": "str"},
        "custom_domain_configuration": {
            "key": "properties.customDomainConfiguration",
            "type": "CustomDomainConfiguration",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        static_ip: Optional[str] = None,
        dapr_ai_connection_string: Optional[str] = None,
        custom_domain_configuration: Optional["_models.CustomDomainConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The complex type of the extended location.
        :paramtype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
        :keyword static_ip: Static IP of the connectedEnvironment.
        :paramtype static_ip: str
        :keyword dapr_ai_connection_string: Application Insights connection string used by Dapr to
         export Service to Service communication telemetry.
        :paramtype dapr_ai_connection_string: str
        :keyword custom_domain_configuration: Custom domain configuration for the environment.
        :paramtype custom_domain_configuration:
         ~azure.mgmt.appcontainers.models.CustomDomainConfiguration
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.provisioning_state: Optional[Union[str, "_models.ConnectedEnvironmentProvisioningState"]] = None
        self.deployment_errors: Optional[str] = None
        self.default_domain: Optional[str] = None
        self.static_ip = static_ip
        self.dapr_ai_connection_string = dapr_ai_connection_string
        self.custom_domain_configuration = custom_domain_configuration


class ConnectedEnvironmentCollection(_serialization.Model):
    """Collection of connectedEnvironments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of resources.
    :vartype value: list[~azure.mgmt.appcontainers.models.ConnectedEnvironment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectedEnvironment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ConnectedEnvironment"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ConnectedEnvironment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ConnectedEnvironmentDaprComponent(ProxyResource):
    """Dapr Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar component_type: Component type.
    :vartype component_type: str
    :ivar version: Component version.
    :vartype version: str
    :ivar ignore_errors: Boolean describing if the component errors are ignores.
    :vartype ignore_errors: bool
    :ivar init_timeout: Initialization timeout.
    :vartype init_timeout: str
    :ivar secrets: Collection of secrets used by a Dapr component.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.Secret]
    :ivar secret_store_component: Name of a Dapr component to retrieve component secrets from.
    :vartype secret_store_component: str
    :ivar metadata: Component metadata.
    :vartype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
    :ivar scopes: Names of container apps that can use this Dapr component.
    :vartype scopes: list[str]
    :ivar service_component_bind: List of container app services that are bound to the Dapr
     component.
    :vartype service_component_bind:
     list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
    :ivar provisioning_state: Provisioning state of the Connected Environment Dapr Component. Known
     values are: "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.ConnectedEnvironmentDaprComponentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "component_type": {"key": "properties.componentType", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "ignore_errors": {"key": "properties.ignoreErrors", "type": "bool"},
        "init_timeout": {"key": "properties.initTimeout", "type": "str"},
        "secrets": {"key": "properties.secrets", "type": "[Secret]"},
        "secret_store_component": {"key": "properties.secretStoreComponent", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "[DaprMetadata]"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "service_component_bind": {"key": "properties.serviceComponentBind", "type": "[DaprComponentServiceBinding]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "deployment_errors": {"key": "properties.deploymentErrors", "type": "str"},
    }

    def __init__(
        self,
        *,
        component_type: Optional[str] = None,
        version: Optional[str] = None,
        ignore_errors: bool = False,
        init_timeout: Optional[str] = None,
        secrets: Optional[List["_models.Secret"]] = None,
        secret_store_component: Optional[str] = None,
        metadata: Optional[List["_models.DaprMetadata"]] = None,
        scopes: Optional[List[str]] = None,
        service_component_bind: Optional[List["_models.DaprComponentServiceBinding"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component_type: Component type.
        :paramtype component_type: str
        :keyword version: Component version.
        :paramtype version: str
        :keyword ignore_errors: Boolean describing if the component errors are ignores.
        :paramtype ignore_errors: bool
        :keyword init_timeout: Initialization timeout.
        :paramtype init_timeout: str
        :keyword secrets: Collection of secrets used by a Dapr component.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.Secret]
        :keyword secret_store_component: Name of a Dapr component to retrieve component secrets from.
        :paramtype secret_store_component: str
        :keyword metadata: Component metadata.
        :paramtype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
        :keyword scopes: Names of container apps that can use this Dapr component.
        :paramtype scopes: list[str]
        :keyword service_component_bind: List of container app services that are bound to the Dapr
         component.
        :paramtype service_component_bind:
         list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
        """
        super().__init__(**kwargs)
        self.component_type = component_type
        self.version = version
        self.ignore_errors = ignore_errors
        self.init_timeout = init_timeout
        self.secrets = secrets
        self.secret_store_component = secret_store_component
        self.metadata = metadata
        self.scopes = scopes
        self.service_component_bind = service_component_bind
        self.provisioning_state: Optional[Union[str, "_models.ConnectedEnvironmentDaprComponentProvisioningState"]] = (
            None
        )
        self.deployment_errors: Optional[str] = None


class DaprComponentProperties(_serialization.Model):
    """Dapr Component resource specific properties.

    :ivar component_type: Component type.
    :vartype component_type: str
    :ivar version: Component version.
    :vartype version: str
    :ivar ignore_errors: Boolean describing if the component errors are ignores.
    :vartype ignore_errors: bool
    :ivar init_timeout: Initialization timeout.
    :vartype init_timeout: str
    :ivar secrets: Collection of secrets used by a Dapr component.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.Secret]
    :ivar secret_store_component: Name of a Dapr component to retrieve component secrets from.
    :vartype secret_store_component: str
    :ivar metadata: Component metadata.
    :vartype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
    :ivar scopes: Names of container apps that can use this Dapr component.
    :vartype scopes: list[str]
    :ivar service_component_bind: List of container app services that are bound to the Dapr
     component.
    :vartype service_component_bind:
     list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
    """

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "ignore_errors": {"key": "ignoreErrors", "type": "bool"},
        "init_timeout": {"key": "initTimeout", "type": "str"},
        "secrets": {"key": "secrets", "type": "[Secret]"},
        "secret_store_component": {"key": "secretStoreComponent", "type": "str"},
        "metadata": {"key": "metadata", "type": "[DaprMetadata]"},
        "scopes": {"key": "scopes", "type": "[str]"},
        "service_component_bind": {"key": "serviceComponentBind", "type": "[DaprComponentServiceBinding]"},
    }

    def __init__(
        self,
        *,
        component_type: Optional[str] = None,
        version: Optional[str] = None,
        ignore_errors: bool = False,
        init_timeout: Optional[str] = None,
        secrets: Optional[List["_models.Secret"]] = None,
        secret_store_component: Optional[str] = None,
        metadata: Optional[List["_models.DaprMetadata"]] = None,
        scopes: Optional[List[str]] = None,
        service_component_bind: Optional[List["_models.DaprComponentServiceBinding"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component_type: Component type.
        :paramtype component_type: str
        :keyword version: Component version.
        :paramtype version: str
        :keyword ignore_errors: Boolean describing if the component errors are ignores.
        :paramtype ignore_errors: bool
        :keyword init_timeout: Initialization timeout.
        :paramtype init_timeout: str
        :keyword secrets: Collection of secrets used by a Dapr component.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.Secret]
        :keyword secret_store_component: Name of a Dapr component to retrieve component secrets from.
        :paramtype secret_store_component: str
        :keyword metadata: Component metadata.
        :paramtype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
        :keyword scopes: Names of container apps that can use this Dapr component.
        :paramtype scopes: list[str]
        :keyword service_component_bind: List of container app services that are bound to the Dapr
         component.
        :paramtype service_component_bind:
         list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
        """
        super().__init__(**kwargs)
        self.component_type = component_type
        self.version = version
        self.ignore_errors = ignore_errors
        self.init_timeout = init_timeout
        self.secrets = secrets
        self.secret_store_component = secret_store_component
        self.metadata = metadata
        self.scopes = scopes
        self.service_component_bind = service_component_bind


class ConnectedEnvironmentDaprComponentProperties(DaprComponentProperties):  # pylint: disable=name-too-long
    """Dapr component properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar component_type: Component type.
    :vartype component_type: str
    :ivar version: Component version.
    :vartype version: str
    :ivar ignore_errors: Boolean describing if the component errors are ignores.
    :vartype ignore_errors: bool
    :ivar init_timeout: Initialization timeout.
    :vartype init_timeout: str
    :ivar secrets: Collection of secrets used by a Dapr component.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.Secret]
    :ivar secret_store_component: Name of a Dapr component to retrieve component secrets from.
    :vartype secret_store_component: str
    :ivar metadata: Component metadata.
    :vartype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
    :ivar scopes: Names of container apps that can use this Dapr component.
    :vartype scopes: list[str]
    :ivar service_component_bind: List of container app services that are bound to the Dapr
     component.
    :vartype service_component_bind:
     list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
    :ivar provisioning_state: Provisioning state of the Connected Environment Dapr Component. Known
     values are: "Succeeded", "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.ConnectedEnvironmentDaprComponentProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
    }

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "ignore_errors": {"key": "ignoreErrors", "type": "bool"},
        "init_timeout": {"key": "initTimeout", "type": "str"},
        "secrets": {"key": "secrets", "type": "[Secret]"},
        "secret_store_component": {"key": "secretStoreComponent", "type": "str"},
        "metadata": {"key": "metadata", "type": "[DaprMetadata]"},
        "scopes": {"key": "scopes", "type": "[str]"},
        "service_component_bind": {"key": "serviceComponentBind", "type": "[DaprComponentServiceBinding]"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_errors": {"key": "deploymentErrors", "type": "str"},
    }

    def __init__(
        self,
        *,
        component_type: Optional[str] = None,
        version: Optional[str] = None,
        ignore_errors: bool = False,
        init_timeout: Optional[str] = None,
        secrets: Optional[List["_models.Secret"]] = None,
        secret_store_component: Optional[str] = None,
        metadata: Optional[List["_models.DaprMetadata"]] = None,
        scopes: Optional[List[str]] = None,
        service_component_bind: Optional[List["_models.DaprComponentServiceBinding"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component_type: Component type.
        :paramtype component_type: str
        :keyword version: Component version.
        :paramtype version: str
        :keyword ignore_errors: Boolean describing if the component errors are ignores.
        :paramtype ignore_errors: bool
        :keyword init_timeout: Initialization timeout.
        :paramtype init_timeout: str
        :keyword secrets: Collection of secrets used by a Dapr component.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.Secret]
        :keyword secret_store_component: Name of a Dapr component to retrieve component secrets from.
        :paramtype secret_store_component: str
        :keyword metadata: Component metadata.
        :paramtype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
        :keyword scopes: Names of container apps that can use this Dapr component.
        :paramtype scopes: list[str]
        :keyword service_component_bind: List of container app services that are bound to the Dapr
         component.
        :paramtype service_component_bind:
         list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
        """
        super().__init__(
            component_type=component_type,
            version=version,
            ignore_errors=ignore_errors,
            init_timeout=init_timeout,
            secrets=secrets,
            secret_store_component=secret_store_component,
            metadata=metadata,
            scopes=scopes,
            service_component_bind=service_component_bind,
            **kwargs
        )
        self.provisioning_state: Optional[Union[str, "_models.ConnectedEnvironmentDaprComponentProvisioningState"]] = (
            None
        )
        self.deployment_errors: Optional[str] = None


class ConnectedEnvironmentDaprComponentsCollection(_serialization.Model):  # pylint: disable=name-too-long
    """Collection of Dapr Components for Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of Dapr component resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ConnectedEnvironmentDaprComponent]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectedEnvironmentDaprComponent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ConnectedEnvironmentDaprComponent"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of Dapr component resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ConnectedEnvironmentDaprComponent]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ResourceTags(_serialization.Model):
    """List of key value pairs that describe the resource. This will overwrite the existing tags.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ConnectedEnvironmentPatchResource(ResourceTags):
    """Connected environment patch properties.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """


class ConnectedEnvironmentStorage(ProxyResource):
    """Storage resource for connectedEnvironment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Storage properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.ConnectedEnvironmentStorageProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ConnectedEnvironmentStorageProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ConnectedEnvironmentStorageProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Storage properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.ConnectedEnvironmentStorageProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ConnectedEnvironmentStorageProperties(_serialization.Model):
    """Storage properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the storage. Known values are: "Succeeded",
     "Failed", "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.ConnectedEnvironmentStorageProvisioningState
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar azure_file: Azure file properties.
    :vartype azure_file: ~azure.mgmt.appcontainers.models.AzureFileProperties
    :ivar smb: SMB storage properties.
    :vartype smb: ~azure.mgmt.appcontainers.models.SmbStorage
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "deployment_errors": {"key": "deploymentErrors", "type": "str"},
        "azure_file": {"key": "azureFile", "type": "AzureFileProperties"},
        "smb": {"key": "smb", "type": "SmbStorage"},
    }

    def __init__(
        self,
        *,
        azure_file: Optional["_models.AzureFileProperties"] = None,
        smb: Optional["_models.SmbStorage"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_file: Azure file properties.
        :paramtype azure_file: ~azure.mgmt.appcontainers.models.AzureFileProperties
        :keyword smb: SMB storage properties.
        :paramtype smb: ~azure.mgmt.appcontainers.models.SmbStorage
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.ConnectedEnvironmentStorageProvisioningState"]] = None
        self.deployment_errors: Optional[str] = None
        self.azure_file = azure_file
        self.smb = smb


class ConnectedEnvironmentStoragesCollection(_serialization.Model):
    """Collection of Storage for Environments.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of storage resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ConnectedEnvironmentStorage]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectedEnvironmentStorage]"},
    }

    def __init__(self, *, value: List["_models.ConnectedEnvironmentStorage"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of storage resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ConnectedEnvironmentStorage]
        """
        super().__init__(**kwargs)
        self.value = value


class Container(BaseContainer):
    """Container App container definition.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar image_type: The type of the image. Set to CloudBuild to let the system manages the image,
     where user will not be able to update image through image field. Set to ContainerImage for user
     provided image. Known values are: "CloudBuild" and "ContainerImage".
    :vartype image_type: str or ~azure.mgmt.appcontainers.models.ImageType
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~azure.mgmt.appcontainers.models.ContainerResources
    :ivar volume_mounts: Container volume mounts.
    :vartype volume_mounts: list[~azure.mgmt.appcontainers.models.VolumeMount]
    :ivar probes: List of probes for the container.
    :vartype probes: list[~azure.mgmt.appcontainers.models.ContainerAppProbe]
    """

    _attribute_map = {
        "image": {"key": "image", "type": "str"},
        "image_type": {"key": "imageType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
        "args": {"key": "args", "type": "[str]"},
        "env": {"key": "env", "type": "[EnvironmentVar]"},
        "resources": {"key": "resources", "type": "ContainerResources"},
        "volume_mounts": {"key": "volumeMounts", "type": "[VolumeMount]"},
        "probes": {"key": "probes", "type": "[ContainerAppProbe]"},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        image_type: Optional[Union[str, "_models.ImageType"]] = None,
        name: Optional[str] = None,
        command: Optional[List[str]] = None,
        args: Optional[List[str]] = None,
        env: Optional[List["_models.EnvironmentVar"]] = None,
        resources: Optional["_models.ContainerResources"] = None,
        volume_mounts: Optional[List["_models.VolumeMount"]] = None,
        probes: Optional[List["_models.ContainerAppProbe"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image: Container image tag.
        :paramtype image: str
        :keyword image_type: The type of the image. Set to CloudBuild to let the system manages the
         image, where user will not be able to update image through image field. Set to ContainerImage
         for user provided image. Known values are: "CloudBuild" and "ContainerImage".
        :paramtype image_type: str or ~azure.mgmt.appcontainers.models.ImageType
        :keyword name: Custom container name.
        :paramtype name: str
        :keyword command: Container start command.
        :paramtype command: list[str]
        :keyword args: Container start command arguments.
        :paramtype args: list[str]
        :keyword env: Container environment variables.
        :paramtype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
        :keyword resources: Container resource requirements.
        :paramtype resources: ~azure.mgmt.appcontainers.models.ContainerResources
        :keyword volume_mounts: Container volume mounts.
        :paramtype volume_mounts: list[~azure.mgmt.appcontainers.models.VolumeMount]
        :keyword probes: List of probes for the container.
        :paramtype probes: list[~azure.mgmt.appcontainers.models.ContainerAppProbe]
        """
        super().__init__(
            image=image,
            image_type=image_type,
            name=name,
            command=command,
            args=args,
            env=env,
            resources=resources,
            volume_mounts=volume_mounts,
            **kwargs
        )
        self.probes = probes


class ContainerApp(TrackedResource):
    """Container App.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The complex type of the extended location.
    :vartype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
    :ivar identity: managed identities for the Container App to interact with other Azure services
     without maintaining any secrets or credentials in code.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar managed_by: The fully qualified resource ID of the resource that manages this resource.
     Indicates if this resource is managed by another Azure resource. If this is present, complete
     mode deployment will not delete the resource if it is removed from the template since it is
     managed by another resource.
    :vartype managed_by: str
    :ivar kind: Metadata used to render different experiences for resources of the same type; e.g.
     WorkflowApp is a kind of Microsoft.App/ContainerApps type. If supported, the resource provider
     must validate and persist this value. "workflowapp"
    :vartype kind: str or ~azure.mgmt.appcontainers.models.Kind
    :ivar provisioning_state: Provisioning state of the Container App. Known values are:
     "InProgress", "Succeeded", "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.ContainerAppProvisioningState
    :ivar running_status: Running status of the Container App. Known values are: "Progressing",
     "Running", "Stopped", "Suspended", and "Ready".
    :vartype running_status: str or ~azure.mgmt.appcontainers.models.ContainerAppRunningStatus
    :ivar deployment_errors: Any errors that occurred during deployment.
    :vartype deployment_errors: str
    :ivar managed_environment_id: Deprecated. Resource ID of the Container App's environment.
    :vartype managed_environment_id: str
    :ivar environment_id: Resource ID of environment.
    :vartype environment_id: str
    :ivar workload_profile_name: Workload profile name to pin for container app execution.
    :vartype workload_profile_name: str
    :ivar patching_configuration: Container App auto patch configuration.
    :vartype patching_configuration:
     ~azure.mgmt.appcontainers.models.ContainerAppPropertiesPatchingConfiguration
    :ivar latest_revision_name: Name of the latest revision of the Container App.
    :vartype latest_revision_name: str
    :ivar latest_ready_revision_name: Name of the latest ready revision of the Container App.
    :vartype latest_ready_revision_name: str
    :ivar latest_revision_fqdn: Fully Qualified Domain Name of the latest revision of the Container
     App.
    :vartype latest_revision_fqdn: str
    :ivar custom_domain_verification_id: Id used to verify domain name ownership.
    :vartype custom_domain_verification_id: str
    :ivar configuration: Non versioned Container App configuration properties.
    :vartype configuration: ~azure.mgmt.appcontainers.models.Configuration
    :ivar template: Container App versioned application definition.
    :vartype template: ~azure.mgmt.appcontainers.models.Template
    :ivar outbound_ip_addresses: Outbound IP Addresses for container app.
    :vartype outbound_ip_addresses: list[str]
    :ivar event_stream_endpoint: The endpoint of the eventstream of the container app.
    :vartype event_stream_endpoint: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "running_status": {"readonly": True},
        "deployment_errors": {"readonly": True},
        "latest_revision_name": {"readonly": True},
        "latest_ready_revision_name": {"readonly": True},
        "latest_revision_fqdn": {"readonly": True},
        "custom_domain_verification_id": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "event_stream_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "running_status": {"key": "properties.runningStatus", "type": "str"},
        "deployment_errors": {"key": "properties.deploymentErrors", "type": "str"},
        "managed_environment_id": {"key": "properties.managedEnvironmentId", "type": "str"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
        "workload_profile_name": {"key": "properties.workloadProfileName", "type": "str"},
        "patching_configuration": {
            "key": "properties.patchingConfiguration",
            "type": "ContainerAppPropertiesPatchingConfiguration",
        },
        "latest_revision_name": {"key": "properties.latestRevisionName", "type": "str"},
        "latest_ready_revision_name": {"key": "properties.latestReadyRevisionName", "type": "str"},
        "latest_revision_fqdn": {"key": "properties.latestRevisionFqdn", "type": "str"},
        "custom_domain_verification_id": {"key": "properties.customDomainVerificationId", "type": "str"},
        "configuration": {"key": "properties.configuration", "type": "Configuration"},
        "template": {"key": "properties.template", "type": "Template"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "[str]"},
        "event_stream_endpoint": {"key": "properties.eventStreamEndpoint", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        managed_by: Optional[str] = None,
        kind: Optional[Union[str, "_models.Kind"]] = None,
        managed_environment_id: Optional[str] = None,
        environment_id: Optional[str] = None,
        workload_profile_name: Optional[str] = None,
        patching_configuration: Optional["_models.ContainerAppPropertiesPatchingConfiguration"] = None,
        configuration: Optional["_models.Configuration"] = None,
        template: Optional["_models.Template"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The complex type of the extended location.
        :paramtype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
        :keyword identity: managed identities for the Container App to interact with other Azure
         services without maintaining any secrets or credentials in code.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword managed_by: The fully qualified resource ID of the resource that manages this
         resource. Indicates if this resource is managed by another Azure resource. If this is present,
         complete mode deployment will not delete the resource if it is removed from the template since
         it is managed by another resource.
        :paramtype managed_by: str
        :keyword kind: Metadata used to render different experiences for resources of the same type;
         e.g. WorkflowApp is a kind of Microsoft.App/ContainerApps type. If supported, the resource
         provider must validate and persist this value. "workflowapp"
        :paramtype kind: str or ~azure.mgmt.appcontainers.models.Kind
        :keyword managed_environment_id: Deprecated. Resource ID of the Container App's environment.
        :paramtype managed_environment_id: str
        :keyword environment_id: Resource ID of environment.
        :paramtype environment_id: str
        :keyword workload_profile_name: Workload profile name to pin for container app execution.
        :paramtype workload_profile_name: str
        :keyword patching_configuration: Container App auto patch configuration.
        :paramtype patching_configuration:
         ~azure.mgmt.appcontainers.models.ContainerAppPropertiesPatchingConfiguration
        :keyword configuration: Non versioned Container App configuration properties.
        :paramtype configuration: ~azure.mgmt.appcontainers.models.Configuration
        :keyword template: Container App versioned application definition.
        :paramtype template: ~azure.mgmt.appcontainers.models.Template
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.identity = identity
        self.managed_by = managed_by
        self.kind = kind
        self.provisioning_state: Optional[Union[str, "_models.ContainerAppProvisioningState"]] = None
        self.running_status: Optional[Union[str, "_models.ContainerAppRunningStatus"]] = None
        self.deployment_errors: Optional[str] = None
        self.managed_environment_id = managed_environment_id
        self.environment_id = environment_id
        self.workload_profile_name = workload_profile_name
        self.patching_configuration = patching_configuration
        self.latest_revision_name: Optional[str] = None
        self.latest_ready_revision_name: Optional[str] = None
        self.latest_revision_fqdn: Optional[str] = None
        self.custom_domain_verification_id: Optional[str] = None
        self.configuration = configuration
        self.template = template
        self.outbound_ip_addresses: Optional[List[str]] = None
        self.event_stream_endpoint: Optional[str] = None


class ContainerAppAuthToken(TrackedResource):
    """Container App Auth Token.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar token: Auth token value.
    :vartype token: str
    :ivar expires: Token expiration date.
    :vartype expires: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "token": {"readonly": True},
        "expires": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "token": {"key": "properties.token", "type": "str"},
        "expires": {"key": "properties.expires", "type": "iso-8601"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.token: Optional[str] = None
        self.expires: Optional[datetime.datetime] = None


class ContainerAppCollection(_serialization.Model):
    """Container App collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ContainerApp]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContainerApp]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ContainerApp"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ContainerApp]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ContainerAppJobExecutions(_serialization.Model):
    """Container App executions collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.JobExecution]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobExecution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.JobExecution"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.JobExecution]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ContainerAppProbe(_serialization.Model):
    """Probe describes a health check to be performed against a container to determine whether it is
    alive or ready to receive traffic.

    :ivar failure_threshold: Minimum consecutive failures for the probe to be considered failed
     after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
    :vartype failure_threshold: int
    :ivar http_get: HTTPGet specifies the http request to perform.
    :vartype http_get: ~azure.mgmt.appcontainers.models.ContainerAppProbeHttpGet
    :ivar initial_delay_seconds: Number of seconds after the container has started before liveness
     probes are initiated. Minimum value is 1. Maximum value is 60.
    :vartype initial_delay_seconds: int
    :ivar period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds.
     Minimum value is 1. Maximum value is 240.
    :vartype period_seconds: int
    :ivar success_threshold: Minimum consecutive successes for the probe to be considered
     successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
     value is 1. Maximum value is 10.
    :vartype success_threshold: int
    :ivar tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet
     supported.
    :vartype tcp_socket: ~azure.mgmt.appcontainers.models.ContainerAppProbeTcpSocket
    :ivar termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate
     gracefully upon probe failure. The grace period is the duration in seconds after the processes
     running in the pod are sent a termination signal and the time when the processes are forcibly
     halted with a kill signal. Set this value longer than the expected cleanup time for your
     process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise,
     this value overrides the value provided by the pod spec. Value must be non-negative integer.
     The value zero indicates stop immediately via the kill signal (no opportunity to shut down).
     This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum
     value is 3600 seconds (1 hour).
    :vartype termination_grace_period_seconds: int
    :ivar timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second.
     Minimum value is 1. Maximum value is 240.
    :vartype timeout_seconds: int
    :ivar type: The type of probe. Known values are: "Liveness", "Readiness", and "Startup".
    :vartype type: str or ~azure.mgmt.appcontainers.models.Type
    """

    _attribute_map = {
        "failure_threshold": {"key": "failureThreshold", "type": "int"},
        "http_get": {"key": "httpGet", "type": "ContainerAppProbeHttpGet"},
        "initial_delay_seconds": {"key": "initialDelaySeconds", "type": "int"},
        "period_seconds": {"key": "periodSeconds", "type": "int"},
        "success_threshold": {"key": "successThreshold", "type": "int"},
        "tcp_socket": {"key": "tcpSocket", "type": "ContainerAppProbeTcpSocket"},
        "termination_grace_period_seconds": {"key": "terminationGracePeriodSeconds", "type": "int"},
        "timeout_seconds": {"key": "timeoutSeconds", "type": "int"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        failure_threshold: Optional[int] = None,
        http_get: Optional["_models.ContainerAppProbeHttpGet"] = None,
        initial_delay_seconds: Optional[int] = None,
        period_seconds: Optional[int] = None,
        success_threshold: Optional[int] = None,
        tcp_socket: Optional["_models.ContainerAppProbeTcpSocket"] = None,
        termination_grace_period_seconds: Optional[int] = None,
        timeout_seconds: Optional[int] = None,
        type: Optional[Union[str, "_models.Type"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword failure_threshold: Minimum consecutive failures for the probe to be considered failed
         after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
        :paramtype failure_threshold: int
        :keyword http_get: HTTPGet specifies the http request to perform.
        :paramtype http_get: ~azure.mgmt.appcontainers.models.ContainerAppProbeHttpGet
        :keyword initial_delay_seconds: Number of seconds after the container has started before
         liveness probes are initiated. Minimum value is 1. Maximum value is 60.
        :paramtype initial_delay_seconds: int
        :keyword period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds.
         Minimum value is 1. Maximum value is 240.
        :paramtype period_seconds: int
        :keyword success_threshold: Minimum consecutive successes for the probe to be considered
         successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
         value is 1. Maximum value is 10.
        :paramtype success_threshold: int
        :keyword tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet
         supported.
        :paramtype tcp_socket: ~azure.mgmt.appcontainers.models.ContainerAppProbeTcpSocket
        :keyword termination_grace_period_seconds: Optional duration in seconds the pod needs to
         terminate gracefully upon probe failure. The grace period is the duration in seconds after the
         processes running in the pod are sent a termination signal and the time when the processes are
         forcibly halted with a kill signal. Set this value longer than the expected cleanup time for
         your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used.
         Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative
         integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut
         down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate.
         Maximum value is 3600 seconds (1 hour).
        :paramtype termination_grace_period_seconds: int
        :keyword timeout_seconds: Number of seconds after which the probe times out. Defaults to 1
         second. Minimum value is 1. Maximum value is 240.
        :paramtype timeout_seconds: int
        :keyword type: The type of probe. Known values are: "Liveness", "Readiness", and "Startup".
        :paramtype type: str or ~azure.mgmt.appcontainers.models.Type
        """
        super().__init__(**kwargs)
        self.failure_threshold = failure_threshold
        self.http_get = http_get
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.success_threshold = success_threshold
        self.tcp_socket = tcp_socket
        self.termination_grace_period_seconds = termination_grace_period_seconds
        self.timeout_seconds = timeout_seconds
        self.type = type


class ContainerAppProbeHttpGet(_serialization.Model):
    """HTTPGet specifies the http request to perform.

    All required parameters must be populated in order to send to server.

    :ivar host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in
     httpHeaders instead.
    :vartype host: str
    :ivar http_headers: Custom headers to set in the request. HTTP allows repeated headers.
    :vartype http_headers:
     list[~azure.mgmt.appcontainers.models.ContainerAppProbeHttpGetHttpHeadersItem]
    :ivar path: Path to access on the HTTP server.
    :vartype path: str
    :ivar port: Name or number of the port to access on the container. Number must be in the range
     1 to 65535. Name must be an IANA_SVC_NAME. Required.
    :vartype port: int
    :ivar scheme: Scheme to use for connecting to the host. Defaults to HTTP. Known values are:
     "HTTP" and "HTTPS".
    :vartype scheme: str or ~azure.mgmt.appcontainers.models.Scheme
    """

    _validation = {
        "port": {"required": True},
    }

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "http_headers": {"key": "httpHeaders", "type": "[ContainerAppProbeHttpGetHttpHeadersItem]"},
        "path": {"key": "path", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "scheme": {"key": "scheme", "type": "str"},
    }

    def __init__(
        self,
        *,
        port: int,
        host: Optional[str] = None,
        http_headers: Optional[List["_models.ContainerAppProbeHttpGetHttpHeadersItem"]] = None,
        path: Optional[str] = None,
        scheme: Optional[Union[str, "_models.Scheme"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host: Host name to connect to, defaults to the pod IP. You probably want to set "Host"
         in httpHeaders instead.
        :paramtype host: str
        :keyword http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :paramtype http_headers:
         list[~azure.mgmt.appcontainers.models.ContainerAppProbeHttpGetHttpHeadersItem]
        :keyword path: Path to access on the HTTP server.
        :paramtype path: str
        :keyword port: Name or number of the port to access on the container. Number must be in the
         range 1 to 65535. Name must be an IANA_SVC_NAME. Required.
        :paramtype port: int
        :keyword scheme: Scheme to use for connecting to the host. Defaults to HTTP. Known values are:
         "HTTP" and "HTTPS".
        :paramtype scheme: str or ~azure.mgmt.appcontainers.models.Scheme
        """
        super().__init__(**kwargs)
        self.host = host
        self.http_headers = http_headers
        self.path = path
        self.port = port
        self.scheme = scheme


class ContainerAppProbeHttpGetHttpHeadersItem(_serialization.Model):
    """HTTPHeader describes a custom header to be used in HTTP probes.

    All required parameters must be populated in order to send to server.

    :ivar name: The header field name. Required.
    :vartype name: str
    :ivar value: The header field value. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: The header field name. Required.
        :paramtype name: str
        :keyword value: The header field value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ContainerAppProbeTcpSocket(_serialization.Model):
    """TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.

    All required parameters must be populated in order to send to server.

    :ivar host: Optional: Host name to connect to, defaults to the pod IP.
    :vartype host: str
    :ivar port: Number or name of the port to access on the container. Number must be in the range
     1 to 65535. Name must be an IANA_SVC_NAME. Required.
    :vartype port: int
    """

    _validation = {
        "port": {"required": True},
    }

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, port: int, host: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword host: Optional: Host name to connect to, defaults to the pod IP.
        :paramtype host: str
        :keyword port: Number or name of the port to access on the container. Number must be in the
         range 1 to 65535. Name must be an IANA_SVC_NAME. Required.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.host = host
        self.port = port


class ContainerAppPropertiesPatchingConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Container App auto patch configuration.

    :ivar patching_mode: Patching mode for the container app. Null or default in this field will be
     interpreted as Automatic by RP. Automatic mode will automatically apply available patches.
     Manual mode will require the user to manually apply patches. Disabled mode will stop patch
     detection and auto patching. Known values are: "Automatic", "Manual", and "Disabled".
    :vartype patching_mode: str or ~azure.mgmt.appcontainers.models.PatchingMode
    """

    _attribute_map = {
        "patching_mode": {"key": "patchingMode", "type": "str"},
    }

    def __init__(self, *, patching_mode: Optional[Union[str, "_models.PatchingMode"]] = None, **kwargs: Any) -> None:
        """
        :keyword patching_mode: Patching mode for the container app. Null or default in this field will
         be interpreted as Automatic by RP. Automatic mode will automatically apply available patches.
         Manual mode will require the user to manually apply patches. Disabled mode will stop patch
         detection and auto patching. Known values are: "Automatic", "Manual", and "Disabled".
        :paramtype patching_mode: str or ~azure.mgmt.appcontainers.models.PatchingMode
        """
        super().__init__(**kwargs)
        self.patching_mode = patching_mode


class ContainerAppsBuildCollection(_serialization.Model):
    """The response of a Container Apps Build Resource list operation.

    All required parameters must be populated in order to send to server.

    :ivar value: The Container Apps Build Resource items on this page. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ContainerAppsBuildResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContainerAppsBuildResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ContainerAppsBuildResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The Container Apps Build Resource items on this page. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ContainerAppsBuildResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ContainerAppsBuildConfiguration(_serialization.Model):
    """Configuration of the build.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar base_os: Base OS used to build and run the app.
    :vartype base_os: str
    :ivar platform: Platform to be used to build and run the app.
    :vartype platform: str
    :ivar platform_version: Platform version to be used to build and run the app.
    :vartype platform_version: str
    :ivar environment_variables: List of environment variables to be passed to the build, secrets
     should not be used in environment variable.
    :vartype environment_variables: list[~azure.mgmt.appcontainers.models.EnvironmentVariable]
    :ivar pre_build_steps: List of steps to perform before the build.
    :vartype pre_build_steps: list[~azure.mgmt.appcontainers.models.PreBuildStep]
    """

    _validation = {
        "base_os": {"readonly": True},
        "platform": {"readonly": True},
        "platform_version": {"readonly": True},
        "environment_variables": {"readonly": True},
        "pre_build_steps": {"readonly": True},
    }

    _attribute_map = {
        "base_os": {"key": "baseOs", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "platform_version": {"key": "platformVersion", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "[EnvironmentVariable]"},
        "pre_build_steps": {"key": "preBuildSteps", "type": "[PreBuildStep]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.base_os: Optional[str] = None
        self.platform: Optional[str] = None
        self.platform_version: Optional[str] = None
        self.environment_variables: Optional[List["_models.EnvironmentVariable"]] = None
        self.pre_build_steps: Optional[List["_models.PreBuildStep"]] = None


class ContainerAppsBuildResource(ProxyResource):
    """Information pertaining to an individual build.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar provisioning_state: Build provisioning state. Known values are: "Succeeded", "Failed",
     "Canceled", "Creating", "Updating", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.appcontainers.models.BuildProvisioningState
    :ivar build_status: Status of the build once it has been provisioned. Known values are:
     "NotStarted", "InProgress", "Succeeded", "Canceled", and "Failed".
    :vartype build_status: str or ~azure.mgmt.appcontainers.models.BuildStatus
    :ivar destination_container_registry: Container registry that the final image will be uploaded
     to.
    :vartype destination_container_registry:
     ~azure.mgmt.appcontainers.models.ContainerRegistryWithCustomImage
    :ivar configuration: Configuration of the build.
    :vartype configuration: ~azure.mgmt.appcontainers.models.ContainerAppsBuildConfiguration
    :ivar log_stream_endpoint: Endpoint from which the build logs can be streamed.
    :vartype log_stream_endpoint: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "build_status": {"readonly": True},
        "destination_container_registry": {"readonly": True},
        "configuration": {"readonly": True},
        "log_stream_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "build_status": {"key": "properties.buildStatus", "type": "str"},
        "destination_container_registry": {
            "key": "properties.destinationContainerRegistry",
            "type": "ContainerRegistryWithCustomImage",
        },
        "configuration": {"key": "properties.configuration", "type": "ContainerAppsBuildConfiguration"},
        "log_stream_endpoint": {"key": "properties.logStreamEndpoint", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.BuildProvisioningState"]] = None
        self.build_status: Optional[Union[str, "_models.BuildStatus"]] = None
        self.destination_container_registry: Optional["_models.ContainerRegistryWithCustomImage"] = None
        self.configuration: Optional["_models.ContainerAppsBuildConfiguration"] = None
        self.log_stream_endpoint: Optional[str] = None


class ContainerAppSecret(_serialization.Model):
    """Container App Secret.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    :ivar identity: Resource ID of a managed identity to authenticate with Azure Key Vault, or
     System to use a system-assigned identity.
    :vartype identity: str
    :ivar key_vault_url: Azure Key Vault URL pointing to the secret referenced by the container
     app.
    :vartype key_vault_url: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
        "identity": {"readonly": True},
        "key_vault_url": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "identity": {"key": "identity", "type": "str"},
        "key_vault_url": {"key": "keyVaultUrl", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[str] = None
        self.identity: Optional[str] = None
        self.key_vault_url: Optional[str] = None


class ContainerAppsPatchResource(ProxyResource):
    """Container App Patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Properties that describes current states of the patch resource.
    :vartype properties: ~azure.mgmt.appcontainers.models.PatchProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "PatchProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties: Optional["_models.PatchProperties"] = None


class ContainerExecutionStatus(_serialization.Model):
    """Container Apps Job execution container status. Contains status code and reason.

    :ivar name: Container Name.
    :vartype name: str
    :ivar code: Exit code.
    :vartype code: int
    :ivar additional_information: Additional information for the container status.
    :vartype additional_information: str
    :ivar status: Status of the container.
    :vartype status: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "code": {"key": "code", "type": "int"},
        "additional_information": {"key": "additionalInformation", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        code: Optional[int] = None,
        additional_information: Optional[str] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Container Name.
        :paramtype name: str
        :keyword code: Exit code.
        :paramtype code: int
        :keyword additional_information: Additional information for the container status.
        :paramtype additional_information: str
        :keyword status: Status of the container.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.code = code
        self.additional_information = additional_information
        self.status = status


class ContainerRegistry(_serialization.Model):
    """Model representing a mapping from a container registry to the identity used to connect to it.

    All required parameters must be populated in order to send to server.

    :ivar container_registry_server: Login server of the container registry. Required.
    :vartype container_registry_server: str
    :ivar identity_resource_id: Resource ID of the managed identity. Required.
    :vartype identity_resource_id: str
    """

    _validation = {
        "container_registry_server": {"required": True},
        "identity_resource_id": {"required": True},
    }

    _attribute_map = {
        "container_registry_server": {"key": "containerRegistryServer", "type": "str"},
        "identity_resource_id": {"key": "identityResourceId", "type": "str"},
    }

    def __init__(self, *, container_registry_server: str, identity_resource_id: str, **kwargs: Any) -> None:
        """
        :keyword container_registry_server: Login server of the container registry. Required.
        :paramtype container_registry_server: str
        :keyword identity_resource_id: Resource ID of the managed identity. Required.
        :paramtype identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.container_registry_server = container_registry_server
        self.identity_resource_id = identity_resource_id


class ContainerRegistryWithCustomImage(_serialization.Model):
    """Container registry that the final image will be uploaded to.

    All required parameters must be populated in order to send to server.

    :ivar server: Login server of the container registry that the final image should be uploaded
     to. Builder resource needs to have this container registry defined along with an identity to
     use to access it. Required.
    :vartype server: str
    :ivar image: Full name that the final image should be uploaded as, including both image name
     and tag.
    :vartype image: str
    """

    _validation = {
        "server": {"required": True},
    }

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "image": {"key": "image", "type": "str"},
    }

    def __init__(self, *, server: str, image: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword server: Login server of the container registry that the final image should be uploaded
         to. Builder resource needs to have this container registry defined along with an identity to
         use to access it. Required.
        :paramtype server: str
        :keyword image: Full name that the final image should be uploaded as, including both image name
         and tag.
        :paramtype image: str
        """
        super().__init__(**kwargs)
        self.server = server
        self.image = image


class ContainerResources(_serialization.Model):
    """Container App container resource requirements.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cpu: Required CPU in cores, e.g. 0.5.
    :vartype cpu: float
    :ivar memory: Required memory, e.g. "250Mb".
    :vartype memory: str
    :ivar ephemeral_storage: Ephemeral Storage, e.g. "1Gi".
    :vartype ephemeral_storage: str
    :ivar gpu: Required GPU in cores for GPU based app, e.g. 1.0.
    :vartype gpu: float
    """

    _validation = {
        "ephemeral_storage": {"readonly": True},
    }

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "float"},
        "memory": {"key": "memory", "type": "str"},
        "ephemeral_storage": {"key": "ephemeralStorage", "type": "str"},
        "gpu": {"key": "gpu", "type": "float"},
    }

    def __init__(
        self, *, cpu: Optional[float] = None, memory: Optional[str] = None, gpu: Optional[float] = None, **kwargs: Any
    ) -> None:
        """
        :keyword cpu: Required CPU in cores, e.g. 0.5.
        :paramtype cpu: float
        :keyword memory: Required memory, e.g. "250Mb".
        :paramtype memory: str
        :keyword gpu: Required GPU in cores for GPU based app, e.g. 1.0.
        :paramtype gpu: float
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory
        self.ephemeral_storage: Optional[str] = None
        self.gpu = gpu


class CookieExpiration(_serialization.Model):
    """The configuration settings of the session cookie's expiration.

    :ivar convention: The convention used when determining the session cookie's expiration. Known
     values are: "FixedTime" and "IdentityProviderDerived".
    :vartype convention: str or ~azure.mgmt.appcontainers.models.CookieExpirationConvention
    :ivar time_to_expiration: The time after the request is made when the session cookie should
     expire.
    :vartype time_to_expiration: str
    """

    _attribute_map = {
        "convention": {"key": "convention", "type": "str"},
        "time_to_expiration": {"key": "timeToExpiration", "type": "str"},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "_models.CookieExpirationConvention"]] = None,
        time_to_expiration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword convention: The convention used when determining the session cookie's expiration.
         Known values are: "FixedTime" and "IdentityProviderDerived".
        :paramtype convention: str or ~azure.mgmt.appcontainers.models.CookieExpirationConvention
        :keyword time_to_expiration: The time after the request is made when the session cookie should
         expire.
        :paramtype time_to_expiration: str
        """
        super().__init__(**kwargs)
        self.convention = convention
        self.time_to_expiration = time_to_expiration


class CorsPolicy(_serialization.Model):
    """Cross-Origin-Resource-Sharing policy.

    All required parameters must be populated in order to send to server.

    :ivar allowed_origins: Specifies the content for the access-control-allow-origins header.
     Required.
    :vartype allowed_origins: list[str]
    :ivar allowed_methods: Specifies the content for the access-control-allow-methods header.
    :vartype allowed_methods: list[str]
    :ivar allowed_headers: Specifies the content for the access-control-allow-headers header.
    :vartype allowed_headers: list[str]
    :ivar expose_headers: Specifies the content for the access-control-expose-headers header.
    :vartype expose_headers: list[str]
    :ivar max_age: Specifies the content for the access-control-max-age header.
    :vartype max_age: int
    :ivar allow_credentials: Specifies whether the resource allows credentials.
    :vartype allow_credentials: bool
    """

    _validation = {
        "allowed_origins": {"required": True},
    }

    _attribute_map = {
        "allowed_origins": {"key": "allowedOrigins", "type": "[str]"},
        "allowed_methods": {"key": "allowedMethods", "type": "[str]"},
        "allowed_headers": {"key": "allowedHeaders", "type": "[str]"},
        "expose_headers": {"key": "exposeHeaders", "type": "[str]"},
        "max_age": {"key": "maxAge", "type": "int"},
        "allow_credentials": {"key": "allowCredentials", "type": "bool"},
    }

    def __init__(
        self,
        *,
        allowed_origins: List[str],
        allowed_methods: Optional[List[str]] = None,
        allowed_headers: Optional[List[str]] = None,
        expose_headers: Optional[List[str]] = None,
        max_age: Optional[int] = None,
        allow_credentials: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_origins: Specifies the content for the access-control-allow-origins header.
         Required.
        :paramtype allowed_origins: list[str]
        :keyword allowed_methods: Specifies the content for the access-control-allow-methods header.
        :paramtype allowed_methods: list[str]
        :keyword allowed_headers: Specifies the content for the access-control-allow-headers header.
        :paramtype allowed_headers: list[str]
        :keyword expose_headers: Specifies the content for the access-control-expose-headers header.
        :paramtype expose_headers: list[str]
        :keyword max_age: Specifies the content for the access-control-max-age header.
        :paramtype max_age: int
        :keyword allow_credentials: Specifies whether the resource allows credentials.
        :paramtype allow_credentials: bool
        """
        super().__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.allowed_headers = allowed_headers
        self.expose_headers = expose_headers
        self.max_age = max_age
        self.allow_credentials = allow_credentials


class CustomContainerTemplate(_serialization.Model):
    """Custom container configuration.

    :ivar registry_credentials: Private container registry credentials for containers used by the
     sessions of the session pool.
    :vartype registry_credentials: ~azure.mgmt.appcontainers.models.SessionRegistryCredentials
    :ivar containers: List of container definitions for the sessions of the session pool.
    :vartype containers: list[~azure.mgmt.appcontainers.models.SessionContainer]
    :ivar ingress: Session pool ingress configuration.
    :vartype ingress: ~azure.mgmt.appcontainers.models.SessionIngress
    """

    _attribute_map = {
        "registry_credentials": {"key": "registryCredentials", "type": "SessionRegistryCredentials"},
        "containers": {"key": "containers", "type": "[SessionContainer]"},
        "ingress": {"key": "ingress", "type": "SessionIngress"},
    }

    def __init__(
        self,
        *,
        registry_credentials: Optional["_models.SessionRegistryCredentials"] = None,
        containers: Optional[List["_models.SessionContainer"]] = None,
        ingress: Optional["_models.SessionIngress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword registry_credentials: Private container registry credentials for containers used by
         the sessions of the session pool.
        :paramtype registry_credentials: ~azure.mgmt.appcontainers.models.SessionRegistryCredentials
        :keyword containers: List of container definitions for the sessions of the session pool.
        :paramtype containers: list[~azure.mgmt.appcontainers.models.SessionContainer]
        :keyword ingress: Session pool ingress configuration.
        :paramtype ingress: ~azure.mgmt.appcontainers.models.SessionIngress
        """
        super().__init__(**kwargs)
        self.registry_credentials = registry_credentials
        self.containers = containers
        self.ingress = ingress


class CustomDomain(_serialization.Model):
    """Custom Domain of a Container App.

    All required parameters must be populated in order to send to server.

    :ivar name: Hostname. Required.
    :vartype name: str
    :ivar binding_type: Custom Domain binding type. Known values are: "Disabled", "SniEnabled", and
     "Auto".
    :vartype binding_type: str or ~azure.mgmt.appcontainers.models.BindingType
    :ivar certificate_id: Resource Id of the Certificate to be bound to this hostname. Must exist
     in the Managed Environment.
    :vartype certificate_id: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "binding_type": {"key": "bindingType", "type": "str"},
        "certificate_id": {"key": "certificateId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        binding_type: Optional[Union[str, "_models.BindingType"]] = None,
        certificate_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Hostname. Required.
        :paramtype name: str
        :keyword binding_type: Custom Domain binding type. Known values are: "Disabled", "SniEnabled",
         and "Auto".
        :paramtype binding_type: str or ~azure.mgmt.appcontainers.models.BindingType
        :keyword certificate_id: Resource Id of the Certificate to be bound to this hostname. Must
         exist in the Managed Environment.
        :paramtype certificate_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.binding_type = binding_type
        self.certificate_id = certificate_id


class CustomDomainConfiguration(_serialization.Model):
    """Configuration properties for apps environment custom domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar custom_domain_verification_id: Id used to verify domain name ownership.
    :vartype custom_domain_verification_id: str
    :ivar dns_suffix: Dns suffix for the environment domain.
    :vartype dns_suffix: str
    :ivar certificate_key_vault_properties: Certificate stored in Azure Key Vault.
    :vartype certificate_key_vault_properties:
     ~azure.mgmt.appcontainers.models.CertificateKeyVaultProperties
    :ivar certificate_value: PFX or PEM blob.
    :vartype certificate_value: bytes
    :ivar certificate_password: Certificate password.
    :vartype certificate_password: str
    :ivar expiration_date: Certificate expiration date.
    :vartype expiration_date: ~datetime.datetime
    :ivar thumbprint: Certificate thumbprint.
    :vartype thumbprint: str
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    """

    _validation = {
        "custom_domain_verification_id": {"readonly": True},
        "expiration_date": {"readonly": True},
        "thumbprint": {"readonly": True},
        "subject_name": {"readonly": True},
    }

    _attribute_map = {
        "custom_domain_verification_id": {"key": "customDomainVerificationId", "type": "str"},
        "dns_suffix": {"key": "dnsSuffix", "type": "str"},
        "certificate_key_vault_properties": {
            "key": "certificateKeyVaultProperties",
            "type": "CertificateKeyVaultProperties",
        },
        "certificate_value": {"key": "certificateValue", "type": "bytearray"},
        "certificate_password": {"key": "certificatePassword", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "iso-8601"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "subject_name": {"key": "subjectName", "type": "str"},
    }

    def __init__(
        self,
        *,
        dns_suffix: Optional[str] = None,
        certificate_key_vault_properties: Optional["_models.CertificateKeyVaultProperties"] = None,
        certificate_value: Optional[bytes] = None,
        certificate_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dns_suffix: Dns suffix for the environment domain.
        :paramtype dns_suffix: str
        :keyword certificate_key_vault_properties: Certificate stored in Azure Key Vault.
        :paramtype certificate_key_vault_properties:
         ~azure.mgmt.appcontainers.models.CertificateKeyVaultProperties
        :keyword certificate_value: PFX or PEM blob.
        :paramtype certificate_value: bytes
        :keyword certificate_password: Certificate password.
        :paramtype certificate_password: str
        """
        super().__init__(**kwargs)
        self.custom_domain_verification_id: Optional[str] = None
        self.dns_suffix = dns_suffix
        self.certificate_key_vault_properties = certificate_key_vault_properties
        self.certificate_value = certificate_value
        self.certificate_password = certificate_password
        self.expiration_date: Optional[datetime.datetime] = None
        self.thumbprint: Optional[str] = None
        self.subject_name: Optional[str] = None


class CustomHostnameAnalysisResult(_serialization.Model):
    """Custom domain analysis.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar host_name: Host name that was analyzed.
    :vartype host_name: str
    :ivar is_hostname_already_verified: :code:`<code>true</code>` if hostname is already verified;
     otherwise, :code:`<code>false</code>`.
    :vartype is_hostname_already_verified: bool
    :ivar custom_domain_verification_test: DNS verification test result. Known values are:
     "Passed", "Failed", and "Skipped".
    :vartype custom_domain_verification_test: str or
     ~azure.mgmt.appcontainers.models.DnsVerificationTestResult
    :ivar custom_domain_verification_failure_info: Raw failure information if DNS verification
     fails.
    :vartype custom_domain_verification_failure_info:
     ~azure.mgmt.appcontainers.models.CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo
    :ivar has_conflict_on_managed_environment: :code:`<code>true</code>` if there is a conflict on
     the Container App's managed environment; otherwise, :code:`<code>false</code>`.
    :vartype has_conflict_on_managed_environment: bool
    :ivar conflict_with_environment_custom_domain: :code:`<code>true</code>` if there is a conflict
     on the Container App's managed environment level custom domain; otherwise,
     :code:`<code>false</code>`.
    :vartype conflict_with_environment_custom_domain: bool
    :ivar conflicting_container_app_resource_id: Name of the conflicting Container App on the
     Managed Environment if it's within the same subscription.
    :vartype conflicting_container_app_resource_id: str
    :ivar c_name_records: CName records visible for this hostname.
    :vartype c_name_records: list[str]
    :ivar txt_records: TXT records visible for this hostname.
    :vartype txt_records: list[str]
    :ivar a_records: A records visible for this hostname.
    :vartype a_records: list[str]
    :ivar alternate_c_name_records: Alternate CName records visible for this hostname.
    :vartype alternate_c_name_records: list[str]
    :ivar alternate_txt_records: Alternate TXT records visible for this hostname.
    :vartype alternate_txt_records: list[str]
    """

    _validation = {
        "host_name": {"readonly": True},
        "is_hostname_already_verified": {"readonly": True},
        "custom_domain_verification_test": {"readonly": True},
        "custom_domain_verification_failure_info": {"readonly": True},
        "has_conflict_on_managed_environment": {"readonly": True},
        "conflict_with_environment_custom_domain": {"readonly": True},
        "conflicting_container_app_resource_id": {"readonly": True},
    }

    _attribute_map = {
        "host_name": {"key": "hostName", "type": "str"},
        "is_hostname_already_verified": {"key": "isHostnameAlreadyVerified", "type": "bool"},
        "custom_domain_verification_test": {"key": "customDomainVerificationTest", "type": "str"},
        "custom_domain_verification_failure_info": {
            "key": "customDomainVerificationFailureInfo",
            "type": "CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo",
        },
        "has_conflict_on_managed_environment": {"key": "hasConflictOnManagedEnvironment", "type": "bool"},
        "conflict_with_environment_custom_domain": {"key": "conflictWithEnvironmentCustomDomain", "type": "bool"},
        "conflicting_container_app_resource_id": {"key": "conflictingContainerAppResourceId", "type": "str"},
        "c_name_records": {"key": "cNameRecords", "type": "[str]"},
        "txt_records": {"key": "txtRecords", "type": "[str]"},
        "a_records": {"key": "aRecords", "type": "[str]"},
        "alternate_c_name_records": {"key": "alternateCNameRecords", "type": "[str]"},
        "alternate_txt_records": {"key": "alternateTxtRecords", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        c_name_records: Optional[List[str]] = None,
        txt_records: Optional[List[str]] = None,
        a_records: Optional[List[str]] = None,
        alternate_c_name_records: Optional[List[str]] = None,
        alternate_txt_records: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword c_name_records: CName records visible for this hostname.
        :paramtype c_name_records: list[str]
        :keyword txt_records: TXT records visible for this hostname.
        :paramtype txt_records: list[str]
        :keyword a_records: A records visible for this hostname.
        :paramtype a_records: list[str]
        :keyword alternate_c_name_records: Alternate CName records visible for this hostname.
        :paramtype alternate_c_name_records: list[str]
        :keyword alternate_txt_records: Alternate TXT records visible for this hostname.
        :paramtype alternate_txt_records: list[str]
        """
        super().__init__(**kwargs)
        self.host_name: Optional[str] = None
        self.is_hostname_already_verified: Optional[bool] = None
        self.custom_domain_verification_test: Optional[Union[str, "_models.DnsVerificationTestResult"]] = None
        self.custom_domain_verification_failure_info: Optional[
            "_models.CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo"
        ] = None
        self.has_conflict_on_managed_environment: Optional[bool] = None
        self.conflict_with_environment_custom_domain: Optional[bool] = None
        self.conflicting_container_app_resource_id: Optional[str] = None
        self.c_name_records = c_name_records
        self.txt_records = txt_records
        self.a_records = a_records
        self.alternate_c_name_records = alternate_c_name_records
        self.alternate_txt_records = alternate_txt_records


class CustomHostnameAnalysisResultCustomDomainVerificationFailureInfo(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Raw failure information if DNS verification fails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details: Details or the error.
    :vartype details:
     list[~azure.mgmt.appcontainers.models.CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {
            "key": "details",
            "type": "[CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem]",
        },
    }

    def __init__(
        self,
        *,
        details: Optional[
            List["_models.CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword details: Details or the error.
        :paramtype details:
         list[~azure.mgmt.appcontainers.models.CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem]
        """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details = details


class CustomHostnameAnalysisResultCustomDomainVerificationFailureInfoDetailsItem(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None


class CustomOpenIdConnectProvider(_serialization.Model):
    """The configuration settings of the custom Open ID Connect provider.

    :ivar enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not be
     enabled; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the custom Open ID
     Connect provider.
    :vartype registration: ~azure.mgmt.appcontainers.models.OpenIdConnectRegistration
    :ivar login: The configuration settings of the login flow of the custom Open ID Connect
     provider.
    :vartype login: ~azure.mgmt.appcontainers.models.OpenIdConnectLogin
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "OpenIdConnectRegistration"},
        "login": {"key": "login", "type": "OpenIdConnectLogin"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.OpenIdConnectRegistration"] = None,
        login: Optional["_models.OpenIdConnectLogin"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the custom Open ID provider provider should not
         be enabled; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the custom Open
         ID Connect provider.
        :paramtype registration: ~azure.mgmt.appcontainers.models.OpenIdConnectRegistration
        :keyword login: The configuration settings of the login flow of the custom Open ID Connect
         provider.
        :paramtype login: ~azure.mgmt.appcontainers.models.OpenIdConnectLogin
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class CustomScaleRule(_serialization.Model):
    """Container App container Custom scaling rule.

    :ivar type: Type of the custom scale rule
     eg: azure-servicebus, redis etc.
    :vartype type: str
    :ivar metadata: Metadata properties to describe custom scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
    :ivar identity: The resource ID of a user-assigned managed identity that is assigned to the
     Container App, or 'system' for system-assigned identity.
    :vartype identity: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the custom scale rule
         eg: azure-servicebus, redis etc.
        :paramtype type: str
        :keyword metadata: Metadata properties to describe custom scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
        :keyword identity: The resource ID of a user-assigned managed identity that is assigned to the
         Container App, or 'system' for system-assigned identity.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.metadata = metadata
        self.auth = auth
        self.identity = identity


class Dapr(_serialization.Model):
    """Container App Dapr configuration.

    :ivar enabled: Boolean indicating if the Dapr side car is enabled.
    :vartype enabled: bool
    :ivar app_id: Dapr application identifier.
    :vartype app_id: str
    :ivar app_protocol: Tells Dapr which protocol your application is using. Valid options are http
     and grpc. Default is http. Known values are: "http" and "grpc".
    :vartype app_protocol: str or ~azure.mgmt.appcontainers.models.AppProtocol
    :ivar app_port: Tells Dapr which port your application is listening on.
    :vartype app_port: int
    :ivar http_read_buffer_size: Dapr max size of http header read buffer in KB to handle when
     sending multi-KB headers. Default is 65KB.
    :vartype http_read_buffer_size: int
    :ivar http_max_request_size: Increasing max size of request body http and grpc servers
     parameter in MB to handle uploading of big files. Default is 4 MB.
    :vartype http_max_request_size: int
    :ivar log_level: Sets the log level for the Dapr sidecar. Allowed values are debug, info, warn,
     error. Default is info. Known values are: "info", "debug", "warn", and "error".
    :vartype log_level: str or ~azure.mgmt.appcontainers.models.LogLevel
    :ivar enable_api_logging: Enables API logging for the Dapr sidecar.
    :vartype enable_api_logging: bool
    :ivar app_health: Dapr application health check configuration.
    :vartype app_health: ~azure.mgmt.appcontainers.models.DaprAppHealth
    :ivar max_concurrency: Maximum number of concurrent requests, events handled by the Dapr
     sidecar.
    :vartype max_concurrency: int
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "app_id": {"key": "appId", "type": "str"},
        "app_protocol": {"key": "appProtocol", "type": "str"},
        "app_port": {"key": "appPort", "type": "int"},
        "http_read_buffer_size": {"key": "httpReadBufferSize", "type": "int"},
        "http_max_request_size": {"key": "httpMaxRequestSize", "type": "int"},
        "log_level": {"key": "logLevel", "type": "str"},
        "enable_api_logging": {"key": "enableApiLogging", "type": "bool"},
        "app_health": {"key": "appHealth", "type": "DaprAppHealth"},
        "max_concurrency": {"key": "maxConcurrency", "type": "int"},
    }

    def __init__(
        self,
        *,
        enabled: bool = False,
        app_id: Optional[str] = None,
        app_protocol: Union[str, "_models.AppProtocol"] = "http",
        app_port: Optional[int] = None,
        http_read_buffer_size: Optional[int] = None,
        http_max_request_size: Optional[int] = None,
        log_level: Optional[Union[str, "_models.LogLevel"]] = None,
        enable_api_logging: Optional[bool] = None,
        app_health: Optional["_models.DaprAppHealth"] = None,
        max_concurrency: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Boolean indicating if the Dapr side car is enabled.
        :paramtype enabled: bool
        :keyword app_id: Dapr application identifier.
        :paramtype app_id: str
        :keyword app_protocol: Tells Dapr which protocol your application is using. Valid options are
         http and grpc. Default is http. Known values are: "http" and "grpc".
        :paramtype app_protocol: str or ~azure.mgmt.appcontainers.models.AppProtocol
        :keyword app_port: Tells Dapr which port your application is listening on.
        :paramtype app_port: int
        :keyword http_read_buffer_size: Dapr max size of http header read buffer in KB to handle when
         sending multi-KB headers. Default is 65KB.
        :paramtype http_read_buffer_size: int
        :keyword http_max_request_size: Increasing max size of request body http and grpc servers
         parameter in MB to handle uploading of big files. Default is 4 MB.
        :paramtype http_max_request_size: int
        :keyword log_level: Sets the log level for the Dapr sidecar. Allowed values are debug, info,
         warn, error. Default is info. Known values are: "info", "debug", "warn", and "error".
        :paramtype log_level: str or ~azure.mgmt.appcontainers.models.LogLevel
        :keyword enable_api_logging: Enables API logging for the Dapr sidecar.
        :paramtype enable_api_logging: bool
        :keyword app_health: Dapr application health check configuration.
        :paramtype app_health: ~azure.mgmt.appcontainers.models.DaprAppHealth
        :keyword max_concurrency: Maximum number of concurrent requests, events handled by the Dapr
         sidecar.
        :paramtype max_concurrency: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.app_id = app_id
        self.app_protocol = app_protocol
        self.app_port = app_port
        self.http_read_buffer_size = http_read_buffer_size
        self.http_max_request_size = http_max_request_size
        self.log_level = log_level
        self.enable_api_logging = enable_api_logging
        self.app_health = app_health
        self.max_concurrency = max_concurrency


class DaprAppHealth(_serialization.Model):
    """Dapr application health check configuration.

    :ivar enabled: Boolean indicating if the health probe is enabled.
    :vartype enabled: bool
    :ivar path: Path for the health probe.
    :vartype path: str
    :ivar probe_interval_seconds: Interval for the health probe in seconds.
    :vartype probe_interval_seconds: int
    :ivar probe_timeout_milliseconds: Timeout for the health probe in milliseconds.
    :vartype probe_timeout_milliseconds: int
    :ivar threshold: Threshold for the health probe.
    :vartype threshold: int
    """

    _validation = {
        "probe_interval_seconds": {"minimum": 1},
        "probe_timeout_milliseconds": {"minimum": 1},
        "threshold": {"minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "path": {"key": "path", "type": "str"},
        "probe_interval_seconds": {"key": "probeIntervalSeconds", "type": "int"},
        "probe_timeout_milliseconds": {"key": "probeTimeoutMilliseconds", "type": "int"},
        "threshold": {"key": "threshold", "type": "int"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        path: Optional[str] = None,
        probe_interval_seconds: Optional[int] = None,
        probe_timeout_milliseconds: Optional[int] = None,
        threshold: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Boolean indicating if the health probe is enabled.
        :paramtype enabled: bool
        :keyword path: Path for the health probe.
        :paramtype path: str
        :keyword probe_interval_seconds: Interval for the health probe in seconds.
        :paramtype probe_interval_seconds: int
        :keyword probe_timeout_milliseconds: Timeout for the health probe in milliseconds.
        :paramtype probe_timeout_milliseconds: int
        :keyword threshold: Threshold for the health probe.
        :paramtype threshold: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.path = path
        self.probe_interval_seconds = probe_interval_seconds
        self.probe_timeout_milliseconds = probe_timeout_milliseconds
        self.threshold = threshold


class DaprComponent(ProxyResource):
    """Dapr Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar component_type: Component type.
    :vartype component_type: str
    :ivar version: Component version.
    :vartype version: str
    :ivar ignore_errors: Boolean describing if the component errors are ignores.
    :vartype ignore_errors: bool
    :ivar init_timeout: Initialization timeout.
    :vartype init_timeout: str
    :ivar secrets: Collection of secrets used by a Dapr component.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.Secret]
    :ivar secret_store_component: Name of a Dapr component to retrieve component secrets from.
    :vartype secret_store_component: str
    :ivar metadata: Component metadata.
    :vartype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
    :ivar scopes: Names of container apps that can use this Dapr component.
    :vartype scopes: list[str]
    :ivar service_component_bind: List of container app services that are bound to the Dapr
     component.
    :vartype service_component_bind:
     list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "component_type": {"key": "properties.componentType", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "ignore_errors": {"key": "properties.ignoreErrors", "type": "bool"},
        "init_timeout": {"key": "properties.initTimeout", "type": "str"},
        "secrets": {"key": "properties.secrets", "type": "[Secret]"},
        "secret_store_component": {"key": "properties.secretStoreComponent", "type": "str"},
        "metadata": {"key": "properties.metadata", "type": "[DaprMetadata]"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "service_component_bind": {"key": "properties.serviceComponentBind", "type": "[DaprComponentServiceBinding]"},
    }

    def __init__(
        self,
        *,
        component_type: Optional[str] = None,
        version: Optional[str] = None,
        ignore_errors: bool = False,
        init_timeout: Optional[str] = None,
        secrets: Optional[List["_models.Secret"]] = None,
        secret_store_component: Optional[str] = None,
        metadata: Optional[List["_models.DaprMetadata"]] = None,
        scopes: Optional[List[str]] = None,
        service_component_bind: Optional[List["_models.DaprComponentServiceBinding"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component_type: Component type.
        :paramtype component_type: str
        :keyword version: Component version.
        :paramtype version: str
        :keyword ignore_errors: Boolean describing if the component errors are ignores.
        :paramtype ignore_errors: bool
        :keyword init_timeout: Initialization timeout.
        :paramtype init_timeout: str
        :keyword secrets: Collection of secrets used by a Dapr component.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.Secret]
        :keyword secret_store_component: Name of a Dapr component to retrieve component secrets from.
        :paramtype secret_store_component: str
        :keyword metadata: Component metadata.
        :paramtype metadata: list[~azure.mgmt.appcontainers.models.DaprMetadata]
        :keyword scopes: Names of container apps that can use this Dapr component.
        :paramtype scopes: list[str]
        :keyword service_component_bind: List of container app services that are bound to the Dapr
         component.
        :paramtype service_component_bind:
         list[~azure.mgmt.appcontainers.models.DaprComponentServiceBinding]
        """
        super().__init__(**kwargs)
        self.component_type = component_type
        self.version = version
        self.ignore_errors = ignore_errors
        self.init_timeout = init_timeout
        self.secrets = secrets
        self.secret_store_component = secret_store_component
        self.metadata = metadata
        self.scopes = scopes
        self.service_component_bind = service_component_bind


class DaprComponentResiliencyPoliciesCollection(_serialization.Model):  # pylint: disable=name-too-long
    """Dapr Component Resiliency Policies ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicy]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DaprComponentResiliencyPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DaprComponentResiliencyPolicy"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DaprComponentResiliencyPolicy(ProxyResource):
    """Dapr Component Resiliency Policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar inbound_policy: The optional inbound component resiliency policy configuration.
    :vartype inbound_policy:
     ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyConfiguration
    :ivar outbound_policy: The optional outbound component resiliency policy configuration.
    :vartype outbound_policy:
     ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "inbound_policy": {"key": "properties.inboundPolicy", "type": "DaprComponentResiliencyPolicyConfiguration"},
        "outbound_policy": {"key": "properties.outboundPolicy", "type": "DaprComponentResiliencyPolicyConfiguration"},
    }

    def __init__(
        self,
        *,
        inbound_policy: Optional["_models.DaprComponentResiliencyPolicyConfiguration"] = None,
        outbound_policy: Optional["_models.DaprComponentResiliencyPolicyConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword inbound_policy: The optional inbound component resiliency policy configuration.
        :paramtype inbound_policy:
         ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyConfiguration
        :keyword outbound_policy: The optional outbound component resiliency policy configuration.
        :paramtype outbound_policy:
         ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyConfiguration
        """
        super().__init__(**kwargs)
        self.inbound_policy = inbound_policy
        self.outbound_policy = outbound_policy


class DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Dapr Component Resiliency Policy Circuit Breaker Policy Configuration.

    :ivar consecutive_errors: The number of consecutive errors before the circuit is opened.
    :vartype consecutive_errors: int
    :ivar timeout_in_seconds: The interval in seconds until a retry attempt is made after the
     circuit is opened.
    :vartype timeout_in_seconds: int
    :ivar interval_in_seconds: The optional interval in seconds after which the error count resets
     to 0. An interval of 0 will never reset. If not specified, the timeoutInSeconds value will be
     used.
    :vartype interval_in_seconds: int
    """

    _attribute_map = {
        "consecutive_errors": {"key": "consecutiveErrors", "type": "int"},
        "timeout_in_seconds": {"key": "timeoutInSeconds", "type": "int"},
        "interval_in_seconds": {"key": "intervalInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        consecutive_errors: Optional[int] = None,
        timeout_in_seconds: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword consecutive_errors: The number of consecutive errors before the circuit is opened.
        :paramtype consecutive_errors: int
        :keyword timeout_in_seconds: The interval in seconds until a retry attempt is made after the
         circuit is opened.
        :paramtype timeout_in_seconds: int
        :keyword interval_in_seconds: The optional interval in seconds after which the error count
         resets to 0. An interval of 0 will never reset. If not specified, the timeoutInSeconds value
         will be used.
        :paramtype interval_in_seconds: int
        """
        super().__init__(**kwargs)
        self.consecutive_errors = consecutive_errors
        self.timeout_in_seconds = timeout_in_seconds
        self.interval_in_seconds = interval_in_seconds


class DaprComponentResiliencyPolicyConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Dapr Component Resiliency Policy Configuration.

    :ivar http_retry_policy: The optional HTTP retry policy configuration.
    :vartype http_retry_policy:
     ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration
    :ivar timeout_policy: The optional timeout policy configuration.
    :vartype timeout_policy:
     ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration
    :ivar circuit_breaker_policy: The optional circuit breaker policy configuration.
    :vartype circuit_breaker_policy:
     ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration
    """

    _attribute_map = {
        "http_retry_policy": {
            "key": "httpRetryPolicy",
            "type": "DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration",
        },
        "timeout_policy": {"key": "timeoutPolicy", "type": "DaprComponentResiliencyPolicyTimeoutPolicyConfiguration"},
        "circuit_breaker_policy": {
            "key": "circuitBreakerPolicy",
            "type": "DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration",
        },
    }

    def __init__(
        self,
        *,
        http_retry_policy: Optional["_models.DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration"] = None,
        timeout_policy: Optional["_models.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration"] = None,
        circuit_breaker_policy: Optional[
            "_models.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword http_retry_policy: The optional HTTP retry policy configuration.
        :paramtype http_retry_policy:
         ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration
        :keyword timeout_policy: The optional timeout policy configuration.
        :paramtype timeout_policy:
         ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyTimeoutPolicyConfiguration
        :keyword circuit_breaker_policy: The optional circuit breaker policy configuration.
        :paramtype circuit_breaker_policy:
         ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyCircuitBreakerPolicyConfiguration
        """
        super().__init__(**kwargs)
        self.http_retry_policy = http_retry_policy
        self.timeout_policy = timeout_policy
        self.circuit_breaker_policy = circuit_breaker_policy


class DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Dapr Component Resiliency Policy HTTP Retry Backoff Configuration.

    :ivar initial_delay_in_milliseconds: The optional initial delay in milliseconds before an
     operation is retried.
    :vartype initial_delay_in_milliseconds: int
    :ivar max_interval_in_milliseconds: The optional maximum time interval in milliseconds between
     retry attempts.
    :vartype max_interval_in_milliseconds: int
    """

    _attribute_map = {
        "initial_delay_in_milliseconds": {"key": "initialDelayInMilliseconds", "type": "int"},
        "max_interval_in_milliseconds": {"key": "maxIntervalInMilliseconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        initial_delay_in_milliseconds: Optional[int] = None,
        max_interval_in_milliseconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword initial_delay_in_milliseconds: The optional initial delay in milliseconds before an
         operation is retried.
        :paramtype initial_delay_in_milliseconds: int
        :keyword max_interval_in_milliseconds: The optional maximum time interval in milliseconds
         between retry attempts.
        :paramtype max_interval_in_milliseconds: int
        """
        super().__init__(**kwargs)
        self.initial_delay_in_milliseconds = initial_delay_in_milliseconds
        self.max_interval_in_milliseconds = max_interval_in_milliseconds


class DaprComponentResiliencyPolicyHttpRetryPolicyConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Dapr Component Resiliency Policy HTTP Retry Policy Configuration.

    :ivar max_retries: The optional maximum number of retries.
    :vartype max_retries: int
    :ivar retry_back_off: The optional retry backoff configuration.
    :vartype retry_back_off:
     ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration
    """

    _attribute_map = {
        "max_retries": {"key": "maxRetries", "type": "int"},
        "retry_back_off": {"key": "retryBackOff", "type": "DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration"},
    }

    def __init__(
        self,
        *,
        max_retries: Optional[int] = None,
        retry_back_off: Optional["_models.DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_retries: The optional maximum number of retries.
        :paramtype max_retries: int
        :keyword retry_back_off: The optional retry backoff configuration.
        :paramtype retry_back_off:
         ~azure.mgmt.appcontainers.models.DaprComponentResiliencyPolicyHttpRetryBackOffConfiguration
        """
        super().__init__(**kwargs)
        self.max_retries = max_retries
        self.retry_back_off = retry_back_off


class DaprComponentResiliencyPolicyTimeoutPolicyConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Dapr Component Resiliency Policy Timeout Policy Configuration.

    :ivar response_timeout_in_seconds: The optional response timeout in seconds.
    :vartype response_timeout_in_seconds: int
    """

    _attribute_map = {
        "response_timeout_in_seconds": {"key": "responseTimeoutInSeconds", "type": "int"},
    }

    def __init__(self, *, response_timeout_in_seconds: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword response_timeout_in_seconds: The optional response timeout in seconds.
        :paramtype response_timeout_in_seconds: int
        """
        super().__init__(**kwargs)
        self.response_timeout_in_seconds = response_timeout_in_seconds


class DaprComponentsCollection(_serialization.Model):
    """Dapr Components ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.DaprComponent]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DaprComponent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DaprComponent"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.DaprComponent]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DaprComponentServiceBinding(_serialization.Model):
    """Configuration to bind a Dapr Component to a dev ContainerApp Service.

    :ivar name: Name of the service bind.
    :vartype name: str
    :ivar service_id: Resource id of the target service.
    :vartype service_id: str
    :ivar metadata: Service bind metadata.
    :vartype metadata: ~azure.mgmt.appcontainers.models.DaprServiceBindMetadata
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "service_id": {"key": "serviceId", "type": "str"},
        "metadata": {"key": "metadata", "type": "DaprServiceBindMetadata"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        service_id: Optional[str] = None,
        metadata: Optional["_models.DaprServiceBindMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the service bind.
        :paramtype name: str
        :keyword service_id: Resource id of the target service.
        :paramtype service_id: str
        :keyword metadata: Service bind metadata.
        :paramtype metadata: ~azure.mgmt.appcontainers.models.DaprServiceBindMetadata
        """
        super().__init__(**kwargs)
        self.name = name
        self.service_id = service_id
        self.metadata = metadata


class DaprConfiguration(_serialization.Model):
    """Configuration properties Dapr component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The version of Dapr.
    :vartype version: str
    """

    _validation = {
        "version": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version: Optional[str] = None


class DaprMetadata(_serialization.Model):
    """Dapr component metadata.

    :ivar name: Metadata property name.
    :vartype name: str
    :ivar value: Metadata property value.
    :vartype value: str
    :ivar secret_ref: Name of the Dapr Component secret from which to pull the metadata property
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "secret_ref": {"key": "secretRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Metadata property name.
        :paramtype name: str
        :keyword value: Metadata property value.
        :paramtype value: str
        :keyword secret_ref: Name of the Dapr Component secret from which to pull the metadata property
         value.
        :paramtype secret_ref: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class DaprSecret(_serialization.Model):
    """Dapr component Secret for ListSecrets Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[str] = None


class DaprSecretsCollection(_serialization.Model):
    """Dapr component Secrets Collection for ListSecrets Action.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of secrets used by a Dapr component. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.DaprSecret]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DaprSecret]"},
    }

    def __init__(self, *, value: List["_models.DaprSecret"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of secrets used by a Dapr component. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.DaprSecret]
        """
        super().__init__(**kwargs)
        self.value = value


class DaprServiceBindMetadata(_serialization.Model):
    """Dapr component metadata.

    :ivar name: Service bind metadata property name.
    :vartype name: str
    :ivar value: Service bind metadata property value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Service bind metadata property name.
        :paramtype name: str
        :keyword value: Service bind metadata property value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class DaprSubscription(ProxyResource):
    """Dapr PubSub Event Subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar pubsub_name: Dapr PubSub component name.
    :vartype pubsub_name: str
    :ivar topic: Topic name.
    :vartype topic: str
    :ivar dead_letter_topic: Deadletter topic name.
    :vartype dead_letter_topic: str
    :ivar routes: Subscription routes.
    :vartype routes: ~azure.mgmt.appcontainers.models.DaprSubscriptionRoutes
    :ivar scopes: Application scopes to restrict the subscription to specific apps.
    :vartype scopes: list[str]
    :ivar metadata: Subscription metadata.
    :vartype metadata: dict[str, str]
    :ivar bulk_subscribe: Bulk subscription options.
    :vartype bulk_subscribe: ~azure.mgmt.appcontainers.models.DaprSubscriptionBulkSubscribeOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "pubsub_name": {"key": "properties.pubsubName", "type": "str"},
        "topic": {"key": "properties.topic", "type": "str"},
        "dead_letter_topic": {"key": "properties.deadLetterTopic", "type": "str"},
        "routes": {"key": "properties.routes", "type": "DaprSubscriptionRoutes"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "metadata": {"key": "properties.metadata", "type": "{str}"},
        "bulk_subscribe": {"key": "properties.bulkSubscribe", "type": "DaprSubscriptionBulkSubscribeOptions"},
    }

    def __init__(
        self,
        *,
        pubsub_name: Optional[str] = None,
        topic: Optional[str] = None,
        dead_letter_topic: Optional[str] = None,
        routes: Optional["_models.DaprSubscriptionRoutes"] = None,
        scopes: Optional[List[str]] = None,
        metadata: Optional[Dict[str, str]] = None,
        bulk_subscribe: Optional["_models.DaprSubscriptionBulkSubscribeOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pubsub_name: Dapr PubSub component name.
        :paramtype pubsub_name: str
        :keyword topic: Topic name.
        :paramtype topic: str
        :keyword dead_letter_topic: Deadletter topic name.
        :paramtype dead_letter_topic: str
        :keyword routes: Subscription routes.
        :paramtype routes: ~azure.mgmt.appcontainers.models.DaprSubscriptionRoutes
        :keyword scopes: Application scopes to restrict the subscription to specific apps.
        :paramtype scopes: list[str]
        :keyword metadata: Subscription metadata.
        :paramtype metadata: dict[str, str]
        :keyword bulk_subscribe: Bulk subscription options.
        :paramtype bulk_subscribe:
         ~azure.mgmt.appcontainers.models.DaprSubscriptionBulkSubscribeOptions
        """
        super().__init__(**kwargs)
        self.pubsub_name = pubsub_name
        self.topic = topic
        self.dead_letter_topic = dead_letter_topic
        self.routes = routes
        self.scopes = scopes
        self.metadata = metadata
        self.bulk_subscribe = bulk_subscribe


class DaprSubscriptionBulkSubscribeOptions(_serialization.Model):
    """Dapr PubSub Bulk Subscription Options.

    :ivar enabled: Enable bulk subscription.
    :vartype enabled: bool
    :ivar max_messages_count: Maximum number of messages to deliver in a bulk message.
    :vartype max_messages_count: int
    :ivar max_await_duration_ms: Maximum duration in milliseconds to wait before a bulk message is
     sent to the app.
    :vartype max_await_duration_ms: int
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "max_messages_count": {"key": "maxMessagesCount", "type": "int"},
        "max_await_duration_ms": {"key": "maxAwaitDurationMs", "type": "int"},
    }

    def __init__(
        self,
        *,
        enabled: bool = False,
        max_messages_count: Optional[int] = None,
        max_await_duration_ms: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Enable bulk subscription.
        :paramtype enabled: bool
        :keyword max_messages_count: Maximum number of messages to deliver in a bulk message.
        :paramtype max_messages_count: int
        :keyword max_await_duration_ms: Maximum duration in milliseconds to wait before a bulk message
         is sent to the app.
        :paramtype max_await_duration_ms: int
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.max_messages_count = max_messages_count
        self.max_await_duration_ms = max_await_duration_ms


class DaprSubscriptionRouteRule(_serialization.Model):
    """Dapr Pubsub Event Subscription Route Rule is used to specify the condition for sending a
    message to a specific path.

    :ivar match: The optional CEL expression used to match the event. If the match is not
     specified, then the route is considered the default. The rules are tested in the order
     specified, so they should be define from most-to-least specific. The default route should
     appear last in the list.
    :vartype match: str
    :ivar path: The path for events that match this rule.
    :vartype path: str
    """

    _attribute_map = {
        "match": {"key": "match", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, match: Optional[str] = None, path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword match: The optional CEL expression used to match the event. If the match is not
         specified, then the route is considered the default. The rules are tested in the order
         specified, so they should be define from most-to-least specific. The default route should
         appear last in the list.
        :paramtype match: str
        :keyword path: The path for events that match this rule.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.match = match
        self.path = path


class DaprSubscriptionRoutes(_serialization.Model):
    """Dapr PubSub Event Subscription Routes configuration.

    :ivar rules: The list of Dapr PubSub Event Subscription Route Rules.
    :vartype rules: list[~azure.mgmt.appcontainers.models.DaprSubscriptionRouteRule]
    :ivar default: The default path to deliver events that do not match any of the rules.
    :vartype default: str
    """

    _attribute_map = {
        "rules": {"key": "rules", "type": "[DaprSubscriptionRouteRule]"},
        "default": {"key": "default", "type": "str"},
    }

    def __init__(
        self,
        *,
        rules: Optional[List["_models.DaprSubscriptionRouteRule"]] = None,
        default: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rules: The list of Dapr PubSub Event Subscription Route Rules.
        :paramtype rules: list[~azure.mgmt.appcontainers.models.DaprSubscriptionRouteRule]
        :keyword default: The default path to deliver events that do not match any of the rules.
        :paramtype default: str
        """
        super().__init__(**kwargs)
        self.rules = rules
        self.default = default


class DaprSubscriptionsCollection(_serialization.Model):
    """Dapr Subscriptions ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.DaprSubscription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DaprSubscription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DaprSubscription"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.DaprSubscription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DataDogConfiguration(_serialization.Model):
    """Configuration of datadog.

    :ivar site: The data dog site.
    :vartype site: str
    :ivar key: The data dog api key.
    :vartype key: str
    """

    _attribute_map = {
        "site": {"key": "site", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(self, *, site: Optional[str] = None, key: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword site: The data dog site.
        :paramtype site: str
        :keyword key: The data dog api key.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.site = site
        self.key = key


class DefaultAuthorizationPolicy(_serialization.Model):
    """The configuration settings of the Azure Active Directory default authorization policy.

    :ivar allowed_principals: The configuration settings of the Azure Active Directory allowed
     principals.
    :vartype allowed_principals: ~azure.mgmt.appcontainers.models.AllowedPrincipals
    :ivar allowed_applications: The configuration settings of the Azure Active Directory allowed
     applications.
    :vartype allowed_applications: list[str]
    """

    _attribute_map = {
        "allowed_principals": {"key": "allowedPrincipals", "type": "AllowedPrincipals"},
        "allowed_applications": {"key": "allowedApplications", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_principals: Optional["_models.AllowedPrincipals"] = None,
        allowed_applications: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_principals: The configuration settings of the Azure Active Directory allowed
         principals.
        :paramtype allowed_principals: ~azure.mgmt.appcontainers.models.AllowedPrincipals
        :keyword allowed_applications: The configuration settings of the Azure Active Directory allowed
         applications.
        :paramtype allowed_applications: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_principals = allowed_principals
        self.allowed_applications = allowed_applications


class DefaultErrorResponse(_serialization.Model):
    """App Service error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error model.
    :vartype error: ~azure.mgmt.appcontainers.models.DefaultErrorResponseError
    """

    _validation = {
        "error": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "DefaultErrorResponseError"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error: Optional["_models.DefaultErrorResponseError"] = None


class DefaultErrorResponseError(_serialization.Model):
    """Error model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    :ivar details: Details or the error.
    :vartype details: list[~azure.mgmt.appcontainers.models.DefaultErrorResponseErrorDetailsItem]
    :ivar innererror: More information to debug error.
    :vartype innererror: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "innererror": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[DefaultErrorResponseErrorDetailsItem]"},
        "innererror": {"key": "innererror", "type": "str"},
    }

    def __init__(
        self, *, details: Optional[List["_models.DefaultErrorResponseErrorDetailsItem"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword details: Details or the error.
        :paramtype details: list[~azure.mgmt.appcontainers.models.DefaultErrorResponseErrorDetailsItem]
        """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details = details
        self.innererror: Optional[str] = None


class DefaultErrorResponseErrorDetailsItem(_serialization.Model):
    """Detailed errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Standardized string to programmatically identify the error.
    :vartype code: str
    :ivar message: Detailed error description and debugging information.
    :vartype message: str
    :ivar target: Detailed error description and debugging information.
    :vartype target: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None


class DestinationsConfiguration(_serialization.Model):
    """Configuration of Open Telemetry destinations.

    :ivar data_dog_configuration: Open telemetry datadog destination configuration.
    :vartype data_dog_configuration: ~azure.mgmt.appcontainers.models.DataDogConfiguration
    :ivar otlp_configurations: Open telemetry otlp configurations.
    :vartype otlp_configurations: list[~azure.mgmt.appcontainers.models.OtlpConfiguration]
    """

    _attribute_map = {
        "data_dog_configuration": {"key": "dataDogConfiguration", "type": "DataDogConfiguration"},
        "otlp_configurations": {"key": "otlpConfigurations", "type": "[OtlpConfiguration]"},
    }

    def __init__(
        self,
        *,
        data_dog_configuration: Optional["_models.DataDogConfiguration"] = None,
        otlp_configurations: Optional[List["_models.OtlpConfiguration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_dog_configuration: Open telemetry datadog destination configuration.
        :paramtype data_dog_configuration: ~azure.mgmt.appcontainers.models.DataDogConfiguration
        :keyword otlp_configurations: Open telemetry otlp configurations.
        :paramtype otlp_configurations: list[~azure.mgmt.appcontainers.models.OtlpConfiguration]
        """
        super().__init__(**kwargs)
        self.data_dog_configuration = data_dog_configuration
        self.otlp_configurations = otlp_configurations


class DiagnosticDataProviderMetadata(_serialization.Model):
    """Details of a diagnostics data provider.

    :ivar provider_name: Name of data provider.
    :vartype provider_name: str
    :ivar property_bag: Collection of properties.
    :vartype property_bag:
     list[~azure.mgmt.appcontainers.models.DiagnosticDataProviderMetadataPropertyBagItem]
    """

    _attribute_map = {
        "provider_name": {"key": "providerName", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "[DiagnosticDataProviderMetadataPropertyBagItem]"},
    }

    def __init__(
        self,
        *,
        provider_name: Optional[str] = None,
        property_bag: Optional[List["_models.DiagnosticDataProviderMetadataPropertyBagItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider_name: Name of data provider.
        :paramtype provider_name: str
        :keyword property_bag: Collection of properties.
        :paramtype property_bag:
         list[~azure.mgmt.appcontainers.models.DiagnosticDataProviderMetadataPropertyBagItem]
        """
        super().__init__(**kwargs)
        self.provider_name = provider_name
        self.property_bag = property_bag


class DiagnosticDataProviderMetadataPropertyBagItem(_serialization.Model):  # pylint: disable=name-too-long
    """Property details.

    :ivar name: Property name.
    :vartype name: str
    :ivar value: Property value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Property name.
        :paramtype name: str
        :keyword value: Property value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class DiagnosticDataTableResponseColumn(_serialization.Model):
    """Diagnostics data column.

    :ivar column_name: Column name.
    :vartype column_name: str
    :ivar data_type: Data type of the column.
    :vartype data_type: str
    :ivar column_type: Column type.
    :vartype column_type: str
    """

    _attribute_map = {
        "column_name": {"key": "columnName", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "column_type": {"key": "columnType", "type": "str"},
    }

    def __init__(
        self,
        *,
        column_name: Optional[str] = None,
        data_type: Optional[str] = None,
        column_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column_name: Column name.
        :paramtype column_name: str
        :keyword data_type: Data type of the column.
        :paramtype data_type: str
        :keyword column_type: Column type.
        :paramtype column_type: str
        """
        super().__init__(**kwargs)
        self.column_name = column_name
        self.data_type = data_type
        self.column_type = column_type


class DiagnosticDataTableResponseObject(_serialization.Model):
    """Diagnostics data table.

    :ivar table_name: Table name.
    :vartype table_name: str
    :ivar columns: Columns in the table.
    :vartype columns: list[~azure.mgmt.appcontainers.models.DiagnosticDataTableResponseColumn]
    :ivar rows: Rows in the table.
    :vartype rows: list[JSON]
    """

    _attribute_map = {
        "table_name": {"key": "tableName", "type": "str"},
        "columns": {"key": "columns", "type": "[DiagnosticDataTableResponseColumn]"},
        "rows": {"key": "rows", "type": "[object]"},
    }

    def __init__(
        self,
        *,
        table_name: Optional[str] = None,
        columns: Optional[List["_models.DiagnosticDataTableResponseColumn"]] = None,
        rows: Optional[List[JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table_name: Table name.
        :paramtype table_name: str
        :keyword columns: Columns in the table.
        :paramtype columns: list[~azure.mgmt.appcontainers.models.DiagnosticDataTableResponseColumn]
        :keyword rows: Rows in the table.
        :paramtype rows: list[JSON]
        """
        super().__init__(**kwargs)
        self.table_name = table_name
        self.columns = columns
        self.rows = rows


class DiagnosticRendering(_serialization.Model):
    """Rendering details of a diagnostics table.

    :ivar type: Rendering type.
    :vartype type: int
    :ivar title: Title of the table.
    :vartype title: str
    :ivar description: Description of the table.
    :vartype description: str
    :ivar is_visible: Flag if the table should be rendered.
    :vartype is_visible: bool
    """

    _attribute_map = {
        "type": {"key": "type", "type": "int"},
        "title": {"key": "title", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_visible": {"key": "isVisible", "type": "bool"},
    }

    def __init__(
        self,
        *,
        type: Optional[int] = None,
        title: Optional[str] = None,
        description: Optional[str] = None,
        is_visible: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Rendering type.
        :paramtype type: int
        :keyword title: Title of the table.
        :paramtype title: str
        :keyword description: Description of the table.
        :paramtype description: str
        :keyword is_visible: Flag if the table should be rendered.
        :paramtype is_visible: bool
        """
        super().__init__(**kwargs)
        self.type = type
        self.title = title
        self.description = description
        self.is_visible = is_visible


class Diagnostics(ProxyResource):
    """Diagnostics data for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Diagnostics resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.DiagnosticsProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "DiagnosticsProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DiagnosticsProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Diagnostics resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.DiagnosticsProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class DiagnosticsCollection(_serialization.Model):
    """Diagnostics data collection for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of diagnostic data. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.Diagnostics]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Diagnostics]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Diagnostics"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of diagnostic data. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.Diagnostics]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DiagnosticsDataApiResponse(_serialization.Model):
    """Diagnostics data returned from a detector.

    :ivar table: Table response.
    :vartype table: ~azure.mgmt.appcontainers.models.DiagnosticDataTableResponseObject
    :ivar rendering_properties: Details of the table response.
    :vartype rendering_properties: ~azure.mgmt.appcontainers.models.DiagnosticRendering
    """

    _attribute_map = {
        "table": {"key": "table", "type": "DiagnosticDataTableResponseObject"},
        "rendering_properties": {"key": "renderingProperties", "type": "DiagnosticRendering"},
    }

    def __init__(
        self,
        *,
        table: Optional["_models.DiagnosticDataTableResponseObject"] = None,
        rendering_properties: Optional["_models.DiagnosticRendering"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword table: Table response.
        :paramtype table: ~azure.mgmt.appcontainers.models.DiagnosticDataTableResponseObject
        :keyword rendering_properties: Details of the table response.
        :paramtype rendering_properties: ~azure.mgmt.appcontainers.models.DiagnosticRendering
        """
        super().__init__(**kwargs)
        self.table = table
        self.rendering_properties = rendering_properties


class DiagnosticsDefinition(_serialization.Model):
    """Metadata of the diagnostics response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique detector name.
    :vartype id: str
    :ivar name: Display Name of the detector.
    :vartype name: str
    :ivar description: Details of the diagnostics info.
    :vartype description: str
    :ivar author: Authors' names of the detector.
    :vartype author: str
    :ivar category: Category of the detector.
    :vartype category: str
    :ivar support_topic_list: List of support topics.
    :vartype support_topic_list: list[~azure.mgmt.appcontainers.models.DiagnosticSupportTopic]
    :ivar analysis_types: List of analysis types.
    :vartype analysis_types: list[str]
    :ivar type: Authors' names of the detector.
    :vartype type: str
    :ivar score: Authors' names of the detector.
    :vartype score: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "description": {"readonly": True},
        "author": {"readonly": True},
        "category": {"readonly": True},
        "type": {"readonly": True},
        "score": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "author": {"key": "author", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "support_topic_list": {"key": "supportTopicList", "type": "[DiagnosticSupportTopic]"},
        "analysis_types": {"key": "analysisTypes", "type": "[str]"},
        "type": {"key": "type", "type": "str"},
        "score": {"key": "score", "type": "float"},
    }

    def __init__(
        self,
        *,
        support_topic_list: Optional[List["_models.DiagnosticSupportTopic"]] = None,
        analysis_types: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword support_topic_list: List of support topics.
        :paramtype support_topic_list: list[~azure.mgmt.appcontainers.models.DiagnosticSupportTopic]
        :keyword analysis_types: List of analysis types.
        :paramtype analysis_types: list[str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.author: Optional[str] = None
        self.category: Optional[str] = None
        self.support_topic_list = support_topic_list
        self.analysis_types = analysis_types
        self.type: Optional[str] = None
        self.score: Optional[float] = None


class DiagnosticsProperties(_serialization.Model):
    """Diagnostics resource specific properties.

    :ivar metadata: Metadata of the diagnostics response.
    :vartype metadata: ~azure.mgmt.appcontainers.models.DiagnosticsDefinition
    :ivar dataset: Set of data collections associated with the response.
    :vartype dataset: list[~azure.mgmt.appcontainers.models.DiagnosticsDataApiResponse]
    :ivar status: Status of the diagnostics response.
    :vartype status: ~azure.mgmt.appcontainers.models.DiagnosticsStatus
    :ivar data_provider_metadata: List of data providers' metadata.
    :vartype data_provider_metadata:
     ~azure.mgmt.appcontainers.models.DiagnosticDataProviderMetadata
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "DiagnosticsDefinition"},
        "dataset": {"key": "dataset", "type": "[DiagnosticsDataApiResponse]"},
        "status": {"key": "status", "type": "DiagnosticsStatus"},
        "data_provider_metadata": {"key": "dataProviderMetadata", "type": "DiagnosticDataProviderMetadata"},
    }

    def __init__(
        self,
        *,
        metadata: Optional["_models.DiagnosticsDefinition"] = None,
        dataset: Optional[List["_models.DiagnosticsDataApiResponse"]] = None,
        status: Optional["_models.DiagnosticsStatus"] = None,
        data_provider_metadata: Optional["_models.DiagnosticDataProviderMetadata"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata of the diagnostics response.
        :paramtype metadata: ~azure.mgmt.appcontainers.models.DiagnosticsDefinition
        :keyword dataset: Set of data collections associated with the response.
        :paramtype dataset: list[~azure.mgmt.appcontainers.models.DiagnosticsDataApiResponse]
        :keyword status: Status of the diagnostics response.
        :paramtype status: ~azure.mgmt.appcontainers.models.DiagnosticsStatus
        :keyword data_provider_metadata: List of data providers' metadata.
        :paramtype data_provider_metadata:
         ~azure.mgmt.appcontainers.models.DiagnosticDataProviderMetadata
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.dataset = dataset
        self.status = status
        self.data_provider_metadata = data_provider_metadata


class DiagnosticsStatus(_serialization.Model):
    """Rendering details of a diagnostics table.

    :ivar message: Diagnostic message.
    :vartype message: str
    :ivar status_id: Status.
    :vartype status_id: int
    """

    _attribute_map = {
        "message": {"key": "message", "type": "str"},
        "status_id": {"key": "statusId", "type": "int"},
    }

    def __init__(self, *, message: Optional[str] = None, status_id: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword message: Diagnostic message.
        :paramtype message: str
        :keyword status_id: Status.
        :paramtype status_id: int
        """
        super().__init__(**kwargs)
        self.message = message
        self.status_id = status_id


class DiagnosticSupportTopic(_serialization.Model):
    """Support topic information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Unique topic identifier.
    :vartype id: str
    :ivar pes_id: PES identifier.
    :vartype pes_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "pes_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "pes_id": {"key": "pesId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.pes_id: Optional[str] = None


class DiskEncryptionConfiguration(_serialization.Model):
    """Configuration properties for disk encryption.

    :ivar key_vault_configuration: The Key Vault that contains your key to use for disk encryption.
     The Key Vault must be in the same region as the Managed Environment.
    :vartype key_vault_configuration:
     ~azure.mgmt.appcontainers.models.DiskEncryptionConfigurationKeyVaultConfiguration
    """

    _attribute_map = {
        "key_vault_configuration": {
            "key": "keyVaultConfiguration",
            "type": "DiskEncryptionConfigurationKeyVaultConfiguration",
        },
    }

    def __init__(
        self,
        *,
        key_vault_configuration: Optional["_models.DiskEncryptionConfigurationKeyVaultConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_configuration: The Key Vault that contains your key to use for disk
         encryption. The Key Vault must be in the same region as the Managed Environment.
        :paramtype key_vault_configuration:
         ~azure.mgmt.appcontainers.models.DiskEncryptionConfigurationKeyVaultConfiguration
        """
        super().__init__(**kwargs)
        self.key_vault_configuration = key_vault_configuration


class DiskEncryptionConfigurationKeyVaultConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """The Key Vault that contains your key to use for disk encryption. The Key Vault must be in the
    same region as the Managed Environment.

    :ivar key_url: Key URL pointing to a key in KeyVault. Version segment of the Url is required.
    :vartype key_url: str
    :ivar auth: Configuration properties for the authentication to the Key Vault.
    :vartype auth:
     ~azure.mgmt.appcontainers.models.DiskEncryptionConfigurationKeyVaultConfigurationAuth
    """

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "auth": {"key": "auth", "type": "DiskEncryptionConfigurationKeyVaultConfigurationAuth"},
    }

    def __init__(
        self,
        *,
        key_url: Optional[str] = None,
        auth: Optional["_models.DiskEncryptionConfigurationKeyVaultConfigurationAuth"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_url: Key URL pointing to a key in KeyVault. Version segment of the Url is
         required.
        :paramtype key_url: str
        :keyword auth: Configuration properties for the authentication to the Key Vault.
        :paramtype auth:
         ~azure.mgmt.appcontainers.models.DiskEncryptionConfigurationKeyVaultConfigurationAuth
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.auth = auth


class DiskEncryptionConfigurationKeyVaultConfigurationAuth(_serialization.Model):  # pylint: disable=name-too-long
    """Configuration properties for the authentication to the Key Vault.

    :ivar identity: Resource ID of a user-assigned managed identity to authenticate to the Key
     Vault. The identity must be assigned to the managed environment, in the same tenant as the Key
     Vault, and it must have the following key permissions on the Key Vault: wrapkey, unwrapkey,
     get.
    :vartype identity: str
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(self, *, identity: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword identity: Resource ID of a user-assigned managed identity to authenticate to the Key
         Vault. The identity must be assigned to the managed environment, in the same tenant as the Key
         Vault, and it must have the following key permissions on the Key Vault: wrapkey, unwrapkey,
         get.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.identity = identity


class DotNetComponent(ProxyResource):
    """.NET Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar component_type: Type of the .NET Component. "AspireDashboard"
    :vartype component_type: str or ~azure.mgmt.appcontainers.models.DotNetComponentType
    :ivar provisioning_state: Provisioning state of the .NET Component. Known values are:
     "Succeeded", "Failed", "Canceled", "Deleting", and "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.DotNetComponentProvisioningState
    :ivar configurations: List of .NET Components configuration properties.
    :vartype configurations:
     list[~azure.mgmt.appcontainers.models.DotNetComponentConfigurationProperty]
    :ivar service_binds: List of .NET Components that are bound to the .NET component.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.DotNetComponentServiceBind]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "component_type": {"key": "properties.componentType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "configurations": {"key": "properties.configurations", "type": "[DotNetComponentConfigurationProperty]"},
        "service_binds": {"key": "properties.serviceBinds", "type": "[DotNetComponentServiceBind]"},
    }

    def __init__(
        self,
        *,
        component_type: Optional[Union[str, "_models.DotNetComponentType"]] = None,
        configurations: Optional[List["_models.DotNetComponentConfigurationProperty"]] = None,
        service_binds: Optional[List["_models.DotNetComponentServiceBind"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword component_type: Type of the .NET Component. "AspireDashboard"
        :paramtype component_type: str or ~azure.mgmt.appcontainers.models.DotNetComponentType
        :keyword configurations: List of .NET Components configuration properties.
        :paramtype configurations:
         list[~azure.mgmt.appcontainers.models.DotNetComponentConfigurationProperty]
        :keyword service_binds: List of .NET Components that are bound to the .NET component.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.DotNetComponentServiceBind]
        """
        super().__init__(**kwargs)
        self.component_type = component_type
        self.provisioning_state: Optional[Union[str, "_models.DotNetComponentProvisioningState"]] = None
        self.configurations = configurations
        self.service_binds = service_binds


class DotNetComponentConfigurationProperty(_serialization.Model):
    """Configuration properties for a .NET Component.

    :ivar property_name: The name of the property.
    :vartype property_name: str
    :ivar value: The value of the property.
    :vartype value: str
    """

    _attribute_map = {
        "property_name": {"key": "propertyName", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, property_name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword property_name: The name of the property.
        :paramtype property_name: str
        :keyword value: The value of the property.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.property_name = property_name
        self.value = value


class DotNetComponentsCollection(_serialization.Model):
    """.NET Components ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.DotNetComponent]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DotNetComponent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.DotNetComponent"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.DotNetComponent]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DotNetComponentServiceBind(_serialization.Model):
    """Configuration to bind a .NET Component to another .NET Component.

    :ivar name: Name of the service bind.
    :vartype name: str
    :ivar service_id: Resource id of the target service.
    :vartype service_id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "service_id": {"key": "serviceId", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, service_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the service bind.
        :paramtype name: str
        :keyword service_id: Resource id of the target service.
        :paramtype service_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.service_id = service_id


class DynamicPoolConfiguration(_serialization.Model):
    """Dynamic pool configuration.

    :ivar lifecycle_configuration: The lifecycle configuration of a session in the dynamic session
     pool.
    :vartype lifecycle_configuration: ~azure.mgmt.appcontainers.models.LifecycleConfiguration
    """

    _attribute_map = {
        "lifecycle_configuration": {"key": "lifecycleConfiguration", "type": "LifecycleConfiguration"},
    }

    def __init__(
        self, *, lifecycle_configuration: Optional["_models.LifecycleConfiguration"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword lifecycle_configuration: The lifecycle configuration of a session in the dynamic
         session pool.
        :paramtype lifecycle_configuration: ~azure.mgmt.appcontainers.models.LifecycleConfiguration
        """
        super().__init__(**kwargs)
        self.lifecycle_configuration = lifecycle_configuration


class EncryptionSettings(_serialization.Model):
    """The configuration settings of the secrets references of encryption key and signing key for
    ContainerApp Service Authentication/Authorization.

    :ivar container_app_auth_encryption_secret_name: The secret name which is referenced for
     EncryptionKey.
    :vartype container_app_auth_encryption_secret_name: str
    :ivar container_app_auth_signing_secret_name: The secret name which is referenced for
     SigningKey.
    :vartype container_app_auth_signing_secret_name: str
    """

    _attribute_map = {
        "container_app_auth_encryption_secret_name": {"key": "containerAppAuthEncryptionSecretName", "type": "str"},
        "container_app_auth_signing_secret_name": {"key": "containerAppAuthSigningSecretName", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_app_auth_encryption_secret_name: Optional[str] = None,
        container_app_auth_signing_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_app_auth_encryption_secret_name: The secret name which is referenced for
         EncryptionKey.
        :paramtype container_app_auth_encryption_secret_name: str
        :keyword container_app_auth_signing_secret_name: The secret name which is referenced for
         SigningKey.
        :paramtype container_app_auth_signing_secret_name: str
        """
        super().__init__(**kwargs)
        self.container_app_auth_encryption_secret_name = container_app_auth_encryption_secret_name
        self.container_app_auth_signing_secret_name = container_app_auth_signing_secret_name


class EnvironmentAuthToken(TrackedResource):
    """Environment Auth Token.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar token: Auth token value.
    :vartype token: str
    :ivar expires: Token expiration date.
    :vartype expires: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "token": {"readonly": True},
        "expires": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "token": {"key": "properties.token", "type": "str"},
        "expires": {"key": "properties.expires", "type": "iso-8601"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.token: Optional[str] = None
        self.expires: Optional[datetime.datetime] = None


class EnvironmentVar(_serialization.Model):
    """Container App container environment variable.

    :ivar name: Environment variable name.
    :vartype name: str
    :ivar value: Non-secret environment variable value.
    :vartype value: str
    :ivar secret_ref: Name of the Container App secret from which to pull the environment variable
     value.
    :vartype secret_ref: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "secret_ref": {"key": "secretRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        secret_ref: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Environment variable name.
        :paramtype name: str
        :keyword value: Non-secret environment variable value.
        :paramtype value: str
        :keyword secret_ref: Name of the Container App secret from which to pull the environment
         variable value.
        :paramtype secret_ref: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.secret_ref = secret_ref


class EnvironmentVariable(_serialization.Model):
    """Model representing an environment variable.

    All required parameters must be populated in order to send to server.

    :ivar name: Environment variable name. Required.
    :vartype name: str
    :ivar value: Environment variable value. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: Environment variable name. Required.
        :paramtype name: str
        :keyword value: Environment variable value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.appcontainers.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.appcontainers.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorEntity(_serialization.Model):
    """Body of the error response returned from the API.

    :ivar extended_code: Type of error.
    :vartype extended_code: str
    :ivar message_template: Message template.
    :vartype message_template: str
    :ivar parameters: Parameters for the template.
    :vartype parameters: list[str]
    :ivar inner_errors: Inner errors.
    :vartype inner_errors: list[~azure.mgmt.appcontainers.models.ErrorEntity]
    :ivar details: Error Details.
    :vartype details: list[~azure.mgmt.appcontainers.models.ErrorEntity]
    :ivar target: The error target.
    :vartype target: str
    :ivar code: Basic error code.
    :vartype code: str
    :ivar message: Any details of the error.
    :vartype message: str
    """

    _attribute_map = {
        "extended_code": {"key": "extendedCode", "type": "str"},
        "message_template": {"key": "messageTemplate", "type": "str"},
        "parameters": {"key": "parameters", "type": "[str]"},
        "inner_errors": {"key": "innerErrors", "type": "[ErrorEntity]"},
        "details": {"key": "details", "type": "[ErrorEntity]"},
        "target": {"key": "target", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        extended_code: Optional[str] = None,
        message_template: Optional[str] = None,
        parameters: Optional[List[str]] = None,
        inner_errors: Optional[List["_models.ErrorEntity"]] = None,
        details: Optional[List["_models.ErrorEntity"]] = None,
        target: Optional[str] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_code: Type of error.
        :paramtype extended_code: str
        :keyword message_template: Message template.
        :paramtype message_template: str
        :keyword parameters: Parameters for the template.
        :paramtype parameters: list[str]
        :keyword inner_errors: Inner errors.
        :paramtype inner_errors: list[~azure.mgmt.appcontainers.models.ErrorEntity]
        :keyword details: Error Details.
        :paramtype details: list[~azure.mgmt.appcontainers.models.ErrorEntity]
        :keyword target: The error target.
        :paramtype target: str
        :keyword code: Basic error code.
        :paramtype code: str
        :keyword message: Any details of the error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.extended_code = extended_code
        self.message_template = message_template
        self.parameters = parameters
        self.inner_errors = inner_errors
        self.details = details
        self.target = target
        self.code = code
        self.message = message


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.appcontainers.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.appcontainers.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExecutionStatus(_serialization.Model):
    """Container Apps Job execution status.

    :ivar replicas: Replicas in the execution.
    :vartype replicas: list[~azure.mgmt.appcontainers.models.ReplicaExecutionStatus]
    """

    _attribute_map = {
        "replicas": {"key": "replicas", "type": "[ReplicaExecutionStatus]"},
    }

    def __init__(self, *, replicas: Optional[List["_models.ReplicaExecutionStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword replicas: Replicas in the execution.
        :paramtype replicas: list[~azure.mgmt.appcontainers.models.ReplicaExecutionStatus]
        """
        super().__init__(**kwargs)
        self.replicas = replicas


class ExtendedLocation(_serialization.Model):
    """The complex type of the extended location.

    :ivar name: The name of the extended location.
    :vartype name: str
    :ivar type: The type of the extended location. "CustomLocation"
    :vartype type: str or ~azure.mgmt.appcontainers.models.ExtendedLocationTypes
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "_models.ExtendedLocationTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the extended location.
        :paramtype name: str
        :keyword type: The type of the extended location. "CustomLocation"
        :paramtype type: str or ~azure.mgmt.appcontainers.models.ExtendedLocationTypes
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Facebook(_serialization.Model):
    """The configuration settings of the Facebook provider.

    :ivar enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
     despite the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Facebook
     provider.
    :vartype registration: ~azure.mgmt.appcontainers.models.AppRegistration
    :ivar graph_api_version: The version of the Facebook api to be used while logging in.
    :vartype graph_api_version: str
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.appcontainers.models.LoginScopes
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "AppRegistration"},
        "graph_api_version": {"key": "graphApiVersion", "type": "str"},
        "login": {"key": "login", "type": "LoginScopes"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.AppRegistration"] = None,
        graph_api_version: Optional[str] = None,
        login: Optional["_models.LoginScopes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Facebook provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Facebook
         provider.
        :paramtype registration: ~azure.mgmt.appcontainers.models.AppRegistration
        :keyword graph_api_version: The version of the Facebook api to be used while logging in.
        :paramtype graph_api_version: str
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.appcontainers.models.LoginScopes
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.graph_api_version = graph_api_version
        self.login = login


class ForwardProxy(_serialization.Model):
    """The configuration settings of a forward proxy used to make the requests.

    :ivar convention: The convention used to determine the url of the request made. Known values
     are: "NoProxy", "Standard", and "Custom".
    :vartype convention: str or ~azure.mgmt.appcontainers.models.ForwardProxyConvention
    :ivar custom_host_header_name: The name of the header containing the host of the request.
    :vartype custom_host_header_name: str
    :ivar custom_proto_header_name: The name of the header containing the scheme of the request.
    :vartype custom_proto_header_name: str
    """

    _attribute_map = {
        "convention": {"key": "convention", "type": "str"},
        "custom_host_header_name": {"key": "customHostHeaderName", "type": "str"},
        "custom_proto_header_name": {"key": "customProtoHeaderName", "type": "str"},
    }

    def __init__(
        self,
        *,
        convention: Optional[Union[str, "_models.ForwardProxyConvention"]] = None,
        custom_host_header_name: Optional[str] = None,
        custom_proto_header_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword convention: The convention used to determine the url of the request made. Known values
         are: "NoProxy", "Standard", and "Custom".
        :paramtype convention: str or ~azure.mgmt.appcontainers.models.ForwardProxyConvention
        :keyword custom_host_header_name: The name of the header containing the host of the request.
        :paramtype custom_host_header_name: str
        :keyword custom_proto_header_name: The name of the header containing the scheme of the request.
        :paramtype custom_proto_header_name: str
        """
        super().__init__(**kwargs)
        self.convention = convention
        self.custom_host_header_name = custom_host_header_name
        self.custom_proto_header_name = custom_proto_header_name


class GitHub(_serialization.Model):
    """The configuration settings of the GitHub provider.

    :ivar enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the GitHub provider.
    :vartype registration: ~azure.mgmt.appcontainers.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.appcontainers.models.LoginScopes
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "ClientRegistration"},
        "login": {"key": "login", "type": "LoginScopes"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.ClientRegistration"] = None,
        login: Optional["_models.LoginScopes"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the GitHub provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the GitHub
         provider.
        :paramtype registration: ~azure.mgmt.appcontainers.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.appcontainers.models.LoginScopes
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login


class GithubActionConfiguration(_serialization.Model):
    """Configuration properties that define the mutable settings of a Container App SourceControl.

    :ivar registry_info: Registry configurations.
    :vartype registry_info: ~azure.mgmt.appcontainers.models.RegistryInfo
    :ivar azure_credentials: AzureCredentials configurations.
    :vartype azure_credentials: ~azure.mgmt.appcontainers.models.AzureCredentials
    :ivar context_path: Context path.
    :vartype context_path: str
    :ivar dockerfile_path: Dockerfile path.
    :vartype dockerfile_path: str
    :ivar github_personal_access_token: One time Github PAT to configure github environment.
    :vartype github_personal_access_token: str
    :ivar image: Image name.
    :vartype image: str
    :ivar publish_type: Code or Image.
    :vartype publish_type: str
    :ivar os: Operation system.
    :vartype os: str
    :ivar runtime_stack: Runtime stack.
    :vartype runtime_stack: str
    :ivar runtime_version: Runtime version.
    :vartype runtime_version: str
    :ivar build_environment_variables: List of environment variables to be passed to the build.
    :vartype build_environment_variables:
     list[~azure.mgmt.appcontainers.models.EnvironmentVariable]
    """

    _attribute_map = {
        "registry_info": {"key": "registryInfo", "type": "RegistryInfo"},
        "azure_credentials": {"key": "azureCredentials", "type": "AzureCredentials"},
        "context_path": {"key": "contextPath", "type": "str"},
        "dockerfile_path": {"key": "dockerfilePath", "type": "str"},
        "github_personal_access_token": {"key": "githubPersonalAccessToken", "type": "str"},
        "image": {"key": "image", "type": "str"},
        "publish_type": {"key": "publishType", "type": "str"},
        "os": {"key": "os", "type": "str"},
        "runtime_stack": {"key": "runtimeStack", "type": "str"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
        "build_environment_variables": {"key": "buildEnvironmentVariables", "type": "[EnvironmentVariable]"},
    }

    def __init__(
        self,
        *,
        registry_info: Optional["_models.RegistryInfo"] = None,
        azure_credentials: Optional["_models.AzureCredentials"] = None,
        context_path: Optional[str] = None,
        dockerfile_path: Optional[str] = None,
        github_personal_access_token: Optional[str] = None,
        image: Optional[str] = None,
        publish_type: Optional[str] = None,
        os: Optional[str] = None,
        runtime_stack: Optional[str] = None,
        runtime_version: Optional[str] = None,
        build_environment_variables: Optional[List["_models.EnvironmentVariable"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword registry_info: Registry configurations.
        :paramtype registry_info: ~azure.mgmt.appcontainers.models.RegistryInfo
        :keyword azure_credentials: AzureCredentials configurations.
        :paramtype azure_credentials: ~azure.mgmt.appcontainers.models.AzureCredentials
        :keyword context_path: Context path.
        :paramtype context_path: str
        :keyword dockerfile_path: Dockerfile path.
        :paramtype dockerfile_path: str
        :keyword github_personal_access_token: One time Github PAT to configure github environment.
        :paramtype github_personal_access_token: str
        :keyword image: Image name.
        :paramtype image: str
        :keyword publish_type: Code or Image.
        :paramtype publish_type: str
        :keyword os: Operation system.
        :paramtype os: str
        :keyword runtime_stack: Runtime stack.
        :paramtype runtime_stack: str
        :keyword runtime_version: Runtime version.
        :paramtype runtime_version: str
        :keyword build_environment_variables: List of environment variables to be passed to the build.
        :paramtype build_environment_variables:
         list[~azure.mgmt.appcontainers.models.EnvironmentVariable]
        """
        super().__init__(**kwargs)
        self.registry_info = registry_info
        self.azure_credentials = azure_credentials
        self.context_path = context_path
        self.dockerfile_path = dockerfile_path
        self.github_personal_access_token = github_personal_access_token
        self.image = image
        self.publish_type = publish_type
        self.os = os
        self.runtime_stack = runtime_stack
        self.runtime_version = runtime_version
        self.build_environment_variables = build_environment_variables


class GlobalValidation(_serialization.Model):
    """The configuration settings that determines the validation flow of users using ContainerApp
    Service Authentication/Authorization.

    :ivar unauthenticated_client_action: The action to take when an unauthenticated client attempts
     to access the app. Known values are: "RedirectToLoginPage", "AllowAnonymous", "Return401", and
     "Return403".
    :vartype unauthenticated_client_action: str or
     ~azure.mgmt.appcontainers.models.UnauthenticatedClientActionV2
    :ivar redirect_to_provider: The default authentication provider to use when multiple providers
     are configured.
     This setting is only needed if multiple providers are configured and the unauthenticated client
     action is set to "RedirectToLoginPage".
    :vartype redirect_to_provider: str
    :ivar excluded_paths: The paths for which unauthenticated flow would not be redirected to the
     login page.
    :vartype excluded_paths: list[str]
    """

    _attribute_map = {
        "unauthenticated_client_action": {"key": "unauthenticatedClientAction", "type": "str"},
        "redirect_to_provider": {"key": "redirectToProvider", "type": "str"},
        "excluded_paths": {"key": "excludedPaths", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        unauthenticated_client_action: Optional[Union[str, "_models.UnauthenticatedClientActionV2"]] = None,
        redirect_to_provider: Optional[str] = None,
        excluded_paths: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unauthenticated_client_action: The action to take when an unauthenticated client
         attempts to access the app. Known values are: "RedirectToLoginPage", "AllowAnonymous",
         "Return401", and "Return403".
        :paramtype unauthenticated_client_action: str or
         ~azure.mgmt.appcontainers.models.UnauthenticatedClientActionV2
        :keyword redirect_to_provider: The default authentication provider to use when multiple
         providers are configured.
         This setting is only needed if multiple providers are configured and the unauthenticated client
         action is set to "RedirectToLoginPage".
        :paramtype redirect_to_provider: str
        :keyword excluded_paths: The paths for which unauthenticated flow would not be redirected to
         the login page.
        :paramtype excluded_paths: list[str]
        """
        super().__init__(**kwargs)
        self.unauthenticated_client_action = unauthenticated_client_action
        self.redirect_to_provider = redirect_to_provider
        self.excluded_paths = excluded_paths


class Google(_serialization.Model):
    """The configuration settings of the Google provider.

    :ivar enabled: :code:`<code>false</code>` if the Google provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Google provider.
    :vartype registration: ~azure.mgmt.appcontainers.models.ClientRegistration
    :ivar login: The configuration settings of the login flow.
    :vartype login: ~azure.mgmt.appcontainers.models.LoginScopes
    :ivar validation: The configuration settings of the Azure Active Directory token validation
     flow.
    :vartype validation: ~azure.mgmt.appcontainers.models.AllowedAudiencesValidation
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "ClientRegistration"},
        "login": {"key": "login", "type": "LoginScopes"},
        "validation": {"key": "validation", "type": "AllowedAudiencesValidation"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.ClientRegistration"] = None,
        login: Optional["_models.LoginScopes"] = None,
        validation: Optional["_models.AllowedAudiencesValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Google provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Google
         provider.
        :paramtype registration: ~azure.mgmt.appcontainers.models.ClientRegistration
        :keyword login: The configuration settings of the login flow.
        :paramtype login: ~azure.mgmt.appcontainers.models.LoginScopes
        :keyword validation: The configuration settings of the Azure Active Directory token validation
         flow.
        :paramtype validation: ~azure.mgmt.appcontainers.models.AllowedAudiencesValidation
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration
        self.login = login
        self.validation = validation


class Header(_serialization.Model):
    """Header of otlp configuration.

    :ivar key: The key of otlp configuration header.
    :vartype key: str
    :ivar value: The value of otlp configuration header.
    :vartype value: str
    """

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key: The key of otlp configuration header.
        :paramtype key: str
        :keyword value: The value of otlp configuration header.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class HeaderMatch(_serialization.Model):
    """Conditions required to match a header.

    :ivar header: Name of the header.
    :vartype header: str
    :ivar exact_match: Exact value of the header.
    :vartype exact_match: str
    :ivar prefix_match: Prefix value of the header.
    :vartype prefix_match: str
    :ivar suffix_match: Suffix value of the header.
    :vartype suffix_match: str
    :ivar regex_match: Regex value of the header.
    :vartype regex_match: str
    """

    _attribute_map = {
        "header": {"key": "header", "type": "str"},
        "exact_match": {"key": "match.exactMatch", "type": "str"},
        "prefix_match": {"key": "match.prefixMatch", "type": "str"},
        "suffix_match": {"key": "match.suffixMatch", "type": "str"},
        "regex_match": {"key": "match.regexMatch", "type": "str"},
    }

    def __init__(
        self,
        *,
        header: Optional[str] = None,
        exact_match: Optional[str] = None,
        prefix_match: Optional[str] = None,
        suffix_match: Optional[str] = None,
        regex_match: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword header: Name of the header.
        :paramtype header: str
        :keyword exact_match: Exact value of the header.
        :paramtype exact_match: str
        :keyword prefix_match: Prefix value of the header.
        :paramtype prefix_match: str
        :keyword suffix_match: Suffix value of the header.
        :paramtype suffix_match: str
        :keyword regex_match: Regex value of the header.
        :paramtype regex_match: str
        """
        super().__init__(**kwargs)
        self.header = header
        self.exact_match = exact_match
        self.prefix_match = prefix_match
        self.suffix_match = suffix_match
        self.regex_match = regex_match


class HttpConnectionPool(_serialization.Model):
    """Defines parameters for http connection pooling.

    :ivar http1_max_pending_requests: Maximum number of pending http1 requests allowed.
    :vartype http1_max_pending_requests: int
    :ivar http2_max_requests: Maximum number of http2 requests allowed.
    :vartype http2_max_requests: int
    """

    _attribute_map = {
        "http1_max_pending_requests": {"key": "http1MaxPendingRequests", "type": "int"},
        "http2_max_requests": {"key": "http2MaxRequests", "type": "int"},
    }

    def __init__(
        self,
        *,
        http1_max_pending_requests: Optional[int] = None,
        http2_max_requests: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword http1_max_pending_requests: Maximum number of pending http1 requests allowed.
        :paramtype http1_max_pending_requests: int
        :keyword http2_max_requests: Maximum number of http2 requests allowed.
        :paramtype http2_max_requests: int
        """
        super().__init__(**kwargs)
        self.http1_max_pending_requests = http1_max_pending_requests
        self.http2_max_requests = http2_max_requests


class HttpGet(_serialization.Model):
    """Model representing a http get request.

    All required parameters must be populated in order to send to server.

    :ivar url: URL to make HTTP GET request against. Required.
    :vartype url: str
    :ivar file_name: Name of the file that the request should be saved to.
    :vartype file_name: str
    :ivar headers: List of headers to send with the request.
    :vartype headers: list[str]
    """

    _validation = {
        "url": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
        "file_name": {"key": "fileName", "type": "str"},
        "headers": {"key": "headers", "type": "[str]"},
    }

    def __init__(
        self, *, url: str, file_name: Optional[str] = None, headers: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword url: URL to make HTTP GET request against. Required.
        :paramtype url: str
        :keyword file_name: Name of the file that the request should be saved to.
        :paramtype file_name: str
        :keyword headers: List of headers to send with the request.
        :paramtype headers: list[str]
        """
        super().__init__(**kwargs)
        self.url = url
        self.file_name = file_name
        self.headers = headers


class HttpRetryPolicy(_serialization.Model):
    """Policy that defines http request retry conditions.

    :ivar max_retries: Maximum number of times a request will retry.
    :vartype max_retries: int
    :ivar headers: Headers that must be present for a request to be retried.
    :vartype headers: list[~azure.mgmt.appcontainers.models.HeaderMatch]
    :ivar http_status_codes: Additional http status codes that can trigger a retry.
    :vartype http_status_codes: list[int]
    :ivar errors: Errors that can trigger a retry.
    :vartype errors: list[str]
    :ivar initial_delay_in_milliseconds: Initial delay, in milliseconds, before retrying a request.
    :vartype initial_delay_in_milliseconds: int
    :ivar max_interval_in_milliseconds: Maximum interval, in milliseconds, between retries.
    :vartype max_interval_in_milliseconds: int
    """

    _attribute_map = {
        "max_retries": {"key": "maxRetries", "type": "int"},
        "headers": {"key": "matches.headers", "type": "[HeaderMatch]"},
        "http_status_codes": {"key": "matches.httpStatusCodes", "type": "[int]"},
        "errors": {"key": "matches.errors", "type": "[str]"},
        "initial_delay_in_milliseconds": {"key": "retryBackOff.initialDelayInMilliseconds", "type": "int"},
        "max_interval_in_milliseconds": {"key": "retryBackOff.maxIntervalInMilliseconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_retries: Optional[int] = None,
        headers: Optional[List["_models.HeaderMatch"]] = None,
        http_status_codes: Optional[List[int]] = None,
        errors: Optional[List[str]] = None,
        initial_delay_in_milliseconds: Optional[int] = None,
        max_interval_in_milliseconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_retries: Maximum number of times a request will retry.
        :paramtype max_retries: int
        :keyword headers: Headers that must be present for a request to be retried.
        :paramtype headers: list[~azure.mgmt.appcontainers.models.HeaderMatch]
        :keyword http_status_codes: Additional http status codes that can trigger a retry.
        :paramtype http_status_codes: list[int]
        :keyword errors: Errors that can trigger a retry.
        :paramtype errors: list[str]
        :keyword initial_delay_in_milliseconds: Initial delay, in milliseconds, before retrying a
         request.
        :paramtype initial_delay_in_milliseconds: int
        :keyword max_interval_in_milliseconds: Maximum interval, in milliseconds, between retries.
        :paramtype max_interval_in_milliseconds: int
        """
        super().__init__(**kwargs)
        self.max_retries = max_retries
        self.headers = headers
        self.http_status_codes = http_status_codes
        self.errors = errors
        self.initial_delay_in_milliseconds = initial_delay_in_milliseconds
        self.max_interval_in_milliseconds = max_interval_in_milliseconds


class HttpRoute(_serialization.Model):
    """Http Routes configuration, including paths to match on and whether or not rewrites are to be
    done.

    :ivar match: Conditions route will match on.
    :vartype match: ~azure.mgmt.appcontainers.models.HttpRouteMatch
    :ivar action: Once route is matched, what is the desired action.
    :vartype action: ~azure.mgmt.appcontainers.models.HttpRouteAction
    """

    _attribute_map = {
        "match": {"key": "match", "type": "HttpRouteMatch"},
        "action": {"key": "action", "type": "HttpRouteAction"},
    }

    def __init__(
        self,
        *,
        match: Optional["_models.HttpRouteMatch"] = None,
        action: Optional["_models.HttpRouteAction"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword match: Conditions route will match on.
        :paramtype match: ~azure.mgmt.appcontainers.models.HttpRouteMatch
        :keyword action: Once route is matched, what is the desired action.
        :paramtype action: ~azure.mgmt.appcontainers.models.HttpRouteAction
        """
        super().__init__(**kwargs)
        self.match = match
        self.action = action


class HttpRouteAction(_serialization.Model):
    """Action to perform once matching of routes is done.

    :ivar prefix_rewrite: Rewrite prefix, default is no rewrites.
    :vartype prefix_rewrite: str
    """

    _attribute_map = {
        "prefix_rewrite": {"key": "prefixRewrite", "type": "str"},
    }

    def __init__(self, *, prefix_rewrite: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword prefix_rewrite: Rewrite prefix, default is no rewrites.
        :paramtype prefix_rewrite: str
        """
        super().__init__(**kwargs)
        self.prefix_rewrite = prefix_rewrite


class HttpRouteConfig(ProxyResource):
    """Advanced Ingress routing for path/header based routing for a Container App Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Http Route Config properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.HttpRouteConfigProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "HttpRouteConfigProperties"},
    }

    def __init__(self, *, properties: Optional["_models.HttpRouteConfigProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Http Route Config properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.HttpRouteConfigProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class HttpRouteConfigCollection(_serialization.Model):
    """Collection of Advanced Ingress Routing Config resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.HttpRouteConfig]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[HttpRouteConfig]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.HttpRouteConfig"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.HttpRouteConfig]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class HttpRouteConfigProperties(_serialization.Model):
    """Http Route Config properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state of the Http Route Config in cluster. Known
     values are: "Succeeded", "Failed", "Canceled", "Waiting", "Updating", "Deleting", and
     "Pending".
    :vartype provisioning_state: str or ~azure.mgmt.appcontainers.models.HttpRouteProvisioningState
    :ivar provisioning_errors: List of errors when trying to reconcile http routes.
    :vartype provisioning_errors:
     list[~azure.mgmt.appcontainers.models.HttpRouteProvisioningErrors]
    :ivar fqdn: FQDN of the route resource.
    :vartype fqdn: str
    :ivar custom_domains: Custom domain bindings for http Routes' hostnames.
    :vartype custom_domains: list[~azure.mgmt.appcontainers.models.CustomDomain]
    :ivar rules: Routing Rules for http route resource.
    :vartype rules: list[~azure.mgmt.appcontainers.models.HttpRouteRule]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "provisioning_errors": {"readonly": True},
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "provisioning_errors": {"key": "provisioningErrors", "type": "[HttpRouteProvisioningErrors]"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "custom_domains": {"key": "customDomains", "type": "[CustomDomain]"},
        "rules": {"key": "rules", "type": "[HttpRouteRule]"},
    }

    def __init__(
        self,
        *,
        custom_domains: Optional[List["_models.CustomDomain"]] = None,
        rules: Optional[List["_models.HttpRouteRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword custom_domains: Custom domain bindings for http Routes' hostnames.
        :paramtype custom_domains: list[~azure.mgmt.appcontainers.models.CustomDomain]
        :keyword rules: Routing Rules for http route resource.
        :paramtype rules: list[~azure.mgmt.appcontainers.models.HttpRouteRule]
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.HttpRouteProvisioningState"]] = None
        self.provisioning_errors: Optional[List["_models.HttpRouteProvisioningErrors"]] = None
        self.fqdn: Optional[str] = None
        self.custom_domains = custom_domains
        self.rules = rules


class HttpRouteMatch(_serialization.Model):
    """Criteria to match on.

    :ivar prefix: match on all prefix's. Not exact.
    :vartype prefix: str
    :ivar path: match on exact path.
    :vartype path: str
    :ivar path_separated_prefix: match on all prefix's. Not exact.
    :vartype path_separated_prefix: str
    :ivar case_sensitive: path case sensitive, default is true.
    :vartype case_sensitive: bool
    """

    _attribute_map = {
        "prefix": {"key": "prefix", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "path_separated_prefix": {"key": "pathSeparatedPrefix", "type": "str"},
        "case_sensitive": {"key": "caseSensitive", "type": "bool"},
    }

    def __init__(
        self,
        *,
        prefix: Optional[str] = None,
        path: Optional[str] = None,
        path_separated_prefix: Optional[str] = None,
        case_sensitive: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword prefix: match on all prefix's. Not exact.
        :paramtype prefix: str
        :keyword path: match on exact path.
        :paramtype path: str
        :keyword path_separated_prefix: match on all prefix's. Not exact.
        :paramtype path_separated_prefix: str
        :keyword case_sensitive: path case sensitive, default is true.
        :paramtype case_sensitive: bool
        """
        super().__init__(**kwargs)
        self.prefix = prefix
        self.path = path
        self.path_separated_prefix = path_separated_prefix
        self.case_sensitive = case_sensitive


class HttpRouteProvisioningErrors(_serialization.Model):
    """List of provisioning errors for a http route config object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Timestamp error occured at.
    :vartype timestamp: ~datetime.datetime
    :ivar message: Description or error message.
    :vartype message: str
    """

    _validation = {
        "timestamp": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.timestamp: Optional[datetime.datetime] = None
        self.message: Optional[str] = None


class HttpRouteRule(_serialization.Model):
    """Http Route rule.

    :ivar targets: Targets- container apps, revisions, labels.
    :vartype targets: list[~azure.mgmt.appcontainers.models.HttpRouteTarget]
    :ivar routes: Routing configuration that will allow matches on specific paths/headers.
    :vartype routes: list[~azure.mgmt.appcontainers.models.HttpRoute]
    :ivar description: Description of rule. Optional.
    :vartype description: str
    """

    _attribute_map = {
        "targets": {"key": "targets", "type": "[HttpRouteTarget]"},
        "routes": {"key": "routes", "type": "[HttpRoute]"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        targets: Optional[List["_models.HttpRouteTarget"]] = None,
        routes: Optional[List["_models.HttpRoute"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword targets: Targets- container apps, revisions, labels.
        :paramtype targets: list[~azure.mgmt.appcontainers.models.HttpRouteTarget]
        :keyword routes: Routing configuration that will allow matches on specific paths/headers.
        :paramtype routes: list[~azure.mgmt.appcontainers.models.HttpRoute]
        :keyword description: Description of rule. Optional.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.targets = targets
        self.routes = routes
        self.description = description


class HttpRouteTarget(_serialization.Model):
    """Targets - Container App Names, Revision Names, Labels.

    All required parameters must be populated in order to send to server.

    :ivar container_app: Container App Name to route requests to. Required.
    :vartype container_app: str
    :ivar revision: Revision to route requests to.
    :vartype revision: str
    :ivar label: Label/Revision to route requests to.
    :vartype label: str
    :ivar weight: Weighted routing.
    :vartype weight: int
    """

    _validation = {
        "container_app": {"required": True},
        "weight": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "container_app": {"key": "containerApp", "type": "str"},
        "revision": {"key": "revision", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
    }

    def __init__(
        self,
        *,
        container_app: str,
        revision: Optional[str] = None,
        label: Optional[str] = None,
        weight: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_app: Container App Name to route requests to. Required.
        :paramtype container_app: str
        :keyword revision: Revision to route requests to.
        :paramtype revision: str
        :keyword label: Label/Revision to route requests to.
        :paramtype label: str
        :keyword weight: Weighted routing.
        :paramtype weight: int
        """
        super().__init__(**kwargs)
        self.container_app = container_app
        self.revision = revision
        self.label = label
        self.weight = weight


class HttpScaleRule(_serialization.Model):
    """Container App container Http scaling rule.

    :ivar metadata: Metadata properties to describe http scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the custom scale rule.
    :vartype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
    :ivar identity: The resource ID of a user-assigned managed identity that is assigned to the
     Container App, or 'system' for system-assigned identity.
    :vartype identity: str
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata properties to describe http scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the custom scale rule.
        :paramtype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
        :keyword identity: The resource ID of a user-assigned managed identity that is assigned to the
         Container App, or 'system' for system-assigned identity.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.auth = auth
        self.identity = identity


class HttpSettings(_serialization.Model):
    """The configuration settings of the HTTP requests for authentication and authorization requests
    made against ContainerApp Service Authentication/Authorization.

    :ivar require_https: :code:`<code>false</code>` if the authentication/authorization responses
     not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
    :vartype require_https: bool
    :ivar routes: The configuration settings of the paths HTTP requests.
    :vartype routes: ~azure.mgmt.appcontainers.models.HttpSettingsRoutes
    :ivar forward_proxy: The configuration settings of a forward proxy used to make the requests.
    :vartype forward_proxy: ~azure.mgmt.appcontainers.models.ForwardProxy
    """

    _attribute_map = {
        "require_https": {"key": "requireHttps", "type": "bool"},
        "routes": {"key": "routes", "type": "HttpSettingsRoutes"},
        "forward_proxy": {"key": "forwardProxy", "type": "ForwardProxy"},
    }

    def __init__(
        self,
        *,
        require_https: Optional[bool] = None,
        routes: Optional["_models.HttpSettingsRoutes"] = None,
        forward_proxy: Optional["_models.ForwardProxy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword require_https: :code:`<code>false</code>` if the authentication/authorization
         responses not having the HTTPS scheme are permissible; otherwise, :code:`<code>true</code>`.
        :paramtype require_https: bool
        :keyword routes: The configuration settings of the paths HTTP requests.
        :paramtype routes: ~azure.mgmt.appcontainers.models.HttpSettingsRoutes
        :keyword forward_proxy: The configuration settings of a forward proxy used to make the
         requests.
        :paramtype forward_proxy: ~azure.mgmt.appcontainers.models.ForwardProxy
        """
        super().__init__(**kwargs)
        self.require_https = require_https
        self.routes = routes
        self.forward_proxy = forward_proxy


class HttpSettingsRoutes(_serialization.Model):
    """The configuration settings of the paths HTTP requests.

    :ivar api_prefix: The prefix that should precede all the authentication/authorization paths.
    :vartype api_prefix: str
    """

    _attribute_map = {
        "api_prefix": {"key": "apiPrefix", "type": "str"},
    }

    def __init__(self, *, api_prefix: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword api_prefix: The prefix that should precede all the authentication/authorization paths.
        :paramtype api_prefix: str
        """
        super().__init__(**kwargs)
        self.api_prefix = api_prefix


class IdentityProviders(_serialization.Model):
    """The configuration settings of each of the identity providers used to configure ContainerApp
    Service Authentication/Authorization.

    :ivar azure_active_directory: The configuration settings of the Azure Active directory
     provider.
    :vartype azure_active_directory: ~azure.mgmt.appcontainers.models.AzureActiveDirectory
    :ivar facebook: The configuration settings of the Facebook provider.
    :vartype facebook: ~azure.mgmt.appcontainers.models.Facebook
    :ivar git_hub: The configuration settings of the GitHub provider.
    :vartype git_hub: ~azure.mgmt.appcontainers.models.GitHub
    :ivar google: The configuration settings of the Google provider.
    :vartype google: ~azure.mgmt.appcontainers.models.Google
    :ivar twitter: The configuration settings of the Twitter provider.
    :vartype twitter: ~azure.mgmt.appcontainers.models.Twitter
    :ivar apple: The configuration settings of the Apple provider.
    :vartype apple: ~azure.mgmt.appcontainers.models.Apple
    :ivar azure_static_web_apps: The configuration settings of the Azure Static Web Apps provider.
    :vartype azure_static_web_apps: ~azure.mgmt.appcontainers.models.AzureStaticWebApps
    :ivar custom_open_id_connect_providers: The map of the name of the alias of each custom Open ID
     Connect provider to the
     configuration settings of the custom Open ID Connect provider.
    :vartype custom_open_id_connect_providers: dict[str,
     ~azure.mgmt.appcontainers.models.CustomOpenIdConnectProvider]
    """

    _attribute_map = {
        "azure_active_directory": {"key": "azureActiveDirectory", "type": "AzureActiveDirectory"},
        "facebook": {"key": "facebook", "type": "Facebook"},
        "git_hub": {"key": "gitHub", "type": "GitHub"},
        "google": {"key": "google", "type": "Google"},
        "twitter": {"key": "twitter", "type": "Twitter"},
        "apple": {"key": "apple", "type": "Apple"},
        "azure_static_web_apps": {"key": "azureStaticWebApps", "type": "AzureStaticWebApps"},
        "custom_open_id_connect_providers": {
            "key": "customOpenIdConnectProviders",
            "type": "{CustomOpenIdConnectProvider}",
        },
    }

    def __init__(
        self,
        *,
        azure_active_directory: Optional["_models.AzureActiveDirectory"] = None,
        facebook: Optional["_models.Facebook"] = None,
        git_hub: Optional["_models.GitHub"] = None,
        google: Optional["_models.Google"] = None,
        twitter: Optional["_models.Twitter"] = None,
        apple: Optional["_models.Apple"] = None,
        azure_static_web_apps: Optional["_models.AzureStaticWebApps"] = None,
        custom_open_id_connect_providers: Optional[Dict[str, "_models.CustomOpenIdConnectProvider"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_active_directory: The configuration settings of the Azure Active directory
         provider.
        :paramtype azure_active_directory: ~azure.mgmt.appcontainers.models.AzureActiveDirectory
        :keyword facebook: The configuration settings of the Facebook provider.
        :paramtype facebook: ~azure.mgmt.appcontainers.models.Facebook
        :keyword git_hub: The configuration settings of the GitHub provider.
        :paramtype git_hub: ~azure.mgmt.appcontainers.models.GitHub
        :keyword google: The configuration settings of the Google provider.
        :paramtype google: ~azure.mgmt.appcontainers.models.Google
        :keyword twitter: The configuration settings of the Twitter provider.
        :paramtype twitter: ~azure.mgmt.appcontainers.models.Twitter
        :keyword apple: The configuration settings of the Apple provider.
        :paramtype apple: ~azure.mgmt.appcontainers.models.Apple
        :keyword azure_static_web_apps: The configuration settings of the Azure Static Web Apps
         provider.
        :paramtype azure_static_web_apps: ~azure.mgmt.appcontainers.models.AzureStaticWebApps
        :keyword custom_open_id_connect_providers: The map of the name of the alias of each custom Open
         ID Connect provider to the
         configuration settings of the custom Open ID Connect provider.
        :paramtype custom_open_id_connect_providers: dict[str,
         ~azure.mgmt.appcontainers.models.CustomOpenIdConnectProvider]
        """
        super().__init__(**kwargs)
        self.azure_active_directory = azure_active_directory
        self.facebook = facebook
        self.git_hub = git_hub
        self.google = google
        self.twitter = twitter
        self.apple = apple
        self.azure_static_web_apps = azure_static_web_apps
        self.custom_open_id_connect_providers = custom_open_id_connect_providers


class IdentitySettings(_serialization.Model):
    """Optional settings for a Managed Identity that is assigned to the Container App.

    All required parameters must be populated in order to send to server.

    :ivar identity: The resource ID of a user-assigned managed identity that is assigned to the
     Container App, or 'system' for system-assigned identity. Required.
    :vartype identity: str
    :ivar lifecycle: Use to select the lifecycle stages of a Container App during which the Managed
     Identity should be available. Known values are: "Init", "Main", "None", and "All".
    :vartype lifecycle: str or ~azure.mgmt.appcontainers.models.IdentitySettingsLifeCycle
    """

    _validation = {
        "identity": {"required": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "str"},
        "lifecycle": {"key": "lifecycle", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: str,
        lifecycle: Optional[Union[str, "_models.IdentitySettingsLifeCycle"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The resource ID of a user-assigned managed identity that is assigned to the
         Container App, or 'system' for system-assigned identity. Required.
        :paramtype identity: str
        :keyword lifecycle: Use to select the lifecycle stages of a Container App during which the
         Managed Identity should be available. Known values are: "Init", "Main", "None", and "All".
        :paramtype lifecycle: str or ~azure.mgmt.appcontainers.models.IdentitySettingsLifeCycle
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.lifecycle = lifecycle


class Ingress(_serialization.Model):
    """Container App Ingress configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar fqdn: Hostname.
    :vartype fqdn: str
    :ivar external: Bool indicating if app exposes an external http endpoint.
    :vartype external: bool
    :ivar target_port: Target Port in containers for traffic from ingress.
    :vartype target_port: int
    :ivar exposed_port: Exposed Port in containers for TCP traffic from ingress.
    :vartype exposed_port: int
    :ivar transport: Ingress transport protocol. Known values are: "auto", "http", "http2", and
     "tcp".
    :vartype transport: str or ~azure.mgmt.appcontainers.models.IngressTransportMethod
    :ivar traffic: Traffic weights for app's revisions.
    :vartype traffic: list[~azure.mgmt.appcontainers.models.TrafficWeight]
    :ivar custom_domains: custom domain bindings for Container Apps' hostnames.
    :vartype custom_domains: list[~azure.mgmt.appcontainers.models.CustomDomain]
    :ivar allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false HTTP
     connections are automatically redirected to HTTPS connections.
    :vartype allow_insecure: bool
    :ivar ip_security_restrictions: Rules to restrict incoming IP address.
    :vartype ip_security_restrictions:
     list[~azure.mgmt.appcontainers.models.IpSecurityRestrictionRule]
    :ivar sticky_sessions: Sticky Sessions for Single Revision Mode.
    :vartype sticky_sessions: ~azure.mgmt.appcontainers.models.IngressStickySessions
    :ivar client_certificate_mode: Client certificate mode for mTLS authentication. Ignore
     indicates server drops client certificate on forwarding. Accept indicates server forwards
     client certificate but does not require a client certificate. Require indicates server requires
     a client certificate. Known values are: "ignore", "accept", and "require".
    :vartype client_certificate_mode: str or
     ~azure.mgmt.appcontainers.models.IngressClientCertificateMode
    :ivar cors_policy: CORS policy for container app.
    :vartype cors_policy: ~azure.mgmt.appcontainers.models.CorsPolicy
    :ivar additional_port_mappings: Settings to expose additional ports on container app.
    :vartype additional_port_mappings: list[~azure.mgmt.appcontainers.models.IngressPortMapping]
    :ivar target_port_http_scheme: Whether an http app listens on http or https. Known values are:
     "http" and "https".
    :vartype target_port_http_scheme: str or
     ~azure.mgmt.appcontainers.models.IngressTargetPortHttpScheme
    """

    _validation = {
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "external": {"key": "external", "type": "bool"},
        "target_port": {"key": "targetPort", "type": "int"},
        "exposed_port": {"key": "exposedPort", "type": "int"},
        "transport": {"key": "transport", "type": "str"},
        "traffic": {"key": "traffic", "type": "[TrafficWeight]"},
        "custom_domains": {"key": "customDomains", "type": "[CustomDomain]"},
        "allow_insecure": {"key": "allowInsecure", "type": "bool"},
        "ip_security_restrictions": {"key": "ipSecurityRestrictions", "type": "[IpSecurityRestrictionRule]"},
        "sticky_sessions": {"key": "stickySessions", "type": "IngressStickySessions"},
        "client_certificate_mode": {"key": "clientCertificateMode", "type": "str"},
        "cors_policy": {"key": "corsPolicy", "type": "CorsPolicy"},
        "additional_port_mappings": {"key": "additionalPortMappings", "type": "[IngressPortMapping]"},
        "target_port_http_scheme": {"key": "targetPortHttpScheme", "type": "str"},
    }

    def __init__(
        self,
        *,
        external: bool = False,
        target_port: Optional[int] = None,
        exposed_port: Optional[int] = None,
        transport: Union[str, "_models.IngressTransportMethod"] = "auto",
        traffic: Optional[List["_models.TrafficWeight"]] = None,
        custom_domains: Optional[List["_models.CustomDomain"]] = None,
        allow_insecure: bool = False,
        ip_security_restrictions: Optional[List["_models.IpSecurityRestrictionRule"]] = None,
        sticky_sessions: Optional["_models.IngressStickySessions"] = None,
        client_certificate_mode: Optional[Union[str, "_models.IngressClientCertificateMode"]] = None,
        cors_policy: Optional["_models.CorsPolicy"] = None,
        additional_port_mappings: Optional[List["_models.IngressPortMapping"]] = None,
        target_port_http_scheme: Optional[Union[str, "_models.IngressTargetPortHttpScheme"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword external: Bool indicating if app exposes an external http endpoint.
        :paramtype external: bool
        :keyword target_port: Target Port in containers for traffic from ingress.
        :paramtype target_port: int
        :keyword exposed_port: Exposed Port in containers for TCP traffic from ingress.
        :paramtype exposed_port: int
        :keyword transport: Ingress transport protocol. Known values are: "auto", "http", "http2", and
         "tcp".
        :paramtype transport: str or ~azure.mgmt.appcontainers.models.IngressTransportMethod
        :keyword traffic: Traffic weights for app's revisions.
        :paramtype traffic: list[~azure.mgmt.appcontainers.models.TrafficWeight]
        :keyword custom_domains: custom domain bindings for Container Apps' hostnames.
        :paramtype custom_domains: list[~azure.mgmt.appcontainers.models.CustomDomain]
        :keyword allow_insecure: Bool indicating if HTTP connections to is allowed. If set to false
         HTTP connections are automatically redirected to HTTPS connections.
        :paramtype allow_insecure: bool
        :keyword ip_security_restrictions: Rules to restrict incoming IP address.
        :paramtype ip_security_restrictions:
         list[~azure.mgmt.appcontainers.models.IpSecurityRestrictionRule]
        :keyword sticky_sessions: Sticky Sessions for Single Revision Mode.
        :paramtype sticky_sessions: ~azure.mgmt.appcontainers.models.IngressStickySessions
        :keyword client_certificate_mode: Client certificate mode for mTLS authentication. Ignore
         indicates server drops client certificate on forwarding. Accept indicates server forwards
         client certificate but does not require a client certificate. Require indicates server requires
         a client certificate. Known values are: "ignore", "accept", and "require".
        :paramtype client_certificate_mode: str or
         ~azure.mgmt.appcontainers.models.IngressClientCertificateMode
        :keyword cors_policy: CORS policy for container app.
        :paramtype cors_policy: ~azure.mgmt.appcontainers.models.CorsPolicy
        :keyword additional_port_mappings: Settings to expose additional ports on container app.
        :paramtype additional_port_mappings: list[~azure.mgmt.appcontainers.models.IngressPortMapping]
        :keyword target_port_http_scheme: Whether an http app listens on http or https. Known values
         are: "http" and "https".
        :paramtype target_port_http_scheme: str or
         ~azure.mgmt.appcontainers.models.IngressTargetPortHttpScheme
        """
        super().__init__(**kwargs)
        self.fqdn: Optional[str] = None
        self.external = external
        self.target_port = target_port
        self.exposed_port = exposed_port
        self.transport = transport
        self.traffic = traffic
        self.custom_domains = custom_domains
        self.allow_insecure = allow_insecure
        self.ip_security_restrictions = ip_security_restrictions
        self.sticky_sessions = sticky_sessions
        self.client_certificate_mode = client_certificate_mode
        self.cors_policy = cors_policy
        self.additional_port_mappings = additional_port_mappings
        self.target_port_http_scheme = target_port_http_scheme


class IngressConfiguration(_serialization.Model):
    """Settings for the ingress component, including workload profile, scaling, and connection
    handling.

    :ivar workload_profile_name: Name of the workload profile used by the ingress component.
     Required.
    :vartype workload_profile_name: str
    :ivar scale: Scaling configuration for the ingress component. Required.
    :vartype scale: ~azure.mgmt.appcontainers.models.IngressConfigurationScale
    :ivar termination_grace_period_seconds: Time (in seconds) to allow active connections to
     complete on termination. Must be between 0 and 3600. Defaults to 480 seconds.
    :vartype termination_grace_period_seconds: int
    :ivar header_count_limit: Maximum number of headers per request allowed by the ingress. Must be
     at least 1. Defaults to 100.
    :vartype header_count_limit: int
    :ivar request_idle_timeout: Duration (in minutes) before idle requests are timed out. Must be
     at least 1 minute. Defaults to 4 minutes.
    :vartype request_idle_timeout: int
    """

    _attribute_map = {
        "workload_profile_name": {"key": "workloadProfileName", "type": "str"},
        "scale": {"key": "scale", "type": "IngressConfigurationScale"},
        "termination_grace_period_seconds": {"key": "terminationGracePeriodSeconds", "type": "int"},
        "header_count_limit": {"key": "headerCountLimit", "type": "int"},
        "request_idle_timeout": {"key": "requestIdleTimeout", "type": "int"},
    }

    def __init__(
        self,
        *,
        workload_profile_name: Optional[str] = None,
        scale: Optional["_models.IngressConfigurationScale"] = None,
        termination_grace_period_seconds: Optional[int] = None,
        header_count_limit: Optional[int] = None,
        request_idle_timeout: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workload_profile_name: Name of the workload profile used by the ingress component.
         Required.
        :paramtype workload_profile_name: str
        :keyword scale: Scaling configuration for the ingress component. Required.
        :paramtype scale: ~azure.mgmt.appcontainers.models.IngressConfigurationScale
        :keyword termination_grace_period_seconds: Time (in seconds) to allow active connections to
         complete on termination. Must be between 0 and 3600. Defaults to 480 seconds.
        :paramtype termination_grace_period_seconds: int
        :keyword header_count_limit: Maximum number of headers per request allowed by the ingress. Must
         be at least 1. Defaults to 100.
        :paramtype header_count_limit: int
        :keyword request_idle_timeout: Duration (in minutes) before idle requests are timed out. Must
         be at least 1 minute. Defaults to 4 minutes.
        :paramtype request_idle_timeout: int
        """
        super().__init__(**kwargs)
        self.workload_profile_name = workload_profile_name
        self.scale = scale
        self.termination_grace_period_seconds = termination_grace_period_seconds
        self.header_count_limit = header_count_limit
        self.request_idle_timeout = request_idle_timeout


class IngressConfigurationScale(_serialization.Model):
    """Scaling configuration for the ingress component. Required.

    :ivar min_replicas: Minimum number of ingress replicas. Must be at least 2. Required.
    :vartype min_replicas: int
    :ivar max_replicas: Maximum number of ingress replicas. Must be greater than or equal to
     minReplicas.
    :vartype max_replicas: int
    """

    _attribute_map = {
        "min_replicas": {"key": "minReplicas", "type": "int"},
        "max_replicas": {"key": "maxReplicas", "type": "int"},
    }

    def __init__(
        self, *, min_replicas: Optional[int] = None, max_replicas: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword min_replicas: Minimum number of ingress replicas. Must be at least 2. Required.
        :paramtype min_replicas: int
        :keyword max_replicas: Maximum number of ingress replicas. Must be greater than or equal to
         minReplicas.
        :paramtype max_replicas: int
        """
        super().__init__(**kwargs)
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas


class IngressPortMapping(_serialization.Model):
    """Port mappings of container app ingress.

    All required parameters must be populated in order to send to server.

    :ivar external: Specifies whether the app port is accessible outside of the environment.
     Required.
    :vartype external: bool
    :ivar target_port: Specifies the port user's container listens on. Required.
    :vartype target_port: int
    :ivar exposed_port: Specifies the exposed port for the target port. If not specified, it
     defaults to target port.
    :vartype exposed_port: int
    """

    _validation = {
        "external": {"required": True},
        "target_port": {"required": True},
    }

    _attribute_map = {
        "external": {"key": "external", "type": "bool"},
        "target_port": {"key": "targetPort", "type": "int"},
        "exposed_port": {"key": "exposedPort", "type": "int"},
    }

    def __init__(self, *, external: bool, target_port: int, exposed_port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword external: Specifies whether the app port is accessible outside of the environment.
         Required.
        :paramtype external: bool
        :keyword target_port: Specifies the port user's container listens on. Required.
        :paramtype target_port: int
        :keyword exposed_port: Specifies the exposed port for the target port. If not specified, it
         defaults to target port.
        :paramtype exposed_port: int
        """
        super().__init__(**kwargs)
        self.external = external
        self.target_port = target_port
        self.exposed_port = exposed_port


class IngressStickySessions(_serialization.Model):
    """Sticky Sessions for Single Revision Mode.

    :ivar affinity: Sticky Session Affinity. Known values are: "sticky" and "none".
    :vartype affinity: str or ~azure.mgmt.appcontainers.models.Affinity
    """

    _attribute_map = {
        "affinity": {"key": "affinity", "type": "str"},
    }

    def __init__(self, *, affinity: Optional[Union[str, "_models.Affinity"]] = None, **kwargs: Any) -> None:
        """
        :keyword affinity: Sticky Session Affinity. Known values are: "sticky" and "none".
        :paramtype affinity: str or ~azure.mgmt.appcontainers.models.Affinity
        """
        super().__init__(**kwargs)
        self.affinity = affinity


class InitContainer(BaseContainer):
    """Container App init container definition.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar image_type: The type of the image. Set to CloudBuild to let the system manages the image,
     where user will not be able to update image through image field. Set to ContainerImage for user
     provided image. Known values are: "CloudBuild" and "ContainerImage".
    :vartype image_type: str or ~azure.mgmt.appcontainers.models.ImageType
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~azure.mgmt.appcontainers.models.ContainerResources
    :ivar volume_mounts: Container volume mounts.
    :vartype volume_mounts: list[~azure.mgmt.appcontainers.models.VolumeMount]
    """


class IpSecurityRestrictionRule(_serialization.Model):
    """Rule to restrict incoming IP address.

    All required parameters must be populated in order to send to server.

    :ivar name: Name for the IP restriction rule. Required.
    :vartype name: str
    :ivar description: Describe the IP restriction rule that is being sent to the container-app.
     This is an optional field.
    :vartype description: str
    :ivar ip_address_range: CIDR notation to match incoming IP address. Required.
    :vartype ip_address_range: str
    :ivar action: Allow or Deny rules to determine for incoming IP. Note: Rules can only consist of
     ALL Allow or ALL Deny. Required. Known values are: "Allow" and "Deny".
    :vartype action: str or ~azure.mgmt.appcontainers.models.Action
    """

    _validation = {
        "name": {"required": True},
        "ip_address_range": {"required": True},
        "action": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "ip_address_range": {"key": "ipAddressRange", "type": "str"},
        "action": {"key": "action", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        ip_address_range: str,
        action: Union[str, "_models.Action"],
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name for the IP restriction rule. Required.
        :paramtype name: str
        :keyword description: Describe the IP restriction rule that is being sent to the container-app.
         This is an optional field.
        :paramtype description: str
        :keyword ip_address_range: CIDR notation to match incoming IP address. Required.
        :paramtype ip_address_range: str
        :keyword action: Allow or Deny rules to determine for incoming IP. Note: Rules can only consist
         of ALL Allow or ALL Deny. Required. Known values are: "Allow" and "Deny".
        :paramtype action: str or ~azure.mgmt.appcontainers.models.Action
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description
        self.ip_address_range = ip_address_range
        self.action = action


class JavaComponent(ProxyResource):
    """Java Component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Java Component resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.JavaComponentProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "JavaComponentProperties"},
    }

    def __init__(self, *, properties: Optional["_models.JavaComponentProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Java Component resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.JavaComponentProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class JavaComponentConfigurationProperty(_serialization.Model):
    """Configuration properties for a Java Component.

    :ivar property_name: The name of the property.
    :vartype property_name: str
    :ivar value: The value of the property.
    :vartype value: str
    """

    _attribute_map = {
        "property_name": {"key": "propertyName", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, property_name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword property_name: The name of the property.
        :paramtype property_name: str
        :keyword value: The value of the property.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.property_name = property_name
        self.value = value


class JavaComponentIngress(_serialization.Model):
    """Container App Ingress configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar fqdn: Hostname of the Java Component endpoint.
    :vartype fqdn: str
    """

    _validation = {
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.fqdn: Optional[str] = None


class JavaComponentProperties(_serialization.Model):
    """Java Component common properties.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    NacosComponent, SpringBootAdminComponent, SpringCloudConfigComponent,
    SpringCloudEurekaComponent, SpringCloudGatewayComponent

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar component_type: Type of the Java Component. Required. Known values are:
     "SpringBootAdmin", "SpringCloudEureka", "SpringCloudConfig", "SpringCloudGateway", and "Nacos".
    :vartype component_type: str or ~azure.mgmt.appcontainers.models.JavaComponentType
    :ivar provisioning_state: Provisioning state of the Java Component. Known values are:
     "Succeeded", "Failed", "Canceled", "Deleting", and "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.JavaComponentProvisioningState
    :ivar configurations: List of Java Components configuration properties.
    :vartype configurations:
     list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
    :ivar scale: Java component scaling configurations.
    :vartype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
    :ivar service_binds: List of Java Components that are bound to the Java component.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
    """

    _validation = {
        "component_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "configurations": {"key": "configurations", "type": "[JavaComponentConfigurationProperty]"},
        "scale": {"key": "scale", "type": "JavaComponentPropertiesScale"},
        "service_binds": {"key": "serviceBinds", "type": "[JavaComponentServiceBind]"},
    }

    _subtype_map = {
        "component_type": {
            "Nacos": "NacosComponent",
            "SpringBootAdmin": "SpringBootAdminComponent",
            "SpringCloudConfig": "SpringCloudConfigComponent",
            "SpringCloudEureka": "SpringCloudEurekaComponent",
            "SpringCloudGateway": "SpringCloudGatewayComponent",
        }
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["_models.JavaComponentConfigurationProperty"]] = None,
        scale: Optional["_models.JavaComponentPropertiesScale"] = None,
        service_binds: Optional[List["_models.JavaComponentServiceBind"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configurations: List of Java Components configuration properties.
        :paramtype configurations:
         list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
        :keyword scale: Java component scaling configurations.
        :paramtype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
        :keyword service_binds: List of Java Components that are bound to the Java component.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
        """
        super().__init__(**kwargs)
        self.component_type: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.JavaComponentProvisioningState"]] = None
        self.configurations = configurations
        self.scale = scale
        self.service_binds = service_binds


class JavaComponentPropertiesScale(_serialization.Model):
    """Java component scaling configurations.

    :ivar min_replicas: Optional. Minimum number of Java component replicas. Defaults to 1 if not
     set.
    :vartype min_replicas: int
    :ivar max_replicas: Optional. Maximum number of Java component replicas.
    :vartype max_replicas: int
    """

    _attribute_map = {
        "min_replicas": {"key": "minReplicas", "type": "int"},
        "max_replicas": {"key": "maxReplicas", "type": "int"},
    }

    def __init__(
        self, *, min_replicas: Optional[int] = None, max_replicas: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword min_replicas: Optional. Minimum number of Java component replicas. Defaults to 1 if
         not set.
        :paramtype min_replicas: int
        :keyword max_replicas: Optional. Maximum number of Java component replicas.
        :paramtype max_replicas: int
        """
        super().__init__(**kwargs)
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas


class JavaComponentsCollection(_serialization.Model):
    """Java Components ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.JavaComponent]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JavaComponent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.JavaComponent"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.JavaComponent]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class JavaComponentServiceBind(_serialization.Model):
    """Configuration to bind a Java Component to another Java Component.

    :ivar name: Name of the service bind.
    :vartype name: str
    :ivar service_id: Resource id of the target service.
    :vartype service_id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "service_id": {"key": "serviceId", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, service_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the service bind.
        :paramtype name: str
        :keyword service_id: Resource id of the target service.
        :paramtype service_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.service_id = service_id


class Job(TrackedResource):
    """Container App Job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar extended_location: The complex type of the extended location.
    :vartype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
    :ivar identity: Managed identities needed by a container app job to interact with other Azure
     services to not maintain any secrets or credentials in code.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar provisioning_state: Provisioning state of the Container Apps Job. Known values are:
     "InProgress", "Succeeded", "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.appcontainers.models.JobProvisioningState
    :ivar running_state: Current running state of the job. Known values are: "Ready",
     "Progressing", and "Suspended".
    :vartype running_state: str or ~azure.mgmt.appcontainers.models.JobRunningState
    :ivar environment_id: Resource ID of environment.
    :vartype environment_id: str
    :ivar workload_profile_name: Workload profile name to pin for container apps job execution.
    :vartype workload_profile_name: str
    :ivar configuration: Container Apps Job configuration properties.
    :vartype configuration: ~azure.mgmt.appcontainers.models.JobConfiguration
    :ivar template: Container Apps job definition.
    :vartype template: ~azure.mgmt.appcontainers.models.JobTemplate
    :ivar outbound_ip_addresses: Outbound IP Addresses of a container apps job.
    :vartype outbound_ip_addresses: list[str]
    :ivar event_stream_endpoint: The endpoint of the eventstream of the container apps job.
    :vartype event_stream_endpoint: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "running_state": {"readonly": True},
        "outbound_ip_addresses": {"readonly": True},
        "event_stream_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "running_state": {"key": "properties.runningState", "type": "str"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
        "workload_profile_name": {"key": "properties.workloadProfileName", "type": "str"},
        "configuration": {"key": "properties.configuration", "type": "JobConfiguration"},
        "template": {"key": "properties.template", "type": "JobTemplate"},
        "outbound_ip_addresses": {"key": "properties.outboundIpAddresses", "type": "[str]"},
        "event_stream_endpoint": {"key": "properties.eventStreamEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        environment_id: Optional[str] = None,
        workload_profile_name: Optional[str] = None,
        configuration: Optional["_models.JobConfiguration"] = None,
        template: Optional["_models.JobTemplate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword extended_location: The complex type of the extended location.
        :paramtype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
        :keyword identity: Managed identities needed by a container app job to interact with other
         Azure services to not maintain any secrets or credentials in code.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword environment_id: Resource ID of environment.
        :paramtype environment_id: str
        :keyword workload_profile_name: Workload profile name to pin for container apps job execution.
        :paramtype workload_profile_name: str
        :keyword configuration: Container Apps Job configuration properties.
        :paramtype configuration: ~azure.mgmt.appcontainers.models.JobConfiguration
        :keyword template: Container Apps job definition.
        :paramtype template: ~azure.mgmt.appcontainers.models.JobTemplate
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.extended_location = extended_location
        self.identity = identity
        self.provisioning_state: Optional[Union[str, "_models.JobProvisioningState"]] = None
        self.running_state: Optional[Union[str, "_models.JobRunningState"]] = None
        self.environment_id = environment_id
        self.workload_profile_name = workload_profile_name
        self.configuration = configuration
        self.template = template
        self.outbound_ip_addresses: Optional[List[str]] = None
        self.event_stream_endpoint: Optional[str] = None


class JobConfiguration(_serialization.Model):
    """Non versioned Container Apps Job configuration properties.

    All required parameters must be populated in order to send to server.

    :ivar secrets: Collection of secrets used by a Container Apps Job.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.Secret]
    :ivar trigger_type: Trigger type of the job. Known values are: "Schedule", "Event", and
     "Manual".
    :vartype trigger_type: str or ~azure.mgmt.appcontainers.models.TriggerType
    :ivar replica_timeout: Maximum number of seconds a replica is allowed to run. Required.
    :vartype replica_timeout: int
    :ivar replica_retry_limit: Maximum number of retries before failing the job.
    :vartype replica_retry_limit: int
    :ivar manual_trigger_config: Manual trigger configuration for a single execution job.
     Properties replicaCompletionCount and parallelism would be set to 1 by default.
    :vartype manual_trigger_config:
     ~azure.mgmt.appcontainers.models.JobConfigurationManualTriggerConfig
    :ivar schedule_trigger_config: Cron formatted repeating trigger schedule ("\\ * * * * *") for
     cronjobs. Properties completions and parallelism would be set to 1 by default.
    :vartype schedule_trigger_config:
     ~azure.mgmt.appcontainers.models.JobConfigurationScheduleTriggerConfig
    :ivar event_trigger_config: Trigger configuration of an event driven job.
    :vartype event_trigger_config:
     ~azure.mgmt.appcontainers.models.JobConfigurationEventTriggerConfig
    :ivar registries: Collection of private container registry credentials used by a Container apps
     job.
    :vartype registries: list[~azure.mgmt.appcontainers.models.RegistryCredentials]
    :ivar identity_settings: Optional settings for Managed Identities that are assigned to the
     Container App Job. If a Managed Identity is not specified here, default settings will be used.
    :vartype identity_settings: list[~azure.mgmt.appcontainers.models.IdentitySettings]
    """

    _validation = {
        "trigger_type": {"required": True},
        "replica_timeout": {"required": True},
    }

    _attribute_map = {
        "secrets": {"key": "secrets", "type": "[Secret]"},
        "trigger_type": {"key": "triggerType", "type": "str"},
        "replica_timeout": {"key": "replicaTimeout", "type": "int"},
        "replica_retry_limit": {"key": "replicaRetryLimit", "type": "int"},
        "manual_trigger_config": {"key": "manualTriggerConfig", "type": "JobConfigurationManualTriggerConfig"},
        "schedule_trigger_config": {"key": "scheduleTriggerConfig", "type": "JobConfigurationScheduleTriggerConfig"},
        "event_trigger_config": {"key": "eventTriggerConfig", "type": "JobConfigurationEventTriggerConfig"},
        "registries": {"key": "registries", "type": "[RegistryCredentials]"},
        "identity_settings": {"key": "identitySettings", "type": "[IdentitySettings]"},
    }

    def __init__(
        self,
        *,
        trigger_type: Union[str, "_models.TriggerType"] = "Manual",
        replica_timeout: int,
        secrets: Optional[List["_models.Secret"]] = None,
        replica_retry_limit: Optional[int] = None,
        manual_trigger_config: Optional["_models.JobConfigurationManualTriggerConfig"] = None,
        schedule_trigger_config: Optional["_models.JobConfigurationScheduleTriggerConfig"] = None,
        event_trigger_config: Optional["_models.JobConfigurationEventTriggerConfig"] = None,
        registries: Optional[List["_models.RegistryCredentials"]] = None,
        identity_settings: Optional[List["_models.IdentitySettings"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword secrets: Collection of secrets used by a Container Apps Job.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.Secret]
        :keyword trigger_type: Trigger type of the job. Known values are: "Schedule", "Event", and
         "Manual".
        :paramtype trigger_type: str or ~azure.mgmt.appcontainers.models.TriggerType
        :keyword replica_timeout: Maximum number of seconds a replica is allowed to run. Required.
        :paramtype replica_timeout: int
        :keyword replica_retry_limit: Maximum number of retries before failing the job.
        :paramtype replica_retry_limit: int
        :keyword manual_trigger_config: Manual trigger configuration for a single execution job.
         Properties replicaCompletionCount and parallelism would be set to 1 by default.
        :paramtype manual_trigger_config:
         ~azure.mgmt.appcontainers.models.JobConfigurationManualTriggerConfig
        :keyword schedule_trigger_config: Cron formatted repeating trigger schedule ("\\ * * * * *")
         for cronjobs. Properties completions and parallelism would be set to 1 by default.
        :paramtype schedule_trigger_config:
         ~azure.mgmt.appcontainers.models.JobConfigurationScheduleTriggerConfig
        :keyword event_trigger_config: Trigger configuration of an event driven job.
        :paramtype event_trigger_config:
         ~azure.mgmt.appcontainers.models.JobConfigurationEventTriggerConfig
        :keyword registries: Collection of private container registry credentials used by a Container
         apps job.
        :paramtype registries: list[~azure.mgmt.appcontainers.models.RegistryCredentials]
        :keyword identity_settings: Optional settings for Managed Identities that are assigned to the
         Container App Job. If a Managed Identity is not specified here, default settings will be used.
        :paramtype identity_settings: list[~azure.mgmt.appcontainers.models.IdentitySettings]
        """
        super().__init__(**kwargs)
        self.secrets = secrets
        self.trigger_type = trigger_type
        self.replica_timeout = replica_timeout
        self.replica_retry_limit = replica_retry_limit
        self.manual_trigger_config = manual_trigger_config
        self.schedule_trigger_config = schedule_trigger_config
        self.event_trigger_config = event_trigger_config
        self.registries = registries
        self.identity_settings = identity_settings


class JobConfigurationEventTriggerConfig(_serialization.Model):
    """Trigger configuration of an event driven job.

    :ivar replica_completion_count: Minimum number of successful replica completions before overall
     job completion.
    :vartype replica_completion_count: int
    :ivar parallelism: Number of parallel replicas of a job that can run at a given time.
    :vartype parallelism: int
    :ivar scale: Scaling configurations for event driven jobs.
    :vartype scale: ~azure.mgmt.appcontainers.models.JobScale
    """

    _attribute_map = {
        "replica_completion_count": {"key": "replicaCompletionCount", "type": "int"},
        "parallelism": {"key": "parallelism", "type": "int"},
        "scale": {"key": "scale", "type": "JobScale"},
    }

    def __init__(
        self,
        *,
        replica_completion_count: Optional[int] = None,
        parallelism: Optional[int] = None,
        scale: Optional["_models.JobScale"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword replica_completion_count: Minimum number of successful replica completions before
         overall job completion.
        :paramtype replica_completion_count: int
        :keyword parallelism: Number of parallel replicas of a job that can run at a given time.
        :paramtype parallelism: int
        :keyword scale: Scaling configurations for event driven jobs.
        :paramtype scale: ~azure.mgmt.appcontainers.models.JobScale
        """
        super().__init__(**kwargs)
        self.replica_completion_count = replica_completion_count
        self.parallelism = parallelism
        self.scale = scale


class JobConfigurationManualTriggerConfig(_serialization.Model):
    """Manual trigger configuration for a single execution job. Properties replicaCompletionCount and
    parallelism would be set to 1 by default.

    :ivar replica_completion_count: Minimum number of successful replica completions before overall
     job completion.
    :vartype replica_completion_count: int
    :ivar parallelism: Number of parallel replicas of a job that can run at a given time.
    :vartype parallelism: int
    """

    _attribute_map = {
        "replica_completion_count": {"key": "replicaCompletionCount", "type": "int"},
        "parallelism": {"key": "parallelism", "type": "int"},
    }

    def __init__(
        self, *, replica_completion_count: Optional[int] = None, parallelism: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword replica_completion_count: Minimum number of successful replica completions before
         overall job completion.
        :paramtype replica_completion_count: int
        :keyword parallelism: Number of parallel replicas of a job that can run at a given time.
        :paramtype parallelism: int
        """
        super().__init__(**kwargs)
        self.replica_completion_count = replica_completion_count
        self.parallelism = parallelism


class JobConfigurationScheduleTriggerConfig(_serialization.Model):
    """Cron formatted repeating trigger schedule ("\\ * * * * *") for cronjobs. Properties completions
    and parallelism would be set to 1 by default.

    All required parameters must be populated in order to send to server.

    :ivar replica_completion_count: Minimum number of successful replica completions before overall
     job completion.
    :vartype replica_completion_count: int
    :ivar cron_expression: Cron formatted repeating schedule ("\\ * * * * *") of a Cron Job.
     Required.
    :vartype cron_expression: str
    :ivar parallelism: Number of parallel replicas of a job that can run at a given time.
    :vartype parallelism: int
    """

    _validation = {
        "cron_expression": {"required": True},
    }

    _attribute_map = {
        "replica_completion_count": {"key": "replicaCompletionCount", "type": "int"},
        "cron_expression": {"key": "cronExpression", "type": "str"},
        "parallelism": {"key": "parallelism", "type": "int"},
    }

    def __init__(
        self,
        *,
        cron_expression: str,
        replica_completion_count: Optional[int] = None,
        parallelism: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword replica_completion_count: Minimum number of successful replica completions before
         overall job completion.
        :paramtype replica_completion_count: int
        :keyword cron_expression: Cron formatted repeating schedule ("\\ * * * * *") of a Cron Job.
         Required.
        :paramtype cron_expression: str
        :keyword parallelism: Number of parallel replicas of a job that can run at a given time.
        :paramtype parallelism: int
        """
        super().__init__(**kwargs)
        self.replica_completion_count = replica_completion_count
        self.cron_expression = cron_expression
        self.parallelism = parallelism


class JobExecution(_serialization.Model):
    """Container Apps Job execution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Job execution Name.
    :vartype name: str
    :ivar id: Job execution Id.
    :vartype id: str
    :ivar type: Job execution type.
    :vartype type: str
    :ivar status: Current running State of the job. Known values are: "Running", "Processing",
     "Stopped", "Degraded", "Failed", "Unknown", and "Succeeded".
    :vartype status: str or ~azure.mgmt.appcontainers.models.JobExecutionRunningState
    :ivar start_time: Job execution start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job execution end time.
    :vartype end_time: ~datetime.datetime
    :ivar template: Job's execution container.
    :vartype template: ~azure.mgmt.appcontainers.models.JobExecutionTemplate
    :ivar detailed_status: Detailed status of the job execution.
    :vartype detailed_status: ~azure.mgmt.appcontainers.models.ExecutionStatus
    """

    _validation = {
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "template": {"key": "properties.template", "type": "JobExecutionTemplate"},
        "detailed_status": {"key": "properties.detailedStatus", "type": "ExecutionStatus"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        template: Optional["_models.JobExecutionTemplate"] = None,
        detailed_status: Optional["_models.ExecutionStatus"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Job execution Name.
        :paramtype name: str
        :keyword id: Job execution Id.
        :paramtype id: str
        :keyword type: Job execution type.
        :paramtype type: str
        :keyword start_time: Job execution start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Job execution end time.
        :paramtype end_time: ~datetime.datetime
        :keyword template: Job's execution container.
        :paramtype template: ~azure.mgmt.appcontainers.models.JobExecutionTemplate
        :keyword detailed_status: Detailed status of the job execution.
        :paramtype detailed_status: ~azure.mgmt.appcontainers.models.ExecutionStatus
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.status: Optional[Union[str, "_models.JobExecutionRunningState"]] = None
        self.start_time = start_time
        self.end_time = end_time
        self.template = template
        self.detailed_status = detailed_status


class JobExecutionBase(_serialization.Model):
    """Container App's Job execution name.

    :ivar name: Job execution name.
    :vartype name: str
    :ivar id: Job execution Id.
    :vartype id: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Job execution name.
        :paramtype name: str
        :keyword id: Job execution Id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id


class JobExecutionContainer(_serialization.Model):
    """Container Apps Jobs execution container definition.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~azure.mgmt.appcontainers.models.ContainerResources
    """

    _attribute_map = {
        "image": {"key": "image", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
        "args": {"key": "args", "type": "[str]"},
        "env": {"key": "env", "type": "[EnvironmentVar]"},
        "resources": {"key": "resources", "type": "ContainerResources"},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        name: Optional[str] = None,
        command: Optional[List[str]] = None,
        args: Optional[List[str]] = None,
        env: Optional[List["_models.EnvironmentVar"]] = None,
        resources: Optional["_models.ContainerResources"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image: Container image tag.
        :paramtype image: str
        :keyword name: Custom container name.
        :paramtype name: str
        :keyword command: Container start command.
        :paramtype command: list[str]
        :keyword args: Container start command arguments.
        :paramtype args: list[str]
        :keyword env: Container environment variables.
        :paramtype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
        :keyword resources: Container resource requirements.
        :paramtype resources: ~azure.mgmt.appcontainers.models.ContainerResources
        """
        super().__init__(**kwargs)
        self.image = image
        self.name = name
        self.command = command
        self.args = args
        self.env = env
        self.resources = resources


class JobExecutionNamesCollection(_serialization.Model):
    """Container App executions names list.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.JobExecutionBase]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobExecutionBase]"},
    }

    def __init__(self, *, value: List["_models.JobExecutionBase"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.JobExecutionBase]
        """
        super().__init__(**kwargs)
        self.value = value


class JobExecutionTemplate(_serialization.Model):
    """Job's execution template, containing container configuration for a job's execution.

    :ivar containers: List of container definitions for the Container Apps Job.
    :vartype containers: list[~azure.mgmt.appcontainers.models.JobExecutionContainer]
    :ivar init_containers: List of specialized containers that run before job containers.
    :vartype init_containers: list[~azure.mgmt.appcontainers.models.JobExecutionContainer]
    """

    _attribute_map = {
        "containers": {"key": "containers", "type": "[JobExecutionContainer]"},
        "init_containers": {"key": "initContainers", "type": "[JobExecutionContainer]"},
    }

    def __init__(
        self,
        *,
        containers: Optional[List["_models.JobExecutionContainer"]] = None,
        init_containers: Optional[List["_models.JobExecutionContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword containers: List of container definitions for the Container Apps Job.
        :paramtype containers: list[~azure.mgmt.appcontainers.models.JobExecutionContainer]
        :keyword init_containers: List of specialized containers that run before job containers.
        :paramtype init_containers: list[~azure.mgmt.appcontainers.models.JobExecutionContainer]
        """
        super().__init__(**kwargs)
        self.containers = containers
        self.init_containers = init_containers


class JobPatchProperties(_serialization.Model):
    """Container Apps Job resource specific properties.

    :ivar extended_location: The complex type of the extended location.
    :vartype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
    :ivar identity: Managed identities needed by a container app job to interact with other Azure
     services to not maintain any secrets or credentials in code.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties:
    :vartype properties: ~azure.mgmt.appcontainers.models.JobPatchPropertiesProperties
    """

    _attribute_map = {
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "JobPatchPropertiesProperties"},
    }

    def __init__(
        self,
        *,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.JobPatchPropertiesProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword extended_location: The complex type of the extended location.
        :paramtype extended_location: ~azure.mgmt.appcontainers.models.ExtendedLocation
        :keyword identity: Managed identities needed by a container app job to interact with other
         Azure services to not maintain any secrets or credentials in code.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties:
        :paramtype properties: ~azure.mgmt.appcontainers.models.JobPatchPropertiesProperties
        """
        super().__init__(**kwargs)
        self.extended_location = extended_location
        self.identity = identity
        self.tags = tags
        self.properties = properties


class JobPatchPropertiesProperties(_serialization.Model):
    """JobPatchPropertiesProperties.

    :ivar environment_id: Resource ID of environment.
    :vartype environment_id: str
    :ivar configuration: Container Apps Job configuration properties.
    :vartype configuration: ~azure.mgmt.appcontainers.models.JobConfiguration
    :ivar template: Container Apps job definition.
    :vartype template: ~azure.mgmt.appcontainers.models.JobTemplate
    :ivar outbound_ip_addresses: Outbound IP Addresses of a container apps job.
    :vartype outbound_ip_addresses: list[str]
    :ivar event_stream_endpoint: The endpoint of the eventstream of the container apps job.
    :vartype event_stream_endpoint: str
    """

    _attribute_map = {
        "environment_id": {"key": "environmentId", "type": "str"},
        "configuration": {"key": "configuration", "type": "JobConfiguration"},
        "template": {"key": "template", "type": "JobTemplate"},
        "outbound_ip_addresses": {"key": "outboundIpAddresses", "type": "[str]"},
        "event_stream_endpoint": {"key": "eventStreamEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        environment_id: Optional[str] = None,
        configuration: Optional["_models.JobConfiguration"] = None,
        template: Optional["_models.JobTemplate"] = None,
        outbound_ip_addresses: Optional[List[str]] = None,
        event_stream_endpoint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword environment_id: Resource ID of environment.
        :paramtype environment_id: str
        :keyword configuration: Container Apps Job configuration properties.
        :paramtype configuration: ~azure.mgmt.appcontainers.models.JobConfiguration
        :keyword template: Container Apps job definition.
        :paramtype template: ~azure.mgmt.appcontainers.models.JobTemplate
        :keyword outbound_ip_addresses: Outbound IP Addresses of a container apps job.
        :paramtype outbound_ip_addresses: list[str]
        :keyword event_stream_endpoint: The endpoint of the eventstream of the container apps job.
        :paramtype event_stream_endpoint: str
        """
        super().__init__(**kwargs)
        self.environment_id = environment_id
        self.configuration = configuration
        self.template = template
        self.outbound_ip_addresses = outbound_ip_addresses
        self.event_stream_endpoint = event_stream_endpoint


class JobScale(_serialization.Model):
    """Scaling configurations for event driven jobs.

    :ivar polling_interval: Interval to check each event source in seconds. Defaults to 30s.
    :vartype polling_interval: int
    :ivar min_executions: Minimum number of job executions that are created for a trigger, default
     0.
    :vartype min_executions: int
    :ivar max_executions: Maximum number of job executions that are created for a trigger, default
     100.
    :vartype max_executions: int
    :ivar rules: Scaling rules.
    :vartype rules: list[~azure.mgmt.appcontainers.models.JobScaleRule]
    """

    _attribute_map = {
        "polling_interval": {"key": "pollingInterval", "type": "int"},
        "min_executions": {"key": "minExecutions", "type": "int"},
        "max_executions": {"key": "maxExecutions", "type": "int"},
        "rules": {"key": "rules", "type": "[JobScaleRule]"},
    }

    def __init__(
        self,
        *,
        polling_interval: Optional[int] = None,
        min_executions: int = 0,
        max_executions: int = 100,
        rules: Optional[List["_models.JobScaleRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword polling_interval: Interval to check each event source in seconds. Defaults to 30s.
        :paramtype polling_interval: int
        :keyword min_executions: Minimum number of job executions that are created for a trigger,
         default 0.
        :paramtype min_executions: int
        :keyword max_executions: Maximum number of job executions that are created for a trigger,
         default 100.
        :paramtype max_executions: int
        :keyword rules: Scaling rules.
        :paramtype rules: list[~azure.mgmt.appcontainers.models.JobScaleRule]
        """
        super().__init__(**kwargs)
        self.polling_interval = polling_interval
        self.min_executions = min_executions
        self.max_executions = max_executions
        self.rules = rules


class JobScaleRule(_serialization.Model):
    """Scaling rule.

    :ivar name: Scale Rule Name.
    :vartype name: str
    :ivar type: Type of the scale rule
     eg: azure-servicebus, redis etc.
    :vartype type: str
    :ivar metadata: Metadata properties to describe the scale rule.
    :vartype metadata: JSON
    :ivar auth: Authentication secrets for the scale rule.
    :vartype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
    :ivar identity: The resource ID of a user-assigned managed identity that is assigned to the
     job, or 'system' for system-assigned identity.
    :vartype identity: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metadata": {"key": "metadata", "type": "object"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        metadata: Optional[JSON] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Scale Rule Name.
        :paramtype name: str
        :keyword type: Type of the scale rule
         eg: azure-servicebus, redis etc.
        :paramtype type: str
        :keyword metadata: Metadata properties to describe the scale rule.
        :paramtype metadata: JSON
        :keyword auth: Authentication secrets for the scale rule.
        :paramtype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
        :keyword identity: The resource ID of a user-assigned managed identity that is assigned to the
         job, or 'system' for system-assigned identity.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type
        self.metadata = metadata
        self.auth = auth
        self.identity = identity


class JobsCollection(_serialization.Model):
    """Container Apps Jobs collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.Job]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Job]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Job"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.Job]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class JobSecretsCollection(_serialization.Model):
    """Container Apps Job Secrets Collection ARM resource.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.Secret]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Secret]"},
    }

    def __init__(self, *, value: List["_models.Secret"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.Secret]
        """
        super().__init__(**kwargs)
        self.value = value


class JobTemplate(_serialization.Model):
    """Container Apps Job versioned application definition. Defines the desired state of an immutable
    revision. Any changes to this section Will result in a new revision being created.

    :ivar init_containers: List of specialized containers that run before app containers.
    :vartype init_containers: list[~azure.mgmt.appcontainers.models.InitContainer]
    :ivar containers: List of container definitions for the Container App.
    :vartype containers: list[~azure.mgmt.appcontainers.models.Container]
    :ivar volumes: List of volume definitions for the Container App.
    :vartype volumes: list[~azure.mgmt.appcontainers.models.Volume]
    """

    _attribute_map = {
        "init_containers": {"key": "initContainers", "type": "[InitContainer]"},
        "containers": {"key": "containers", "type": "[Container]"},
        "volumes": {"key": "volumes", "type": "[Volume]"},
    }

    def __init__(
        self,
        *,
        init_containers: Optional[List["_models.InitContainer"]] = None,
        containers: Optional[List["_models.Container"]] = None,
        volumes: Optional[List["_models.Volume"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword init_containers: List of specialized containers that run before app containers.
        :paramtype init_containers: list[~azure.mgmt.appcontainers.models.InitContainer]
        :keyword containers: List of container definitions for the Container App.
        :paramtype containers: list[~azure.mgmt.appcontainers.models.Container]
        :keyword volumes: List of volume definitions for the Container App.
        :paramtype volumes: list[~azure.mgmt.appcontainers.models.Volume]
        """
        super().__init__(**kwargs)
        self.init_containers = init_containers
        self.containers = containers
        self.volumes = volumes


class JwtClaimChecks(_serialization.Model):
    """The configuration settings of the checks that should be made while validating the JWT Claims.

    :ivar allowed_groups: The list of the allowed groups.
    :vartype allowed_groups: list[str]
    :ivar allowed_client_applications: The list of the allowed client applications.
    :vartype allowed_client_applications: list[str]
    """

    _attribute_map = {
        "allowed_groups": {"key": "allowedGroups", "type": "[str]"},
        "allowed_client_applications": {"key": "allowedClientApplications", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        allowed_groups: Optional[List[str]] = None,
        allowed_client_applications: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allowed_groups: The list of the allowed groups.
        :paramtype allowed_groups: list[str]
        :keyword allowed_client_applications: The list of the allowed client applications.
        :paramtype allowed_client_applications: list[str]
        """
        super().__init__(**kwargs)
        self.allowed_groups = allowed_groups
        self.allowed_client_applications = allowed_client_applications


class KedaConfiguration(_serialization.Model):
    """Configuration properties Keda component.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The version of Keda.
    :vartype version: str
    """

    _validation = {
        "version": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version: Optional[str] = None


class LabelHistory(ProxyResource):
    """Container App Label History.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Container App Label History resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.LabelHistoryProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "LabelHistoryProperties"},
    }

    def __init__(self, *, properties: Optional["_models.LabelHistoryProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Container App Label History resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.LabelHistoryProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class LabelHistoryCollection(_serialization.Model):
    """Container App Label History collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.LabelHistory]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LabelHistory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.LabelHistory"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.LabelHistory]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class LabelHistoryProperties(_serialization.Model):
    """Container App Label History resource specific properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar records: List of label history records.
    :vartype records: list[~azure.mgmt.appcontainers.models.LabelHistoryRecordItem]
    """

    _validation = {
        "records": {"readonly": True},
    }

    _attribute_map = {
        "records": {"key": "records", "type": "[LabelHistoryRecordItem]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.records: Optional[List["_models.LabelHistoryRecordItem"]] = None


class LabelHistoryRecordItem(_serialization.Model):
    """Container App Label History Item resource specific properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar revision: Container App revision name that label was applied to.
    :vartype revision: str
    :ivar start: Timestamp describing when the label was applied to the revision.
    :vartype start: ~datetime.datetime
    :ivar stop: Timestamp describing when the label was removed from the revision. Only meaningful
     when the label is currently applied to the revision.
    :vartype stop: ~datetime.datetime
    :ivar status: Status of the label history record. Known values are: "Succeeded", "Failed", and
     "Starting".
    :vartype status: str or ~azure.mgmt.appcontainers.models.Status
    """

    _validation = {
        "revision": {"readonly": True},
        "start": {"readonly": True},
        "stop": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "revision": {"key": "revision", "type": "str"},
        "start": {"key": "start", "type": "iso-8601"},
        "stop": {"key": "stop", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.revision: Optional[str] = None
        self.start: Optional[datetime.datetime] = None
        self.stop: Optional[datetime.datetime] = None
        self.status: Optional[Union[str, "_models.Status"]] = None


class LifecycleConfiguration(_serialization.Model):
    """The lifecycle configuration properties of a session in the dynamic session pool.

    :ivar lifecycle_type: The lifecycle type of the session pool. Known values are: "Timed" and
     "OnContainerExit".
    :vartype lifecycle_type: str or ~azure.mgmt.appcontainers.models.LifecycleType
    :ivar cooldown_period_in_seconds: The cooldown period of a session in seconds when the
     lifecycle type is 'Timed'.
    :vartype cooldown_period_in_seconds: int
    :ivar max_alive_period_in_seconds: The maximum alive period of a session in seconds when the
     lifecycle type is 'OnContainerExit'.
    :vartype max_alive_period_in_seconds: int
    """

    _attribute_map = {
        "lifecycle_type": {"key": "lifecycleType", "type": "str"},
        "cooldown_period_in_seconds": {"key": "cooldownPeriodInSeconds", "type": "int"},
        "max_alive_period_in_seconds": {"key": "maxAlivePeriodInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        lifecycle_type: Optional[Union[str, "_models.LifecycleType"]] = None,
        cooldown_period_in_seconds: Optional[int] = None,
        max_alive_period_in_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword lifecycle_type: The lifecycle type of the session pool. Known values are: "Timed" and
         "OnContainerExit".
        :paramtype lifecycle_type: str or ~azure.mgmt.appcontainers.models.LifecycleType
        :keyword cooldown_period_in_seconds: The cooldown period of a session in seconds when the
         lifecycle type is 'Timed'.
        :paramtype cooldown_period_in_seconds: int
        :keyword max_alive_period_in_seconds: The maximum alive period of a session in seconds when the
         lifecycle type is 'OnContainerExit'.
        :paramtype max_alive_period_in_seconds: int
        """
        super().__init__(**kwargs)
        self.lifecycle_type = lifecycle_type
        self.cooldown_period_in_seconds = cooldown_period_in_seconds
        self.max_alive_period_in_seconds = max_alive_period_in_seconds


class ListUsagesResult(_serialization.Model):
    """ListUsagesResult.

    :ivar value: The list of compute resource usages.
    :vartype value: list[~azure.mgmt.appcontainers.models.Usage]
    :ivar next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Usage"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of compute resource usages.
        :paramtype value: list[~azure.mgmt.appcontainers.models.Usage]
        :keyword next_link: The URI to fetch the next page of compute resource usage information. Call
         ListNext() with this to fetch the next page of compute resource usage information.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogAnalyticsConfiguration(_serialization.Model):
    """Log Analytics configuration, must only be provided when destination is configured as
    'log-analytics'.

    :ivar customer_id: Log analytics customer id.
    :vartype customer_id: str
    :ivar shared_key: Log analytics customer key.
    :vartype shared_key: str
    :ivar dynamic_json_columns: Boolean indicating whether to parse json string log into dynamic
     json columns.
    :vartype dynamic_json_columns: bool
    """

    _attribute_map = {
        "customer_id": {"key": "customerId", "type": "str"},
        "shared_key": {"key": "sharedKey", "type": "str"},
        "dynamic_json_columns": {"key": "dynamicJsonColumns", "type": "bool"},
    }

    def __init__(
        self,
        *,
        customer_id: Optional[str] = None,
        shared_key: Optional[str] = None,
        dynamic_json_columns: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword customer_id: Log analytics customer id.
        :paramtype customer_id: str
        :keyword shared_key: Log analytics customer key.
        :paramtype shared_key: str
        :keyword dynamic_json_columns: Boolean indicating whether to parse json string log into dynamic
         json columns.
        :paramtype dynamic_json_columns: bool
        """
        super().__init__(**kwargs)
        self.customer_id = customer_id
        self.shared_key = shared_key
        self.dynamic_json_columns = dynamic_json_columns


class LoggerSetting(_serialization.Model):
    """Logger settings for java workloads.

    All required parameters must be populated in order to send to server.

    :ivar logger: Logger name. Required.
    :vartype logger: str
    :ivar level: The specified logger's log level. Required. Known values are: "off", "error",
     "info", "debug", "trace", and "warn".
    :vartype level: str or ~azure.mgmt.appcontainers.models.Level
    """

    _validation = {
        "logger": {"required": True},
        "level": {"required": True},
    }

    _attribute_map = {
        "logger": {"key": "logger", "type": "str"},
        "level": {"key": "level", "type": "str"},
    }

    def __init__(self, *, logger: str, level: Union[str, "_models.Level"], **kwargs: Any) -> None:
        """
        :keyword logger: Logger name. Required.
        :paramtype logger: str
        :keyword level: The specified logger's log level. Required. Known values are: "off", "error",
         "info", "debug", "trace", and "warn".
        :paramtype level: str or ~azure.mgmt.appcontainers.models.Level
        """
        super().__init__(**kwargs)
        self.logger = logger
        self.level = level


class LogicApp(ProxyResource):
    """A logic app extension resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "object"},
    }

    def __init__(self, *, properties: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword properties: The resource-specific properties for this resource.
        :paramtype properties: JSON
        """
        super().__init__(**kwargs)
        self.properties = properties


class Login(_serialization.Model):
    """The configuration settings of the login flow of users using ContainerApp Service
    Authentication/Authorization.

    :ivar routes: The routes that specify the endpoints used for login and logout requests.
    :vartype routes: ~azure.mgmt.appcontainers.models.LoginRoutes
    :ivar token_store: The configuration settings of the token store.
    :vartype token_store: ~azure.mgmt.appcontainers.models.TokenStore
    :ivar preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
     request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
    :vartype preserve_url_fragments_for_logins: bool
    :ivar allowed_external_redirect_urls: External URLs that can be redirected to as part of
     logging in or logging out of the app. Note that the query string part of the URL is ignored.
     This is an advanced setting typically only needed by Windows Store application backends.
     Note that URLs within the current domain are always implicitly allowed.
    :vartype allowed_external_redirect_urls: list[str]
    :ivar cookie_expiration: The configuration settings of the session cookie's expiration.
    :vartype cookie_expiration: ~azure.mgmt.appcontainers.models.CookieExpiration
    :ivar nonce: The configuration settings of the nonce used in the login flow.
    :vartype nonce: ~azure.mgmt.appcontainers.models.Nonce
    """

    _attribute_map = {
        "routes": {"key": "routes", "type": "LoginRoutes"},
        "token_store": {"key": "tokenStore", "type": "TokenStore"},
        "preserve_url_fragments_for_logins": {"key": "preserveUrlFragmentsForLogins", "type": "bool"},
        "allowed_external_redirect_urls": {"key": "allowedExternalRedirectUrls", "type": "[str]"},
        "cookie_expiration": {"key": "cookieExpiration", "type": "CookieExpiration"},
        "nonce": {"key": "nonce", "type": "Nonce"},
    }

    def __init__(
        self,
        *,
        routes: Optional["_models.LoginRoutes"] = None,
        token_store: Optional["_models.TokenStore"] = None,
        preserve_url_fragments_for_logins: Optional[bool] = None,
        allowed_external_redirect_urls: Optional[List[str]] = None,
        cookie_expiration: Optional["_models.CookieExpiration"] = None,
        nonce: Optional["_models.Nonce"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword routes: The routes that specify the endpoints used for login and logout requests.
        :paramtype routes: ~azure.mgmt.appcontainers.models.LoginRoutes
        :keyword token_store: The configuration settings of the token store.
        :paramtype token_store: ~azure.mgmt.appcontainers.models.TokenStore
        :keyword preserve_url_fragments_for_logins: :code:`<code>true</code>` if the fragments from the
         request are preserved after the login request is made; otherwise, :code:`<code>false</code>`.
        :paramtype preserve_url_fragments_for_logins: bool
        :keyword allowed_external_redirect_urls: External URLs that can be redirected to as part of
         logging in or logging out of the app. Note that the query string part of the URL is ignored.
         This is an advanced setting typically only needed by Windows Store application backends.
         Note that URLs within the current domain are always implicitly allowed.
        :paramtype allowed_external_redirect_urls: list[str]
        :keyword cookie_expiration: The configuration settings of the session cookie's expiration.
        :paramtype cookie_expiration: ~azure.mgmt.appcontainers.models.CookieExpiration
        :keyword nonce: The configuration settings of the nonce used in the login flow.
        :paramtype nonce: ~azure.mgmt.appcontainers.models.Nonce
        """
        super().__init__(**kwargs)
        self.routes = routes
        self.token_store = token_store
        self.preserve_url_fragments_for_logins = preserve_url_fragments_for_logins
        self.allowed_external_redirect_urls = allowed_external_redirect_urls
        self.cookie_expiration = cookie_expiration
        self.nonce = nonce


class LoginRoutes(_serialization.Model):
    """The routes that specify the endpoints used for login and logout requests.

    :ivar logout_endpoint: The endpoint at which a logout request should be made.
    :vartype logout_endpoint: str
    """

    _attribute_map = {
        "logout_endpoint": {"key": "logoutEndpoint", "type": "str"},
    }

    def __init__(self, *, logout_endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword logout_endpoint: The endpoint at which a logout request should be made.
        :paramtype logout_endpoint: str
        """
        super().__init__(**kwargs)
        self.logout_endpoint = logout_endpoint


class LoginScopes(_serialization.Model):
    """The configuration settings of the login flow, including the scopes that should be requested.

    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        "scopes": {"key": "scopes", "type": "[str]"},
    }

    def __init__(self, *, scopes: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super().__init__(**kwargs)
        self.scopes = scopes


class LogsConfiguration(_serialization.Model):
    """Configuration of Open Telemetry logs.

    :ivar destinations: Open telemetry logs destinations.
    :vartype destinations: list[str]
    """

    _attribute_map = {
        "destinations": {"key": "destinations", "type": "[str]"},
    }

    def __init__(self, *, destinations: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword destinations: Open telemetry logs destinations.
        :paramtype destinations: list[str]
        """
        super().__init__(**kwargs)
        self.destinations = destinations


class MaintenanceConfigurationCollection(_serialization.Model):
    """The response of list maintenance configuration resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Results of the list maintenance configuration resources.
    :vartype value: list[~azure.mgmt.appcontainers.models.MaintenanceConfigurationResource]
    :ivar next_link: Link for next page of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MaintenanceConfigurationResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.MaintenanceConfigurationResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Results of the list maintenance configuration resources.
        :paramtype value: list[~azure.mgmt.appcontainers.models.MaintenanceConfigurationResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class MaintenanceConfigurationResource(ProxyResource):
    """Information about the Maintenance Configuration resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar scheduled_entries: List of maintenance schedules for a managed environment.
    :vartype scheduled_entries: list[~azure.mgmt.appcontainers.models.ScheduledEntry]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "scheduled_entries": {"key": "properties.scheduledEntries", "type": "[ScheduledEntry]"},
    }

    def __init__(self, *, scheduled_entries: Optional[List["_models.ScheduledEntry"]] = None, **kwargs: Any) -> None:
        """
        :keyword scheduled_entries: List of maintenance schedules for a managed environment.
        :paramtype scheduled_entries: list[~azure.mgmt.appcontainers.models.ScheduledEntry]
        """
        super().__init__(**kwargs)
        self.scheduled_entries = scheduled_entries


class ManagedCertificate(TrackedResource):
    """Managed certificates used for Custom Domain bindings of Container Apps in a Managed
    Environment.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: Certificate resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.ManagedCertificateProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "ManagedCertificateProperties"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ManagedCertificateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword properties: Certificate resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.ManagedCertificateProperties
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.properties = properties


class ManagedCertificateCollection(_serialization.Model):
    """Collection of Managed Certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ManagedCertificate]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ManagedCertificate"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ManagedCertificate]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ManagedCertificatePatch(_serialization.Model):
    """A managed certificate to update.

    :ivar tags: Application-specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Application-specific metadata in the form of key-value pairs.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ManagedCertificateProperties(_serialization.Model):
    """Certificate resource specific properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the certificate. Known values are: "Succeeded",
     "Failed", "Canceled", "DeleteFailed", "Pending", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.CertificateProvisioningState
    :ivar subject_name: Subject name of the certificate.
    :vartype subject_name: str
    :ivar error: Any error occurred during the certificate provision.
    :vartype error: str
    :ivar domain_control_validation: Selected type of domain control validation for managed
     certificates. Known values are: "CNAME", "HTTP", and "TXT".
    :vartype domain_control_validation: str or
     ~azure.mgmt.appcontainers.models.ManagedCertificateDomainControlValidation
    :ivar validation_token: A TXT token used for DNS TXT domain control validation when issuing
     this type of managed certificates.
    :vartype validation_token: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "error": {"readonly": True},
        "validation_token": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "subject_name": {"key": "subjectName", "type": "str"},
        "error": {"key": "error", "type": "str"},
        "domain_control_validation": {"key": "domainControlValidation", "type": "str"},
        "validation_token": {"key": "validationToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        subject_name: Optional[str] = None,
        domain_control_validation: Optional[Union[str, "_models.ManagedCertificateDomainControlValidation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword subject_name: Subject name of the certificate.
        :paramtype subject_name: str
        :keyword domain_control_validation: Selected type of domain control validation for managed
         certificates. Known values are: "CNAME", "HTTP", and "TXT".
        :paramtype domain_control_validation: str or
         ~azure.mgmt.appcontainers.models.ManagedCertificateDomainControlValidation
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[Union[str, "_models.CertificateProvisioningState"]] = None
        self.subject_name = subject_name
        self.error: Optional[str] = None
        self.domain_control_validation = domain_control_validation
        self.validation_token: Optional[str] = None


class ManagedEnvironment(TrackedResource):
    """An environment for hosting container apps.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar kind: Kind of the Environment.
    :vartype kind: str
    :ivar identity: Managed identities for the Managed Environment to interact with other Azure
     services without maintaining any secrets or credentials in code.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar provisioning_state: Provisioning state of the Environment. Known values are: "Succeeded",
     "Failed", "Canceled", "Waiting", "InitializationInProgress", "InfrastructureSetupInProgress",
     "InfrastructureSetupComplete", "ScheduledForDelete", "UpgradeRequested", and "UpgradeFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.EnvironmentProvisioningState
    :ivar dapr_ai_instrumentation_key: Azure Monitor instrumentation key used by Dapr to export
     Service to Service communication telemetry.
    :vartype dapr_ai_instrumentation_key: str
    :ivar dapr_ai_connection_string: Application Insights connection string used by Dapr to export
     Service to Service communication telemetry.
    :vartype dapr_ai_connection_string: str
    :ivar vnet_configuration: Vnet configuration for the environment.
    :vartype vnet_configuration: ~azure.mgmt.appcontainers.models.VnetConfiguration
    :ivar deployment_errors: Any errors that occurred during deployment or deployment validation.
    :vartype deployment_errors: str
    :ivar default_domain: Default Domain Name for the cluster.
    :vartype default_domain: str
    :ivar private_link_default_domain: Private Link Default Domain Name for the environment.
    :vartype private_link_default_domain: str
    :ivar static_ip: Static IP of the Environment.
    :vartype static_ip: str
    :ivar app_logs_configuration: Cluster configuration which enables the log daemon to export app
     logs to configured destination.
    :vartype app_logs_configuration: ~azure.mgmt.appcontainers.models.AppLogsConfiguration
    :ivar app_insights_configuration: Environment level Application Insights configuration.
    :vartype app_insights_configuration: ~azure.mgmt.appcontainers.models.AppInsightsConfiguration
    :ivar open_telemetry_configuration: Environment Open Telemetry configuration.
    :vartype open_telemetry_configuration:
     ~azure.mgmt.appcontainers.models.OpenTelemetryConfiguration
    :ivar zone_redundant: Whether or not this Managed Environment is zone-redundant.
    :vartype zone_redundant: bool
    :ivar availability_zones: The list of availability zones to use for managed environment.
    :vartype availability_zones: list[str]
    :ivar custom_domain_configuration: Custom domain configuration for the environment.
    :vartype custom_domain_configuration:
     ~azure.mgmt.appcontainers.models.CustomDomainConfiguration
    :ivar event_stream_endpoint: The endpoint of the eventstream of the Environment.
    :vartype event_stream_endpoint: str
    :ivar workload_profiles: Workload profiles configured for the Managed Environment.
    :vartype workload_profiles: list[~azure.mgmt.appcontainers.models.WorkloadProfile]
    :ivar keda_configuration: The configuration of Keda component.
    :vartype keda_configuration: ~azure.mgmt.appcontainers.models.KedaConfiguration
    :ivar dapr_configuration: The configuration of Dapr component.
    :vartype dapr_configuration: ~azure.mgmt.appcontainers.models.DaprConfiguration
    :ivar infrastructure_resource_group: Name of the platform-managed resource group created for
     the Managed Environment to host infrastructure resources. If a subnet ID is provided, this
     resource group will be created in the same subscription as the subnet.
    :vartype infrastructure_resource_group: str
    :ivar peer_authentication: Peer authentication settings for the Managed Environment.
    :vartype peer_authentication:
     ~azure.mgmt.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication
    :ivar peer_traffic_configuration: Peer traffic settings for the Managed Environment.
    :vartype peer_traffic_configuration:
     ~azure.mgmt.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfiguration
    :ivar ingress_configuration: Ingress configuration for the Managed Environment.
    :vartype ingress_configuration: ~azure.mgmt.appcontainers.models.IngressConfiguration
    :ivar private_endpoint_connections: Private endpoint connections to the resource.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.appcontainers.models.PrivateEndpointConnection]
    :ivar public_network_access: Property to allow or block all public traffic. Allowed Values:
     'Enabled', 'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.appcontainers.models.PublicNetworkAccess
    :ivar disk_encryption_configuration: Disk encryption configuration for the Managed Environment.
    :vartype disk_encryption_configuration:
     ~azure.mgmt.appcontainers.models.DiskEncryptionConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "deployment_errors": {"readonly": True},
        "default_domain": {"readonly": True},
        "private_link_default_domain": {"readonly": True},
        "static_ip": {"readonly": True},
        "event_stream_endpoint": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "dapr_ai_instrumentation_key": {"key": "properties.daprAIInstrumentationKey", "type": "str"},
        "dapr_ai_connection_string": {"key": "properties.daprAIConnectionString", "type": "str"},
        "vnet_configuration": {"key": "properties.vnetConfiguration", "type": "VnetConfiguration"},
        "deployment_errors": {"key": "properties.deploymentErrors", "type": "str"},
        "default_domain": {"key": "properties.defaultDomain", "type": "str"},
        "private_link_default_domain": {"key": "properties.privateLinkDefaultDomain", "type": "str"},
        "static_ip": {"key": "properties.staticIp", "type": "str"},
        "app_logs_configuration": {"key": "properties.appLogsConfiguration", "type": "AppLogsConfiguration"},
        "app_insights_configuration": {
            "key": "properties.appInsightsConfiguration",
            "type": "AppInsightsConfiguration",
        },
        "open_telemetry_configuration": {
            "key": "properties.openTelemetryConfiguration",
            "type": "OpenTelemetryConfiguration",
        },
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "custom_domain_configuration": {
            "key": "properties.customDomainConfiguration",
            "type": "CustomDomainConfiguration",
        },
        "event_stream_endpoint": {"key": "properties.eventStreamEndpoint", "type": "str"},
        "workload_profiles": {"key": "properties.workloadProfiles", "type": "[WorkloadProfile]"},
        "keda_configuration": {"key": "properties.kedaConfiguration", "type": "KedaConfiguration"},
        "dapr_configuration": {"key": "properties.daprConfiguration", "type": "DaprConfiguration"},
        "infrastructure_resource_group": {"key": "properties.infrastructureResourceGroup", "type": "str"},
        "peer_authentication": {
            "key": "properties.peerAuthentication",
            "type": "ManagedEnvironmentPropertiesPeerAuthentication",
        },
        "peer_traffic_configuration": {
            "key": "properties.peerTrafficConfiguration",
            "type": "ManagedEnvironmentPropertiesPeerTrafficConfiguration",
        },
        "ingress_configuration": {"key": "properties.ingressConfiguration", "type": "IngressConfiguration"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnection]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "disk_encryption_configuration": {
            "key": "properties.diskEncryptionConfiguration",
            "type": "DiskEncryptionConfiguration",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[str] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        dapr_ai_instrumentation_key: Optional[str] = None,
        dapr_ai_connection_string: Optional[str] = None,
        vnet_configuration: Optional["_models.VnetConfiguration"] = None,
        app_logs_configuration: Optional["_models.AppLogsConfiguration"] = None,
        app_insights_configuration: Optional["_models.AppInsightsConfiguration"] = None,
        open_telemetry_configuration: Optional["_models.OpenTelemetryConfiguration"] = None,
        zone_redundant: Optional[bool] = None,
        availability_zones: Optional[List[str]] = None,
        custom_domain_configuration: Optional["_models.CustomDomainConfiguration"] = None,
        workload_profiles: Optional[List["_models.WorkloadProfile"]] = None,
        keda_configuration: Optional["_models.KedaConfiguration"] = None,
        dapr_configuration: Optional["_models.DaprConfiguration"] = None,
        infrastructure_resource_group: Optional[str] = None,
        peer_authentication: Optional["_models.ManagedEnvironmentPropertiesPeerAuthentication"] = None,
        peer_traffic_configuration: Optional["_models.ManagedEnvironmentPropertiesPeerTrafficConfiguration"] = None,
        ingress_configuration: Optional["_models.IngressConfiguration"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        disk_encryption_configuration: Optional["_models.DiskEncryptionConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword kind: Kind of the Environment.
        :paramtype kind: str
        :keyword identity: Managed identities for the Managed Environment to interact with other Azure
         services without maintaining any secrets or credentials in code.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword dapr_ai_instrumentation_key: Azure Monitor instrumentation key used by Dapr to export
         Service to Service communication telemetry.
        :paramtype dapr_ai_instrumentation_key: str
        :keyword dapr_ai_connection_string: Application Insights connection string used by Dapr to
         export Service to Service communication telemetry.
        :paramtype dapr_ai_connection_string: str
        :keyword vnet_configuration: Vnet configuration for the environment.
        :paramtype vnet_configuration: ~azure.mgmt.appcontainers.models.VnetConfiguration
        :keyword app_logs_configuration: Cluster configuration which enables the log daemon to export
         app logs to configured destination.
        :paramtype app_logs_configuration: ~azure.mgmt.appcontainers.models.AppLogsConfiguration
        :keyword app_insights_configuration: Environment level Application Insights configuration.
        :paramtype app_insights_configuration:
         ~azure.mgmt.appcontainers.models.AppInsightsConfiguration
        :keyword open_telemetry_configuration: Environment Open Telemetry configuration.
        :paramtype open_telemetry_configuration:
         ~azure.mgmt.appcontainers.models.OpenTelemetryConfiguration
        :keyword zone_redundant: Whether or not this Managed Environment is zone-redundant.
        :paramtype zone_redundant: bool
        :keyword availability_zones: The list of availability zones to use for managed environment.
        :paramtype availability_zones: list[str]
        :keyword custom_domain_configuration: Custom domain configuration for the environment.
        :paramtype custom_domain_configuration:
         ~azure.mgmt.appcontainers.models.CustomDomainConfiguration
        :keyword workload_profiles: Workload profiles configured for the Managed Environment.
        :paramtype workload_profiles: list[~azure.mgmt.appcontainers.models.WorkloadProfile]
        :keyword keda_configuration: The configuration of Keda component.
        :paramtype keda_configuration: ~azure.mgmt.appcontainers.models.KedaConfiguration
        :keyword dapr_configuration: The configuration of Dapr component.
        :paramtype dapr_configuration: ~azure.mgmt.appcontainers.models.DaprConfiguration
        :keyword infrastructure_resource_group: Name of the platform-managed resource group created for
         the Managed Environment to host infrastructure resources. If a subnet ID is provided, this
         resource group will be created in the same subscription as the subnet.
        :paramtype infrastructure_resource_group: str
        :keyword peer_authentication: Peer authentication settings for the Managed Environment.
        :paramtype peer_authentication:
         ~azure.mgmt.appcontainers.models.ManagedEnvironmentPropertiesPeerAuthentication
        :keyword peer_traffic_configuration: Peer traffic settings for the Managed Environment.
        :paramtype peer_traffic_configuration:
         ~azure.mgmt.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfiguration
        :keyword ingress_configuration: Ingress configuration for the Managed Environment.
        :paramtype ingress_configuration: ~azure.mgmt.appcontainers.models.IngressConfiguration
        :keyword public_network_access: Property to allow or block all public traffic. Allowed Values:
         'Enabled', 'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.appcontainers.models.PublicNetworkAccess
        :keyword disk_encryption_configuration: Disk encryption configuration for the Managed
         Environment.
        :paramtype disk_encryption_configuration:
         ~azure.mgmt.appcontainers.models.DiskEncryptionConfiguration
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.kind = kind
        self.identity = identity
        self.provisioning_state: Optional[Union[str, "_models.EnvironmentProvisioningState"]] = None
        self.dapr_ai_instrumentation_key = dapr_ai_instrumentation_key
        self.dapr_ai_connection_string = dapr_ai_connection_string
        self.vnet_configuration = vnet_configuration
        self.deployment_errors: Optional[str] = None
        self.default_domain: Optional[str] = None
        self.private_link_default_domain: Optional[str] = None
        self.static_ip: Optional[str] = None
        self.app_logs_configuration = app_logs_configuration
        self.app_insights_configuration = app_insights_configuration
        self.open_telemetry_configuration = open_telemetry_configuration
        self.zone_redundant = zone_redundant
        self.availability_zones = availability_zones
        self.custom_domain_configuration = custom_domain_configuration
        self.event_stream_endpoint: Optional[str] = None
        self.workload_profiles = workload_profiles
        self.keda_configuration = keda_configuration
        self.dapr_configuration = dapr_configuration
        self.infrastructure_resource_group = infrastructure_resource_group
        self.peer_authentication = peer_authentication
        self.peer_traffic_configuration = peer_traffic_configuration
        self.ingress_configuration = ingress_configuration
        self.private_endpoint_connections: Optional[List["_models.PrivateEndpointConnection"]] = None
        self.public_network_access = public_network_access
        self.disk_encryption_configuration = disk_encryption_configuration


class ManagedEnvironmentPropertiesPeerAuthentication(_serialization.Model):  # pylint: disable=name-too-long
    """Peer authentication settings for the Managed Environment.

    :ivar mtls: Mutual TLS authentication settings for the Managed Environment.
    :vartype mtls: ~azure.mgmt.appcontainers.models.Mtls
    """

    _attribute_map = {
        "mtls": {"key": "mtls", "type": "Mtls"},
    }

    def __init__(self, *, mtls: Optional["_models.Mtls"] = None, **kwargs: Any) -> None:
        """
        :keyword mtls: Mutual TLS authentication settings for the Managed Environment.
        :paramtype mtls: ~azure.mgmt.appcontainers.models.Mtls
        """
        super().__init__(**kwargs)
        self.mtls = mtls


class ManagedEnvironmentPropertiesPeerTrafficConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """Peer traffic settings for the Managed Environment.

    :ivar encryption: Peer traffic encryption settings for the Managed Environment.
    :vartype encryption:
     ~azure.mgmt.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption
    """

    _attribute_map = {
        "encryption": {"key": "encryption", "type": "ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption"},
    }

    def __init__(
        self,
        *,
        encryption: Optional["_models.ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption: Peer traffic encryption settings for the Managed Environment.
        :paramtype encryption:
         ~azure.mgmt.appcontainers.models.ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption
        """
        super().__init__(**kwargs)
        self.encryption = encryption


class ManagedEnvironmentPropertiesPeerTrafficConfigurationEncryption(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Peer traffic encryption settings for the Managed Environment.

    :ivar enabled: Boolean indicating whether the peer traffic encryption is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Boolean indicating whether the peer traffic encryption is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class ManagedEnvironmentsCollection(_serialization.Model):
    """Collection of Environments.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ManagedEnvironment]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedEnvironment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.ManagedEnvironment"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ManagedEnvironment]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ManagedEnvironmentStorage(ProxyResource):
    """Storage resource for managedEnvironment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Storage properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.ManagedEnvironmentStorageProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "ManagedEnvironmentStorageProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.ManagedEnvironmentStorageProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Storage properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.ManagedEnvironmentStorageProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ManagedEnvironmentStorageProperties(_serialization.Model):
    """Storage properties.

    :ivar azure_file: Azure file properties.
    :vartype azure_file: ~azure.mgmt.appcontainers.models.AzureFileProperties
    :ivar nfs_azure_file: NFS Azure file properties.
    :vartype nfs_azure_file: ~azure.mgmt.appcontainers.models.NfsAzureFileProperties
    """

    _attribute_map = {
        "azure_file": {"key": "azureFile", "type": "AzureFileProperties"},
        "nfs_azure_file": {"key": "nfsAzureFile", "type": "NfsAzureFileProperties"},
    }

    def __init__(
        self,
        *,
        azure_file: Optional["_models.AzureFileProperties"] = None,
        nfs_azure_file: Optional["_models.NfsAzureFileProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_file: Azure file properties.
        :paramtype azure_file: ~azure.mgmt.appcontainers.models.AzureFileProperties
        :keyword nfs_azure_file: NFS Azure file properties.
        :paramtype nfs_azure_file: ~azure.mgmt.appcontainers.models.NfsAzureFileProperties
        """
        super().__init__(**kwargs)
        self.azure_file = azure_file
        self.nfs_azure_file = nfs_azure_file


class ManagedEnvironmentStoragesCollection(_serialization.Model):
    """Collection of Storage for Environments.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of storage resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ManagedEnvironmentStorage]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedEnvironmentStorage]"},
    }

    def __init__(self, *, value: List["_models.ManagedEnvironmentStorage"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of storage resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ManagedEnvironmentStorage]
        """
        super().__init__(**kwargs)
        self.value = value


class ManagedIdentitySetting(_serialization.Model):
    """Optional settings for a Managed Identity that is assigned to the Session pool.

    All required parameters must be populated in order to send to server.

    :ivar identity: The resource ID of a user-assigned managed identity that is assigned to the
     Session Pool, or 'system' for system-assigned identity. Required.
    :vartype identity: str
    :ivar lifecycle: Use to select the lifecycle stages of a Session Pool during which the Managed
     Identity should be available. Known values are: "Init", "Main", "None", and "All".
    :vartype lifecycle: str or ~azure.mgmt.appcontainers.models.IdentitySettingsLifeCycle
    """

    _validation = {
        "identity": {"required": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "str"},
        "lifecycle": {"key": "lifecycle", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: str,
        lifecycle: Optional[Union[str, "_models.IdentitySettingsLifeCycle"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The resource ID of a user-assigned managed identity that is assigned to the
         Session Pool, or 'system' for system-assigned identity. Required.
        :paramtype identity: str
        :keyword lifecycle: Use to select the lifecycle stages of a Session Pool during which the
         Managed Identity should be available. Known values are: "Init", "Main", "None", and "All".
        :paramtype lifecycle: str or ~azure.mgmt.appcontainers.models.IdentitySettingsLifeCycle
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.lifecycle = lifecycle


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.appcontainers.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.appcontainers.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.appcontainers.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.appcontainers.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MetricsConfiguration(_serialization.Model):
    """Configuration of Open Telemetry metrics.

    :ivar include_keda: Boolean indicating if including keda metrics.
    :vartype include_keda: bool
    :ivar destinations: Open telemetry metrics destinations.
    :vartype destinations: list[str]
    """

    _attribute_map = {
        "include_keda": {"key": "includeKeda", "type": "bool"},
        "destinations": {"key": "destinations", "type": "[str]"},
    }

    def __init__(
        self, *, include_keda: Optional[bool] = None, destinations: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword include_keda: Boolean indicating if including keda metrics.
        :paramtype include_keda: bool
        :keyword destinations: Open telemetry metrics destinations.
        :paramtype destinations: list[str]
        """
        super().__init__(**kwargs)
        self.include_keda = include_keda
        self.destinations = destinations


class Mtls(_serialization.Model):
    """Configuration properties for mutual TLS authentication.

    :ivar enabled: Boolean indicating whether the mutual TLS authentication is enabled.
    :vartype enabled: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Boolean indicating whether the mutual TLS authentication is enabled.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled


class NacosComponent(JavaComponentProperties):
    """Nacos properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar component_type: Type of the Java Component. Required. Known values are:
     "SpringBootAdmin", "SpringCloudEureka", "SpringCloudConfig", "SpringCloudGateway", and "Nacos".
    :vartype component_type: str or ~azure.mgmt.appcontainers.models.JavaComponentType
    :ivar provisioning_state: Provisioning state of the Java Component. Known values are:
     "Succeeded", "Failed", "Canceled", "Deleting", and "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.JavaComponentProvisioningState
    :ivar configurations: List of Java Components configuration properties.
    :vartype configurations:
     list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
    :ivar scale: Java component scaling configurations.
    :vartype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
    :ivar service_binds: List of Java Components that are bound to the Java component.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
    :ivar ingress: Java Component Ingress configurations.
    :vartype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
    """

    _validation = {
        "component_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "configurations": {"key": "configurations", "type": "[JavaComponentConfigurationProperty]"},
        "scale": {"key": "scale", "type": "JavaComponentPropertiesScale"},
        "service_binds": {"key": "serviceBinds", "type": "[JavaComponentServiceBind]"},
        "ingress": {"key": "ingress", "type": "JavaComponentIngress"},
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["_models.JavaComponentConfigurationProperty"]] = None,
        scale: Optional["_models.JavaComponentPropertiesScale"] = None,
        service_binds: Optional[List["_models.JavaComponentServiceBind"]] = None,
        ingress: Optional["_models.JavaComponentIngress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configurations: List of Java Components configuration properties.
        :paramtype configurations:
         list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
        :keyword scale: Java component scaling configurations.
        :paramtype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
        :keyword service_binds: List of Java Components that are bound to the Java component.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
        :keyword ingress: Java Component Ingress configurations.
        :paramtype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
        """
        super().__init__(configurations=configurations, scale=scale, service_binds=service_binds, **kwargs)
        self.component_type: str = "Nacos"
        self.ingress = ingress


class NfsAzureFileProperties(_serialization.Model):
    """NFS Azure File Properties.

    :ivar server: Server for NFS azure file.
    :vartype server: str
    :ivar access_mode: Access mode for storage. Known values are: "ReadOnly" and "ReadWrite".
    :vartype access_mode: str or ~azure.mgmt.appcontainers.models.AccessMode
    :ivar share_name: NFS Azure file share name.
    :vartype share_name: str
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "access_mode": {"key": "accessMode", "type": "str"},
        "share_name": {"key": "shareName", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        access_mode: Optional[Union[str, "_models.AccessMode"]] = None,
        share_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server: Server for NFS azure file.
        :paramtype server: str
        :keyword access_mode: Access mode for storage. Known values are: "ReadOnly" and "ReadWrite".
        :paramtype access_mode: str or ~azure.mgmt.appcontainers.models.AccessMode
        :keyword share_name: NFS Azure file share name.
        :paramtype share_name: str
        """
        super().__init__(**kwargs)
        self.server = server
        self.access_mode = access_mode
        self.share_name = share_name


class Nonce(_serialization.Model):
    """The configuration settings of the nonce used in the login flow.

    :ivar validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
     completing the login flow; otherwise, :code:`<code>true</code>`.
    :vartype validate_nonce: bool
    :ivar nonce_expiration_interval: The time after the request is made when the nonce should
     expire.
    :vartype nonce_expiration_interval: str
    """

    _attribute_map = {
        "validate_nonce": {"key": "validateNonce", "type": "bool"},
        "nonce_expiration_interval": {"key": "nonceExpirationInterval", "type": "str"},
    }

    def __init__(
        self, *, validate_nonce: Optional[bool] = None, nonce_expiration_interval: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword validate_nonce: :code:`<code>false</code>` if the nonce should not be validated while
         completing the login flow; otherwise, :code:`<code>true</code>`.
        :paramtype validate_nonce: bool
        :keyword nonce_expiration_interval: The time after the request is made when the nonce should
         expire.
        :paramtype nonce_expiration_interval: str
        """
        super().__init__(**kwargs)
        self.validate_nonce = validate_nonce
        self.nonce_expiration_interval = nonce_expiration_interval


class OpenIdConnectClientCredential(_serialization.Model):
    """The authentication client credentials of the custom Open ID Connect provider.

    :ivar method: The method that should be used to authenticate the user. Default value is
     "ClientSecretPost".
    :vartype method: str
    :ivar client_secret_setting_name: The app setting that contains the client secret for the
     custom Open ID Connect provider.
    :vartype client_secret_setting_name: str
    """

    _attribute_map = {
        "method": {"key": "method", "type": "str"},
        "client_secret_setting_name": {"key": "clientSecretSettingName", "type": "str"},
    }

    def __init__(
        self,
        *,
        method: Optional[Literal["ClientSecretPost"]] = None,
        client_secret_setting_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword method: The method that should be used to authenticate the user. Default value is
         "ClientSecretPost".
        :paramtype method: str
        :keyword client_secret_setting_name: The app setting that contains the client secret for the
         custom Open ID Connect provider.
        :paramtype client_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.method = method
        self.client_secret_setting_name = client_secret_setting_name


class OpenIdConnectConfig(_serialization.Model):
    """The configuration settings of the endpoints used for the custom Open ID Connect provider.

    :ivar authorization_endpoint: The endpoint to be used to make an authorization request.
    :vartype authorization_endpoint: str
    :ivar token_endpoint: The endpoint to be used to request a token.
    :vartype token_endpoint: str
    :ivar issuer: The endpoint that issues the token.
    :vartype issuer: str
    :ivar certification_uri: The endpoint that provides the keys necessary to validate the token.
    :vartype certification_uri: str
    :ivar well_known_open_id_configuration: The endpoint that contains all the configuration
     endpoints for the provider.
    :vartype well_known_open_id_configuration: str
    """

    _attribute_map = {
        "authorization_endpoint": {"key": "authorizationEndpoint", "type": "str"},
        "token_endpoint": {"key": "tokenEndpoint", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "certification_uri": {"key": "certificationUri", "type": "str"},
        "well_known_open_id_configuration": {"key": "wellKnownOpenIdConfiguration", "type": "str"},
    }

    def __init__(
        self,
        *,
        authorization_endpoint: Optional[str] = None,
        token_endpoint: Optional[str] = None,
        issuer: Optional[str] = None,
        certification_uri: Optional[str] = None,
        well_known_open_id_configuration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorization_endpoint: The endpoint to be used to make an authorization request.
        :paramtype authorization_endpoint: str
        :keyword token_endpoint: The endpoint to be used to request a token.
        :paramtype token_endpoint: str
        :keyword issuer: The endpoint that issues the token.
        :paramtype issuer: str
        :keyword certification_uri: The endpoint that provides the keys necessary to validate the
         token.
        :paramtype certification_uri: str
        :keyword well_known_open_id_configuration: The endpoint that contains all the configuration
         endpoints for the provider.
        :paramtype well_known_open_id_configuration: str
        """
        super().__init__(**kwargs)
        self.authorization_endpoint = authorization_endpoint
        self.token_endpoint = token_endpoint
        self.issuer = issuer
        self.certification_uri = certification_uri
        self.well_known_open_id_configuration = well_known_open_id_configuration


class OpenIdConnectLogin(_serialization.Model):
    """The configuration settings of the login flow of the custom Open ID Connect provider.

    :ivar name_claim_type: The name of the claim that contains the users name.
    :vartype name_claim_type: str
    :ivar scopes: A list of the scopes that should be requested while authenticating.
    :vartype scopes: list[str]
    """

    _attribute_map = {
        "name_claim_type": {"key": "nameClaimType", "type": "str"},
        "scopes": {"key": "scopes", "type": "[str]"},
    }

    def __init__(
        self, *, name_claim_type: Optional[str] = None, scopes: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name_claim_type: The name of the claim that contains the users name.
        :paramtype name_claim_type: str
        :keyword scopes: A list of the scopes that should be requested while authenticating.
        :paramtype scopes: list[str]
        """
        super().__init__(**kwargs)
        self.name_claim_type = name_claim_type
        self.scopes = scopes


class OpenIdConnectRegistration(_serialization.Model):
    """The configuration settings of the app registration for the custom Open ID Connect provider.

    :ivar client_id: The client id of the custom Open ID Connect provider.
    :vartype client_id: str
    :ivar client_credential: The authentication credentials of the custom Open ID Connect provider.
    :vartype client_credential: ~azure.mgmt.appcontainers.models.OpenIdConnectClientCredential
    :ivar open_id_connect_configuration: The configuration settings of the endpoints used for the
     custom Open ID Connect provider.
    :vartype open_id_connect_configuration: ~azure.mgmt.appcontainers.models.OpenIdConnectConfig
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "client_credential": {"key": "clientCredential", "type": "OpenIdConnectClientCredential"},
        "open_id_connect_configuration": {"key": "openIdConnectConfiguration", "type": "OpenIdConnectConfig"},
    }

    def __init__(
        self,
        *,
        client_id: Optional[str] = None,
        client_credential: Optional["_models.OpenIdConnectClientCredential"] = None,
        open_id_connect_configuration: Optional["_models.OpenIdConnectConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_id: The client id of the custom Open ID Connect provider.
        :paramtype client_id: str
        :keyword client_credential: The authentication credentials of the custom Open ID Connect
         provider.
        :paramtype client_credential: ~azure.mgmt.appcontainers.models.OpenIdConnectClientCredential
        :keyword open_id_connect_configuration: The configuration settings of the endpoints used for
         the custom Open ID Connect provider.
        :paramtype open_id_connect_configuration: ~azure.mgmt.appcontainers.models.OpenIdConnectConfig
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.client_credential = client_credential
        self.open_id_connect_configuration = open_id_connect_configuration


class OpenTelemetryConfiguration(_serialization.Model):
    """Configuration of Open Telemetry.

    :ivar destinations_configuration: Open telemetry destinations configuration.
    :vartype destinations_configuration: ~azure.mgmt.appcontainers.models.DestinationsConfiguration
    :ivar traces_configuration: Open telemetry trace configuration.
    :vartype traces_configuration: ~azure.mgmt.appcontainers.models.TracesConfiguration
    :ivar logs_configuration: Open telemetry logs configuration.
    :vartype logs_configuration: ~azure.mgmt.appcontainers.models.LogsConfiguration
    :ivar metrics_configuration: Open telemetry metrics configuration.
    :vartype metrics_configuration: ~azure.mgmt.appcontainers.models.MetricsConfiguration
    """

    _attribute_map = {
        "destinations_configuration": {"key": "destinationsConfiguration", "type": "DestinationsConfiguration"},
        "traces_configuration": {"key": "tracesConfiguration", "type": "TracesConfiguration"},
        "logs_configuration": {"key": "logsConfiguration", "type": "LogsConfiguration"},
        "metrics_configuration": {"key": "metricsConfiguration", "type": "MetricsConfiguration"},
    }

    def __init__(
        self,
        *,
        destinations_configuration: Optional["_models.DestinationsConfiguration"] = None,
        traces_configuration: Optional["_models.TracesConfiguration"] = None,
        logs_configuration: Optional["_models.LogsConfiguration"] = None,
        metrics_configuration: Optional["_models.MetricsConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destinations_configuration: Open telemetry destinations configuration.
        :paramtype destinations_configuration:
         ~azure.mgmt.appcontainers.models.DestinationsConfiguration
        :keyword traces_configuration: Open telemetry trace configuration.
        :paramtype traces_configuration: ~azure.mgmt.appcontainers.models.TracesConfiguration
        :keyword logs_configuration: Open telemetry logs configuration.
        :paramtype logs_configuration: ~azure.mgmt.appcontainers.models.LogsConfiguration
        :keyword metrics_configuration: Open telemetry metrics configuration.
        :paramtype metrics_configuration: ~azure.mgmt.appcontainers.models.MetricsConfiguration
        """
        super().__init__(**kwargs)
        self.destinations_configuration = destinations_configuration
        self.traces_configuration = traces_configuration
        self.logs_configuration = logs_configuration
        self.metrics_configuration = metrics_configuration


class OperationDetail(_serialization.Model):
    """Operation detail payload.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.appcontainers.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~azure.mgmt.appcontainers.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin


class OperationDisplay(_serialization.Model):
    """Operation display payload.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Resource provider of the operation.
        :paramtype provider: str
        :keyword resource: Resource of the operation.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation.
        :paramtype operation: str
        :keyword description: Localized friendly description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OtlpConfiguration(_serialization.Model):
    """Configuration of otlp.

    :ivar name: The name of otlp configuration.
    :vartype name: str
    :ivar endpoint: The endpoint of otlp configuration.
    :vartype endpoint: str
    :ivar insecure: Boolean indicating if otlp configuration is insecure.
    :vartype insecure: bool
    :ivar headers: Headers of otlp configurations.
    :vartype headers: list[~azure.mgmt.appcontainers.models.Header]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
        "insecure": {"key": "insecure", "type": "bool"},
        "headers": {"key": "headers", "type": "[Header]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        endpoint: Optional[str] = None,
        insecure: Optional[bool] = None,
        headers: Optional[List["_models.Header"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of otlp configuration.
        :paramtype name: str
        :keyword endpoint: The endpoint of otlp configuration.
        :paramtype endpoint: str
        :keyword insecure: Boolean indicating if otlp configuration is insecure.
        :paramtype insecure: bool
        :keyword headers: Headers of otlp configurations.
        :paramtype headers: list[~azure.mgmt.appcontainers.models.Header]
        """
        super().__init__(**kwargs)
        self.name = name
        self.endpoint = endpoint
        self.insecure = insecure
        self.headers = headers


class PatchCollection(_serialization.Model):
    """Container App patch collection.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of patch resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ContainerAppsPatchResource]
    :ivar next_link: the link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContainerAppsPatchResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.ContainerAppsPatchResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of patch resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ContainerAppsPatchResource]
        :keyword next_link: the link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PatchDetails(_serialization.Model):
    """The detailed info of patch operation performing when applying a patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar target_container_name: The name of the target container for the patch. Required.
    :vartype target_container_name: str
    :ivar target_image: The name of the target image for the patch. Required.
    :vartype target_image: str
    :ivar last_detection_time: The UTC timestamp that describes the latest detection was done.
     Required.
    :vartype last_detection_time: ~datetime.datetime
    :ivar detection_status: The status of the patch detection. Required. Known values are:
     "Succeeded", "RegistryLoginFailed", and "Failed".
    :vartype detection_status: str or ~azure.mgmt.appcontainers.models.DetectionStatus
    :ivar new_image_name: The name of the new image created by the patch.
    :vartype new_image_name: str
    :ivar new_layer: New layer update details in the target image.
    :vartype new_layer: ~azure.mgmt.appcontainers.models.PatchDetailsNewLayer
    :ivar old_layer: The old layer details in the target image.
    :vartype old_layer: ~azure.mgmt.appcontainers.models.PatchDetailsOldLayer
    :ivar patch_type: The type for the patch. Known values are: "FrameworkSecurity", "OSSecurity",
     "FrameworkAndOSSecurity", and "Other".
    :vartype patch_type: str or ~azure.mgmt.appcontainers.models.PatchType
    """

    _validation = {
        "target_container_name": {"required": True, "readonly": True},
        "target_image": {"required": True, "readonly": True},
        "last_detection_time": {"required": True, "readonly": True},
        "detection_status": {"required": True, "readonly": True},
        "new_image_name": {"readonly": True},
        "new_layer": {"readonly": True},
        "old_layer": {"readonly": True},
        "patch_type": {"readonly": True},
    }

    _attribute_map = {
        "target_container_name": {"key": "targetContainerName", "type": "str"},
        "target_image": {"key": "targetImage", "type": "str"},
        "last_detection_time": {"key": "lastDetectionTime", "type": "iso-8601"},
        "detection_status": {"key": "detectionStatus", "type": "str"},
        "new_image_name": {"key": "newImageName", "type": "str"},
        "new_layer": {"key": "newLayer", "type": "PatchDetailsNewLayer"},
        "old_layer": {"key": "oldLayer", "type": "PatchDetailsOldLayer"},
        "patch_type": {"key": "patchType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.target_container_name: Optional[str] = None
        self.target_image: Optional[str] = None
        self.last_detection_time: Optional[datetime.datetime] = None
        self.detection_status: Optional[Union[str, "_models.DetectionStatus"]] = None
        self.new_image_name: Optional[str] = None
        self.new_layer: Optional["_models.PatchDetailsNewLayer"] = None
        self.old_layer: Optional["_models.PatchDetailsOldLayer"] = None
        self.patch_type: Optional[Union[str, "_models.PatchType"]] = None


class PatchDetailsNewLayer(_serialization.Model):
    """New layer update details in the target image.

    :ivar name: The details of the new layer for the target image.
    :vartype name: str
    :ivar framework_and_version: The framework and its version in the new run image for the target
     image.
    :vartype framework_and_version: str
    :ivar os_and_version: The OS name and its version in the new run image for the target image.
    :vartype os_and_version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "framework_and_version": {"key": "frameworkAndVersion", "type": "str"},
        "os_and_version": {"key": "osAndVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        framework_and_version: Optional[str] = None,
        os_and_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The details of the new layer for the target image.
        :paramtype name: str
        :keyword framework_and_version: The framework and its version in the new run image for the
         target image.
        :paramtype framework_and_version: str
        :keyword os_and_version: The OS name and its version in the new run image for the target image.
        :paramtype os_and_version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.framework_and_version = framework_and_version
        self.os_and_version = os_and_version


class PatchDetailsOldLayer(_serialization.Model):
    """The old layer details in the target image.

    :ivar name: The details of the old layer for the target image.
    :vartype name: str
    :ivar framework_and_version: The framework and its version in the old run image for the target
     image.
    :vartype framework_and_version: str
    :ivar os_and_version: The OS name and its version in the old run image for the target image.
    :vartype os_and_version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "framework_and_version": {"key": "frameworkAndVersion", "type": "str"},
        "os_and_version": {"key": "osAndVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        framework_and_version: Optional[str] = None,
        os_and_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The details of the old layer for the target image.
        :paramtype name: str
        :keyword framework_and_version: The framework and its version in the old run image for the
         target image.
        :paramtype framework_and_version: str
        :keyword os_and_version: The OS name and its version in the old run image for the target image.
        :paramtype os_and_version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.framework_and_version = framework_and_version
        self.os_and_version = os_and_version


class PatchProperties(_serialization.Model):
    """Top level properties that describes current states of the patch resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar target_environment_id: The Azure resource id of the target environment for the patch.
    :vartype target_environment_id: str
    :ivar target_container_app_id: The Azure resource id of the target container app for the patch.
    :vartype target_container_app_id: str
    :ivar target_revision_id: The Azure resource id of the target revision for the patch.
    :vartype target_revision_id: str
    :ivar patch_apply_status: The status of the patch operation. Known values are: "NotStarted",
     "RebaseInProgress", "CreatingRevision", "Succeeded", "Canceled", "RebaseFailed",
     "RevisionCreationFailed", "ImagePushPullFailed", and "ManuallySkipped".
    :vartype patch_apply_status: str or ~azure.mgmt.appcontainers.models.PatchApplyStatus
    :ivar created_at: The UTC timestamp that describes when the patch object was created.
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_at: The UTC timestamp that describes when the patch object was last
     updated.
    :vartype last_modified_at: ~datetime.datetime
    :ivar patch_details: Detailed info describes the patch operation for the target container app.
    :vartype patch_details: list[~azure.mgmt.appcontainers.models.PatchDetails]
    """

    _validation = {
        "patch_apply_status": {"readonly": True},
        "created_at": {"readonly": True},
        "last_modified_at": {"readonly": True},
        "patch_details": {"readonly": True},
    }

    _attribute_map = {
        "target_environment_id": {"key": "targetEnvironmentId", "type": "str"},
        "target_container_app_id": {"key": "targetContainerAppId", "type": "str"},
        "target_revision_id": {"key": "targetRevisionId", "type": "str"},
        "patch_apply_status": {"key": "patchApplyStatus", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "patch_details": {"key": "patchDetails", "type": "[PatchDetails]"},
    }

    def __init__(
        self,
        *,
        target_environment_id: Optional[str] = None,
        target_container_app_id: Optional[str] = None,
        target_revision_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_environment_id: The Azure resource id of the target environment for the patch.
        :paramtype target_environment_id: str
        :keyword target_container_app_id: The Azure resource id of the target container app for the
         patch.
        :paramtype target_container_app_id: str
        :keyword target_revision_id: The Azure resource id of the target revision for the patch.
        :paramtype target_revision_id: str
        """
        super().__init__(**kwargs)
        self.target_environment_id = target_environment_id
        self.target_container_app_id = target_container_app_id
        self.target_revision_id = target_revision_id
        self.patch_apply_status: Optional[Union[str, "_models.PatchApplyStatus"]] = None
        self.created_at: Optional[datetime.datetime] = None
        self.last_modified_at: Optional[datetime.datetime] = None
        self.patch_details: Optional[List["_models.PatchDetails"]] = None


class PatchSkipConfig(_serialization.Model):
    """The configuration for patcher to skip a patch or not.

    :ivar skip: The flag to indicate whether to skip the patch or not.
    :vartype skip: bool
    """

    _attribute_map = {
        "skip": {"key": "skip", "type": "bool"},
    }

    def __init__(self, *, skip: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword skip: The flag to indicate whether to skip the patch or not.
        :paramtype skip: bool
        """
        super().__init__(**kwargs)
        self.skip = skip


class PreBuildStep(_serialization.Model):
    """Model representing a pre-build step.

    :ivar description: Description of the pre-build step.
    :vartype description: str
    :ivar scripts: List of custom commands to run.
    :vartype scripts: list[str]
    :ivar http_get: Http get request to send before the build.
    :vartype http_get: ~azure.mgmt.appcontainers.models.HttpGet
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "scripts": {"key": "scripts", "type": "[str]"},
        "http_get": {"key": "httpGet", "type": "HttpGet"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        scripts: Optional[List[str]] = None,
        http_get: Optional["_models.HttpGet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description of the pre-build step.
        :paramtype description: str
        :keyword scripts: List of custom commands to run.
        :paramtype scripts: list[str]
        :keyword http_get: Http get request to send before the build.
        :paramtype http_get: ~azure.mgmt.appcontainers.models.HttpGet
        """
        super().__init__(**kwargs)
        self.description = description
        self.scripts = scripts
        self.http_get = http_get


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar group_ids: The group ids for the private endpoint resource.
    :vartype group_ids: list[str]
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.appcontainers.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.appcontainers.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Failed", "Canceled", "Waiting", "Updating", "Deleting", and
     "Pending".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.appcontainers.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.appcontainers.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.group_ids: Optional[List[str]] = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.PrivateEndpointConnectionProvisioningState"]] = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.appcontainers.models.PrivateEndpointConnection]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.appcontainers.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.group_id: Optional[str] = None
        self.required_members: Optional[List[str]] = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.appcontainers.models.PrivateLinkResource]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.appcontainers.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.appcontainers.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.appcontainers.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class QueueScaleRule(_serialization.Model):
    """Container App container Azure Queue based scaling rule.

    :ivar account_name: Storage account name. required if using managed identity to authenticate.
    :vartype account_name: str
    :ivar queue_name: Queue name.
    :vartype queue_name: str
    :ivar queue_length: Queue length.
    :vartype queue_length: int
    :ivar auth: Authentication secrets for the queue scale rule.
    :vartype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
    :ivar identity: The resource ID of a user-assigned managed identity that is assigned to the
     Container App, or 'system' for system-assigned identity.
    :vartype identity: str
    """

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "queue_name": {"key": "queueName", "type": "str"},
        "queue_length": {"key": "queueLength", "type": "int"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_name: Optional[str] = None,
        queue_name: Optional[str] = None,
        queue_length: Optional[int] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword account_name: Storage account name. required if using managed identity to
         authenticate.
        :paramtype account_name: str
        :keyword queue_name: Queue name.
        :paramtype queue_name: str
        :keyword queue_length: Queue length.
        :paramtype queue_length: int
        :keyword auth: Authentication secrets for the queue scale rule.
        :paramtype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
        :keyword identity: The resource ID of a user-assigned managed identity that is assigned to the
         Container App, or 'system' for system-assigned identity.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.account_name = account_name
        self.queue_name = queue_name
        self.queue_length = queue_length
        self.auth = auth
        self.identity = identity


class RegistryCredentials(_serialization.Model):
    """Container App Private Registry.

    :ivar server: Container Registry Server.
    :vartype server: str
    :ivar username: Container Registry Username.
    :vartype username: str
    :ivar password_secret_ref: The name of the Secret that contains the registry login password.
    :vartype password_secret_ref: str
    :ivar identity: A Managed Identity to use to authenticate with Azure Container Registry. For
     user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned
     identities, use 'system'.
    :vartype identity: str
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password_secret_ref": {"key": "passwordSecretRef", "type": "str"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        username: Optional[str] = None,
        password_secret_ref: Optional[str] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server: Container Registry Server.
        :paramtype server: str
        :keyword username: Container Registry Username.
        :paramtype username: str
        :keyword password_secret_ref: The name of the Secret that contains the registry login password.
        :paramtype password_secret_ref: str
        :keyword identity: A Managed Identity to use to authenticate with Azure Container Registry. For
         user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned
         identities, use 'system'.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.server = server
        self.username = username
        self.password_secret_ref = password_secret_ref
        self.identity = identity


class RegistryInfo(_serialization.Model):
    """Container App registry information.

    :ivar registry_url: registry server Url.
    :vartype registry_url: str
    :ivar registry_user_name: registry username.
    :vartype registry_user_name: str
    :ivar registry_password: registry secret.
    :vartype registry_password: str
    """

    _attribute_map = {
        "registry_url": {"key": "registryUrl", "type": "str"},
        "registry_user_name": {"key": "registryUserName", "type": "str"},
        "registry_password": {"key": "registryPassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        registry_url: Optional[str] = None,
        registry_user_name: Optional[str] = None,
        registry_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword registry_url: registry server Url.
        :paramtype registry_url: str
        :keyword registry_user_name: registry username.
        :paramtype registry_user_name: str
        :keyword registry_password: registry secret.
        :paramtype registry_password: str
        """
        super().__init__(**kwargs)
        self.registry_url = registry_url
        self.registry_user_name = registry_user_name
        self.registry_password = registry_password


class Replica(ProxyResource):
    """Container App Revision Replica.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar created_time: Timestamp describing when the pod was created by controller.
    :vartype created_time: ~datetime.datetime
    :ivar running_state: Current running state of the replica. Known values are: "Running",
     "NotRunning", and "Unknown".
    :vartype running_state: str or ~azure.mgmt.appcontainers.models.ContainerAppReplicaRunningState
    :ivar running_state_details: The details of replica current running state.
    :vartype running_state_details: str
    :ivar containers: The containers collection under a replica.
    :vartype containers: list[~azure.mgmt.appcontainers.models.ReplicaContainer]
    :ivar init_containers: The init containers collection under a replica.
    :vartype init_containers: list[~azure.mgmt.appcontainers.models.ReplicaContainer]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_time": {"readonly": True},
        "running_state": {"readonly": True},
        "running_state_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "running_state": {"key": "properties.runningState", "type": "str"},
        "running_state_details": {"key": "properties.runningStateDetails", "type": "str"},
        "containers": {"key": "properties.containers", "type": "[ReplicaContainer]"},
        "init_containers": {"key": "properties.initContainers", "type": "[ReplicaContainer]"},
    }

    def __init__(
        self,
        *,
        containers: Optional[List["_models.ReplicaContainer"]] = None,
        init_containers: Optional[List["_models.ReplicaContainer"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword containers: The containers collection under a replica.
        :paramtype containers: list[~azure.mgmt.appcontainers.models.ReplicaContainer]
        :keyword init_containers: The init containers collection under a replica.
        :paramtype init_containers: list[~azure.mgmt.appcontainers.models.ReplicaContainer]
        """
        super().__init__(**kwargs)
        self.created_time: Optional[datetime.datetime] = None
        self.running_state: Optional[Union[str, "_models.ContainerAppReplicaRunningState"]] = None
        self.running_state_details: Optional[str] = None
        self.containers = containers
        self.init_containers = init_containers


class ReplicaCollection(_serialization.Model):
    """Container App Revision Replicas collection ARM resource.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.Replica]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Replica]"},
    }

    def __init__(self, *, value: List["_models.Replica"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.Replica]
        """
        super().__init__(**kwargs)
        self.value = value


class ReplicaContainer(_serialization.Model):
    """Container object under Container App Revision Replica.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The Name of the Container.
    :vartype name: str
    :ivar container_id: The Id of the Container.
    :vartype container_id: str
    :ivar ready: The container ready status.
    :vartype ready: bool
    :ivar started: The container start status.
    :vartype started: bool
    :ivar restart_count: The container restart count.
    :vartype restart_count: int
    :ivar running_state: Current running state of the container. Known values are: "Running",
     "Terminated", and "Waiting".
    :vartype running_state: str or
     ~azure.mgmt.appcontainers.models.ContainerAppContainerRunningState
    :ivar running_state_details: The details of container current running state.
    :vartype running_state_details: str
    :ivar log_stream_endpoint: Log Stream endpoint.
    :vartype log_stream_endpoint: str
    :ivar exec_endpoint: Container exec endpoint.
    :vartype exec_endpoint: str
    :ivar debug_endpoint: Container debug endpoint.
    :vartype debug_endpoint: str
    """

    _validation = {
        "running_state": {"readonly": True},
        "running_state_details": {"readonly": True},
        "log_stream_endpoint": {"readonly": True},
        "exec_endpoint": {"readonly": True},
        "debug_endpoint": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "container_id": {"key": "containerId", "type": "str"},
        "ready": {"key": "ready", "type": "bool"},
        "started": {"key": "started", "type": "bool"},
        "restart_count": {"key": "restartCount", "type": "int"},
        "running_state": {"key": "runningState", "type": "str"},
        "running_state_details": {"key": "runningStateDetails", "type": "str"},
        "log_stream_endpoint": {"key": "logStreamEndpoint", "type": "str"},
        "exec_endpoint": {"key": "execEndpoint", "type": "str"},
        "debug_endpoint": {"key": "debugEndpoint", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        container_id: Optional[str] = None,
        ready: Optional[bool] = None,
        started: Optional[bool] = None,
        restart_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The Name of the Container.
        :paramtype name: str
        :keyword container_id: The Id of the Container.
        :paramtype container_id: str
        :keyword ready: The container ready status.
        :paramtype ready: bool
        :keyword started: The container start status.
        :paramtype started: bool
        :keyword restart_count: The container restart count.
        :paramtype restart_count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.container_id = container_id
        self.ready = ready
        self.started = started
        self.restart_count = restart_count
        self.running_state: Optional[Union[str, "_models.ContainerAppContainerRunningState"]] = None
        self.running_state_details: Optional[str] = None
        self.log_stream_endpoint: Optional[str] = None
        self.exec_endpoint: Optional[str] = None
        self.debug_endpoint: Optional[str] = None


class ReplicaExecutionStatus(_serialization.Model):
    """Container Apps Job execution replica status.

    :ivar name: Replica Name.
    :vartype name: str
    :ivar containers: Containers in the execution replica.
    :vartype containers: list[~azure.mgmt.appcontainers.models.ContainerExecutionStatus]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "containers": {"key": "containers", "type": "[ContainerExecutionStatus]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        containers: Optional[List["_models.ContainerExecutionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Replica Name.
        :paramtype name: str
        :keyword containers: Containers in the execution replica.
        :paramtype containers: list[~azure.mgmt.appcontainers.models.ContainerExecutionStatus]
        """
        super().__init__(**kwargs)
        self.name = name
        self.containers = containers


class Revision(ProxyResource):
    """Container App Revision.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar created_time: Timestamp describing when the revision was created
     by controller.
    :vartype created_time: ~datetime.datetime
    :ivar last_active_time: Timestamp describing when the revision was last active. Only meaningful
     when revision is inactive.
    :vartype last_active_time: ~datetime.datetime
    :ivar fqdn: Fully qualified domain name of the revision.
    :vartype fqdn: str
    :ivar template: Container App Revision Template with all possible settings and the
     defaults if user did not provide them. The defaults are populated
     as they were at the creation time.
    :vartype template: ~azure.mgmt.appcontainers.models.Template
    :ivar active: Boolean describing if the Revision is Active.
    :vartype active: bool
    :ivar replicas: Number of pods currently running for this revision.
    :vartype replicas: int
    :ivar traffic_weight: Traffic weight assigned to this revision.
    :vartype traffic_weight: int
    :ivar labels: List of labels assigned to this revision.
    :vartype labels: list[str]
    :ivar provisioning_error: Optional Field - Platform Error Message.
    :vartype provisioning_error: str
    :ivar health_state: Current health State of the revision. Known values are: "Healthy",
     "Unhealthy", and "None".
    :vartype health_state: str or ~azure.mgmt.appcontainers.models.RevisionHealthState
    :ivar provisioning_state: Current provisioning State of the revision. Known values are:
     "Provisioning", "Provisioned", "Failed", "Deprovisioning", and "Deprovisioned".
    :vartype provisioning_state: str or ~azure.mgmt.appcontainers.models.RevisionProvisioningState
    :ivar running_state: Current running state of the revision. Known values are: "Running",
     "Processing", "Stopped", "Degraded", "Failed", and "Unknown".
    :vartype running_state: str or ~azure.mgmt.appcontainers.models.RevisionRunningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "created_time": {"readonly": True},
        "last_active_time": {"readonly": True},
        "fqdn": {"readonly": True},
        "template": {"readonly": True},
        "active": {"readonly": True},
        "replicas": {"readonly": True},
        "traffic_weight": {"readonly": True},
        "labels": {"readonly": True},
        "provisioning_error": {"readonly": True},
        "health_state": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "running_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "created_time": {"key": "properties.createdTime", "type": "iso-8601"},
        "last_active_time": {"key": "properties.lastActiveTime", "type": "iso-8601"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "template": {"key": "properties.template", "type": "Template"},
        "active": {"key": "properties.active", "type": "bool"},
        "replicas": {"key": "properties.replicas", "type": "int"},
        "traffic_weight": {"key": "properties.trafficWeight", "type": "int"},
        "labels": {"key": "properties.labels", "type": "[str]"},
        "provisioning_error": {"key": "properties.provisioningError", "type": "str"},
        "health_state": {"key": "properties.healthState", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "running_state": {"key": "properties.runningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_time: Optional[datetime.datetime] = None
        self.last_active_time: Optional[datetime.datetime] = None
        self.fqdn: Optional[str] = None
        self.template: Optional["_models.Template"] = None
        self.active: Optional[bool] = None
        self.replicas: Optional[int] = None
        self.traffic_weight: Optional[int] = None
        self.labels: Optional[List[str]] = None
        self.provisioning_error: Optional[str] = None
        self.health_state: Optional[Union[str, "_models.RevisionHealthState"]] = None
        self.provisioning_state: Optional[Union[str, "_models.RevisionProvisioningState"]] = None
        self.running_state: Optional[Union[str, "_models.RevisionRunningState"]] = None


class RevisionCollection(_serialization.Model):
    """Container App Revisions collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.Revision]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Revision]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Revision"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.Revision]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class Runtime(_serialization.Model):
    """Container App Runtime configuration.

    :ivar java: Java app configuration.
    :vartype java: ~azure.mgmt.appcontainers.models.RuntimeJava
    :ivar dotnet: .NET app configuration.
    :vartype dotnet: ~azure.mgmt.appcontainers.models.RuntimeDotnet
    """

    _attribute_map = {
        "java": {"key": "java", "type": "RuntimeJava"},
        "dotnet": {"key": "dotnet", "type": "RuntimeDotnet"},
    }

    def __init__(
        self,
        *,
        java: Optional["_models.RuntimeJava"] = None,
        dotnet: Optional["_models.RuntimeDotnet"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword java: Java app configuration.
        :paramtype java: ~azure.mgmt.appcontainers.models.RuntimeJava
        :keyword dotnet: .NET app configuration.
        :paramtype dotnet: ~azure.mgmt.appcontainers.models.RuntimeDotnet
        """
        super().__init__(**kwargs)
        self.java = java
        self.dotnet = dotnet


class RuntimeDotnet(_serialization.Model):
    """.NET app configuration.

    :ivar auto_configure_data_protection: Auto configure the ASP.NET Core Data Protection feature.
    :vartype auto_configure_data_protection: bool
    """

    _attribute_map = {
        "auto_configure_data_protection": {"key": "autoConfigureDataProtection", "type": "bool"},
    }

    def __init__(self, *, auto_configure_data_protection: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword auto_configure_data_protection: Auto configure the ASP.NET Core Data Protection
         feature.
        :paramtype auto_configure_data_protection: bool
        """
        super().__init__(**kwargs)
        self.auto_configure_data_protection = auto_configure_data_protection


class RuntimeJava(_serialization.Model):
    """Java app configuration.

    :ivar enable_metrics: Enable jmx core metrics for the java app.
    :vartype enable_metrics: bool
    :ivar java_agent: Diagnostic capabilities achieved by java agent.
    :vartype java_agent: ~azure.mgmt.appcontainers.models.RuntimeJavaAgent
    """

    _attribute_map = {
        "enable_metrics": {"key": "enableMetrics", "type": "bool"},
        "java_agent": {"key": "javaAgent", "type": "RuntimeJavaAgent"},
    }

    def __init__(
        self,
        *,
        enable_metrics: Optional[bool] = None,
        java_agent: Optional["_models.RuntimeJavaAgent"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_metrics: Enable jmx core metrics for the java app.
        :paramtype enable_metrics: bool
        :keyword java_agent: Diagnostic capabilities achieved by java agent.
        :paramtype java_agent: ~azure.mgmt.appcontainers.models.RuntimeJavaAgent
        """
        super().__init__(**kwargs)
        self.enable_metrics = enable_metrics
        self.java_agent = java_agent


class RuntimeJavaAgent(_serialization.Model):
    """Diagnostic capabilities achieved by java agent.

    :ivar enabled: Enable java agent injection for the java app.
    :vartype enabled: bool
    :ivar logging: Capabilities on the java logging scenario.
    :vartype logging: ~azure.mgmt.appcontainers.models.RuntimeJavaAgentLogging
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "logging": {"key": "logging", "type": "RuntimeJavaAgentLogging"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        logging: Optional["_models.RuntimeJavaAgentLogging"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Enable java agent injection for the java app.
        :paramtype enabled: bool
        :keyword logging: Capabilities on the java logging scenario.
        :paramtype logging: ~azure.mgmt.appcontainers.models.RuntimeJavaAgentLogging
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.logging = logging


class RuntimeJavaAgentLogging(_serialization.Model):
    """Capabilities on the java logging scenario.

    :ivar logger_settings: Settings of the logger for the java app.
    :vartype logger_settings: list[~azure.mgmt.appcontainers.models.LoggerSetting]
    """

    _attribute_map = {
        "logger_settings": {"key": "loggerSettings", "type": "[LoggerSetting]"},
    }

    def __init__(self, *, logger_settings: Optional[List["_models.LoggerSetting"]] = None, **kwargs: Any) -> None:
        """
        :keyword logger_settings: Settings of the logger for the java app.
        :paramtype logger_settings: list[~azure.mgmt.appcontainers.models.LoggerSetting]
        """
        super().__init__(**kwargs)
        self.logger_settings = logger_settings


class Scale(_serialization.Model):
    """Container App scaling configurations.

    :ivar min_replicas: Optional. Minimum number of container replicas.
    :vartype min_replicas: int
    :ivar max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not set.
    :vartype max_replicas: int
    :ivar cooldown_period: Optional. KEDA Cooldown Period. Defaults to 300 seconds if not set.
    :vartype cooldown_period: int
    :ivar polling_interval: Optional. KEDA Polling Interval. Defaults to 30 seconds if not set.
    :vartype polling_interval: int
    :ivar rules: Scaling rules.
    :vartype rules: list[~azure.mgmt.appcontainers.models.ScaleRule]
    """

    _attribute_map = {
        "min_replicas": {"key": "minReplicas", "type": "int"},
        "max_replicas": {"key": "maxReplicas", "type": "int"},
        "cooldown_period": {"key": "cooldownPeriod", "type": "int"},
        "polling_interval": {"key": "pollingInterval", "type": "int"},
        "rules": {"key": "rules", "type": "[ScaleRule]"},
    }

    def __init__(
        self,
        *,
        min_replicas: Optional[int] = None,
        max_replicas: int = 10,
        cooldown_period: Optional[int] = None,
        polling_interval: Optional[int] = None,
        rules: Optional[List["_models.ScaleRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_replicas: Optional. Minimum number of container replicas.
        :paramtype min_replicas: int
        :keyword max_replicas: Optional. Maximum number of container replicas. Defaults to 10 if not
         set.
        :paramtype max_replicas: int
        :keyword cooldown_period: Optional. KEDA Cooldown Period. Defaults to 300 seconds if not set.
        :paramtype cooldown_period: int
        :keyword polling_interval: Optional. KEDA Polling Interval. Defaults to 30 seconds if not set.
        :paramtype polling_interval: int
        :keyword rules: Scaling rules.
        :paramtype rules: list[~azure.mgmt.appcontainers.models.ScaleRule]
        """
        super().__init__(**kwargs)
        self.min_replicas = min_replicas
        self.max_replicas = max_replicas
        self.cooldown_period = cooldown_period
        self.polling_interval = polling_interval
        self.rules = rules


class ScaleConfiguration(_serialization.Model):
    """Scale configuration.

    :ivar max_concurrent_sessions: The maximum count of sessions at the same time.
    :vartype max_concurrent_sessions: int
    :ivar ready_session_instances: The minimum count of ready session instances.
    :vartype ready_session_instances: int
    """

    _attribute_map = {
        "max_concurrent_sessions": {"key": "maxConcurrentSessions", "type": "int"},
        "ready_session_instances": {"key": "readySessionInstances", "type": "int"},
    }

    def __init__(
        self,
        *,
        max_concurrent_sessions: Optional[int] = None,
        ready_session_instances: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword max_concurrent_sessions: The maximum count of sessions at the same time.
        :paramtype max_concurrent_sessions: int
        :keyword ready_session_instances: The minimum count of ready session instances.
        :paramtype ready_session_instances: int
        """
        super().__init__(**kwargs)
        self.max_concurrent_sessions = max_concurrent_sessions
        self.ready_session_instances = ready_session_instances


class ScaleRule(_serialization.Model):
    """Container App container scaling rule.

    :ivar name: Scale Rule Name.
    :vartype name: str
    :ivar azure_queue: Azure Queue based scaling.
    :vartype azure_queue: ~azure.mgmt.appcontainers.models.QueueScaleRule
    :ivar custom: Custom scale rule.
    :vartype custom: ~azure.mgmt.appcontainers.models.CustomScaleRule
    :ivar http: HTTP requests based scaling.
    :vartype http: ~azure.mgmt.appcontainers.models.HttpScaleRule
    :ivar tcp: Tcp requests based scaling.
    :vartype tcp: ~azure.mgmt.appcontainers.models.TcpScaleRule
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "azure_queue": {"key": "azureQueue", "type": "QueueScaleRule"},
        "custom": {"key": "custom", "type": "CustomScaleRule"},
        "http": {"key": "http", "type": "HttpScaleRule"},
        "tcp": {"key": "tcp", "type": "TcpScaleRule"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        azure_queue: Optional["_models.QueueScaleRule"] = None,
        custom: Optional["_models.CustomScaleRule"] = None,
        http: Optional["_models.HttpScaleRule"] = None,
        tcp: Optional["_models.TcpScaleRule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Scale Rule Name.
        :paramtype name: str
        :keyword azure_queue: Azure Queue based scaling.
        :paramtype azure_queue: ~azure.mgmt.appcontainers.models.QueueScaleRule
        :keyword custom: Custom scale rule.
        :paramtype custom: ~azure.mgmt.appcontainers.models.CustomScaleRule
        :keyword http: HTTP requests based scaling.
        :paramtype http: ~azure.mgmt.appcontainers.models.HttpScaleRule
        :keyword tcp: Tcp requests based scaling.
        :paramtype tcp: ~azure.mgmt.appcontainers.models.TcpScaleRule
        """
        super().__init__(**kwargs)
        self.name = name
        self.azure_queue = azure_queue
        self.custom = custom
        self.http = http
        self.tcp = tcp


class ScaleRuleAuth(_serialization.Model):
    """Auth Secrets for Scale Rule.

    :ivar secret_ref: Name of the secret from which to pull the auth params.
    :vartype secret_ref: str
    :ivar trigger_parameter: Trigger Parameter that uses the secret.
    :vartype trigger_parameter: str
    """

    _attribute_map = {
        "secret_ref": {"key": "secretRef", "type": "str"},
        "trigger_parameter": {"key": "triggerParameter", "type": "str"},
    }

    def __init__(
        self, *, secret_ref: Optional[str] = None, trigger_parameter: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword secret_ref: Name of the secret from which to pull the auth params.
        :paramtype secret_ref: str
        :keyword trigger_parameter: Trigger Parameter that uses the secret.
        :paramtype trigger_parameter: str
        """
        super().__init__(**kwargs)
        self.secret_ref = secret_ref
        self.trigger_parameter = trigger_parameter


class ScgRoute(_serialization.Model):
    """Spring Cloud Gateway route definition.

    All required parameters must be populated in order to send to server.

    :ivar id: Id of the route. Required.
    :vartype id: str
    :ivar uri: Uri of the route. Required.
    :vartype uri: str
    :ivar predicates: Predicates of the route.
    :vartype predicates: list[str]
    :ivar filters: Filters of the route.
    :vartype filters: list[str]
    :ivar order: Order of the route.
    :vartype order: int
    """

    _validation = {
        "id": {"required": True},
        "uri": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "predicates": {"key": "predicates", "type": "[str]"},
        "filters": {"key": "filters", "type": "[str]"},
        "order": {"key": "order", "type": "int"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        uri: str,
        predicates: Optional[List[str]] = None,
        filters: Optional[List[str]] = None,
        order: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Id of the route. Required.
        :paramtype id: str
        :keyword uri: Uri of the route. Required.
        :paramtype uri: str
        :keyword predicates: Predicates of the route.
        :paramtype predicates: list[str]
        :keyword filters: Filters of the route.
        :paramtype filters: list[str]
        :keyword order: Order of the route.
        :paramtype order: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.uri = uri
        self.predicates = predicates
        self.filters = filters
        self.order = order


class ScheduledEntry(_serialization.Model):
    """Maintenance schedule entry for a managed environment.

    All required parameters must be populated in order to send to server.

    :ivar week_day: Day of the week when a managed environment can be patched. Required. Known
     values are: "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
    :vartype week_day: str or ~azure.mgmt.appcontainers.models.WeekDay
    :ivar start_hour_utc: Start hour after which managed environment maintenance can start from 0
     to 23 hour. Required.
    :vartype start_hour_utc: int
    :ivar duration_hours: Length of maintenance window range from 8 to 24 hours. Required.
    :vartype duration_hours: int
    """

    _validation = {
        "week_day": {"required": True},
        "start_hour_utc": {"required": True},
        "duration_hours": {"required": True},
    }

    _attribute_map = {
        "week_day": {"key": "weekDay", "type": "str"},
        "start_hour_utc": {"key": "startHourUtc", "type": "int"},
        "duration_hours": {"key": "durationHours", "type": "int"},
    }

    def __init__(
        self, *, week_day: Union[str, "_models.WeekDay"], start_hour_utc: int, duration_hours: int, **kwargs: Any
    ) -> None:
        """
        :keyword week_day: Day of the week when a managed environment can be patched. Required. Known
         values are: "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", and "Sunday".
        :paramtype week_day: str or ~azure.mgmt.appcontainers.models.WeekDay
        :keyword start_hour_utc: Start hour after which managed environment maintenance can start from
         0 to 23 hour. Required.
        :paramtype start_hour_utc: int
        :keyword duration_hours: Length of maintenance window range from 8 to 24 hours. Required.
        :paramtype duration_hours: int
        """
        super().__init__(**kwargs)
        self.week_day = week_day
        self.start_hour_utc = start_hour_utc
        self.duration_hours = duration_hours


class Secret(_serialization.Model):
    """Secret definition.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    :ivar identity: Resource ID of a managed identity to authenticate with Azure Key Vault, or
     System to use a system-assigned identity.
    :vartype identity: str
    :ivar key_vault_url: Azure Key Vault URL pointing to the secret referenced by the container
     app.
    :vartype key_vault_url: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "identity": {"key": "identity", "type": "str"},
        "key_vault_url": {"key": "keyVaultUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        identity: Optional[str] = None,
        key_vault_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Secret Name.
        :paramtype name: str
        :keyword value: Secret Value.
        :paramtype value: str
        :keyword identity: Resource ID of a managed identity to authenticate with Azure Key Vault, or
         System to use a system-assigned identity.
        :paramtype identity: str
        :keyword key_vault_url: Azure Key Vault URL pointing to the secret referenced by the container
         app.
        :paramtype key_vault_url: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value
        self.identity = identity
        self.key_vault_url = key_vault_url


class SecretKeyVaultProperties(_serialization.Model):
    """Properties for a secret stored in a Key Vault.

    :ivar identity: Resource ID of a managed identity to authenticate with Azure Key Vault, or
     System to use a system-assigned identity.
    :vartype identity: str
    :ivar key_vault_url: URL pointing to the Azure Key Vault secret.
    :vartype key_vault_url: str
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "str"},
        "key_vault_url": {"key": "keyVaultUrl", "type": "str"},
    }

    def __init__(self, *, identity: Optional[str] = None, key_vault_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword identity: Resource ID of a managed identity to authenticate with Azure Key Vault, or
         System to use a system-assigned identity.
        :paramtype identity: str
        :keyword key_vault_url: URL pointing to the Azure Key Vault secret.
        :paramtype key_vault_url: str
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.key_vault_url = key_vault_url


class SecretsCollection(_serialization.Model):
    """Container App Secrets Collection ARM resource.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.ContainerAppSecret]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ContainerAppSecret]"},
    }

    def __init__(self, *, value: List["_models.ContainerAppSecret"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.ContainerAppSecret]
        """
        super().__init__(**kwargs)
        self.value = value


class SecretVolumeItem(_serialization.Model):
    """Secret to be added to volume.

    :ivar secret_ref: Name of the Container App secret from which to pull the secret value.
    :vartype secret_ref: str
    :ivar path: Path to project secret to. If no path is provided, path defaults to name of secret
     listed in secretRef.
    :vartype path: str
    """

    _attribute_map = {
        "secret_ref": {"key": "secretRef", "type": "str"},
        "path": {"key": "path", "type": "str"},
    }

    def __init__(self, *, secret_ref: Optional[str] = None, path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword secret_ref: Name of the Container App secret from which to pull the secret value.
        :paramtype secret_ref: str
        :keyword path: Path to project secret to. If no path is provided, path defaults to name of
         secret listed in secretRef.
        :paramtype path: str
        """
        super().__init__(**kwargs)
        self.secret_ref = secret_ref
        self.path = path


class Service(_serialization.Model):
    """Container App to be a dev service.

    All required parameters must be populated in order to send to server.

    :ivar type: Dev ContainerApp service type. Required.
    :vartype type: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: str, **kwargs: Any) -> None:
        """
        :keyword type: Dev ContainerApp service type. Required.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.type = type


class ServiceBind(_serialization.Model):
    """Configuration to bind a ContainerApp to a dev ContainerApp Service.

    :ivar service_id: Resource id of the target service.
    :vartype service_id: str
    :ivar name: Name of the service bind.
    :vartype name: str
    :ivar client_type: Type of the client to be used to connect to the service.
    :vartype client_type: str
    :ivar customized_keys: Customized keys for customizing injected values to the app.
    :vartype customized_keys: dict[str, str]
    """

    _attribute_map = {
        "service_id": {"key": "serviceId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "client_type": {"key": "clientType", "type": "str"},
        "customized_keys": {"key": "customizedKeys", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        service_id: Optional[str] = None,
        name: Optional[str] = None,
        client_type: Optional[str] = None,
        customized_keys: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_id: Resource id of the target service.
        :paramtype service_id: str
        :keyword name: Name of the service bind.
        :paramtype name: str
        :keyword client_type: Type of the client to be used to connect to the service.
        :paramtype client_type: str
        :keyword customized_keys: Customized keys for customizing injected values to the app.
        :paramtype customized_keys: dict[str, str]
        """
        super().__init__(**kwargs)
        self.service_id = service_id
        self.name = name
        self.client_type = client_type
        self.customized_keys = customized_keys


class SessionContainer(_serialization.Model):
    """Container definitions for the sessions of the session pool.

    :ivar image: Container image tag.
    :vartype image: str
    :ivar name: Custom container name.
    :vartype name: str
    :ivar command: Container start command.
    :vartype command: list[str]
    :ivar args: Container start command arguments.
    :vartype args: list[str]
    :ivar env: Container environment variables.
    :vartype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
    :ivar resources: Container resource requirements.
    :vartype resources: ~azure.mgmt.appcontainers.models.SessionContainerResources
    :ivar probes: List of probes for the container.
    :vartype probes: list[~azure.mgmt.appcontainers.models.SessionProbe]
    """

    _attribute_map = {
        "image": {"key": "image", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "command": {"key": "command", "type": "[str]"},
        "args": {"key": "args", "type": "[str]"},
        "env": {"key": "env", "type": "[EnvironmentVar]"},
        "resources": {"key": "resources", "type": "SessionContainerResources"},
        "probes": {"key": "probes", "type": "[SessionProbe]"},
    }

    def __init__(
        self,
        *,
        image: Optional[str] = None,
        name: Optional[str] = None,
        command: Optional[List[str]] = None,
        args: Optional[List[str]] = None,
        env: Optional[List["_models.EnvironmentVar"]] = None,
        resources: Optional["_models.SessionContainerResources"] = None,
        probes: Optional[List["_models.SessionProbe"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image: Container image tag.
        :paramtype image: str
        :keyword name: Custom container name.
        :paramtype name: str
        :keyword command: Container start command.
        :paramtype command: list[str]
        :keyword args: Container start command arguments.
        :paramtype args: list[str]
        :keyword env: Container environment variables.
        :paramtype env: list[~azure.mgmt.appcontainers.models.EnvironmentVar]
        :keyword resources: Container resource requirements.
        :paramtype resources: ~azure.mgmt.appcontainers.models.SessionContainerResources
        :keyword probes: List of probes for the container.
        :paramtype probes: list[~azure.mgmt.appcontainers.models.SessionProbe]
        """
        super().__init__(**kwargs)
        self.image = image
        self.name = name
        self.command = command
        self.args = args
        self.env = env
        self.resources = resources
        self.probes = probes


class SessionContainerResources(_serialization.Model):
    """Container resource requirements for sessions of the session pool.

    :ivar cpu: Required CPU in cores, e.g. 0.5.
    :vartype cpu: float
    :ivar memory: Required memory, e.g. "250Mb".
    :vartype memory: str
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "float"},
        "memory": {"key": "memory", "type": "str"},
    }

    def __init__(self, *, cpu: Optional[float] = None, memory: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cpu: Required CPU in cores, e.g. 0.5.
        :paramtype cpu: float
        :keyword memory: Required memory, e.g. "250Mb".
        :paramtype memory: str
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory = memory


class SessionIngress(_serialization.Model):
    """Session pool ingress configuration.

    :ivar target_port: Target port in containers for traffic from ingress.
    :vartype target_port: int
    """

    _attribute_map = {
        "target_port": {"key": "targetPort", "type": "int"},
    }

    def __init__(self, *, target_port: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword target_port: Target port in containers for traffic from ingress.
        :paramtype target_port: int
        """
        super().__init__(**kwargs)
        self.target_port = target_port


class SessionNetworkConfiguration(_serialization.Model):
    """Session network configuration.

    :ivar status: Network status for the sessions. Known values are: "EgressEnabled" and
     "EgressDisabled".
    :vartype status: str or ~azure.mgmt.appcontainers.models.SessionNetworkStatus
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, status: Optional[Union[str, "_models.SessionNetworkStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword status: Network status for the sessions. Known values are: "EgressEnabled" and
         "EgressDisabled".
        :paramtype status: str or ~azure.mgmt.appcontainers.models.SessionNetworkStatus
        """
        super().__init__(**kwargs)
        self.status = status


class SessionPool(TrackedResource):
    """Container App session pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: Managed identities needed by a session pool to interact with other Azure
     services to not maintain any secrets or credentials in code.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar environment_id: Resource ID of the session pool's environment.
    :vartype environment_id: str
    :ivar container_type: The container type of the sessions. Known values are: "CustomContainer"
     and "PythonLTS".
    :vartype container_type: str or ~azure.mgmt.appcontainers.models.ContainerType
    :ivar pool_management_type: The pool management type of the session pool. Known values are:
     "Manual" and "Dynamic".
    :vartype pool_management_type: str or ~azure.mgmt.appcontainers.models.PoolManagementType
    :ivar node_count: The number of nodes the session pool is using.
    :vartype node_count: int
    :ivar scale_configuration: The scale configuration of the session pool.
    :vartype scale_configuration: ~azure.mgmt.appcontainers.models.ScaleConfiguration
    :ivar secrets: The secrets of the session pool.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.SessionPoolSecret]
    :ivar dynamic_pool_configuration: The pool configuration if the poolManagementType is dynamic.
    :vartype dynamic_pool_configuration: ~azure.mgmt.appcontainers.models.DynamicPoolConfiguration
    :ivar custom_container_template: The custom container configuration if the containerType is
     CustomContainer.
    :vartype custom_container_template: ~azure.mgmt.appcontainers.models.CustomContainerTemplate
    :ivar session_network_configuration: The network configuration of the sessions in the session
     pool.
    :vartype session_network_configuration:
     ~azure.mgmt.appcontainers.models.SessionNetworkConfiguration
    :ivar pool_management_endpoint: The endpoint to manage the pool.
    :vartype pool_management_endpoint: str
    :ivar provisioning_state: Provisioning state of the session pool. Known values are:
     "InProgress", "Succeeded", "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.SessionPoolProvisioningState
    :ivar managed_identity_settings: Optional settings for a Managed Identity that is assigned to
     the Session pool.
    :vartype managed_identity_settings:
     list[~azure.mgmt.appcontainers.models.ManagedIdentitySetting]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "node_count": {"readonly": True},
        "pool_management_endpoint": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "environment_id": {"key": "properties.environmentId", "type": "str"},
        "container_type": {"key": "properties.containerType", "type": "str"},
        "pool_management_type": {"key": "properties.poolManagementType", "type": "str"},
        "node_count": {"key": "properties.nodeCount", "type": "int"},
        "scale_configuration": {"key": "properties.scaleConfiguration", "type": "ScaleConfiguration"},
        "secrets": {"key": "properties.secrets", "type": "[SessionPoolSecret]"},
        "dynamic_pool_configuration": {
            "key": "properties.dynamicPoolConfiguration",
            "type": "DynamicPoolConfiguration",
        },
        "custom_container_template": {"key": "properties.customContainerTemplate", "type": "CustomContainerTemplate"},
        "session_network_configuration": {
            "key": "properties.sessionNetworkConfiguration",
            "type": "SessionNetworkConfiguration",
        },
        "pool_management_endpoint": {"key": "properties.poolManagementEndpoint", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "managed_identity_settings": {"key": "properties.managedIdentitySettings", "type": "[ManagedIdentitySetting]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        environment_id: Optional[str] = None,
        container_type: Optional[Union[str, "_models.ContainerType"]] = None,
        pool_management_type: Optional[Union[str, "_models.PoolManagementType"]] = None,
        scale_configuration: Optional["_models.ScaleConfiguration"] = None,
        secrets: Optional[List["_models.SessionPoolSecret"]] = None,
        dynamic_pool_configuration: Optional["_models.DynamicPoolConfiguration"] = None,
        custom_container_template: Optional["_models.CustomContainerTemplate"] = None,
        session_network_configuration: Optional["_models.SessionNetworkConfiguration"] = None,
        managed_identity_settings: Optional[List["_models.ManagedIdentitySetting"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: Managed identities needed by a session pool to interact with other Azure
         services to not maintain any secrets or credentials in code.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword environment_id: Resource ID of the session pool's environment.
        :paramtype environment_id: str
        :keyword container_type: The container type of the sessions. Known values are:
         "CustomContainer" and "PythonLTS".
        :paramtype container_type: str or ~azure.mgmt.appcontainers.models.ContainerType
        :keyword pool_management_type: The pool management type of the session pool. Known values are:
         "Manual" and "Dynamic".
        :paramtype pool_management_type: str or ~azure.mgmt.appcontainers.models.PoolManagementType
        :keyword scale_configuration: The scale configuration of the session pool.
        :paramtype scale_configuration: ~azure.mgmt.appcontainers.models.ScaleConfiguration
        :keyword secrets: The secrets of the session pool.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.SessionPoolSecret]
        :keyword dynamic_pool_configuration: The pool configuration if the poolManagementType is
         dynamic.
        :paramtype dynamic_pool_configuration:
         ~azure.mgmt.appcontainers.models.DynamicPoolConfiguration
        :keyword custom_container_template: The custom container configuration if the containerType is
         CustomContainer.
        :paramtype custom_container_template: ~azure.mgmt.appcontainers.models.CustomContainerTemplate
        :keyword session_network_configuration: The network configuration of the sessions in the
         session pool.
        :paramtype session_network_configuration:
         ~azure.mgmt.appcontainers.models.SessionNetworkConfiguration
        :keyword managed_identity_settings: Optional settings for a Managed Identity that is assigned
         to the Session pool.
        :paramtype managed_identity_settings:
         list[~azure.mgmt.appcontainers.models.ManagedIdentitySetting]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.environment_id = environment_id
        self.container_type = container_type
        self.pool_management_type = pool_management_type
        self.node_count: Optional[int] = None
        self.scale_configuration = scale_configuration
        self.secrets = secrets
        self.dynamic_pool_configuration = dynamic_pool_configuration
        self.custom_container_template = custom_container_template
        self.session_network_configuration = session_network_configuration
        self.pool_management_endpoint: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.SessionPoolProvisioningState"]] = None
        self.managed_identity_settings = managed_identity_settings


class SessionPoolCollection(_serialization.Model):
    """Session pool collection Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.SessionPool]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SessionPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SessionPool"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.SessionPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class SessionPoolSecret(_serialization.Model):
    """Secret definition.

    :ivar name: Secret Name.
    :vartype name: str
    :ivar value: Secret Value.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Secret Name.
        :paramtype name: str
        :keyword value: Secret Value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class SessionPoolUpdatableProperties(_serialization.Model):
    """Container App session pool updatable properties.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: Managed identities needed by a session pool to interact with other Azure
     services to not maintain any secrets or credentials in code.
    :vartype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
    :ivar scale_configuration: The scale configuration of the session pool.
    :vartype scale_configuration: ~azure.mgmt.appcontainers.models.ScaleConfiguration
    :ivar secrets: The secrets of the session pool.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.SessionPoolSecret]
    :ivar dynamic_pool_configuration: The pool configuration if the poolManagementType is dynamic.
    :vartype dynamic_pool_configuration: ~azure.mgmt.appcontainers.models.DynamicPoolConfiguration
    :ivar custom_container_template: The custom container configuration if the containerType is
     CustomContainer.
    :vartype custom_container_template: ~azure.mgmt.appcontainers.models.CustomContainerTemplate
    :ivar session_network_configuration: The network configuration of the sessions in the session
     pool.
    :vartype session_network_configuration:
     ~azure.mgmt.appcontainers.models.SessionNetworkConfiguration
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "scale_configuration": {"key": "properties.scaleConfiguration", "type": "ScaleConfiguration"},
        "secrets": {"key": "properties.secrets", "type": "[SessionPoolSecret]"},
        "dynamic_pool_configuration": {
            "key": "properties.dynamicPoolConfiguration",
            "type": "DynamicPoolConfiguration",
        },
        "custom_container_template": {"key": "properties.customContainerTemplate", "type": "CustomContainerTemplate"},
        "session_network_configuration": {
            "key": "properties.sessionNetworkConfiguration",
            "type": "SessionNetworkConfiguration",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        scale_configuration: Optional["_models.ScaleConfiguration"] = None,
        secrets: Optional[List["_models.SessionPoolSecret"]] = None,
        dynamic_pool_configuration: Optional["_models.DynamicPoolConfiguration"] = None,
        custom_container_template: Optional["_models.CustomContainerTemplate"] = None,
        session_network_configuration: Optional["_models.SessionNetworkConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: Managed identities needed by a session pool to interact with other Azure
         services to not maintain any secrets or credentials in code.
        :paramtype identity: ~azure.mgmt.appcontainers.models.ManagedServiceIdentity
        :keyword scale_configuration: The scale configuration of the session pool.
        :paramtype scale_configuration: ~azure.mgmt.appcontainers.models.ScaleConfiguration
        :keyword secrets: The secrets of the session pool.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.SessionPoolSecret]
        :keyword dynamic_pool_configuration: The pool configuration if the poolManagementType is
         dynamic.
        :paramtype dynamic_pool_configuration:
         ~azure.mgmt.appcontainers.models.DynamicPoolConfiguration
        :keyword custom_container_template: The custom container configuration if the containerType is
         CustomContainer.
        :paramtype custom_container_template: ~azure.mgmt.appcontainers.models.CustomContainerTemplate
        :keyword session_network_configuration: The network configuration of the sessions in the
         session pool.
        :paramtype session_network_configuration:
         ~azure.mgmt.appcontainers.models.SessionNetworkConfiguration
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.scale_configuration = scale_configuration
        self.secrets = secrets
        self.dynamic_pool_configuration = dynamic_pool_configuration
        self.custom_container_template = custom_container_template
        self.session_network_configuration = session_network_configuration


class SessionProbe(_serialization.Model):
    """Session probe configuration.

    :ivar type: Denotes the type of probe. Can be Liveness or Startup, Readiness probe is not
     supported in sessions. Type must be unique for each probe within the context of a list of
     probes (SessionProbes). Known values are: "Liveness" and "Startup".
    :vartype type: str or ~azure.mgmt.appcontainers.models.SessionProbeType
    :ivar http_get: HTTPGet specifies the http request to perform.
    :vartype http_get: ~azure.mgmt.appcontainers.models.SessionProbeHttpGet
    :ivar tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet
     supported.
    :vartype tcp_socket: ~azure.mgmt.appcontainers.models.SessionProbeTcpSocket
    :ivar failure_threshold: Minimum consecutive failures for the probe to be considered failed
     after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
    :vartype failure_threshold: int
    :ivar initial_delay_seconds: Number of seconds after the container has started before liveness
     probes are initiated. Minimum value is 1. Maximum value is 60.
    :vartype initial_delay_seconds: int
    :ivar period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds.
     Minimum value is 1. Maximum value is 240.
    :vartype period_seconds: int
    :ivar success_threshold: Minimum consecutive successes for the probe to be considered
     successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
     value is 1. Maximum value is 10.
    :vartype success_threshold: int
    :ivar termination_grace_period_seconds: Optional duration in seconds the pod needs to terminate
     gracefully upon probe failure. The grace period is the duration in seconds after the processes
     running in the pod are sent a termination signal and the time when the processes are forcibly
     halted with a kill signal. Set this value longer than the expected cleanup time for your
     process. If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise,
     this value overrides the value provided by the pod spec. Value must be non-negative integer.
     The value zero indicates stop immediately via the kill signal (no opportunity to shut down).
     This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate. Maximum
     value is 3600 seconds (1 hour).
    :vartype termination_grace_period_seconds: int
    :ivar timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second.
     Minimum value is 1. Maximum value is 240.
    :vartype timeout_seconds: int
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "http_get": {"key": "httpGet", "type": "SessionProbeHttpGet"},
        "tcp_socket": {"key": "tcpSocket", "type": "SessionProbeTcpSocket"},
        "failure_threshold": {"key": "failureThreshold", "type": "int"},
        "initial_delay_seconds": {"key": "initialDelaySeconds", "type": "int"},
        "period_seconds": {"key": "periodSeconds", "type": "int"},
        "success_threshold": {"key": "successThreshold", "type": "int"},
        "termination_grace_period_seconds": {"key": "terminationGracePeriodSeconds", "type": "int"},
        "timeout_seconds": {"key": "timeoutSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SessionProbeType"]] = None,
        http_get: Optional["_models.SessionProbeHttpGet"] = None,
        tcp_socket: Optional["_models.SessionProbeTcpSocket"] = None,
        failure_threshold: Optional[int] = None,
        initial_delay_seconds: Optional[int] = None,
        period_seconds: Optional[int] = None,
        success_threshold: Optional[int] = None,
        termination_grace_period_seconds: Optional[int] = None,
        timeout_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Denotes the type of probe. Can be Liveness or Startup, Readiness probe is not
         supported in sessions. Type must be unique for each probe within the context of a list of
         probes (SessionProbes). Known values are: "Liveness" and "Startup".
        :paramtype type: str or ~azure.mgmt.appcontainers.models.SessionProbeType
        :keyword http_get: HTTPGet specifies the http request to perform.
        :paramtype http_get: ~azure.mgmt.appcontainers.models.SessionProbeHttpGet
        :keyword tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet
         supported.
        :paramtype tcp_socket: ~azure.mgmt.appcontainers.models.SessionProbeTcpSocket
        :keyword failure_threshold: Minimum consecutive failures for the probe to be considered failed
         after having succeeded. Defaults to 3. Minimum value is 1. Maximum value is 10.
        :paramtype failure_threshold: int
        :keyword initial_delay_seconds: Number of seconds after the container has started before
         liveness probes are initiated. Minimum value is 1. Maximum value is 60.
        :paramtype initial_delay_seconds: int
        :keyword period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds.
         Minimum value is 1. Maximum value is 240.
        :paramtype period_seconds: int
        :keyword success_threshold: Minimum consecutive successes for the probe to be considered
         successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
         value is 1. Maximum value is 10.
        :paramtype success_threshold: int
        :keyword termination_grace_period_seconds: Optional duration in seconds the pod needs to
         terminate gracefully upon probe failure. The grace period is the duration in seconds after the
         processes running in the pod are sent a termination signal and the time when the processes are
         forcibly halted with a kill signal. Set this value longer than the expected cleanup time for
         your process. If this value is nil, the pod's terminationGracePeriodSeconds will be used.
         Otherwise, this value overrides the value provided by the pod spec. Value must be non-negative
         integer. The value zero indicates stop immediately via the kill signal (no opportunity to shut
         down). This is an alpha field and requires enabling ProbeTerminationGracePeriod feature gate.
         Maximum value is 3600 seconds (1 hour).
        :paramtype termination_grace_period_seconds: int
        :keyword timeout_seconds: Number of seconds after which the probe times out. Defaults to 1
         second. Minimum value is 1. Maximum value is 240.
        :paramtype timeout_seconds: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.http_get = http_get
        self.tcp_socket = tcp_socket
        self.failure_threshold = failure_threshold
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.success_threshold = success_threshold
        self.termination_grace_period_seconds = termination_grace_period_seconds
        self.timeout_seconds = timeout_seconds


class SessionProbeHttpGet(_serialization.Model):
    """HTTPGet specifies the http request to perform.

    All required parameters must be populated in order to send to server.

    :ivar host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in
     httpHeaders instead.
    :vartype host: str
    :ivar http_headers: Custom headers to set in the request. HTTP allows repeated headers.
    :vartype http_headers:
     list[~azure.mgmt.appcontainers.models.SessionProbeHttpGetHttpHeadersItem]
    :ivar path: Path to access on the HTTP server.
    :vartype path: str
    :ivar port: Name or number of the port to access on the container. Number must be in the range
     1 to 65535. Name must be an IANA_SVC_NAME. Required.
    :vartype port: int
    :ivar scheme: Scheme to use for connecting to the host. Defaults to HTTP. Known values are:
     "HTTP" and "HTTPS".
    :vartype scheme: str or ~azure.mgmt.appcontainers.models.Scheme
    """

    _validation = {
        "port": {"required": True},
    }

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "http_headers": {"key": "httpHeaders", "type": "[SessionProbeHttpGetHttpHeadersItem]"},
        "path": {"key": "path", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "scheme": {"key": "scheme", "type": "str"},
    }

    def __init__(
        self,
        *,
        port: int,
        host: Optional[str] = None,
        http_headers: Optional[List["_models.SessionProbeHttpGetHttpHeadersItem"]] = None,
        path: Optional[str] = None,
        scheme: Optional[Union[str, "_models.Scheme"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host: Host name to connect to, defaults to the pod IP. You probably want to set "Host"
         in httpHeaders instead.
        :paramtype host: str
        :keyword http_headers: Custom headers to set in the request. HTTP allows repeated headers.
        :paramtype http_headers:
         list[~azure.mgmt.appcontainers.models.SessionProbeHttpGetHttpHeadersItem]
        :keyword path: Path to access on the HTTP server.
        :paramtype path: str
        :keyword port: Name or number of the port to access on the container. Number must be in the
         range 1 to 65535. Name must be an IANA_SVC_NAME. Required.
        :paramtype port: int
        :keyword scheme: Scheme to use for connecting to the host. Defaults to HTTP. Known values are:
         "HTTP" and "HTTPS".
        :paramtype scheme: str or ~azure.mgmt.appcontainers.models.Scheme
        """
        super().__init__(**kwargs)
        self.host = host
        self.http_headers = http_headers
        self.path = path
        self.port = port
        self.scheme = scheme


class SessionProbeHttpGetHttpHeadersItem(_serialization.Model):
    """HTTPHeader describes a custom header to be used in HTTP probes.

    All required parameters must be populated in order to send to server.

    :ivar name: The header field name. Required.
    :vartype name: str
    :ivar value: The header field value. Required.
    :vartype value: str
    """

    _validation = {
        "name": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: str, value: str, **kwargs: Any) -> None:
        """
        :keyword name: The header field name. Required.
        :paramtype name: str
        :keyword value: The header field value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class SessionProbeTcpSocket(_serialization.Model):
    """TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported.

    All required parameters must be populated in order to send to server.

    :ivar host: Optional: Host name to connect to, defaults to the pod IP.
    :vartype host: str
    :ivar port: Number or name of the port to access on the container. Number must be in the range
     1 to 65535. Name must be an IANA_SVC_NAME. Required.
    :vartype port: int
    """

    _validation = {
        "port": {"required": True},
    }

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, *, port: int, host: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword host: Optional: Host name to connect to, defaults to the pod IP.
        :paramtype host: str
        :keyword port: Number or name of the port to access on the container. Number must be in the
         range 1 to 65535. Name must be an IANA_SVC_NAME. Required.
        :paramtype port: int
        """
        super().__init__(**kwargs)
        self.host = host
        self.port = port


class SessionRegistryCredentials(_serialization.Model):
    """Session pool private registry credentials.

    :ivar server: Container registry server.
    :vartype server: str
    :ivar username: Container registry username.
    :vartype username: str
    :ivar password_secret_ref: The name of the secret that contains the registry login password.
    :vartype password_secret_ref: str
    :ivar identity: A Managed Identity to use to authenticate with Azure Container Registry. For
     user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned
     identities, use 'system'.
    :vartype identity: str
    """

    _attribute_map = {
        "server": {"key": "server", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "password_secret_ref": {"key": "passwordSecretRef", "type": "str"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        server: Optional[str] = None,
        username: Optional[str] = None,
        password_secret_ref: Optional[str] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server: Container registry server.
        :paramtype server: str
        :keyword username: Container registry username.
        :paramtype username: str
        :keyword password_secret_ref: The name of the secret that contains the registry login password.
        :paramtype password_secret_ref: str
        :keyword identity: A Managed Identity to use to authenticate with Azure Container Registry. For
         user-assigned identities, use the full user-assigned identity Resource ID. For system-assigned
         identities, use 'system'.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.server = server
        self.username = username
        self.password_secret_ref = password_secret_ref
        self.identity = identity


class SmbStorage(_serialization.Model):
    """SMB storage properties.

    :ivar host: The host name or IP address of the SMB server.
    :vartype host: str
    :ivar share_name: The path to the SMB shared folder.
    :vartype share_name: str
    :ivar username: The user to log on to the SMB server.
    :vartype username: str
    :ivar domain: The domain name for the user.
    :vartype domain: str
    :ivar password: The password for the user.
    :vartype password: str
    :ivar access_mode: Access mode for storage. Known values are: "ReadOnly" and "ReadWrite".
    :vartype access_mode: str or ~azure.mgmt.appcontainers.models.AccessMode
    """

    _attribute_map = {
        "host": {"key": "host", "type": "str"},
        "share_name": {"key": "shareName", "type": "str"},
        "username": {"key": "username", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "access_mode": {"key": "accessMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        host: Optional[str] = None,
        share_name: Optional[str] = None,
        username: Optional[str] = None,
        domain: Optional[str] = None,
        password: Optional[str] = None,
        access_mode: Optional[Union[str, "_models.AccessMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host: The host name or IP address of the SMB server.
        :paramtype host: str
        :keyword share_name: The path to the SMB shared folder.
        :paramtype share_name: str
        :keyword username: The user to log on to the SMB server.
        :paramtype username: str
        :keyword domain: The domain name for the user.
        :paramtype domain: str
        :keyword password: The password for the user.
        :paramtype password: str
        :keyword access_mode: Access mode for storage. Known values are: "ReadOnly" and "ReadWrite".
        :paramtype access_mode: str or ~azure.mgmt.appcontainers.models.AccessMode
        """
        super().__init__(**kwargs)
        self.host = host
        self.share_name = share_name
        self.username = username
        self.domain = domain
        self.password = password
        self.access_mode = access_mode


class SourceControl(ProxyResource):
    """Container App SourceControl.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar operation_state: Current provisioning State of the operation. Known values are:
     "InProgress", "Succeeded", "Failed", and "Canceled".
    :vartype operation_state: str or ~azure.mgmt.appcontainers.models.SourceControlOperationState
    :ivar repo_url: The repo url which will be integrated to ContainerApp.
    :vartype repo_url: str
    :ivar branch: The branch which will trigger the auto deployment.
    :vartype branch: str
    :ivar github_action_configuration: Container App Revision Template with all possible settings
     and the
     defaults if user did not provide them. The defaults are populated
     as they were at the creation time.
    :vartype github_action_configuration:
     ~azure.mgmt.appcontainers.models.GithubActionConfiguration
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "operation_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "operation_state": {"key": "properties.operationState", "type": "str"},
        "repo_url": {"key": "properties.repoUrl", "type": "str"},
        "branch": {"key": "properties.branch", "type": "str"},
        "github_action_configuration": {
            "key": "properties.githubActionConfiguration",
            "type": "GithubActionConfiguration",
        },
    }

    def __init__(
        self,
        *,
        repo_url: Optional[str] = None,
        branch: Optional[str] = None,
        github_action_configuration: Optional["_models.GithubActionConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword repo_url: The repo url which will be integrated to ContainerApp.
        :paramtype repo_url: str
        :keyword branch: The branch which will trigger the auto deployment.
        :paramtype branch: str
        :keyword github_action_configuration: Container App Revision Template with all possible
         settings and the
         defaults if user did not provide them. The defaults are populated
         as they were at the creation time.
        :paramtype github_action_configuration:
         ~azure.mgmt.appcontainers.models.GithubActionConfiguration
        """
        super().__init__(**kwargs)
        self.operation_state: Optional[Union[str, "_models.SourceControlOperationState"]] = None
        self.repo_url = repo_url
        self.branch = branch
        self.github_action_configuration = github_action_configuration


class SourceControlCollection(_serialization.Model):
    """SourceControl collection ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.SourceControl]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SourceControl]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SourceControl"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.SourceControl]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class SpringBootAdminComponent(JavaComponentProperties):
    """Spring Boot Admin properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar component_type: Type of the Java Component. Required. Known values are:
     "SpringBootAdmin", "SpringCloudEureka", "SpringCloudConfig", "SpringCloudGateway", and "Nacos".
    :vartype component_type: str or ~azure.mgmt.appcontainers.models.JavaComponentType
    :ivar provisioning_state: Provisioning state of the Java Component. Known values are:
     "Succeeded", "Failed", "Canceled", "Deleting", and "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.JavaComponentProvisioningState
    :ivar configurations: List of Java Components configuration properties.
    :vartype configurations:
     list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
    :ivar scale: Java component scaling configurations.
    :vartype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
    :ivar service_binds: List of Java Components that are bound to the Java component.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
    :ivar ingress: Java Component Ingress configurations.
    :vartype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
    """

    _validation = {
        "component_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "configurations": {"key": "configurations", "type": "[JavaComponentConfigurationProperty]"},
        "scale": {"key": "scale", "type": "JavaComponentPropertiesScale"},
        "service_binds": {"key": "serviceBinds", "type": "[JavaComponentServiceBind]"},
        "ingress": {"key": "ingress", "type": "JavaComponentIngress"},
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["_models.JavaComponentConfigurationProperty"]] = None,
        scale: Optional["_models.JavaComponentPropertiesScale"] = None,
        service_binds: Optional[List["_models.JavaComponentServiceBind"]] = None,
        ingress: Optional["_models.JavaComponentIngress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configurations: List of Java Components configuration properties.
        :paramtype configurations:
         list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
        :keyword scale: Java component scaling configurations.
        :paramtype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
        :keyword service_binds: List of Java Components that are bound to the Java component.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
        :keyword ingress: Java Component Ingress configurations.
        :paramtype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
        """
        super().__init__(configurations=configurations, scale=scale, service_binds=service_binds, **kwargs)
        self.component_type: str = "SpringBootAdmin"
        self.ingress = ingress


class SpringCloudConfigComponent(JavaComponentProperties):
    """Spring Cloud Config properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar component_type: Type of the Java Component. Required. Known values are:
     "SpringBootAdmin", "SpringCloudEureka", "SpringCloudConfig", "SpringCloudGateway", and "Nacos".
    :vartype component_type: str or ~azure.mgmt.appcontainers.models.JavaComponentType
    :ivar provisioning_state: Provisioning state of the Java Component. Known values are:
     "Succeeded", "Failed", "Canceled", "Deleting", and "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.JavaComponentProvisioningState
    :ivar configurations: List of Java Components configuration properties.
    :vartype configurations:
     list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
    :ivar scale: Java component scaling configurations.
    :vartype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
    :ivar service_binds: List of Java Components that are bound to the Java component.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
    """

    _validation = {
        "component_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "configurations": {"key": "configurations", "type": "[JavaComponentConfigurationProperty]"},
        "scale": {"key": "scale", "type": "JavaComponentPropertiesScale"},
        "service_binds": {"key": "serviceBinds", "type": "[JavaComponentServiceBind]"},
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["_models.JavaComponentConfigurationProperty"]] = None,
        scale: Optional["_models.JavaComponentPropertiesScale"] = None,
        service_binds: Optional[List["_models.JavaComponentServiceBind"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configurations: List of Java Components configuration properties.
        :paramtype configurations:
         list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
        :keyword scale: Java component scaling configurations.
        :paramtype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
        :keyword service_binds: List of Java Components that are bound to the Java component.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
        """
        super().__init__(configurations=configurations, scale=scale, service_binds=service_binds, **kwargs)
        self.component_type: str = "SpringCloudConfig"


class SpringCloudEurekaComponent(JavaComponentProperties):
    """Spring Cloud Eureka properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar component_type: Type of the Java Component. Required. Known values are:
     "SpringBootAdmin", "SpringCloudEureka", "SpringCloudConfig", "SpringCloudGateway", and "Nacos".
    :vartype component_type: str or ~azure.mgmt.appcontainers.models.JavaComponentType
    :ivar provisioning_state: Provisioning state of the Java Component. Known values are:
     "Succeeded", "Failed", "Canceled", "Deleting", and "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.JavaComponentProvisioningState
    :ivar configurations: List of Java Components configuration properties.
    :vartype configurations:
     list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
    :ivar scale: Java component scaling configurations.
    :vartype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
    :ivar service_binds: List of Java Components that are bound to the Java component.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
    :ivar ingress: Java Component Ingress configurations.
    :vartype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
    """

    _validation = {
        "component_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "configurations": {"key": "configurations", "type": "[JavaComponentConfigurationProperty]"},
        "scale": {"key": "scale", "type": "JavaComponentPropertiesScale"},
        "service_binds": {"key": "serviceBinds", "type": "[JavaComponentServiceBind]"},
        "ingress": {"key": "ingress", "type": "JavaComponentIngress"},
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["_models.JavaComponentConfigurationProperty"]] = None,
        scale: Optional["_models.JavaComponentPropertiesScale"] = None,
        service_binds: Optional[List["_models.JavaComponentServiceBind"]] = None,
        ingress: Optional["_models.JavaComponentIngress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configurations: List of Java Components configuration properties.
        :paramtype configurations:
         list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
        :keyword scale: Java component scaling configurations.
        :paramtype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
        :keyword service_binds: List of Java Components that are bound to the Java component.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
        :keyword ingress: Java Component Ingress configurations.
        :paramtype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
        """
        super().__init__(configurations=configurations, scale=scale, service_binds=service_binds, **kwargs)
        self.component_type: str = "SpringCloudEureka"
        self.ingress = ingress


class SpringCloudGatewayComponent(JavaComponentProperties):
    """Spring Cloud Gateway properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar component_type: Type of the Java Component. Required. Known values are:
     "SpringBootAdmin", "SpringCloudEureka", "SpringCloudConfig", "SpringCloudGateway", and "Nacos".
    :vartype component_type: str or ~azure.mgmt.appcontainers.models.JavaComponentType
    :ivar provisioning_state: Provisioning state of the Java Component. Known values are:
     "Succeeded", "Failed", "Canceled", "Deleting", and "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.appcontainers.models.JavaComponentProvisioningState
    :ivar configurations: List of Java Components configuration properties.
    :vartype configurations:
     list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
    :ivar scale: Java component scaling configurations.
    :vartype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
    :ivar service_binds: List of Java Components that are bound to the Java component.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
    :ivar ingress: Java Component Ingress configurations.
    :vartype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
    :ivar spring_cloud_gateway_routes: Gateway route definition.
    :vartype spring_cloud_gateway_routes: list[~azure.mgmt.appcontainers.models.ScgRoute]
    """

    _validation = {
        "component_type": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "component_type": {"key": "componentType", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "configurations": {"key": "configurations", "type": "[JavaComponentConfigurationProperty]"},
        "scale": {"key": "scale", "type": "JavaComponentPropertiesScale"},
        "service_binds": {"key": "serviceBinds", "type": "[JavaComponentServiceBind]"},
        "ingress": {"key": "ingress", "type": "JavaComponentIngress"},
        "spring_cloud_gateway_routes": {"key": "springCloudGatewayRoutes", "type": "[ScgRoute]"},
    }

    def __init__(
        self,
        *,
        configurations: Optional[List["_models.JavaComponentConfigurationProperty"]] = None,
        scale: Optional["_models.JavaComponentPropertiesScale"] = None,
        service_binds: Optional[List["_models.JavaComponentServiceBind"]] = None,
        ingress: Optional["_models.JavaComponentIngress"] = None,
        spring_cloud_gateway_routes: Optional[List["_models.ScgRoute"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configurations: List of Java Components configuration properties.
        :paramtype configurations:
         list[~azure.mgmt.appcontainers.models.JavaComponentConfigurationProperty]
        :keyword scale: Java component scaling configurations.
        :paramtype scale: ~azure.mgmt.appcontainers.models.JavaComponentPropertiesScale
        :keyword service_binds: List of Java Components that are bound to the Java component.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.JavaComponentServiceBind]
        :keyword ingress: Java Component Ingress configurations.
        :paramtype ingress: ~azure.mgmt.appcontainers.models.JavaComponentIngress
        :keyword spring_cloud_gateway_routes: Gateway route definition.
        :paramtype spring_cloud_gateway_routes: list[~azure.mgmt.appcontainers.models.ScgRoute]
        """
        super().__init__(configurations=configurations, scale=scale, service_binds=service_binds, **kwargs)
        self.component_type: str = "SpringCloudGateway"
        self.ingress = ingress
        self.spring_cloud_gateway_routes = spring_cloud_gateway_routes


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.appcontainers.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.appcontainers.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.appcontainers.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.appcontainers.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TcpConnectionPool(_serialization.Model):
    """Defines parameters for tcp connection pooling.

    :ivar max_connections: Maximum number of tcp connections allowed.
    :vartype max_connections: int
    """

    _attribute_map = {
        "max_connections": {"key": "maxConnections", "type": "int"},
    }

    def __init__(self, *, max_connections: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword max_connections: Maximum number of tcp connections allowed.
        :paramtype max_connections: int
        """
        super().__init__(**kwargs)
        self.max_connections = max_connections


class TcpRetryPolicy(_serialization.Model):
    """Policy that defines tcp request retry conditions.

    :ivar max_connect_attempts: Maximum number of attempts to connect to the tcp service.
    :vartype max_connect_attempts: int
    """

    _attribute_map = {
        "max_connect_attempts": {"key": "maxConnectAttempts", "type": "int"},
    }

    def __init__(self, *, max_connect_attempts: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword max_connect_attempts: Maximum number of attempts to connect to the tcp service.
        :paramtype max_connect_attempts: int
        """
        super().__init__(**kwargs)
        self.max_connect_attempts = max_connect_attempts


class TcpScaleRule(_serialization.Model):
    """Container App container Tcp scaling rule.

    :ivar metadata: Metadata properties to describe tcp scale rule.
    :vartype metadata: dict[str, str]
    :ivar auth: Authentication secrets for the tcp scale rule.
    :vartype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
    :ivar identity: The resource ID of a user-assigned managed identity that is assigned to the
     Container App, or 'system' for system-assigned identity.
    :vartype identity: str
    """

    _attribute_map = {
        "metadata": {"key": "metadata", "type": "{str}"},
        "auth": {"key": "auth", "type": "[ScaleRuleAuth]"},
        "identity": {"key": "identity", "type": "str"},
    }

    def __init__(
        self,
        *,
        metadata: Optional[Dict[str, str]] = None,
        auth: Optional[List["_models.ScaleRuleAuth"]] = None,
        identity: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword metadata: Metadata properties to describe tcp scale rule.
        :paramtype metadata: dict[str, str]
        :keyword auth: Authentication secrets for the tcp scale rule.
        :paramtype auth: list[~azure.mgmt.appcontainers.models.ScaleRuleAuth]
        :keyword identity: The resource ID of a user-assigned managed identity that is assigned to the
         Container App, or 'system' for system-assigned identity.
        :paramtype identity: str
        """
        super().__init__(**kwargs)
        self.metadata = metadata
        self.auth = auth
        self.identity = identity


class Template(_serialization.Model):
    """Container App versioned application definition.
    Defines the desired state of an immutable revision.
    Any changes to this section Will result in a new revision being created.

    :ivar revision_suffix: User friendly suffix that is appended to the revision name.
    :vartype revision_suffix: str
    :ivar termination_grace_period_seconds: Optional duration in seconds the Container App Instance
     needs to terminate gracefully. Value must be non-negative integer. The value zero indicates
     stop immediately via the kill signal (no opportunity to shut down). If this value is nil, the
     default grace period will be used instead. Set this value longer than the expected cleanup time
     for your process. Defaults to 30 seconds.
    :vartype termination_grace_period_seconds: int
    :ivar init_containers: List of specialized containers that run before app containers.
    :vartype init_containers: list[~azure.mgmt.appcontainers.models.InitContainer]
    :ivar containers: List of container definitions for the Container App.
    :vartype containers: list[~azure.mgmt.appcontainers.models.Container]
    :ivar scale: Scaling properties for the Container App.
    :vartype scale: ~azure.mgmt.appcontainers.models.Scale
    :ivar volumes: List of volume definitions for the Container App.
    :vartype volumes: list[~azure.mgmt.appcontainers.models.Volume]
    :ivar service_binds: List of container app services bound to the app.
    :vartype service_binds: list[~azure.mgmt.appcontainers.models.ServiceBind]
    """

    _attribute_map = {
        "revision_suffix": {"key": "revisionSuffix", "type": "str"},
        "termination_grace_period_seconds": {"key": "terminationGracePeriodSeconds", "type": "int"},
        "init_containers": {"key": "initContainers", "type": "[InitContainer]"},
        "containers": {"key": "containers", "type": "[Container]"},
        "scale": {"key": "scale", "type": "Scale"},
        "volumes": {"key": "volumes", "type": "[Volume]"},
        "service_binds": {"key": "serviceBinds", "type": "[ServiceBind]"},
    }

    def __init__(
        self,
        *,
        revision_suffix: Optional[str] = None,
        termination_grace_period_seconds: Optional[int] = None,
        init_containers: Optional[List["_models.InitContainer"]] = None,
        containers: Optional[List["_models.Container"]] = None,
        scale: Optional["_models.Scale"] = None,
        volumes: Optional[List["_models.Volume"]] = None,
        service_binds: Optional[List["_models.ServiceBind"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword revision_suffix: User friendly suffix that is appended to the revision name.
        :paramtype revision_suffix: str
        :keyword termination_grace_period_seconds: Optional duration in seconds the Container App
         Instance needs to terminate gracefully. Value must be non-negative integer. The value zero
         indicates stop immediately via the kill signal (no opportunity to shut down). If this value is
         nil, the default grace period will be used instead. Set this value longer than the expected
         cleanup time for your process. Defaults to 30 seconds.
        :paramtype termination_grace_period_seconds: int
        :keyword init_containers: List of specialized containers that run before app containers.
        :paramtype init_containers: list[~azure.mgmt.appcontainers.models.InitContainer]
        :keyword containers: List of container definitions for the Container App.
        :paramtype containers: list[~azure.mgmt.appcontainers.models.Container]
        :keyword scale: Scaling properties for the Container App.
        :paramtype scale: ~azure.mgmt.appcontainers.models.Scale
        :keyword volumes: List of volume definitions for the Container App.
        :paramtype volumes: list[~azure.mgmt.appcontainers.models.Volume]
        :keyword service_binds: List of container app services bound to the app.
        :paramtype service_binds: list[~azure.mgmt.appcontainers.models.ServiceBind]
        """
        super().__init__(**kwargs)
        self.revision_suffix = revision_suffix
        self.termination_grace_period_seconds = termination_grace_period_seconds
        self.init_containers = init_containers
        self.containers = containers
        self.scale = scale
        self.volumes = volumes
        self.service_binds = service_binds


class TimeoutPolicy(_serialization.Model):
    """Policy to set request timeouts.

    :ivar response_timeout_in_seconds: Timeout, in seconds, for a request to respond.
    :vartype response_timeout_in_seconds: int
    :ivar connection_timeout_in_seconds: Timeout, in seconds, for a request to initiate a
     connection.
    :vartype connection_timeout_in_seconds: int
    """

    _attribute_map = {
        "response_timeout_in_seconds": {"key": "responseTimeoutInSeconds", "type": "int"},
        "connection_timeout_in_seconds": {"key": "connectionTimeoutInSeconds", "type": "int"},
    }

    def __init__(
        self,
        *,
        response_timeout_in_seconds: Optional[int] = None,
        connection_timeout_in_seconds: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword response_timeout_in_seconds: Timeout, in seconds, for a request to respond.
        :paramtype response_timeout_in_seconds: int
        :keyword connection_timeout_in_seconds: Timeout, in seconds, for a request to initiate a
         connection.
        :paramtype connection_timeout_in_seconds: int
        """
        super().__init__(**kwargs)
        self.response_timeout_in_seconds = response_timeout_in_seconds
        self.connection_timeout_in_seconds = connection_timeout_in_seconds


class TokenStore(_serialization.Model):
    """The configuration settings of the token store.

    :ivar enabled: :code:`<code>true</code>` to durably store platform-specific security tokens
     that are obtained during login flows; otherwise, :code:`<code>false</code>`.
      The default is :code:`<code>false</code>`.
    :vartype enabled: bool
    :ivar token_refresh_extension_hours: The number of hours after session token expiration that a
     session token can be used to
     call the token refresh API. The default is 72 hours.
    :vartype token_refresh_extension_hours: float
    :ivar azure_blob_storage: The configuration settings of the storage of the tokens if blob
     storage is used.
    :vartype azure_blob_storage: ~azure.mgmt.appcontainers.models.BlobStorageTokenStore
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "token_refresh_extension_hours": {"key": "tokenRefreshExtensionHours", "type": "float"},
        "azure_blob_storage": {"key": "azureBlobStorage", "type": "BlobStorageTokenStore"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        token_refresh_extension_hours: Optional[float] = None,
        azure_blob_storage: Optional["_models.BlobStorageTokenStore"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>true</code>` to durably store platform-specific security tokens
         that are obtained during login flows; otherwise, :code:`<code>false</code>`.
          The default is :code:`<code>false</code>`.
        :paramtype enabled: bool
        :keyword token_refresh_extension_hours: The number of hours after session token expiration that
         a session token can be used to
         call the token refresh API. The default is 72 hours.
        :paramtype token_refresh_extension_hours: float
        :keyword azure_blob_storage: The configuration settings of the storage of the tokens if blob
         storage is used.
        :paramtype azure_blob_storage: ~azure.mgmt.appcontainers.models.BlobStorageTokenStore
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.token_refresh_extension_hours = token_refresh_extension_hours
        self.azure_blob_storage = azure_blob_storage


class TracesConfiguration(_serialization.Model):
    """Configuration of Open Telemetry traces.

    :ivar include_dapr: Boolean indicating if including dapr traces.
    :vartype include_dapr: bool
    :ivar destinations: Open telemetry traces destinations.
    :vartype destinations: list[str]
    """

    _attribute_map = {
        "include_dapr": {"key": "includeDapr", "type": "bool"},
        "destinations": {"key": "destinations", "type": "[str]"},
    }

    def __init__(
        self, *, include_dapr: Optional[bool] = None, destinations: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword include_dapr: Boolean indicating if including dapr traces.
        :paramtype include_dapr: bool
        :keyword destinations: Open telemetry traces destinations.
        :paramtype destinations: list[str]
        """
        super().__init__(**kwargs)
        self.include_dapr = include_dapr
        self.destinations = destinations


class TrafficWeight(_serialization.Model):
    """Traffic weight assigned to a revision.

    :ivar revision_name: Name of a revision.
    :vartype revision_name: str
    :ivar weight: Traffic weight assigned to a revision.
    :vartype weight: int
    :ivar latest_revision: Indicates that the traffic weight belongs to a latest stable revision.
    :vartype latest_revision: bool
    :ivar label: Associates a traffic label with a revision.
    :vartype label: str
    """

    _attribute_map = {
        "revision_name": {"key": "revisionName", "type": "str"},
        "weight": {"key": "weight", "type": "int"},
        "latest_revision": {"key": "latestRevision", "type": "bool"},
        "label": {"key": "label", "type": "str"},
    }

    def __init__(
        self,
        *,
        revision_name: Optional[str] = None,
        weight: Optional[int] = None,
        latest_revision: bool = False,
        label: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword revision_name: Name of a revision.
        :paramtype revision_name: str
        :keyword weight: Traffic weight assigned to a revision.
        :paramtype weight: int
        :keyword latest_revision: Indicates that the traffic weight belongs to a latest stable
         revision.
        :paramtype latest_revision: bool
        :keyword label: Associates a traffic label with a revision.
        :paramtype label: str
        """
        super().__init__(**kwargs)
        self.revision_name = revision_name
        self.weight = weight
        self.latest_revision = latest_revision
        self.label = label


class Twitter(_serialization.Model):
    """The configuration settings of the Twitter provider.

    :ivar enabled: :code:`<code>false</code>` if the Twitter provider should not be enabled despite
     the set registration; otherwise, :code:`<code>true</code>`.
    :vartype enabled: bool
    :ivar registration: The configuration settings of the app registration for the Twitter
     provider.
    :vartype registration: ~azure.mgmt.appcontainers.models.TwitterRegistration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "registration": {"key": "registration", "type": "TwitterRegistration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        registration: Optional["_models.TwitterRegistration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: :code:`<code>false</code>` if the Twitter provider should not be enabled
         despite the set registration; otherwise, :code:`<code>true</code>`.
        :paramtype enabled: bool
        :keyword registration: The configuration settings of the app registration for the Twitter
         provider.
        :paramtype registration: ~azure.mgmt.appcontainers.models.TwitterRegistration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.registration = registration


class TwitterRegistration(_serialization.Model):
    """The configuration settings of the app registration for the Twitter provider.

    :ivar consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
     This setting is required for enabling Twitter Sign-In.
     Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
    :vartype consumer_key: str
    :ivar consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a consumer
     secret of the Twitter
     application used for sign-in.
    :vartype consumer_secret_setting_name: str
    """

    _attribute_map = {
        "consumer_key": {"key": "consumerKey", "type": "str"},
        "consumer_secret_setting_name": {"key": "consumerSecretSettingName", "type": "str"},
    }

    def __init__(
        self, *, consumer_key: Optional[str] = None, consumer_secret_setting_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword consumer_key: The OAuth 1.0a consumer key of the Twitter application used for sign-in.
         This setting is required for enabling Twitter Sign-In.
         Twitter Sign-In documentation: https://dev.twitter.com/web/sign-in.
        :paramtype consumer_key: str
        :keyword consumer_secret_setting_name: The app setting name that contains the OAuth 1.0a
         consumer secret of the Twitter
         application used for sign-in.
        :paramtype consumer_secret_setting_name: str
        """
        super().__init__(**kwargs)
        self.consumer_key = consumer_key
        self.consumer_secret_setting_name = consumer_secret_setting_name


class Usage(_serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar unit: An enum describing the unit of usage measurement. Required. Default value is
     "Count".
    :vartype unit: str
    :ivar current_value: The current usage of the resource. Required.
    :vartype current_value: float
    :ivar limit: The maximum permitted usage of the resource. Required.
    :vartype limit: float
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.appcontainers.models.UsageName
    """

    _validation = {
        "unit": {"required": True, "constant": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "float"},
        "limit": {"key": "limit", "type": "float"},
        "name": {"key": "name", "type": "UsageName"},
    }

    unit = "Count"

    def __init__(self, *, current_value: float, limit: float, name: "_models.UsageName", **kwargs: Any) -> None:
        """
        :keyword current_value: The current usage of the resource. Required.
        :paramtype current_value: float
        :keyword limit: The maximum permitted usage of the resource. Required.
        :paramtype limit: float
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.appcontainers.models.UsageName
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The Usage Names.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The name of the resource.
        :paramtype value: str
        :keyword localized_value: The localized name of the resource.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class VnetConfiguration(_serialization.Model):
    """Configuration properties for apps environment to join a Virtual Network.

    :ivar internal: Boolean indicating the environment only has an internal load balancer. These
     environments do not have a public static IP resource. They must provide infrastructureSubnetId
     if enabling this property.
    :vartype internal: bool
    :ivar infrastructure_subnet_id: Resource ID of a subnet for infrastructure components. Must not
     overlap with any other provided IP ranges.
    :vartype infrastructure_subnet_id: str
    :ivar docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge, network. Must
     not overlap with any other provided IP ranges.
    :vartype docker_bridge_cidr: str
    :ivar platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment
     infrastructure IP addresses. Must not overlap with any other provided IP ranges.
    :vartype platform_reserved_cidr: str
    :ivar platform_reserved_dns_ip: An IP address from the IP range defined by platformReservedCidr
     that will be reserved for the internal DNS server.
    :vartype platform_reserved_dns_ip: str
    """

    _attribute_map = {
        "internal": {"key": "internal", "type": "bool"},
        "infrastructure_subnet_id": {"key": "infrastructureSubnetId", "type": "str"},
        "docker_bridge_cidr": {"key": "dockerBridgeCidr", "type": "str"},
        "platform_reserved_cidr": {"key": "platformReservedCidr", "type": "str"},
        "platform_reserved_dns_ip": {"key": "platformReservedDnsIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        internal: Optional[bool] = None,
        infrastructure_subnet_id: Optional[str] = None,
        docker_bridge_cidr: Optional[str] = None,
        platform_reserved_cidr: Optional[str] = None,
        platform_reserved_dns_ip: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword internal: Boolean indicating the environment only has an internal load balancer. These
         environments do not have a public static IP resource. They must provide infrastructureSubnetId
         if enabling this property.
        :paramtype internal: bool
        :keyword infrastructure_subnet_id: Resource ID of a subnet for infrastructure components. Must
         not overlap with any other provided IP ranges.
        :paramtype infrastructure_subnet_id: str
        :keyword docker_bridge_cidr: CIDR notation IP range assigned to the Docker bridge, network.
         Must not overlap with any other provided IP ranges.
        :paramtype docker_bridge_cidr: str
        :keyword platform_reserved_cidr: IP range in CIDR notation that can be reserved for environment
         infrastructure IP addresses. Must not overlap with any other provided IP ranges.
        :paramtype platform_reserved_cidr: str
        :keyword platform_reserved_dns_ip: An IP address from the IP range defined by
         platformReservedCidr that will be reserved for the internal DNS server.
        :paramtype platform_reserved_dns_ip: str
        """
        super().__init__(**kwargs)
        self.internal = internal
        self.infrastructure_subnet_id = infrastructure_subnet_id
        self.docker_bridge_cidr = docker_bridge_cidr
        self.platform_reserved_cidr = platform_reserved_cidr
        self.platform_reserved_dns_ip = platform_reserved_dns_ip


class Volume(_serialization.Model):
    """Volume definitions for the Container App.

    :ivar name: Volume name.
    :vartype name: str
    :ivar storage_type: Storage type for the volume. If not provided, use EmptyDir. Known values
     are: "AzureFile", "EmptyDir", "Secret", "NfsAzureFile", and "Smb".
    :vartype storage_type: str or ~azure.mgmt.appcontainers.models.StorageType
    :ivar storage_name: Name of storage resource. No need to provide for EmptyDir and Secret.
    :vartype storage_name: str
    :ivar secrets: List of secrets to be added in volume. If no secrets are provided, all secrets
     in collection will be added to volume.
    :vartype secrets: list[~azure.mgmt.appcontainers.models.SecretVolumeItem]
    :ivar mount_options: Mount options used while mounting the Azure file share or NFS Azure file
     share. Must be a comma-separated string.
    :vartype mount_options: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "storage_type": {"key": "storageType", "type": "str"},
        "storage_name": {"key": "storageName", "type": "str"},
        "secrets": {"key": "secrets", "type": "[SecretVolumeItem]"},
        "mount_options": {"key": "mountOptions", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        storage_type: Optional[Union[str, "_models.StorageType"]] = None,
        storage_name: Optional[str] = None,
        secrets: Optional[List["_models.SecretVolumeItem"]] = None,
        mount_options: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Volume name.
        :paramtype name: str
        :keyword storage_type: Storage type for the volume. If not provided, use EmptyDir. Known values
         are: "AzureFile", "EmptyDir", "Secret", "NfsAzureFile", and "Smb".
        :paramtype storage_type: str or ~azure.mgmt.appcontainers.models.StorageType
        :keyword storage_name: Name of storage resource. No need to provide for EmptyDir and Secret.
        :paramtype storage_name: str
        :keyword secrets: List of secrets to be added in volume. If no secrets are provided, all
         secrets in collection will be added to volume.
        :paramtype secrets: list[~azure.mgmt.appcontainers.models.SecretVolumeItem]
        :keyword mount_options: Mount options used while mounting the Azure file share or NFS Azure
         file share. Must be a comma-separated string.
        :paramtype mount_options: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.storage_type = storage_type
        self.storage_name = storage_name
        self.secrets = secrets
        self.mount_options = mount_options


class VolumeMount(_serialization.Model):
    """Volume mount for the Container App.

    :ivar volume_name: This must match the Name of a Volume.
    :vartype volume_name: str
    :ivar mount_path: Path within the container at which the volume should be mounted.Must not
     contain ':'.
    :vartype mount_path: str
    :ivar sub_path: Path within the volume from which the container's volume should be mounted.
     Defaults to "" (volume's root).
    :vartype sub_path: str
    """

    _attribute_map = {
        "volume_name": {"key": "volumeName", "type": "str"},
        "mount_path": {"key": "mountPath", "type": "str"},
        "sub_path": {"key": "subPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        volume_name: Optional[str] = None,
        mount_path: Optional[str] = None,
        sub_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword volume_name: This must match the Name of a Volume.
        :paramtype volume_name: str
        :keyword mount_path: Path within the container at which the volume should be mounted.Must not
         contain ':'.
        :paramtype mount_path: str
        :keyword sub_path: Path within the volume from which the container's volume should be mounted.
         Defaults to "" (volume's root).
        :paramtype sub_path: str
        """
        super().__init__(**kwargs)
        self.volume_name = volume_name
        self.mount_path = mount_path
        self.sub_path = sub_path


class WorkflowArtifacts(_serialization.Model):
    """The workflow filter.

    :ivar app_settings: Application settings of the workflow.
    :vartype app_settings: JSON
    :ivar files: Files of the app.
    :vartype files: JSON
    :ivar files_to_delete: Files of the app to delete.
    :vartype files_to_delete: list[str]
    """

    _attribute_map = {
        "app_settings": {"key": "appSettings", "type": "object"},
        "files": {"key": "files", "type": "object"},
        "files_to_delete": {"key": "filesToDelete", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        app_settings: Optional[JSON] = None,
        files: Optional[JSON] = None,
        files_to_delete: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword app_settings: Application settings of the workflow.
        :paramtype app_settings: JSON
        :keyword files: Files of the app.
        :paramtype files: JSON
        :keyword files_to_delete: Files of the app to delete.
        :paramtype files_to_delete: list[str]
        """
        super().__init__(**kwargs)
        self.app_settings = app_settings
        self.files = files
        self.files_to_delete = files_to_delete


class WorkflowEnvelope(_serialization.Model):
    """Workflow properties definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id.
    :vartype id: str
    :ivar name: Gets the resource name.
    :vartype name: str
    :ivar type: Gets the resource type.
    :vartype type: str
    :ivar kind: The resource kind.
    :vartype kind: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar properties: Additional workflow properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.WorkflowEnvelopeProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "WorkflowEnvelopeProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        properties: Optional["_models.WorkflowEnvelopeProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The resource kind.
        :paramtype kind: str
        :keyword location: The resource location.
        :paramtype location: str
        :keyword properties: Additional workflow properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.WorkflowEnvelopeProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.kind = kind
        self.location = location
        self.properties = properties


class WorkflowEnvelopeCollection(_serialization.Model):
    """Collection of workflow information elements.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.WorkflowEnvelope]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkflowEnvelope]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WorkflowEnvelope"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.WorkflowEnvelope]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class WorkflowEnvelopeProperties(_serialization.Model):
    """Additional workflow properties.

    :ivar files: Gets or sets the files.
    :vartype files: JSON
    :ivar flow_state: Gets or sets the state of the workflow. Known values are: "NotSpecified",
     "Completed", "Enabled", "Disabled", "Deleted", and "Suspended".
    :vartype flow_state: str or ~azure.mgmt.appcontainers.models.WorkflowState
    :ivar health: Gets or sets workflow health.
    :vartype health: ~azure.mgmt.appcontainers.models.WorkflowHealth
    """

    _attribute_map = {
        "files": {"key": "files", "type": "object"},
        "flow_state": {"key": "flowState", "type": "str"},
        "health": {"key": "health", "type": "WorkflowHealth"},
    }

    def __init__(
        self,
        *,
        files: Optional[JSON] = None,
        flow_state: Optional[Union[str, "_models.WorkflowState"]] = None,
        health: Optional["_models.WorkflowHealth"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword files: Gets or sets the files.
        :paramtype files: JSON
        :keyword flow_state: Gets or sets the state of the workflow. Known values are: "NotSpecified",
         "Completed", "Enabled", "Disabled", "Deleted", and "Suspended".
        :paramtype flow_state: str or ~azure.mgmt.appcontainers.models.WorkflowState
        :keyword health: Gets or sets workflow health.
        :paramtype health: ~azure.mgmt.appcontainers.models.WorkflowHealth
        """
        super().__init__(**kwargs)
        self.files = files
        self.flow_state = flow_state
        self.health = health


class WorkflowHealth(_serialization.Model):
    """Represents the workflow health.

    All required parameters must be populated in order to send to server.

    :ivar state: Gets or sets the workflow health state. Required. Known values are:
     "NotSpecified", "Healthy", "Unhealthy", and "Unknown".
    :vartype state: str or ~azure.mgmt.appcontainers.models.WorkflowHealthState
    :ivar error: Gets or sets the workflow error.
    :vartype error: ~azure.mgmt.appcontainers.models.ErrorEntity
    """

    _validation = {
        "state": {"required": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "error": {"key": "error", "type": "ErrorEntity"},
    }

    def __init__(
        self,
        *,
        state: Union[str, "_models.WorkflowHealthState"],
        error: Optional["_models.ErrorEntity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Gets or sets the workflow health state. Required. Known values are:
         "NotSpecified", "Healthy", "Unhealthy", and "Unknown".
        :paramtype state: str or ~azure.mgmt.appcontainers.models.WorkflowHealthState
        :keyword error: Gets or sets the workflow error.
        :paramtype error: ~azure.mgmt.appcontainers.models.ErrorEntity
        """
        super().__init__(**kwargs)
        self.state = state
        self.error = error


class WorkloadProfile(_serialization.Model):
    """Workload profile to scope container app execution.

    All required parameters must be populated in order to send to server.

    :ivar name: Workload profile type for the workloads to run on. Required.
    :vartype name: str
    :ivar enable_fips: Whether to use a FIPS-enabled OS. Supported only for dedicated workload
     profiles.
    :vartype enable_fips: bool
    :ivar workload_profile_type: Workload profile type for the workloads to run on. Required.
    :vartype workload_profile_type: str
    :ivar minimum_count: The minimum capacity.
    :vartype minimum_count: int
    :ivar maximum_count: The maximum capacity.
    :vartype maximum_count: int
    """

    _validation = {
        "name": {"required": True},
        "workload_profile_type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "enable_fips": {"key": "enableFips", "type": "bool"},
        "workload_profile_type": {"key": "workloadProfileType", "type": "str"},
        "minimum_count": {"key": "minimumCount", "type": "int"},
        "maximum_count": {"key": "maximumCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        workload_profile_type: str,
        enable_fips: bool = False,
        minimum_count: Optional[int] = None,
        maximum_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Workload profile type for the workloads to run on. Required.
        :paramtype name: str
        :keyword enable_fips: Whether to use a FIPS-enabled OS. Supported only for dedicated workload
         profiles.
        :paramtype enable_fips: bool
        :keyword workload_profile_type: Workload profile type for the workloads to run on. Required.
        :paramtype workload_profile_type: str
        :keyword minimum_count: The minimum capacity.
        :paramtype minimum_count: int
        :keyword maximum_count: The maximum capacity.
        :paramtype maximum_count: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.enable_fips = enable_fips
        self.workload_profile_type = workload_profile_type
        self.minimum_count = minimum_count
        self.maximum_count = maximum_count


class WorkloadProfileStates(ProxyResource):
    """Collection of all the workload Profile States for a Managed Environment..

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.appcontainers.models.SystemData
    :ivar properties: Workload Profile resource specific properties.
    :vartype properties: ~azure.mgmt.appcontainers.models.WorkloadProfileStatesProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "properties": {"key": "properties", "type": "WorkloadProfileStatesProperties"},
    }

    def __init__(
        self, *, properties: Optional["_models.WorkloadProfileStatesProperties"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword properties: Workload Profile resource specific properties.
        :paramtype properties: ~azure.mgmt.appcontainers.models.WorkloadProfileStatesProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class WorkloadProfileStatesCollection(_serialization.Model):
    """Collection of workloadProfileStates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.appcontainers.models.WorkloadProfileStates]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[WorkloadProfileStates]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.WorkloadProfileStates"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.appcontainers.models.WorkloadProfileStates]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class WorkloadProfileStatesProperties(_serialization.Model):
    """Workload Profile resource specific properties.

    :ivar minimum_count: Minimum count of instances.
    :vartype minimum_count: int
    :ivar maximum_count: Maximum count of nodes.
    :vartype maximum_count: int
    :ivar current_count: Current count of nodes.
    :vartype current_count: int
    """

    _attribute_map = {
        "minimum_count": {"key": "minimumCount", "type": "int"},
        "maximum_count": {"key": "maximumCount", "type": "int"},
        "current_count": {"key": "currentCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        minimum_count: Optional[int] = None,
        maximum_count: Optional[int] = None,
        current_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum_count: Minimum count of instances.
        :paramtype minimum_count: int
        :keyword maximum_count: Maximum count of nodes.
        :paramtype maximum_count: int
        :keyword current_count: Current count of nodes.
        :paramtype current_count: int
        """
        super().__init__(**kwargs)
        self.minimum_count = minimum_count
        self.maximum_count = maximum_count
        self.current_count = current_count
