//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armreservations_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/CalculateReservationOrder.json
func ExampleReservationOrderClient_Calculate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationOrderClient().Calculate(ctx, armreservations.PurchaseRequest{
		Location: to.Ptr("westus"),
		Properties: &armreservations.PurchaseRequestProperties{
			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeShared),
			BillingPlan:      to.Ptr(armreservations.ReservationBillingPlanMonthly),
			BillingScopeID:   to.Ptr("/subscriptions/ed3a1871-612d-abcd-a849-c2542a68be83"),
			DisplayName:      to.Ptr("TestReservationOrder"),
			Quantity:         to.Ptr[int32](1),
			ReservedResourceProperties: &armreservations.PurchaseRequestPropertiesReservedResourceProperties{
				InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
			},
			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
			Term:                 to.Ptr(armreservations.ReservationTermP1Y),
		},
		SKU: &armreservations.SKUName{
			Name: to.Ptr("standard_D1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.CalculatePriceResponse = armreservations.CalculatePriceResponse{
	// 	Properties: &armreservations.CalculatePriceResponseProperties{
	// 		BillingCurrencyTotal: &armreservations.CalculatePriceResponsePropertiesBillingCurrencyTotal{
	// 			Amount: to.Ptr[float64](46),
	// 			CurrencyCode: to.Ptr("USD"),
	// 		},
	// 		PaymentSchedule: []*armreservations.PaymentDetail{
	// 			{
	// 				BillingCurrencyTotal: &armreservations.Price{
	// 					Amount: to.Ptr[float64](40),
	// 					CurrencyCode: to.Ptr("EUR"),
	// 				},
	// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-05-14"); return t}()),
	// 				PricingCurrencyTotal: &armreservations.Price{
	// 					Amount: to.Ptr[float64](46),
	// 					CurrencyCode: to.Ptr("USD"),
	// 				},
	// 			},
	// 			{
	// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-06-14"); return t}()),
	// 				PricingCurrencyTotal: &armreservations.Price{
	// 					Amount: to.Ptr[float64](46),
	// 					CurrencyCode: to.Ptr("USD"),
	// 				},
	// 			},
	// 			{
	// 				DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-07-14"); return t}()),
	// 				PricingCurrencyTotal: &armreservations.Price{
	// 					Amount: to.Ptr[float64](46),
	// 					CurrencyCode: to.Ptr("USD"),
	// 				},
	// 		}},
	// 		PricingCurrencyTotal: &armreservations.CalculatePriceResponsePropertiesPricingCurrencyTotal{
	// 			Amount: to.Ptr[float32](46),
	// 			CurrencyCode: to.Ptr("USD"),
	// 		},
	// 		ReservationOrderID: to.Ptr("6d9cec54-7de8-abcd-9de7-80f5d634f2d2"),
	// 		SKUDescription: to.Ptr("standard_D1"),
	// 		SKUTitle: to.Ptr("Reserved VM Instance, Standard_D1, US West, 1 Year"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationOrders.json
func ExampleReservationOrderClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewReservationOrderClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ReservationOrderList = armreservations.ReservationOrderList{
		// 	Value: []*armreservations.ReservationOrderResponse{
		// 		{
		// 			Name: to.Ptr("1e6407ba-37a5-499f-80ed-a3f0f338e443"),
		// 			Type: to.Ptr("Microsoft.Capacity/reservationOrders"),
		// 			Etag: to.Ptr[int32](7),
		// 			ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1e6407ba-37a5-499f-80ed-a3f0f338e443"),
		// 			Properties: &armreservations.ReservationOrderProperties{
		// 				BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-29T21:20:23.813Z"); return t}()),
		// 				BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 				CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-29T21:22:56.854Z"); return t}()),
		// 				DisplayName: to.Ptr("cabri"),
		// 				ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-08-29"); return t}()),
		// 				ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-29T21:20:23.813Z"); return t}()),
		// 				OriginalQuantity: to.Ptr[int32](1),
		// 				ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 				RequestDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-29T21:20:23.813Z"); return t}()),
		// 				Reservations: []*armreservations.ReservationResponse{
		// 					{
		// 						ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1e6407ba-37a5-499f-80ed-a3f0f338e443/reservations/cae5924e-7a15-419f-a369-124f52d4a106"),
		// 				}},
		// 				Term: to.Ptr(armreservations.ReservationTermP1Y),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("1ea6e203-288e-4732-b9e1-da8bbe10c614"),
		// 			Type: to.Ptr("Microsoft.Capacity/reservationOrders"),
		// 			Etag: to.Ptr[int32](7),
		// 			ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1ea6e203-288e-4732-b9e1-da8bbe10c614"),
		// 			Properties: &armreservations.ReservationOrderProperties{
		// 				BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T12:55:40.279Z"); return t}()),
		// 				BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 				CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T12:58:20.526Z"); return t}()),
		// 				DisplayName: to.Ptr("cabri"),
		// 				ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-08-30"); return t}()),
		// 				ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-30T12:58:20.526Z"); return t}()),
		// 				OriginalQuantity: to.Ptr[int32](9),
		// 				ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 				RequestDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T12:55:40.279Z"); return t}()),
		// 				Reservations: []*armreservations.ReservationResponse{
		// 					{
		// 						ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1ea6e203-288e-4732-b9e1-da8bbe10c614/reservations/d04fd48d-e3f6-42a3-a8f6-1ad0b7513e48"),
		// 				}},
		// 				Term: to.Ptr(armreservations.ReservationTermP1Y),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
		// 			Type: to.Ptr("Microsoft.Capacity/reservationOrders"),
		// 			Etag: to.Ptr[int32](7),
		// 			ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
		// 			Properties: &armreservations.ReservationOrderProperties{
		// 				BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:49:19.025Z"); return t}()),
		// 				BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
		// 				CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:51:49.808Z"); return t}()),
		// 				DisplayName: to.Ptr("cabri"),
		// 				ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-08-30"); return t}()),
		// 				ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-30T03:51:49.808Z"); return t}()),
		// 				OriginalQuantity: to.Ptr[int32](7),
		// 				ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
		// 				RequestDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:49:19.025Z"); return t}()),
		// 				Reservations: []*armreservations.ReservationResponse{
		// 					{
		// 						ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa/reservations/c8c926bd-fc5d-4e29-9d43-b68340ac23a6"),
		// 				}},
		// 				Term: to.Ptr(armreservations.ReservationTermP1Y),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/PurchaseReservationOrder.json
func ExampleReservationOrderClient_BeginPurchase() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewReservationOrderClient().BeginPurchase(ctx, "a075419f-44cc-497f-b68a-14ee811d48b9", armreservations.PurchaseRequest{
		Location: to.Ptr("westus"),
		Properties: &armreservations.PurchaseRequestProperties{
			AppliedScopeType: to.Ptr(armreservations.AppliedScopeTypeShared),
			BillingPlan:      to.Ptr(armreservations.ReservationBillingPlanMonthly),
			BillingScopeID:   to.Ptr("/subscriptions/ed3a1871-612d-abcd-a849-c2542a68be83"),
			DisplayName:      to.Ptr("TestReservationOrder"),
			Quantity:         to.Ptr[int32](1),
			Renew:            to.Ptr(false),
			ReservedResourceProperties: &armreservations.PurchaseRequestPropertiesReservedResourceProperties{
				InstanceFlexibility: to.Ptr(armreservations.InstanceFlexibilityOn),
			},
			ReservedResourceType: to.Ptr(armreservations.ReservedResourceTypeVirtualMachines),
			Term:                 to.Ptr(armreservations.ReservationTermP1Y),
		},
		SKU: &armreservations.SKUName{
			Name: to.Ptr("standard_D1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationOrderResponse = armreservations.ReservationOrderResponse{
	// 	Name: to.Ptr("1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
	// 	Type: to.Ptr("Microsoft.Capacity/reservationOrders"),
	// 	Etag: to.Ptr[int32](7),
	// 	ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
	// 	Properties: &armreservations.ReservationOrderProperties{
	// 		BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:51:49.808Z"); return t}()),
	// 		DisplayName: to.Ptr("cabri"),
	// 		ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-08-30"); return t}()),
	// 		ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-30T03:51:49.808Z"); return t}()),
	// 		OriginalQuantity: to.Ptr[int32](7),
	// 		ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 		RequestDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:49:19.025Z"); return t}()),
	// 		Reservations: []*armreservations.ReservationResponse{
	// 			{
	// 				ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa/reservations/c8c926bd-fc5d-4e29-9d43-b68340ac23a6"),
	// 		}},
	// 		Term: to.Ptr(armreservations.ReservationTermP1Y),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationOrderDetails.json
func ExampleReservationOrderClient_Get_getReservationOrder() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationOrderClient().Get(ctx, "a075419f-44cc-497f-b68a-14ee811d48b9", &armreservations.ReservationOrderClientGetOptions{Expand: nil})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationOrderResponse = armreservations.ReservationOrderResponse{
	// 	Name: to.Ptr("1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
	// 	Type: to.Ptr("Microsoft.Capacity/reservationOrders"),
	// 	Etag: to.Ptr[int32](7),
	// 	ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
	// 	Properties: &armreservations.ReservationOrderProperties{
	// 		BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:49:19.025Z"); return t}()),
	// 		BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:51:49.808Z"); return t}()),
	// 		DisplayName: to.Ptr("cabri"),
	// 		ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-08-30"); return t}()),
	// 		ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-30T03:51:49.808Z"); return t}()),
	// 		OriginalQuantity: to.Ptr[int32](7),
	// 		ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 		RequestDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-08-30T03:49:19.025Z"); return t}()),
	// 		Reservations: []*armreservations.ReservationResponse{
	// 			{
	// 				ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa/reservations/c8c926bd-fc5d-4e29-9d43-b68340ac23a6"),
	// 		}},
	// 		Term: to.Ptr(armreservations.ReservationTermP1Y),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationOrderDetailsWithExpandPlanInformation.json
func ExampleReservationOrderClient_Get_getReservationWithExpandPayments() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationOrderClient().Get(ctx, "a075419f-44cc-497f-b68a-14ee811d48b9", &armreservations.ReservationOrderClientGetOptions{Expand: to.Ptr("schedule")})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ReservationOrderResponse = armreservations.ReservationOrderResponse{
	// 	Name: to.Ptr("1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
	// 	Type: to.Ptr("Microsoft.Capacity/reservationOrders"),
	// 	Etag: to.Ptr[int32](7),
	// 	ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
	// 	Properties: &armreservations.ReservationOrderProperties{
	// 		BenefitStartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T03:51:49.000Z"); return t}()),
	// 		BillingPlan: to.Ptr(armreservations.ReservationBillingPlanMonthly),
	// 		CreatedDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T03:51:49.000Z"); return t}()),
	// 		DisplayName: to.Ptr("cabri"),
	// 		ExpiryDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2018-08-30"); return t}()),
	// 		ExpiryDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2018-08-30T03:51:49.000Z"); return t}()),
	// 		OriginalQuantity: to.Ptr[int32](7),
	// 		PlanInformation: &armreservations.ReservationOrderBillingPlanInformation{
	// 			NextPaymentDueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-09-30"); return t}()),
	// 			PricingCurrencyTotal: &armreservations.Price{
	// 				Amount: to.Ptr[float64](466),
	// 				CurrencyCode: to.Ptr("USD"),
	// 			},
	// 			StartDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-08-30"); return t}()),
	// 			Transactions: []*armreservations.PaymentDetail{
	// 				{
	// 					BillingAccount: to.Ptr("23456"),
	// 					BillingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-09-30"); return t}()),
	// 					PaymentDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-09-30"); return t}()),
	// 					PricingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					Status: to.Ptr(armreservations.PaymentStatusSucceeded),
	// 				},
	// 				{
	// 					BillingAccount: to.Ptr("23456"),
	// 					BillingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-10-30"); return t}()),
	// 					ExtendedStatusInfo: &armreservations.ExtendedStatusInfo{
	// 						Message: to.Ptr("Credit card charge failed."),
	// 						StatusCode: to.Ptr(armreservations.ReservationStatusCode("PaymentDeclined")),
	// 					},
	// 					PaymentDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-10-30"); return t}()),
	// 					PricingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					Status: to.Ptr(armreservations.PaymentStatusFailed),
	// 				},
	// 				{
	// 					BillingAccount: to.Ptr("23456"),
	// 					BillingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-10-31"); return t}()),
	// 					PaymentDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-10-31"); return t}()),
	// 					PricingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					Status: to.Ptr(armreservations.PaymentStatusSucceeded),
	// 				},
	// 				{
	// 					BillingAccount: to.Ptr("23456"),
	// 					BillingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-11-30"); return t}()),
	// 					PaymentDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-11-30"); return t}()),
	// 					PricingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					Status: to.Ptr(armreservations.PaymentStatusSucceeded),
	// 				},
	// 				{
	// 					BillingAccount: to.Ptr("23456"),
	// 					BillingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-07-14"); return t}()),
	// 					PaymentDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-06-14"); return t}()),
	// 					PricingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					Status: to.Ptr(armreservations.PaymentStatusScheduled),
	// 				},
	// 				{
	// 					BillingAccount: to.Ptr("23456"),
	// 					BillingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					DueDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-06-14"); return t}()),
	// 					PaymentDate: to.Ptr(func() time.Time { t, _ := time.Parse("2006-01-02", "2019-08-14"); return t}()),
	// 					PricingCurrencyTotal: &armreservations.Price{
	// 						Amount: to.Ptr[float64](466),
	// 						CurrencyCode: to.Ptr("USD"),
	// 					},
	// 					Status: to.Ptr(armreservations.PaymentStatusScheduled),
	// 			}},
	// 		},
	// 		ProvisioningState: to.Ptr(armreservations.ProvisioningStateSucceeded),
	// 		RequestDateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2019-08-30T03:49:19.000Z"); return t}()),
	// 		Reservations: []*armreservations.ReservationResponse{
	// 			{
	// 				ID: to.Ptr("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa/reservations/c8c926bd-fc5d-4e29-9d43-b68340ac23a6"),
	// 		}},
	// 		Term: to.Ptr(armreservations.ReservationTermP1Y),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/ChangeDirectoryReservationOrder.json
func ExampleReservationOrderClient_ChangeDirectory() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armreservations.NewClientFactory(cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewReservationOrderClient().ChangeDirectory(ctx, "a075419f-44cc-497f-b68a-14ee811d48b9", armreservations.ChangeDirectoryRequest{
		DestinationTenantID: to.Ptr("906655ea-30be-4587-9d12-b50e077b0f32"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ChangeDirectoryResponse = armreservations.ChangeDirectoryResponse{
	// 	ReservationOrder: &armreservations.ChangeDirectoryResult{
	// 		Name: to.Ptr("VM_RI_10-02-2020_15-21"),
	// 		Error: to.Ptr("error string"),
	// 		ID: to.Ptr("a075419f-44cc-497f-b68a-14ee811d48b9"),
	// 		IsSucceeded: to.Ptr(true),
	// 	},
	// 	Reservations: []*armreservations.ChangeDirectoryResult{
	// 		{
	// 			Name: to.Ptr("VM_RI_10-02-2020_15-21"),
	// 			Error: to.Ptr("error string"),
	// 			ID: to.Ptr("1f14354c-dc12-4c8d-8090-6f295a3a34aa"),
	// 			IsSucceeded: to.Ptr(true),
	// 	}},
	// }
}
