#!/usr/bin/env python3

import time

from fenrirscreenreader.core.i18n import _

# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "promote", "enabled"
        ):
            return
        if (
            self.env["runtime"]["SettingsManager"]
            .get_setting("promote", "list")
            .strip(" \t\n")
            == ""
        ):
            return
        if int(time.time() - self.env["input"]["lastInputTime"]) < self.env[
            "runtime"
        ]["SettingsManager"].get_setting_as_int(
            "promote", "inactiveTimeoutSec"
        ):
            return
        if (
            len(
                self.env["runtime"]["SettingsManager"].get_setting(
                    "promote", "list"
                )
            )
            == 0
        ):
            return
        for promote in (
            self.env["runtime"]["SettingsManager"]
            .get_setting("promote", "list")
            .split(",")
        ):
            if promote in self.env["screen"]["new_delta"]:
                self.env["runtime"]["OutputManager"].play_sound_icon(
                    "PromotedText"
                )
                self.env["input"]["lastInputTime"] = time.time()
                return

    def set_callback(self, callback):
        pass
