# متغیرهای محیطی

/// tip

اگه از قبل می‌دونی متغیرهای محیطی چی هستن و چطور ازشون استفاده می‌شه، می‌تونی این بخش رو رد کنی.

///

یه متغیر محیطی (که بهش "**env var**" هم می‌گن) یه متغیریه که **خارج** از کد پایتون، توی **سیستم‌عامل** زندگی می‌کنه و می‌تونه توسط کد پایتونت (یا برنامه‌های دیگه) خونده بشه.

متغیرهای محیطی می‌تونن برای مدیریت **تنظیمات** برنامه، به‌عنوان بخشی از **نصب** پایتون و غیره مفید باشن.

## ساخت و استفاده از متغیرهای محیطی

می‌تونی متغیرهای محیطی رو توی **شل (ترمینال)** **بسازی** و ازشون استفاده کنی، بدون اینکه به پایتون نیاز داشته باشی:

//// tab | لینوکس، مک‌اواس، ویندوز بش

<div class="termy">

```console
// می‌تونی یه متغیر محیطی به اسم MY_NAME بسازی با
$ export MY_NAME="Wade Wilson"

// بعد می‌تونی با برنامه‌های دیگه ازش استفاده کنی، مثل
$ echo "Hello $MY_NAME"

Hello Wade Wilson
```

</div>

////

//// tab | ویندوز پاورشل

<div class="termy">

```console
// یه متغیر محیطی به اسم MY_NAME بساز
$ $Env:MY_NAME = "Wade Wilson"

// با برنامه‌های دیگه ازش استفاده کن، مثل
$ echo "Hello $Env:MY_NAME"

Hello Wade Wilson
```

</div>

////

## خوندن متغیرهای محیطی توی پایتون

می‌تونی متغیرهای محیطی رو **خارج** از پایتون، توی ترمینال (یا با هر روش دیگه) بسازی، و بعد توی **پایتون** اونا رو بخونی.

مثلاً می‌تونی یه فایل `main.py` داشته باشی با:

```Python hl_lines="3"
import os

name = os.getenv("MY_NAME", "World")
print(f"Hello {name} from Python")
```

/// tip

آرگومان دوم <a href="https://docs.python.org/3.8/library/os.html#os.getenv" class="external-link" target="_blank">`os.getenv()`</a> مقدار پیش‌فرضیه که برمی‌گردونه.

اگه ندی، به‌صورت پیش‌فرض `None` هست، اینجا ما `"World"` رو به‌عنوان مقدار پیش‌فرض گذاشتیم.

///

بعد می‌تونی اون برنامه پایتون رو صدا کنی:

//// tab | لینوکس، مک‌اواس، ویندوز بش

<div class="termy">

```console
// اینجا هنوز متغیر محیطی رو تنظیم نکردیم
$ python main.py

// چون متغیر محیطی رو تنظیم نکردیم، مقدار پیش‌فرض رو می‌گیریم

Hello World from Python

// ولی اگه اول یه متغیر محیطی بسازیم
$ export MY_NAME="Wade Wilson"

// و بعد دوباره برنامه رو صدا کنیم
$ python main.py

// حالا می‌تونه متغیر محیطی رو بخونه

Hello Wade Wilson from Python
```

</div>

////

//// tab | ویندوز پاورشل

<div class="termy">

```console
// اینجا هنوز متغیر محیطی رو تنظیم نکردیم
$ python main.py

// چون متغیر محیطی رو تنظیم نکردیم، مقدار پیش‌فرض رو می‌گیریم

Hello World from Python

// ولی اگه اول یه متغیر محیطی بسازیم
$ $Env:MY_NAME = "Wade Wilson"

// و بعد دوباره برنامه رو صدا کنیم
$ python main.py

// حالا می‌تونه متغیر محیطی رو بخونه

Hello Wade Wilson from Python
```

</div>

////

چون متغیرهای محیطی می‌تونن خارج از کد تنظیم بشن، ولی کد می‌تونه اونا رو بخونه، و لازم نیست با بقیه فایل‌ها ذخیره (کمیتی به `git`) بشن، معمولاً برای پیکربندی یا **تنظیمات** استفاده می‌شن.

همچنین می‌تونی یه متغیر محیطی رو فقط برای **یه اجرای خاص برنامه** بسازی، که فقط برای اون برنامه و فقط برای مدت زمان اجراش در دسترسه.

برای این کار، درست قبل از خود برنامه، توی همون خط بسازش:

<div class="termy">

```console
// یه متغیر محیطی MY_NAME رو توی خط برای این اجرای برنامه بساز
$ MY_NAME="Wade Wilson" python main.py

// حالا می‌تونه متغیر محیطی رو بخونه

Hello Wade Wilson from Python

// متغیر محیطی بعدش دیگه وجود نداره
$ python main.py

Hello World from Python
```

</div>

/// tip

می‌تونی بیشتر در موردش توی <a href="https://12factor.net/config" class="external-link" target="_blank">برنامه دوازده‌فاکتوری: پیکربندی</a> بخونی.

///

## نوع‌ها و اعتبارسنجی

این متغیرهای محیطی فقط می‌تونن **رشته‌های متنی** رو نگه دارن، چون خارج از پایتون هستن و باید با برنامه‌های دیگه و بقیه سیستم (و حتی سیستم‌عامل‌های مختلف مثل لینوکس، ویندوز، مک‌اواس) سازگار باشن.

یعنی **هر مقداری** که توی پایتون از یه متغیر محیطی خونده می‌شه یه `str` هست، و هر تبدیل به نوع دیگه یا هر اعتبارسنجی باید توی کد انجام بشه.

توی [راهنمای کاربر پیشرفته - تنظیمات و متغیرهای محیطی](./advanced/settings.md){.internal-link target=_blank} بیشتر در مورد استفاده از متغیرهای محیطی برای مدیریت **تنظیمات برنامه** یاد می‌گیری.

## متغیر محیطی `PATH`

یه متغیر محیطی **خاص** به اسم **`PATH`** وجود داره که سیستم‌عامل‌ها (لینوکس، مک‌اواس، ویندوز) ازش برای پیدا کردن برنامه‌هایی که قراره اجرا بشن استفاده می‌کنن.

مقدار متغیر `PATH` یه رشته طولانی از پوشه‌هاست که توی لینوکس و مک‌اواس با دونقطه `:` و توی ویندوز با نقطه‌ویرگول `;` از هم جدا شدن.

مثلاً، متغیر محیطی `PATH` می‌تونه اینجوری باشه:

//// tab | لینوکس، مک‌اواس

```plaintext
/usr/local/bin:/usr/bin:/bin:/usr/sbin:/sbin
```

یعنی سیستم باید دنبال برنامه‌ها توی این پوشه‌ها بگرده:

* `/usr/local/bin`
* `/usr/bin`
* `/bin`
* `/usr/sbin`
* `/sbin`

////

//// tab | ویندوز

```plaintext
C:\Program Files\Python312\Scripts;C:\Program Files\Python312;C:\Windows\System32
```

یعنی سیستم باید دنبال برنامه‌ها توی این پوشه‌ها بگرده:

* `C:\Program Files\Python312\Scripts`
* `C:\Program Files\Python312`
* `C:\Windows\System32`

////

وقتی یه **دستور** توی ترمینال تایپ می‌کنی، سیستم‌عامل **دنبال** برنامه توی **هر کدوم از این پوشه‌ها** که توی متغیر محیطی `PATH` لیست شدن می‌گرده.

مثلاً، وقتی توی ترمینال `python` تایپ می‌کنی، سیستم‌عامل دنبال یه برنامه به اسم `python` توی **اولین پوشه** توی اون لیست می‌گرده.

اگه پیداش کنه، **استفاده‌ش می‌کنه**. وگرنه توی **پوشه‌های بعدی** دنبالش می‌گرده.

### نصب پایتون و به‌روزرسانی `PATH`

وقتی پایتون رو نصب می‌کنی، ممکنه ازت بپرسن آیا می‌خوای متغیر محیطی `PATH` رو به‌روزرسانی کنی.

//// tab | لینوکس، مک‌اواس

فرض کن پایتون رو نصب کردی و توی یه پوشه `/opt/custompython/bin` قرار گرفته.

اگه بگی بله برای به‌روزرسانی متغیر محیطی `PATH`، نصاب `/opt/custompython/bin` رو به متغیر محیطی `PATH` اضافه می‌کنه.

ممکنه اینجوری بشه:

```plaintext
/usr/local/bin:/usr/bin:/bin:/usr/sbin:/sbin:/opt/custompython/bin
```

این‌جوری، وقتی توی ترمینال `python` تایپ می‌کنی، سیستم برنامه پایتون رو توی `/opt/custompython/bin` (آخرین پوشه) پیدا می‌کنه و از اون استفاده می‌کنه.

////

//// tab | ویندوز

فرض کن پایتون رو نصب کردی و توی یه پوشه `C:\opt\custompython\bin` قرار گرفته.

اگه بگی بله برای به‌روزرسانی متغیر محیطی `PATH`، نصاب `C:\opt\custompython\bin` رو به متغیر محیطی `PATH` اضافه می‌کنه.

```plaintext
C:\Program Files\Python312\Scripts;C:\Program Files\Python312;C:\Windows\System32;C:\opt\custompython\bin
```

این‌جوری، وقتی توی ترمینال `python` تایپ می‌کنی، سیستم برنامه پایتون رو توی `C:\opt\custompython\bin` (آخرین پوشه) پیدا می‌کنه و از اون استفاده می‌کنه.

////

پس، اگه تایپ کنی:

<div class="termy">

```console
$ python
```

</div>

//// tab | لینوکس، مک‌اواس

سیستم برنامه `python` رو توی `/opt/custompython/bin` **پیدا** می‌کنه و اجراش می‌کنه.

تقریباً معادل اینه که تایپ کنی:

<div class="termy">

```console
$ /opt/custompython/bin/python
```

</div>

////

//// tab | ویندوز

سیستم برنامه `python` رو توی `C:\opt\custompython\bin\python` **پیدا** می‌کنه و اجراش می‌کنه.

تقریباً معادل اینه که تایپ کنی:

<div class="termy">

```console
$ C:\opt\custompython\bin\python
```

</div>

////

این اطلاعات وقتی در مورد [محیط‌های مجازی](virtual-environments.md){.internal-link target=_blank} یاد می‌گیری به‌دردت می‌خوره.

## نتیجه‌گیری

با این باید یه درک پایه‌ای از **متغیرهای محیطی** و نحوه استفاده‌شون توی پایتون داشته باشی.

می‌تونی بیشتر در موردشون توی <a href="https://en.wikipedia.org/wiki/Environment_variable" class="external-link" target="_blank">ویکی‌پدیا برای متغیر محیطی</a> بخونی.

توی خیلی موارد مشخص نیست که متغیرهای محیطی چطور می‌تونن فوری مفید و کاربردی باشن. ولی توی موقعیت‌های مختلف توسعه مدام پیداشون می‌شه، پس خوبه که در موردشون بدونی.

مثلاً، توی بخش بعدی در مورد [محیط‌های مجازی](virtual-environments.md) به این اطلاعات نیاز داری.
