Signals2, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), is an implementation of a managed signals and slots system.

### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++03
* Header-Only

### Build Status

Branch          | Travis | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
:-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
[`master`](https://github.com/boostorg/signals2/tree/master) | [![Build Status](https://travis-ci.org/boostorg/signals2.svg?branch=master)](https://travis-ci.org/boostorg/signals2) | [![Build status](https://ci.appveyor.com/api/projects/status/vjbstowu1s13x4l5/branch/master?svg=true)](https://ci.appveyor.com/project/jeking3/signals2-db91c/branch/master) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/15884/badge.svg)](https://scan.coverity.com/projects/boostorg-signals2) | [![codecov](https://codecov.io/gh/boostorg/signals2/branch/master/graph/badge.svg)](https://codecov.io/gh/boostorg/signals2/branch/master)| [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/signals2.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](http://www.boost.org/doc/libs/master/doc/html/signals2.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](http://www.boost.org/development/tests/master/developer/signals2.html)
[`develop`](https://github.com/boostorg/signals2/tree/develop) | [![Build Status](https://travis-ci.org/boostorg/signals2.svg?branch=develop)](https://travis-ci.org/boostorg/signals2) | [![Build status](https://ci.appveyor.com/api/projects/status/vjbstowu1s13x4l5/branch/develop?svg=true)](https://ci.appveyor.com/project/jeking3/signals2-db91c/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/15884/badge.svg)](https://scan.coverity.com/projects/boostorg-signals2) | [![codecov](https://codecov.io/gh/boostorg/signals2/branch/develop/graph/badge.svg)](https://codecov.io/gh/boostorg/signals2/branch/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/signals2.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](http://www.boost.org/doc/libs/develop/doc/html/signals2.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](http://www.boost.org/development/tests/develop/developer/signals2.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `ci`        | continuous integration scripts |
| `doc`       | documentation                  |
| `example`   | examples                       |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-signals2)
* [Report bugs](https://github.com/boostorg/signals2/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[signals2]` tag at the beginning of the subject line.

